package org.palladiosimulator.protocom.workflow;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.workflow.ConstantsContainer;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractCodeGenerationWorkflowRunConfiguration.CodeGenerationAdvice;
import org.palladiosimulator.analyzer.workflow.runconfig.SensitivityAnalysisConfiguration;

import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowConfigurationBuilder;

public class ProtoComGenerationLaunchConfigurationBasedConfigBuilder extends AbstractWorkflowConfigurationBuilder {

    public ProtoComGenerationLaunchConfigurationBasedConfigBuilder(ILaunchConfiguration configuration, String mode)
            throws CoreException {
        super(configuration, mode);
    }

    @Override
    public void fillConfiguration(AbstractWorkflowBasedRunConfiguration configuration) throws CoreException {
        ProtoComGenerationConfiguration config = (ProtoComGenerationConfiguration) configuration;

        config.setDebug(this.isDebug);

        config.setSensitivityAnalysisEnabled(hasValidSensitvityVariableAttribute(ConstantsContainer.VARIABLE_TEXT));
        if (config.isSensitivityAnalysisEnabled()) {
            SensitivityAnalysisConfiguration sensitivityConfig = new SensitivityAnalysisConfiguration(
                    "EJB Sensitivity", getStringAttribute(ConstantsContainer.VARIABLE_TEXT),
                    getDoubleAttribute(ConstantsContainer.MINIMUM_TEXT),
                    getDoubleAttribute(ConstantsContainer.MAXIMUM_TEXT),
                    getDoubleAttribute(ConstantsContainer.STEP_WIDTH_TEXT));
            config.setSensitivityAnalysisConfiguration(sensitivityConfig);
        }

        String modelToCodeTarget = getStringAttribute(ConstantsContainer.MODEL_TO_TEXT_CHOICE);
        if (ConstantsContainer.MODEL_TO_TEXT_TARGET_JAVA_SE_RMI.equals(modelToCodeTarget)) {
            config.setCodeGenerationAdvicesFile(CodeGenerationAdvice.PROTO);
        } else if (ConstantsContainer.MODEL_TO_TEXT_TARGET_JAVA_SE_RMI_STUBS.equals(modelToCodeTarget)) {
            config.setCodeGenerationAdvicesFile(CodeGenerationAdvice.POJO);
        } else if (ConstantsContainer.MODEL_TO_TEXT_TARGET_JAVA_EE_EJB.equals(modelToCodeTarget)) {
            config.setCodeGenerationAdvicesFile(CodeGenerationAdvice.EJB3);
        } else if (ConstantsContainer.MODEL_TO_TEXT_TARGET_JAVA_EE_SERVLET.equals(modelToCodeTarget)) {
        	config.setCodeGenerationAdvicesFile(CodeGenerationAdvice.SERVLET);
        }

    }

    private boolean hasValidSensitvityVariableAttribute(String attribute) throws CoreException {
        if (!configuration.hasAttribute(attribute)) {
            return false;
        }
        Object value = getStringAttribute(attribute);
        // Anne: I sometimes get a "NO ELEMENT SELECTED" result from the LaunchConfig even if I
        // deleted the string from the field
        // I have no idea how to fix it directly, so I need to catch it here.
        // It seems to only appear in the Design Space Exploration tab.
        return value instanceof String && !value.equals("") && !value.equals("NO ELEMENT SELECTED");
    }

}
