/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.visualization.util.ExtensionsFilter;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;
import org.palladiosimulator.servicelevelobjective.edp2.visualization.wizards.SLOViewsWizard;

public class SLODialogChooseRepositoryPage
extends WizardPage
implements ModifyListener {
    private ServiceLevelObjectiveRepository selectedSLORepo;
    private IStatus selectionStatus;
    private final List<ServiceLevelObjective> availableSLOs = new ArrayList<ServiceLevelObjective>();
    private final MetricDescription metricDescription;
    private final Status statusOK;
    Text textFileNameToLoad;

    public SLODialogChooseRepositoryPage(String name, MetricDescription metricDescription) {
        super(name);
        this.setDescription("Please select a file containing a service level objective repository.");
        this.selectionStatus = new Status(1, "not_used", 0, "Please select a file containing a service level objective repository.", null);
        this.statusOK = new Status(0, "not_used", 0, "", null);
        this.metricDescription = metricDescription;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        Group fileInputGroup = new Group(composite, 0);
        this.textFileNameToLoad = new Text((Composite)fileInputGroup, 0);
        this.textFileNameToLoad.addModifyListener((ModifyListener)this);
        GridLayout glFileInputGroup = new GridLayout();
        int numColumns = 3;
        glFileInputGroup.numColumns = 3;
        fileInputGroup.setLayout((Layout)glFileInputGroup);
        fileInputGroup.setText("Import Service Level Objective Repository");
        fileInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textFileNameToLoad.setParent((Composite)fileInputGroup);
        GridData gridDataTextFileName = new GridData(4, 0x1000000, true, false);
        gridDataTextFileName.widthHint = 200;
        this.textFileNameToLoad.setLayoutData((Object)gridDataTextFileName);
        Button workspaceButton = new Button((Composite)fileInputGroup, 0);
        workspaceButton.setText("Workspace...");
        workspaceButton.addSelectionListener((SelectionListener)new WorkspaceButtonSelectionListener(this.textFileNameToLoad, new String[]{"slo"}, "workspace", this.getShell()));
        Button localFileSystemButton = new Button((Composite)fileInputGroup, 0);
        localFileSystemButton.setText("File System...");
        localFileSystemButton.addSelectionListener((SelectionListener)new LocalFileSystemButtonSelectionAdapter(this.textFileNameToLoad, new String[]{"*.slo"}, "filesystem"));
        this.setControl((Control)composite);
    }

    private void loadSLORepository(String uri) {
        MetricSpecPackage.eINSTANCE.eClass();
        ServicelevelObjectivePackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(URI.createFileURI((String)uri));
        try {
            resource.load(null);
            EcoreUtil.resolveAll((ResourceSet)rs);
            this.selectedSLORepo = (ServiceLevelObjectiveRepository)resource.getContents().get(0);
            this.selectionStatus = this.statusOK;
            this.loadSLOs(this.metricDescription);
            this.updatePageStatus();
        }
        catch (IOException e) {
            this.selectionStatus = new Status(4, "not_used", 0, "File not found.", null);
            this.updatePageStatus();
        }
        catch (ClassCastException e) {
            this.selectionStatus = new Status(4, "not_used", 0, "Model does not contain service level repository, please select another repository.", null);
            this.updatePageStatus();
        }
    }

    private void loadSLOs(MetricDescription metricDescription) {
        EList allSLOs = this.selectedSLORepo.getServicelevelobjectives();
        this.availableSLOs.clear();
        for (ServiceLevelObjective element : allSLOs) {
            if (!metricDescription.getName().contains(element.getMeasurementSpecification().getMetricDescription().getName()) && !element.getMeasurementSpecification().getMetricDescription().getName().contains(metricDescription.getName()) || this.availableSLOs.contains(element)) continue;
            this.availableSLOs.add(element);
        }
        if (this.availableSLOs.isEmpty()) {
            this.selectionStatus = new Status(4, "not_used", 0, "No applicable service level objective in repository.", null);
            this.updatePageStatus();
        } else {
            this.setAvailableSLOsInWizard();
        }
    }

    public IStatus updatePageStatus() {
        Status pageStatus = this.statusOK;
        ((SLOViewsWizard)this.getWizard()).setFinishable(false);
        switch (this.selectionStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage());
                pageStatus = this.statusOK;
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 2);
                pageStatus = this.selectionStatus;
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(this.selectionStatus.getMessage(), 1);
                pageStatus = this.selectionStatus;
                break;
            }
            default: {
                this.setErrorMessage(this.selectionStatus.getMessage());
                this.setMessage(null);
                pageStatus = this.selectionStatus;
            }
        }
        this.getContainer().updateButtons();
        return pageStatus;
    }

    private void setAvailableSLOsInWizard() {
        ((SLOViewsWizard)this.getWizard()).setAvailableSLOs(this.availableSLOs);
    }

    public void setSelectedMeasurements(List<Measurement> selectedMeasurements) {
    }

    public void modifyText(ModifyEvent e) {
        String uri = this.textFileNameToLoad.getText();
        uri.trim();
        if (uri.length() > 0) {
            this.loadSLORepository(uri);
        }
    }

    private class LocalFileSystemButtonSelectionAdapter
    implements SelectionListener {
        private final Text field;
        private final String[] extensions;
        private final String dialogTitle;

        public LocalFileSystemButtonSelectionAdapter(Text field, String[] allowedExtensions, String dialogTitle) {
            this.dialogTitle = dialogTitle;
            this.field = field;
            this.extensions = allowedExtensions;
        }

        public String openFileDialog(String[] fileExtension) {
            FileDialog dialog = new FileDialog(SLODialogChooseRepositoryPage.this.getShell(), 4096);
            dialog.setFilterExtensions(fileExtension);
            dialog.setText(this.dialogTitle);
            String filename = null;
            dialog.setFileName(this.field.getText());
            if (dialog.open() != null) {
                String root = String.valueOf(dialog.getFilterPath()) + File.separatorChar;
                filename = String.valueOf(root) + dialog.getFileName();
            }
            return filename;
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedFile = null;
            selectedFile = this.openFileDialog(this.extensions);
            if (selectedFile != null) {
                this.field.setText(selectedFile);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class WorkspaceButtonSelectionListener
    implements SelectionListener {
        private final Text field;
        private final String[] extensions;
        private final String dialogTitle;

        public WorkspaceButtonSelectionListener(Text field, String[] fileExtension, String dialogTitle, Shell shell) {
            this.field = field;
            this.extensions = fileExtension;
            this.dialogTitle = dialogTitle;
        }

        public String openFileDialog(String[] fileExtension) {
            IFile[] files;
            ArrayList<ExtensionsFilter> filters = new ArrayList<ExtensionsFilter>();
            if (fileExtension != null) {
                ExtensionsFilter filter = new ExtensionsFilter(fileExtension);
                filters.add(filter);
            }
            if ((files = WorkspaceResourceDialog.openFileSelection((Shell)SLODialogChooseRepositoryPage.this.getShell(), null, (String)this.dialogTitle, (boolean)false, null, filters)).length != 0 && files[0] != null) {
                System.out.println(files[0].getFullPath());
                String portableString = files[0].getFullPath().toPortableString();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                String workspaceDirectory = workspace.getRoot().getLocation().toFile().getPath().replace('\\', '/');
                String target = String.valueOf(workspaceDirectory) + portableString;
                return target;
            }
            return null;
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedFile = null;
            selectedFile = this.openFileDialog(this.extensions);
            if (selectedFile != null) {
                this.field.setText(selectedFile);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

