/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability;

import org.apache.log4j.Logger;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.Transition;
import org.palladiosimulator.solver.reliability.Inverse;

public class MarkovSolver {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovSolver.class.getName());
    private static MarkovSolver singletonSolver;

    public static MarkovSolver getSingletonInstance() {
        if (singletonSolver == null) {
            singletonSolver = new MarkovSolver();
        }
        return singletonSolver;
    }

    private MarkovSolver() {
    }

    public double[][] solve(MarkovChain markovChain) {
        LOGGER.debug((Object)("Solving Markov Chain [" + markovChain.getName() + "]"));
        double[][] transitionMatrix = new double[markovChain.getStates().size()][markovChain.getStates().size()];
        int i = 0;
        while (i < markovChain.getTransitions().size()) {
            Transition transition = (Transition)markovChain.getTransitions().get(i);
            int index_from = markovChain.getStates().indexOf((Object)transition.getFromState());
            int index_to = markovChain.getStates().indexOf((Object)transition.getToState());
            transitionMatrix[index_from][index_to] = ((Transition)markovChain.getTransitions().get(i)).getProbability();
            ++i;
        }
        i = 0;
        while (i < transitionMatrix.length) {
            int j = 0;
            while (j < transitionMatrix[i].length) {
                transitionMatrix[i][j] = (double)(i == j ? 1 : 0) - transitionMatrix[i][j];
                ++j;
            }
            ++i;
        }
        return Inverse.invert(transitionMatrix);
    }
}

