/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.pcm2markov;

import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_reliability.FailureHandlingEntity;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryAction;
import org.palladiosimulator.pcm.seff.seff_reliability.RecoveryActionBehaviour;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.MarkovHardwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovNetworkInducedFailureType;
import org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.State;
import org.palladiosimulator.reliability.markov.StateType;
import org.palladiosimulator.solver.reliability.pcm2markov.FailureDescription;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovBuilder;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovException;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResourceState;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationSource;
import org.palladiosimulator.solver.reliability.pcm2markov.ProcessingResourceDescriptor;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.visitors.EMFQueryHelper;

public class MarkovSeffVisitor
extends SeffSwitch<MarkovChain> {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovSeffVisitor.class.getName());
    private ContextWrapper contextWrapper;
    private final MarkovEvaluationType evaluationType;
    private final MarkovBuilder markovBuilder;
    private final boolean optimize;
    private final List<String> prefixes;
    private final boolean recordTraces;
    private final boolean simplifiedStateHandling;
    private final MarkovTransformationSource transformationState;

    public MarkovSeffVisitor(MarkovTransformationSource transformationState, ContextWrapper wrapper, List<String> prefixes, MarkovEvaluationType evaluationType, boolean simplifiedStateHandling, boolean optimize, boolean recordTraces) {
        this.transformationState = transformationState;
        this.contextWrapper = wrapper;
        this.prefixes = prefixes;
        this.evaluationType = evaluationType;
        this.optimize = optimize;
        this.recordTraces = recordTraces;
        this.simplifiedStateHandling = simplifiedStateHandling;
        this.markovBuilder = new MarkovBuilder(recordTraces);
    }

    private void addFailureDescription(List<FailureDescription> failureDescriptions, FailureDescription newFailureDescription) {
        FailureDescription existingFailureDescription = null;
        for (FailureDescription comparator : failureDescriptions) {
            if (!newFailureDescription.getFailureType().equals((Object)comparator.getFailureType())) continue;
            existingFailureDescription = comparator;
            break;
        }
        if (existingFailureDescription == null) {
            failureDescriptions.add(newFailureDescription);
        } else {
            existingFailureDescription.setFailureProbability(existingFailureDescription.getFailureProbability() + newFailureDescription.getFailureProbability());
        }
    }

    public MarkovChain caseAbstractInternalControlFlowAction(AbstractInternalControlFlowAction controlFlowAction) {
        if (!(controlFlowAction instanceof RecoveryAction)) {
            return null;
        }
        RecoveryAction action = (RecoveryAction)controlFlowAction;
        String name = String.valueOf(action.getEntityName()) + "[" + action.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit RecoveryAction: " + name));
        EList behaviours = action.getRecoveryActionBehaviours__RecoveryAction();
        if (behaviours.size() == 0) {
            throw new MarkovException("RecoveryAction '" + action.getEntityName() + "' does not specify any behaviours.");
        }
        MarkovChain resultChain = this.processRecoveryActionBehaviour(action, action.getPrimaryBehaviour__RecoveryAction());
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseAcquireAction(AcquireAction acquireAction) {
        String name = String.valueOf(acquireAction.getEntityName()) + "[" + acquireAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit AcquireAction: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseBranchAction(BranchAction branchAction) {
        String name = String.valueOf(branchAction.getEntityName()) + "[" + branchAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit BranchAction: " + name));
        EList transitions = branchAction.getBranches_Branch();
        ArrayList<MarkovChain> specificMarkovChains = new ArrayList<MarkovChain>();
        ArrayList<Double> branchProbabilities = new ArrayList<Double>();
        double branchProbabilitySum = 0.0;
        int i = 0;
        while (i < transitions.size()) {
            Double branchProbability = this.contextWrapper.getBranchProbability((AbstractBranchTransition)transitions.get(i));
            branchProbabilitySum += branchProbability.doubleValue();
            if (branchProbability > 1.0) {
                throw new MarkovException("Error in solved parametric dependencies detected: BranchAction \"" + branchAction.getEntityName() + "\" has probability " + branchProbability + ", which is greater than 1.0");
            }
            if (branchProbabilitySum > 1.0) {
                throw new MarkovException("Error in solved parametric dependencies detected: Branch probabilities of BranchAction \"" + branchAction.getEntityName() + "\" sum up to more than 1.0");
            }
            branchProbabilities.add(branchProbability);
            if (branchProbability > 0.0) {
                this.prefixes.add(String.valueOf(((AbstractBranchTransition)transitions.get(i)).getEntityName()) + "[" + ((AbstractBranchTransition)transitions.get(i)).getId() + "]");
                specificMarkovChains.add((MarkovChain)this.doSwitch((EObject)((AbstractBranchTransition)transitions.get(i)).getBranchBehaviour_BranchTransition()));
                this.prefixes.remove(this.prefixes.size() - 1);
            }
            ++i;
        }
        MarkovChain aggregateMarkovChain = this.markovBuilder.initBranchMarkovChain(this.prefixes, branchProbabilities);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i2 = 0;
        while (i2 < aggregateMarkovChain.getStates().size()) {
            if (((State)aggregateMarkovChain.getStates().get(i2)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)aggregateMarkovChain.getStates().get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, (MarkovChain)specificMarkovChains.get(i2), (State)statesToReplace.get(i2), this.optimize, false);
            ++i2;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    public MarkovChain caseCollectionIteratorAction(CollectionIteratorAction collectionIteratorAction) {
        String name = String.valueOf(collectionIteratorAction.getEntityName()) + "[" + collectionIteratorAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit CollectionIteratorAction: " + name));
        ArrayList<String> prefixesCopy = new ArrayList<String>();
        prefixesCopy.addAll(this.prefixes);
        this.prefixes.clear();
        MarkovChain specificMarkovChain = (MarkovChain)this.doSwitch((EObject)collectionIteratorAction.getBodyBehaviour_Loop());
        this.prefixes.addAll(prefixesCopy);
        ManagedPMF pmf = this.contextWrapper.getLoopIterations((AbstractLoopAction)collectionIteratorAction);
        MarkovChain aggregateMarkovChain = this.markovBuilder.initLoopMarkovChain(this.prefixes, pmf);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i = 0;
        while (i < aggregateMarkovChain.getStates().size()) {
            if (((State)aggregateMarkovChain.getStates().get(i)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)aggregateMarkovChain.getStates().get(i));
            }
            ++i;
        }
        i = 0;
        while (i < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, specificMarkovChain, (State)statesToReplace.get(i), this.optimize, true);
            ++i;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    private MarkovChain caseContainerAvailability(ResourceContainer container) {
        MarkovChain resultChain = null;
        resultChain = this.simplifiedStateHandling ? this.caseContainerAvailabilityForIteratedResourceStates(container) : this.caseContainerAvailabilityForResourceState(container);
        return resultChain;
    }

    private MarkovChain caseContainerAvailabilityForIteratedResourceStates(ResourceContainer container) {
        List<ProcessingResourceDescriptor> descriptors = this.getResourceDescriptors(container, true);
        ArrayList<Double> stateProbabilities = new ArrayList<Double>();
        ArrayList<MarkovChain> stateChains = new ArrayList<MarkovChain>();
        ArrayList<String> prefixesCopy = new ArrayList<String>();
        prefixesCopy.addAll(this.prefixes);
        this.prefixes.clear();
        long i = 0L;
        while ((double)i < Math.pow(2.0, descriptors.size())) {
            this.setResourceState(descriptors, i);
            stateProbabilities.add(this.getResourceStateProbability(descriptors));
            stateChains.add(this.caseContainerAvailabilityForResourceState(container));
            ++i;
        }
        this.prefixes.addAll(prefixesCopy);
        MarkovChain resultChain = this.markovBuilder.initBranchMarkovChain(this.prefixes, stateProbabilities);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i2 = 0;
        while (i2 < resultChain.getStates().size()) {
            if (((State)resultChain.getStates().get(i2)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)resultChain.getStates().get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(resultChain, (MarkovChain)stateChains.get(i2), (State)statesToReplace.get(i2), this.optimize, true);
            ++i2;
        }
        return resultChain;
    }

    private MarkovChain caseContainerAvailabilityForResourceState(ResourceContainer container) {
        List<ProcessingResourceDescriptor> descriptors = this.getResourceDescriptors(container, true);
        List<FailureDescription> failureDescriptions = this.getFailureDescriptionsForResourceState(descriptors);
        MarkovChain resultChain = null;
        resultChain = failureDescriptions.isEmpty() ? this.markovBuilder.initBasicMarkovChain(this.prefixes) : this.markovBuilder.initResourceFailureMarkovChain(this.prefixes, failureDescriptions);
        return resultChain;
    }

    public MarkovChain caseExternalCallAction(ExternalCallAction externalCallAction) {
        String name = String.valueOf(externalCallAction.getEntityName()) + "[" + externalCallAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit ExternalCallAction: " + name));
        ServiceEffectSpecification seff = this.contextWrapper.getNextSEFF(externalCallAction);
        MarkovChain resultChain = null;
        resultChain = seff == null ? this.caseExternalCallActionOutsideSystem(externalCallAction) : this.caseExternalCallActionInsideSystem(externalCallAction);
        if (this.evaluationType != MarkovEvaluationType.SINGLE && this.evaluationType != MarkovEvaluationType.CLASSES) {
            int retryCount = externalCallAction.getRetryCount();
            if (retryCount < 0) {
                LOGGER.warn((Object)("Retry count of ExternalCallAction \"" + externalCallAction.getEntityName() + "\" is negative. Assuming 0."));
                retryCount = 0;
            }
            List<String> failureTypeIds = this.getFailureTypeIds((FailureHandlingEntity)externalCallAction);
            MarkovChain handlingChain = this.markovBuilder.copyMarkovChain(resultChain);
            int i = 0;
            while (i < retryCount) {
                this.markovBuilder.appendFailureHandlingMarkovChain(resultChain, handlingChain, failureTypeIds, this.optimize);
                ++i;
            }
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    private MarkovChain caseExternalCallActionInsideSystem(ExternalCallAction call) {
        ServiceEffectSpecification seff = this.contextWrapper.getNextSEFF(call);
        ContextWrapper originalContextWrapper = (ContextWrapper)this.contextWrapper.clone();
        List contextWrapperList = this.contextWrapper.getContextWrapperFor(call);
        if (contextWrapperList.size() > 1) {
            LOGGER.error((Object)("The Reliability solver only supports one AllocationContext per AssemblyContext. Picking one of the called Allocation contexts for call " + call.getEntityName() + " " + call.getId() + " ignoring the others. Results will be inaccurate."));
        } else if (contextWrapperList.size() == 0) {
            throw new RuntimeException("Internal Error: Could not create a Context Wrapper for call " + call.getEntityName() + " " + call.getId());
        }
        ContextWrapper newContextWrapper = (ContextWrapper)contextWrapperList.get(0);
        this.contextWrapper = originalContextWrapper;
        MarkovChain resultChain = null;
        MarkovChain innerMarkovChain = (MarkovChain)new MarkovSeffVisitor(this.transformationState, newContextWrapper, this.prefixes, this.evaluationType, this.simplifiedStateHandling, this.optimize, this.recordTraces).doSwitch((EObject)seff);
        CommunicationLinkResourceSpecification commLink = this.contextWrapper.getConcreteLinkingResource(call, newContextWrapper.getAllCtx());
        if (commLink != null) {
            ArrayList<State> states = new ArrayList<State>();
            ArrayList<String> names = new ArrayList<String>();
            names.add("MessageTransfer(1)");
            names.add("ServiceExecution");
            names.add("MessageTransfer(2)");
            MarkovChain aggregateMarkovChain = this.markovBuilder.initSequentialMarkovChain(this.prefixes, names, states);
            this.prefixes.add(names.get(0));
            MarkovChain messagingMarkovChain = this.caseMessageTransfer(commLink);
            this.prefixes.remove(this.prefixes.size() - 1);
            this.prefixes.add(names.get(2));
            MarkovChain returnMarkovChain = this.caseMessageTransfer(commLink);
            this.prefixes.remove(this.prefixes.size() - 1);
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, messagingMarkovChain, states.get(0), this.optimize, false);
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, innerMarkovChain, states.get(1), this.optimize, false);
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, returnMarkovChain, states.get(2), this.optimize, false);
            resultChain = aggregateMarkovChain;
        } else {
            resultChain = innerMarkovChain;
        }
        return resultChain;
    }

    private MarkovChain caseExternalCallActionOutsideSystem(ExternalCallAction externalCallAction) {
        List rawFailureDescriptions = this.contextWrapper.getFailureOccurrenceDescriptionsForSystemExternalCall(externalCallAction);
        ArrayList<FailureDescription> resultFailureDescriptions = new ArrayList<FailureDescription>();
        for (ExternalFailureOccurrenceDescription description : rawFailureDescriptions) {
            Role role = description.getSpecifiedReliabilityAnnotation__ExternalFailureOccurrenceDescription().getRole_SpecifiedQoSAnnotation();
            Signature signature = description.getSpecifiedReliabilityAnnotation__ExternalFailureOccurrenceDescription().getSignature_SpecifiedQoSAnnation();
            FailureType failureType = description.getFailureType__ExternalFailureOccurrenceDescription();
            FailureDescription newFailureDescription = null;
            if (failureType instanceof SoftwareInducedFailureType) {
                newFailureDescription = new FailureDescription((MarkovFailureType)MarkovSoftwareInducedFailureType.createExternalFailureType((MarkovEvaluationType)this.evaluationType, (String)failureType.getId(), (String)signature.getId(), (String)role.getId()), description.getFailureProbability());
            } else if (failureType instanceof HardwareInducedFailureType) {
                newFailureDescription = new FailureDescription((MarkovFailureType)MarkovHardwareInducedFailureType.createExternalFailureType((MarkovEvaluationType)this.evaluationType, (String)((HardwareInducedFailureType)failureType).getProcessingResourceType__HardwareInducedFailureType().getId(), (String)signature.getId(), (String)role.getId()), description.getFailureProbability());
            } else if (failureType instanceof NetworkInducedFailureType) {
                newFailureDescription = new FailureDescription((MarkovFailureType)MarkovNetworkInducedFailureType.createExternalFailureType((MarkovEvaluationType)this.evaluationType, (String)((NetworkInducedFailureType)failureType).getCommunicationLinkResourceType__NetworkInducedFailureType().getId(), (String)signature.getId(), (String)role.getId()), description.getFailureProbability());
            }
            this.addFailureDescription(resultFailureDescriptions, newFailureDescription);
        }
        MarkovChain resultChain = resultFailureDescriptions.size() > 0 ? this.markovBuilder.initBasicMarkovChainWithFailures(this.prefixes, resultFailureDescriptions) : this.markovBuilder.initBasicMarkovChain(this.prefixes);
        return resultChain;
    }

    public MarkovChain caseForkAction(ForkAction forkAction) {
        String name = String.valueOf(forkAction.getEntityName()) + "[" + forkAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit ForkAction: " + name));
        ArrayList<MarkovChain> chains = new ArrayList<MarkovChain>();
        ArrayList<ForkedBehaviour> behaviours = new ArrayList<ForkedBehaviour>();
        int i = 0;
        while (i < forkAction.getAsynchronousForkedBehaviours_ForkAction().size()) {
            chains.add((MarkovChain)this.doSwitch((EObject)forkAction.getAsynchronousForkedBehaviours_ForkAction().get(i)));
            behaviours.add((ForkedBehaviour)forkAction.getAsynchronousForkedBehaviours_ForkAction().get(i));
            ++i;
        }
        SynchronisationPoint synch = forkAction.getSynchronisingBehaviours_ForkAction();
        if (synch != null) {
            int i2 = 0;
            while (i2 < synch.getSynchronousForkedBehaviours_SynchronisationPoint().size()) {
                chains.add((MarkovChain)this.doSwitch((EObject)synch.getSynchronousForkedBehaviours_SynchronisationPoint().get(i2)));
                behaviours.add((ForkedBehaviour)synch.getSynchronousForkedBehaviours_SynchronisationPoint().get(i2));
                ++i2;
            }
        }
        ArrayList<State> states = new ArrayList<State>();
        MarkovChain aggregateMarkovChain = this.markovBuilder.initForkMarkovChain(this.prefixes, behaviours, states);
        int i3 = 0;
        while (i3 < behaviours.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, (MarkovChain)chains.get(i3), states.get(i3), this.optimize, false);
            ++i3;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    public MarkovChain caseInternalAction(InternalAction internalAction) {
        String name = String.valueOf(internalAction.getEntityName()) + "[" + internalAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit InternalAction: " + name));
        MarkovChain resultChain = null;
        resultChain = this.simplifiedStateHandling ? this.caseInternalActionForIteratedResourceStates(internalAction) : this.caseInternalActionForResourceState(internalAction);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    private MarkovChain caseInternalActionForIteratedResourceStates(InternalAction internalAction) {
        List<ProcessingResourceDescriptor> descriptors = this.getResourceDescriptors(internalAction);
        ArrayList<Double> stateProbabilities = new ArrayList<Double>();
        ArrayList<MarkovChain> stateChains = new ArrayList<MarkovChain>();
        ArrayList<String> prefixesCopy = new ArrayList<String>();
        prefixesCopy.addAll(this.prefixes);
        this.prefixes.clear();
        long i = 0L;
        while ((double)i < Math.pow(2.0, descriptors.size())) {
            this.setResourceState(descriptors, i);
            stateProbabilities.add(this.getResourceStateProbability(descriptors));
            stateChains.add(this.caseInternalActionForResourceState(internalAction));
            ++i;
        }
        this.prefixes.addAll(prefixesCopy);
        MarkovChain resultChain = this.markovBuilder.initBranchMarkovChain(this.prefixes, stateProbabilities);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i2 = 0;
        while (i2 < resultChain.getStates().size()) {
            if (((State)resultChain.getStates().get(i2)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)resultChain.getStates().get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(resultChain, (MarkovChain)stateChains.get(i2), (State)statesToReplace.get(i2), this.optimize, true);
            ++i2;
        }
        return resultChain;
    }

    private MarkovChain caseInternalActionForResourceState(InternalAction internalAction) {
        List<ProcessingResourceDescriptor> descriptors = this.getResourceDescriptors(internalAction);
        List<FailureDescription> failureDescriptions = this.getFailureDescriptionsForResourceState(descriptors);
        MarkovChain resultChain = null;
        if (failureDescriptions.isEmpty()) {
            failureDescriptions = this.getInternalActionSoftwareFailureDescriptions(internalAction);
            resultChain = this.markovBuilder.initBasicMarkovChainWithFailures(this.prefixes, failureDescriptions);
        } else {
            resultChain = this.markovBuilder.initResourceFailureMarkovChain(this.prefixes, failureDescriptions);
        }
        return resultChain;
    }

    public MarkovChain caseLoopAction(LoopAction loopAction) {
        String name = String.valueOf(loopAction.getEntityName()) + "[" + loopAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit LoopAction: " + name));
        ArrayList<String> prefixesCopy = new ArrayList<String>();
        prefixesCopy.addAll(this.prefixes);
        this.prefixes.clear();
        MarkovChain specificMarkovChain = (MarkovChain)this.doSwitch((EObject)loopAction.getBodyBehaviour_Loop());
        this.prefixes.addAll(prefixesCopy);
        ManagedPMF pmf = this.contextWrapper.getLoopIterations((AbstractLoopAction)loopAction);
        MarkovChain aggregateMarkovChain = this.markovBuilder.initLoopMarkovChain(this.prefixes, pmf);
        ArrayList<State> statesToReplace = new ArrayList<State>();
        int i = 0;
        while (i < aggregateMarkovChain.getStates().size()) {
            if (((State)aggregateMarkovChain.getStates().get(i)).getType().equals((Object)StateType.DEFAULT)) {
                statesToReplace.add((State)aggregateMarkovChain.getStates().get(i));
            }
            ++i;
        }
        i = 0;
        while (i < statesToReplace.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, specificMarkovChain, (State)statesToReplace.get(i), this.optimize, true);
            ++i;
        }
        this.prefixes.remove(this.prefixes.size() - 1);
        return aggregateMarkovChain;
    }

    private MarkovChain caseMessageTransfer(CommunicationLinkResourceSpecification commLink) {
        List<FailureDescription> commFailureDescriptions = this.getFailureDescriptionsForCommunicationLink(commLink);
        MarkovChain messagingMarkovChain = this.markovBuilder.initBasicMarkovChainWithFailures(this.prefixes, commFailureDescriptions);
        return messagingMarkovChain;
    }

    public MarkovChain caseReleaseAction(ReleaseAction releaseAction) {
        String name = String.valueOf(releaseAction.getEntityName()) + "[" + releaseAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit ReleaseAction: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseResourceDemandingBehaviour(ResourceDemandingBehaviour behaviour) {
        LOGGER.debug((Object)"Visit ResourceDemandingBehaviour");
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        ArrayList<MarkovChain> chains = new ArrayList<MarkovChain>();
        StartAction action = (StartAction)EMFQueryHelper.getObjectByType((EList)behaviour.getSteps_Behaviour(), StartAction.class);
        while (action != null) {
            MarkovChain specificMarkovChain = (MarkovChain)this.doSwitch((EObject)action);
            actions.add((AbstractAction)action);
            chains.add(specificMarkovChain);
            action = action.getSuccessor_AbstractAction();
        }
        ArrayList<State> states = new ArrayList<State>();
        MarkovChain aggregateMarkovChain = this.markovBuilder.initBehaviourMarkovChainByAction(this.prefixes, actions, states);
        int i = 0;
        while (i < actions.size()) {
            this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, (MarkovChain)chains.get(i), states.get(i), this.optimize, false);
            ++i;
        }
        return aggregateMarkovChain;
    }

    public MarkovChain caseResourceDemandingSEFF(ResourceDemandingSEFF seff) {
        LOGGER.debug((Object)("Visit ResourceDemandingSEFF: [" + seff.getId() + "]"));
        ArrayList<State> states = new ArrayList<State>();
        ArrayList<String> names = new ArrayList<String>();
        names.add("ContainerAvailability");
        names.add("ServiceExecution");
        MarkovChain aggregateMarkovChain = this.markovBuilder.initSequentialMarkovChain(this.prefixes, names, states);
        this.prefixes.add(names.get(0));
        ResourceContainer container = this.contextWrapper.getAllCtx().getResourceContainer_AllocationContext();
        MarkovChain containerAvailabilityMarkovChain = this.caseContainerAvailability(container);
        this.prefixes.remove(this.prefixes.size() - 1);
        this.prefixes.add(names.get(1));
        MarkovChain innerMarkovChain = this.caseResourceDemandingBehaviour((ResourceDemandingBehaviour)seff);
        this.prefixes.remove(this.prefixes.size() - 1);
        this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, containerAvailabilityMarkovChain, states.get(0), this.optimize, false);
        this.markovBuilder.incorporateMarkovChain(aggregateMarkovChain, innerMarkovChain, states.get(1), this.optimize, false);
        return aggregateMarkovChain;
    }

    public MarkovChain caseSetVariableAction(SetVariableAction setVariableAction) {
        String name = String.valueOf(setVariableAction.getEntityName()) + "[" + setVariableAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit SetVariableAction: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseStartAction(StartAction startAction) {
        String name = String.valueOf(startAction.getEntityName()) + "[" + startAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit StartAction: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    public MarkovChain caseStopAction(StopAction stopAction) {
        String name = String.valueOf(stopAction.getEntityName()) + "[" + stopAction.getId() + "]";
        this.prefixes.add(name);
        LOGGER.debug((Object)("Visit StopAction: " + name));
        MarkovChain resultChain = this.markovBuilder.initBasicMarkovChain(this.prefixes);
        this.prefixes.remove(this.prefixes.size() - 1);
        return resultChain;
    }

    private List<FailureDescription> getFailureDescriptionsForCommunicationLink(CommunicationLinkResourceSpecification commLink) {
        ArrayList<FailureDescription> commFailureDescriptions = new ArrayList<FailureDescription>();
        commFailureDescriptions.add(new FailureDescription((MarkovFailureType)MarkovNetworkInducedFailureType.createInternalFailureType((MarkovEvaluationType)this.evaluationType, (LinkingResource)commLink.getLinkingResource_CommunicationLinkResourceSpecification(), (CommunicationLinkResourceType)commLink.getCommunicationLinkResourceType_CommunicationLinkResourceSpecification()), commLink.getFailureProbability()));
        return commFailureDescriptions;
    }

    private List<FailureDescription> getFailureDescriptionsForResourceState(List<ProcessingResourceDescriptor> descriptors) {
        ArrayList<FailureDescription> failureDescriptions = new ArrayList<FailureDescription>();
        FailureDescription newFailureDescription = null;
        for (ProcessingResourceDescriptor descriptor : descriptors) {
            MarkovResourceState state = descriptor.getCurrentState();
            if (state == null) {
                LOGGER.error((Object)("Resource state no set for " + descriptor.getType().getName() + " resource demand. Assume resource state = OK."));
                continue;
            }
            if (!state.equals((Object)MarkovResourceState.NA)) continue;
            newFailureDescription = new FailureDescription((MarkovFailureType)MarkovHardwareInducedFailureType.createInternalFailureType((MarkovEvaluationType)this.evaluationType, (String)descriptor.getResourceContainerId(), (String)descriptor.getType().getId()), 1.0);
            this.addFailureDescription(failureDescriptions, newFailureDescription);
        }
        return failureDescriptions;
    }

    private List<String> getFailureTypeIds(FailureHandlingEntity entity) {
        ArrayList<String> failureTypes = new ArrayList<String>();
        for (FailureType failureType : entity.getFailureTypes_FailureHandlingEntity()) {
            if (failureType instanceof SoftwareInducedFailureType) {
                failureTypes.add(failureType.getId());
                continue;
            }
            if (failureType instanceof HardwareInducedFailureType) {
                failureTypes.add(((HardwareInducedFailureType)failureType).getProcessingResourceType__HardwareInducedFailureType().getId());
                continue;
            }
            if (failureType instanceof NetworkInducedFailureType) {
                failureTypes.add(((NetworkInducedFailureType)failureType).getCommunicationLinkResourceType__NetworkInducedFailureType().getId());
                continue;
            }
            throw new MarkovException("Unsupported failure type " + failureType.getClass().getName());
        }
        return failureTypes;
    }

    private List<FailureDescription> getInternalActionSoftwareFailureDescriptions(InternalAction internalAction) {
        ArrayList<FailureDescription> failureDescriptions = new ArrayList<FailureDescription>();
        FailureDescription newFailureDescription = null;
        for (InternalFailureOccurrenceDescription description : internalAction.getInternalFailureOccurrenceDescriptions__InternalAction()) {
            newFailureDescription = new FailureDescription((MarkovFailureType)MarkovSoftwareInducedFailureType.createInternalFailureType((MarkovEvaluationType)this.evaluationType, (String)description.getSoftwareInducedFailureType__InternalFailureOccurrenceDescription().getId(), (String)internalAction.getId()), description.getFailureProbability());
            this.addFailureDescription(failureDescriptions, newFailureDescription);
        }
        return failureDescriptions;
    }

    private List<ProcessingResourceDescriptor> getResourceDescriptors(InternalAction internalAction) {
        ArrayList<ProcessingResourceDescriptor> resultList = new ArrayList<ProcessingResourceDescriptor>();
        for (ParametricResourceDemand demand : internalAction.getResourceDemand_Action()) {
            if (demand.getRequiredResource_ParametricResourceDemand().getEntityName().equals("SystemExternalResource")) continue;
            ProcessingResourceDescriptor descriptor = this.transformationState.getDescriptor(demand, this.contextWrapper);
            if (descriptor == null) {
                LOGGER.error((Object)("Missing resource description for " + demand.getRequiredResource_ParametricResourceDemand().getEntityName() + " resource demand. Assume resource state = OK."));
                continue;
            }
            resultList.add(descriptor);
        }
        return resultList;
    }

    private List<ProcessingResourceDescriptor> getResourceDescriptors(ResourceContainer resourceContainer, boolean searchForRequiredResources) {
        ArrayList<ProcessingResourceDescriptor> resultList = new ArrayList<ProcessingResourceDescriptor>();
        for (ProcessingResourceSpecification resource : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
            if (searchForRequiredResources && !resource.isRequiredByContainer()) continue;
            ProcessingResourceDescriptor descriptor = this.transformationState.getDescriptor(resource);
            if (descriptor == null) {
                LOGGER.error((Object)("Missing resource description for resource " + resource.getActiveResourceType_ActiveResourceSpecification().getEntityName() + " in container " + resourceContainer.getEntityName() + ". Assume resource state = OK."));
                continue;
            }
            resultList.add(descriptor);
        }
        return resultList;
    }

    private double getResourceStateProbability(List<ProcessingResourceDescriptor> descriptors) {
        double stateProbability = 1.0;
        for (ProcessingResourceDescriptor descriptor : descriptors) {
            stateProbability *= descriptor.getStateProbability(descriptor.getCurrentState()).doubleValue();
        }
        return stateProbability;
    }

    private MarkovChain processRecoveryActionBehaviour(RecoveryAction action, RecoveryActionBehaviour behaviour) {
        this.prefixes.add("Alternative(" + action.getRecoveryActionBehaviours__RecoveryAction().indexOf((Object)behaviour) + ")");
        MarkovChain resultChain = this.caseResourceDemandingBehaviour((ResourceDemandingBehaviour)behaviour);
        this.prefixes.remove(this.prefixes.size() - 1);
        if (this.evaluationType != MarkovEvaluationType.SINGLE && this.evaluationType != MarkovEvaluationType.CLASSES && behaviour.getFailureHandlingAlternatives__RecoveryActionBehaviour().size() > 0) {
            ArrayList<MarkovChain> failureHandlingChains = new ArrayList<MarkovChain>();
            ArrayList<List<String>> failureTypeLists = new ArrayList<List<String>>();
            for (RecoveryActionBehaviour handlingAlternative : behaviour.getFailureHandlingAlternatives__RecoveryActionBehaviour()) {
                failureTypeLists.add(this.getFailureTypeIds((FailureHandlingEntity)handlingAlternative));
                failureHandlingChains.add(this.processRecoveryActionBehaviour(action, handlingAlternative));
            }
            this.markovBuilder.appendFailureHandlingMarkovChains(resultChain, failureHandlingChains, failureTypeLists, this.optimize);
        }
        return resultChain;
    }

    private void setResourceState(List<ProcessingResourceDescriptor> descriptors, long number) {
        int i = 0;
        while (i < descriptors.size()) {
            MarkovResourceState state = (number >> i) % 2L == 0L ? MarkovResourceState.OK : MarkovResourceState.NA;
            descriptors.get(i).setCurrentState(state);
            ++i;
        }
    }
}

