/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.pcm2markov;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.State;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovBuilder;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovException;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResultApproximation;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationSource;
import org.palladiosimulator.solver.reliability.pcm2markov.ProcessingResourceDescriptor;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;

public class MarkovTransformationResult {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovTransformationResult.class.getName());
    private boolean approximate;
    private final PCMSolverWorkflowRunConfiguration configuration;
    private final Map<MarkovFailureType, Double> cumulatedFailureTypeProbabilities = new HashMap<MarkovFailureType, Double>();
    private double cumulatedPhysicalStateProbability;
    private double cumulatedSuccessProbability;
    private final List<MarkovFailureType> failureTypes;
    private final MarkovBuilder markovBuilder;
    private final MarkovTransformationSource markovSource;
    private final long numberOfPhysicalSystemStates;
    private long physicalStateEvaluationCount;
    private MarkovChain resultChain;
    private final UsageScenario scenario;

    public MarkovTransformationResult(PCMSolverWorkflowRunConfiguration configuration, MarkovTransformationSource markovSource, UsageScenario scenario, List<MarkovFailureType> failureTypes) {
        this.configuration = configuration;
        this.cumulatedPhysicalStateProbability = 0.0;
        this.cumulatedSuccessProbability = 0.0;
        this.markovBuilder = new MarkovBuilder(false);
        this.markovSource = markovSource;
        this.physicalStateEvaluationCount = 0L;
        this.numberOfPhysicalSystemStates = (long)Math.pow(2.0, markovSource.getUnreliableResourceDescriptors().size());
        this.resultChain = null;
        this.scenario = scenario;
        this.failureTypes = failureTypes;
    }

    public void addPhysicalStateResults(MarkovChain resultChain, double[][] markovProbabilityMatrix, double physicalStateProbability) {
        int indexSuccess;
        int indexStart;
        double successProbability;
        if (physicalStateProbability < 0.0 || physicalStateProbability > 1.0) {
            throw new MarkovException("Illegal physical state probability (" + physicalStateProbability + "). The value must be in [0,1].");
        }
        if (this.physicalStateEvaluationCount == 0L) {
            this.resultChain = resultChain;
        }
        if ((successProbability = markovProbabilityMatrix[indexStart = this.markovBuilder.indexOf(resultChain, this.markovBuilder.getStartState(resultChain))][indexSuccess = this.markovBuilder.indexOf(resultChain, this.markovBuilder.getSuccessState(resultChain))]) < 0.0 || successProbability > 1.0) {
            double correctedSuccessProbability = successProbability < 0.5 ? 0.0 : 1.0;
            LOGGER.warn((Object)("Illegal success probability " + successProbability + " outside [0,1]. Assuming a rounding error. " + "Setting success probability to " + correctedSuccessProbability));
            successProbability = correctedSuccessProbability;
        }
        this.cumulatedPhysicalStateProbability += physicalStateProbability;
        this.cumulatedSuccessProbability += physicalStateProbability * successProbability;
        List<State> failureStates = this.markovBuilder.getFailureStates(resultChain);
        int i = 0;
        while (i < failureStates.size()) {
            MarkovFailureType failureType;
            double failureTypeProbability = markovProbabilityMatrix[indexStart][this.markovBuilder.indexOf(resultChain, failureStates.get(i))];
            if (failureTypeProbability < 0.0 || failureTypeProbability > 1.0) {
                throw new MarkovException("Illegal failure type probability (" + failureTypeProbability + "). The value must be in [0,1].");
            }
            double failureTypeProbabilityDelta = physicalStateProbability * failureTypeProbability;
            String failureTypeId = this.markovBuilder.getFailureTypeId(failureStates.get(i));
            Double failureProbability = this.cumulatedFailureTypeProbabilities.get(failureType = this.getFailureType(failureTypeId));
            this.cumulatedFailureTypeProbabilities.put(failureType, (failureProbability == null ? 0.0 : failureProbability) + failureTypeProbabilityDelta);
            ++i;
        }
        ++this.physicalStateEvaluationCount;
        if (this.configuration.isPrintMarkovSingleResults()) {
            BufferedWriter out = null;
            String filePath = this.resolveFile(this.configuration.getLogFile());
            try {
                try {
                    if (this.physicalStateEvaluationCount == 1L) {
                        File f = new File(filePath);
                        if (f.exists()) {
                            f.delete();
                            f.createNewFile();
                        }
                        out = new BufferedWriter(new FileWriter(filePath, true));
                        LOGGER.info((Object)("Logging results of all Markov transformation runs to: " + filePath));
                        out.append(String.valueOf(this.getLogHeadings()) + System.getProperty("line.separator"));
                        out.flush();
                        out.close();
                    }
                    out = new BufferedWriter(new FileWriter(filePath, true));
                    out.append(String.valueOf(this.getLogSingleResults(successProbability, physicalStateProbability)) + System.getProperty("line.separator"));
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Map<MarkovFailureType, Double> getCumulatedFailureTypeProbabilities() {
        return this.cumulatedFailureTypeProbabilities;
    }

    public double getCumulatedPhysicalStateProbability() {
        return this.cumulatedPhysicalStateProbability;
    }

    private MarkovFailureType getFailureType(String failureTypeId) {
        for (MarkovFailureType failureType : this.failureTypes) {
            if (!failureType.getId().equals(failureTypeId)) continue;
            return failureType;
        }
        throw new IllegalArgumentException("MarkovTransformationResult: Failure type with ID \"" + failureTypeId + "\" not found!");
    }

    private String getLogHeadings() {
        StringBuilder resultString = new StringBuilder();
        resultString.append("physical system state number;");
        for (ProcessingResourceDescriptor descriptor : this.markovSource.getUnreliableResourceDescriptors()) {
            resultString.append(String.valueOf(descriptor.getResourceContainerName()) + " - " + descriptor.getType().getName() + ";");
        }
        resultString.append("success probability;");
        resultString.append("physical state probability");
        return resultString.toString();
    }

    private String getLogSingleResults(double successProbability, double physicalStateProbability) {
        StringBuilder resultString = new StringBuilder();
        resultString.append(String.valueOf(this.physicalStateEvaluationCount) + ";");
        for (ProcessingResourceDescriptor descriptor : this.markovSource.getUnreliableResourceDescriptors()) {
            resultString.append(String.valueOf(descriptor.getCurrentState().name()) + ";");
        }
        resultString.append(String.valueOf(successProbability) + ";");
        resultString.append(physicalStateProbability);
        return resultString.toString();
    }

    public long getNumberOfPhysicalSystemStates() {
        return this.numberOfPhysicalSystemStates;
    }

    public long getPhysicalStateEvaluationCount() {
        return this.physicalStateEvaluationCount;
    }

    public MarkovChain getResultChain() {
        return this.resultChain;
    }

    public UsageScenario getScenario() {
        return this.scenario;
    }

    public double getSuccessProbability() {
        return this.cumulatedSuccessProbability;
    }

    public boolean hasRequiredAccuracy(int requiredAccuracy) {
        MarkovResultApproximation approximation = new MarkovResultApproximation(this.cumulatedSuccessProbability, this.cumulatedSuccessProbability + (1.0 - this.cumulatedPhysicalStateProbability));
        return approximation.hasRequiredAccuracy(requiredAccuracy);
    }

    public boolean isDoApproximate() {
        return this.configuration.isIterationOverPhysicalSystemStatesEnabled() && this.approximate && (double)this.physicalStateEvaluationCount < Math.pow(this.markovSource.getUnreliableResourceDescriptors().size(), 2.0);
    }

    private String resolveFile(String fileURL) {
        if (fileURL.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(fileURL));
                fileURL = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return fileURL;
    }

    public void setApproximate(boolean approximate) {
        this.approximate = approximate;
    }
}

