/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.pcm2markov;

import java.util.HashMap;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResourceState;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovResourceType;

public class ProcessingResourceDescriptor {
    static final String NOTSPECIFIED = "UNKNOWN";
    private String containerId;
    private String containerName;
    private MarkovResourceState currentState;
    private boolean requiredByContainer;
    private HashMap<MarkovResourceState, Double> stateProbabilities = new HashMap();
    private MarkovResourceType type;

    public ProcessingResourceDescriptor() {
        this.setStateProbability(MarkovResourceState.OK, 1.0);
        this.setStateProbability(MarkovResourceState.NA, 0.0);
        this.setCurrentState(MarkovResourceState.OK);
        this.setContainerId(NOTSPECIFIED);
        this.setContainerName(NOTSPECIFIED);
        this.setRequiredByContainer(false);
        this.type = new MarkovResourceType();
    }

    public MarkovResourceState getCurrentState() {
        return this.currentState;
    }

    public MarkovResourceState getDefaultState() {
        return MarkovResourceState.OK;
    }

    public String getResourceContainerId() {
        return this.containerId;
    }

    public String getResourceContainerName() {
        return this.containerName;
    }

    public Double getStateProbability(MarkovResourceState state) {
        return this.stateProbabilities.get((Object)state);
    }

    public MarkovResourceType getType() {
        return this.type;
    }

    public boolean isRequiredByContainer() {
        return this.requiredByContainer;
    }

    public void setContainerId(String resourceContainerId) {
        this.containerId = resourceContainerId;
    }

    public void setContainerName(String resourceContainerName) {
        this.containerName = resourceContainerName;
    }

    public void setCurrentState(MarkovResourceState state) {
        this.currentState = state;
    }

    public void setId(String typeId) {
        this.type.setId(typeId);
    }

    public void setName(String typeName) {
        this.type.setName(typeName);
    }

    public void setRequiredByContainer(boolean requiredByContainer) {
        this.requiredByContainer = requiredByContainer;
    }

    public void setStateProbability(MarkovResourceState state, Double probability) {
        this.stateProbabilities.put(state, probability);
    }

    public void switchState() {
        this.currentState = this.currentState == MarkovResourceState.OK ? MarkovResourceState.NA : MarkovResourceState.OK;
    }
}

