/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.runconfig;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.reliability.pcm2markov.Pcm2MarkovStrategy;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.SolverStrategy;

public class RunPCMReliabilityAnalysisJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger((String)RunPCMReliabilityAnalysisJob.class.getName());
    private MDSDBlackboard blackboard;
    private Pcm2MarkovStrategy strategy;

    public RunPCMReliabilityAnalysisJob(PCMSolverWorkflowRunConfiguration configuration) {
        PDFConfiguration.setCurrentConfiguration((int)configuration.getDomainSize(), (double)configuration.getDistance(), (IUnit)IProbabilityFunctionFactory.eINSTANCE.createDefaultUnit());
        if (!configuration.isReliabilityAnalysis()) {
            throw new RuntimeException("Invoked reliability analysis with incompatible configuration data!");
        }
        this.strategy = new Pcm2MarkovStrategy(configuration);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMInstance currentModel = new PCMInstance((PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition"));
        if (!currentModel.isValid()) {
            LOGGER.error((Object)"PCM Instance invalid! Check filenames.");
            return;
        }
        monitor.beginTask("Analysis", 100);
        this.strategy.transform(currentModel);
        monitor.worked(50);
        this.strategy.solve();
        monitor.worked(50);
    }

    public String getName() {
        return "Run PCM Reliability Analysis";
    }

    public SolverStrategy getStrategy() {
        return this.strategy;
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

