/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.sensitivity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.reliability.helper.EMFHelper;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityResultSpecification;
import org.palladiosimulator.reliability.sensitivity.StringParameterSequence;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.solver.reliability.sensitivity.SensitivityCalculator;

public abstract class MarkovSensitivity {
    private static final String LOG_ENTRY_SEPARATOR = "\\";
    protected static final Logger LOGGER = Logger.getLogger(MarkovSensitivity.class);
    protected SensitivityCalculator calculator = new SensitivityCalculator();
    private int currentStepNumber = 0;
    protected EMFHelper helper = new EMFHelper();
    private List<List<String>> logContents = null;
    protected BufferedWriter logWriter = null;
    protected PCMInstance model;
    protected String name = null;
    protected int numberOfSteps;
    private String resultLogfile = null;
    private EList<SensitivityResultSpecification> resultSpecifications = null;
    private SensitivityParameterVariation variation = null;

    protected MarkovSensitivity(String name, SensitivityParameterVariation variation) {
        this.name = name;
        if (variation != null) {
            this.variation = variation;
            this.numberOfSteps = this.calculator.calculateNumberOfSteps(variation);
        }
    }

    protected abstract boolean alterModel();

    private void assureLogHeadingsSize(List<List<String>> list) {
        int numColumns = list.get(0).size();
        int numLines = list.size();
        if (numLines < 3) {
            int i = numLines;
            while (i < 3) {
                ArrayList<String> newLine = new ArrayList<String>();
                int y = 0;
                while (y < numColumns) {
                    newLine.add("");
                    ++y;
                }
                list.add(0, newLine);
                ++i;
            }
        }
    }

    protected abstract void extractSensitivityInformation();

    private void fillEmptyEntries(List<List<String>> list) {
        int numLines = list.size();
        int maxNumColumns = 0;
        int i = 0;
        while (i < numLines) {
            if (list.get(i).size() > maxNumColumns) {
                maxNumColumns = list.get(i).size();
            }
            ++i;
        }
        i = 0;
        while (i < numLines) {
            int y = list.get(i).size();
            while (y < maxNumColumns) {
                list.get(i).add("");
                ++y;
            }
            ++i;
        }
    }

    public void finalize() {
        try {
            int lineNumber = 0;
            while (lineNumber < this.logContents.size()) {
                int index = 0;
                while (index < this.logContents.get(lineNumber).size()) {
                    this.logWriter.append(String.valueOf(this.logContents.get(lineNumber).get(index)) + LOG_ENTRY_SEPARATOR);
                    ++index;
                }
                this.logWriter.append(System.getProperty("line.separator"));
                ++lineNumber;
            }
            this.logWriter.flush();
            this.logWriter.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)("Log file could not be written :" + e.getMessage()));
            e.printStackTrace();
        }
    }

    protected int getCurrentStepNumber() {
        return this.currentStepNumber;
    }

    protected DoubleParameterVariation getDoubleVariation() {
        return (DoubleParameterVariation)this.variation;
    }

    private List<List<String>> getLogHeadings() {
        List<List<String>> resultList = this.getLogHeadingsMulti();
        this.assureLogHeadingsSize(resultList);
        for (UsageScenario scenario : this.model.getUsageModel().getUsageScenario_UsageModel()) {
            resultList.get(resultList.size() - 3).add(scenario.getEntityName());
            resultList.get(resultList.size() - 2).add("Success Probability");
            resultList.get(resultList.size() - 2).add("Failure Probability");
            resultList.get(resultList.size() - 1).add("");
            resultList.get(resultList.size() - 1).add("Total");
            int i = 0;
            while (i < this.resultSpecifications.size()) {
                resultList.get(resultList.size() - 1).add(((SensitivityResultSpecification)this.resultSpecifications.get(i)).getEntityName());
                ++i;
            }
            this.fillEmptyEntries(resultList);
        }
        return resultList;
    }

    protected abstract List<List<String>> getLogHeadingsMulti();

    protected List<String> getLogSingleResults(List<MarkovTransformationResult> markovResults) {
        List<String> resultList = this.getLogSingleResultsMulti();
        for (MarkovTransformationResult result : markovResults) {
            resultList.add(Double.valueOf(result.getSuccessProbability()).toString());
            resultList.add(Double.valueOf(1.0 - result.getSuccessProbability()).toString());
            int i = 0;
            while (i < this.resultSpecifications.size()) {
                resultList.add(Double.valueOf(this.calculator.calculateFailurePotential(result, (SensitivityResultSpecification)this.resultSpecifications.get(i))).toString());
                ++i;
            }
        }
        return resultList;
    }

    protected abstract List<String> getLogSingleResultsMulti();

    protected PCMInstance getModel() {
        return this.model;
    }

    public PCMInstance getNextModel() {
        if (this.increaseCurrentStepNumber()) {
            return null;
        }
        if (!this.alterModel()) {
            LOGGER.error((Object)"PCM instance could not be successfully altered by Markov sensitivity analysis.");
            return null;
        }
        return this.model;
    }

    protected StringParameterSequence getStringSequence() {
        return (StringParameterSequence)this.variation;
    }

    protected boolean increaseCurrentStepNumber() {
        if (this.currentStepNumber < this.numberOfSteps) {
            ++this.currentStepNumber;
            return false;
        }
        return true;
    }

    public void initialize(PCMInstance model) {
        this.setModel(model);
        try {
            new File(this.resultLogfile).delete();
            this.logWriter = new BufferedWriter(new FileWriter(this.resultLogfile, false));
        }
        catch (IOException e) {
            LOGGER.error((Object)("Log file could not be initialized :" + e.getMessage()));
            e.printStackTrace();
        }
        this.logContents = this.getLogHeadings();
    }

    public void logResults(List<MarkovTransformationResult> markovResults) {
        this.logContents.add(this.getLogSingleResults(markovResults));
    }

    protected void resetCurrentStepNumber() {
        this.currentStepNumber = 1;
    }

    public void setLogFileName(String logFileName) {
        this.resultLogfile = logFileName;
    }

    protected void setModel(PCMInstance model) {
        this.model = model;
        this.extractSensitivityInformation();
    }

    public void setResultSpecifications(EList<SensitivityResultSpecification> resultSpecifications) {
        this.resultSpecifications = resultSpecifications;
    }
}

