/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.reliability.sensitivity;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.reliability.helper.EMFHelper;
import org.palladiosimulator.reliability.sensitivity.CombinedSensitivityParameter;
import org.palladiosimulator.reliability.sensitivity.CommunicationLinkReliabilityParameter;
import org.palladiosimulator.reliability.sensitivity.ComponentReliabilityParameter;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.HardwareMTTFParameter;
import org.palladiosimulator.reliability.sensitivity.HardwareMTTRParameter;
import org.palladiosimulator.reliability.sensitivity.InternalActionReliabilityParameter;
import org.palladiosimulator.reliability.sensitivity.NetworkReliabilityParameter;
import org.palladiosimulator.reliability.sensitivity.ProbabilisticBranchParameter;
import org.palladiosimulator.reliability.sensitivity.ResourceMTTFParameter;
import org.palladiosimulator.reliability.sensitivity.ResourceMTTRParameter;
import org.palladiosimulator.reliability.sensitivity.SensitivityConfiguration;
import org.palladiosimulator.reliability.sensitivity.SensitivityPackage;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameter;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityResultSpecification;
import org.palladiosimulator.reliability.sensitivity.SoftwareFailureTypesParameter;
import org.palladiosimulator.reliability.sensitivity.SoftwareReliabilityParameter;
import org.palladiosimulator.reliability.sensitivity.StringParameterSequence;
import org.palladiosimulator.reliability.sensitivity.UsageBranchParameter;
import org.palladiosimulator.reliability.sensitivity.VariableUsageParameter;
import org.palladiosimulator.solver.reliability.sensitivity.ComponentSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.FailureTypeSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.InternalActionSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.MTTFSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.MTTRSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.MarkovSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.MultiSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.NetworkSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.ProbabilisticBranchSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.ResourceMTTFSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.ResourceMTTRSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.SoftwareSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.UsageBranchSensitivity;
import org.palladiosimulator.solver.reliability.sensitivity.VariableUsageSensitivity;

public class MarkovSensitivityBuilder {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovSensitivityBuilder.class.getName());

    public MarkovSensitivity buildSensitivity(String sensitivityModelFileName, String sensitivityLogFileName) {
        SensitivityConfiguration sensitivityConfig = (SensitivityConfiguration)EMFHelper.loadFromXMIFile((String)sensitivityModelFileName, (String)"http://palladiosimulator.org/Reliability/Sensitivity/1.0", (EPackage)SensitivityPackage.eINSTANCE);
        return this.createMarkovSensitivity(sensitivityConfig.getSensitivityParameters__SensitivityConfiguration(), (EList<SensitivityResultSpecification>)sensitivityConfig.getSensitivityResultSpecifications__SensitivityConfiguration(), sensitivityLogFileName);
    }

    private ComponentSensitivity createComponentSensitivity(ComponentReliabilityParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new ComponentSensitivity(parameter.getEntityName(), parameter.getBasicComponent__ComponentReliabilityParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private FailureTypeSensitivity createFailureTypeSensitivity(SoftwareFailureTypesParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            ArrayList<String> failureTypeIds = new ArrayList<String>();
            for (SoftwareInducedFailureType failureType : parameter.getSoftwareInducedFailureTypes__SoftwareFailureTypeReliabilityParameter()) {
                failureTypeIds.add(failureType.getId());
            }
            return new FailureTypeSensitivity(parameter.getEntityName(), failureTypeIds, (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private InternalActionSensitivity createInternalActionSensitivity(InternalActionReliabilityParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new InternalActionSensitivity(parameter.getEntityName(), parameter.getInternalAction__InternalActionReliabilityParameter().getId(), parameter.getSoftwareInducedFailureType__InternalActionReliabilityParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private MarkovSensitivity createMarkovSensitivity(SensitivityParameter parameter, EList<SensitivityResultSpecification> resultSpecifications, String logFileName) {
        MarkovSensitivity result = null;
        if (parameter instanceof CombinedSensitivityParameter) {
            result = this.createMultiSensitivity((CombinedSensitivityParameter)parameter, resultSpecifications, logFileName);
        } else {
            if (parameter instanceof CommunicationLinkReliabilityParameter) {
                LOGGER.error((Object)("Parameter type \"" + parameter.eClass().toString() + "\" not yet supported."));
                return null;
            }
            if (parameter instanceof ComponentReliabilityParameter) {
                result = this.createComponentSensitivity((ComponentReliabilityParameter)parameter);
            } else if (parameter instanceof HardwareMTTFParameter) {
                result = this.createMTTFSensitivity((HardwareMTTFParameter)parameter);
            } else if (parameter instanceof HardwareMTTRParameter) {
                result = this.createMTTRSensitivity((HardwareMTTRParameter)parameter);
            } else if (parameter instanceof InternalActionReliabilityParameter) {
                result = this.createInternalActionSensitivity((InternalActionReliabilityParameter)parameter);
            } else if (parameter instanceof NetworkReliabilityParameter) {
                result = this.createNetworkSensitivity((NetworkReliabilityParameter)parameter);
            } else if (parameter instanceof ProbabilisticBranchParameter) {
                result = this.createProbabilisticBranchSensitivity((ProbabilisticBranchParameter)parameter);
            } else if (parameter instanceof ResourceMTTFParameter) {
                result = this.createResourceMTTFSensitivity((ResourceMTTFParameter)parameter);
            } else if (parameter instanceof ResourceMTTRParameter) {
                result = this.createResourceMTTRSensitivity((ResourceMTTRParameter)parameter);
            } else if (parameter instanceof SoftwareReliabilityParameter) {
                result = this.createSoftwareSensitivity((SoftwareReliabilityParameter)parameter);
            } else if (parameter instanceof VariableUsageParameter) {
                result = this.createVariableUsageSensitivity((VariableUsageParameter)parameter);
            } else if (parameter instanceof UsageBranchParameter) {
                result = this.createUsageBranchSensitivity((UsageBranchParameter)parameter);
            } else if (parameter instanceof SoftwareFailureTypesParameter) {
                result = this.createFailureTypeSensitivity((SoftwareFailureTypesParameter)parameter);
            } else {
                LOGGER.error((Object)("Parameter type \"" + parameter.eClass().toString() + "\" not yet supported."));
                return null;
            }
        }
        result.setLogFileName(logFileName);
        result.setResultSpecifications(resultSpecifications);
        return result;
    }

    private MTTFSensitivity createMTTFSensitivity(HardwareMTTFParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new MTTFSensitivity(parameter.getEntityName(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private MTTRSensitivity createMTTRSensitivity(HardwareMTTRParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new MTTRSensitivity(parameter.getEntityName(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private MultiSensitivity createMultiSensitivity(CombinedSensitivityParameter parameter, EList<SensitivityResultSpecification> resultSpecifications, String logFileName) {
        ArrayList<MarkovSensitivity> subSensitivities = new ArrayList<MarkovSensitivity>();
        for (SensitivityParameter subParameter : parameter.getChildParameters__CombinedSensitivityParameter()) {
            subSensitivities.add(this.createMarkovSensitivity(subParameter, resultSpecifications, logFileName));
        }
        return new MultiSensitivity(parameter.getEntityName(), subSensitivities, parameter.isCombinatory());
    }

    private NetworkSensitivity createNetworkSensitivity(NetworkReliabilityParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new NetworkSensitivity(parameter.getEntityName(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private ProbabilisticBranchSensitivity createProbabilisticBranchSensitivity(ProbabilisticBranchParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new ProbabilisticBranchSensitivity(parameter.getEntityName(), parameter.getProbabilisticBranchTransition__ProbabilisticBranchParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private ResourceMTTFSensitivity createResourceMTTFSensitivity(ResourceMTTFParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new ResourceMTTFSensitivity(parameter.getEntityName(), parameter.getResourceContainer__ResourceMTTFParameter().getId(), parameter.getProcessingResourceType__ResourceMTTFParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private ResourceMTTRSensitivity createResourceMTTRSensitivity(ResourceMTTRParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new ResourceMTTRSensitivity(parameter.getEntityName(), parameter.getResourceContainer__ResourceMTTRParameter().getId(), parameter.getProcessingResourceType__ResourceMTTRParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private SoftwareSensitivity createSoftwareSensitivity(SoftwareReliabilityParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new SoftwareSensitivity(parameter.getEntityName(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private UsageBranchSensitivity createUsageBranchSensitivity(UsageBranchParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof DoubleParameterVariation) {
            return new UsageBranchSensitivity(parameter.getEntityName(), parameter.getBranch__UsageBranchParameter().getId(), parameter.getScenarioBehaviour__UsageBranchParameter().getId(), (DoubleParameterVariation)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }

    private VariableUsageSensitivity createVariableUsageSensitivity(VariableUsageParameter parameter) {
        SensitivityParameterVariation variation = parameter.getSensitivityParameterVariation__SingleSensitivityParameter();
        if (variation instanceof StringParameterSequence) {
            String paramId = null;
            switch (parameter.getVariableUsageType__VariableUsageParameter()) {
                case SYSTEM_CALL_INPUT: {
                    paramId = parameter.getEntryLevelSystemCall__VariableUsageParameter().getId();
                    break;
                }
                case COMPONENT_CONFIGURATION: {
                    paramId = parameter.getBasicComponent__VariableUsageParameter().getId();
                }
            }
            return new VariableUsageSensitivity(parameter.getEntityName(), paramId, parameter.getVariableName(), parameter.getVariableCharacterisationType__VariableUsageParameter(), parameter.getVariableUsageType__VariableUsageParameter(), (StringParameterSequence)variation);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not supported for parameter type \"" + parameter.eClass().toString() + "\"."));
        return null;
    }
}

