/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.SolverStrategy;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnStrategy;
import org.palladiosimulator.solver.transformations.pcm2regex.Pcm2RegExStrategy;

public class RunPCMAnalysisJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static Logger logger = Logger.getLogger((String)RunPCMAnalysisJob.class.getName());
    private SolverStrategy strategy;
    private MDSDBlackboard blackboard;

    public RunPCMAnalysisJob(PCMSolverWorkflowRunConfiguration configuration) {
        PDFConfiguration.setCurrentConfiguration((int)configuration.getDomainSize(), (double)configuration.getDistance(), (IUnit)IProbabilityFunctionFactory.eINSTANCE.createDefaultUnit());
        if (configuration.isReliabilityAnalysis()) {
            throw new RuntimeException("Invoked reliability analysis using wrong job class!");
        }
        if (configuration.getSolver().equals("SRES (Stochastic Regular Expression Solver)")) {
            this.strategy = new Pcm2RegExStrategy(configuration);
        } else if (configuration.getSolver().equals("LQNS (Layered Queueing Network Solver)")) {
            this.strategy = new Pcm2LqnStrategy(configuration);
        } else if (configuration.getSolver().equals("LQSIM (Layered Queueing Simulation)")) {
            this.strategy = new Pcm2LqnStrategy(configuration);
        } else if (configuration.getSolver().equals("LINE")) {
            this.strategy = new Pcm2LqnStrategy(configuration);
        }
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PCMInstance currentModel = new PCMInstance((PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition"));
        if (!currentModel.isValid()) {
            logger.error((Object)"PCM Instance invalid! Check filenames.");
            return;
        }
        monitor.beginTask("Analysis", 100);
        this.strategy.transform(currentModel);
        monitor.worked(50);
        this.strategy.solve();
        monitor.worked(50);
    }

    public SolverStrategy getStrategy() {
        return this.strategy;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Run PCM Analysis";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

