/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.handler;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.SpecifiedQoSAnnotation;
import org.palladiosimulator.pcm.qosannotations.qos_performance.SpecifiedExecutionTime;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourcetypeFactory;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.seff_performance.SeffPerformanceFactory;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationContext;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationFactory;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageContext;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput;
import org.palladiosimulator.solver.context.computed_usage.Input;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.visitors.SeffVisitor;
import org.palladiosimulator.solver.visitors.VariableUsageHelper;

public class ExternalCallActionHandler {
    private SeffVisitor visitor;
    private ComputedUsageFactory compUsageFactory = ComputedUsageFactory.eINSTANCE;
    private ComputedAllocationFactory compAllocationFactory = ComputedAllocationFactory.eINSTANCE;
    private SeffFactory seffFactory = SeffFactory.eINSTANCE;
    private SeffPerformanceFactory performanceFactory = SeffPerformanceFactory.eINSTANCE;
    private static Logger logger = Logger.getLogger((String)ExternalCallActionHandler.class.getName());

    public ExternalCallActionHandler(SeffVisitor seffVisitor) {
        this.visitor = seffVisitor;
    }

    public void handle(ExternalCallAction call) {
        OperationSignature serviceToBeCalled = call.getCalledService_ExternalService();
        ServiceEffectSpecification seff = this.visitor.getContextWrapper().getNextSEFF(call);
        if (seff == null) {
            logger.debug((Object)("I found no SEFF for service " + serviceToBeCalled.getEntityName() + " called by External Call " + call.getId() + " thus I assume a System External Call"));
            String timeSpecification = this.getTimeSpecification((Signature)serviceToBeCalled);
            this.createInternalAction(timeSpecification, call);
        } else {
            ContextWrapper oldContextWrapper = (ContextWrapper)this.visitor.getContextWrapper().clone();
            List<ContextWrapper> contextWrapperList = this.visitor.getContextWrapper().getContextWrapperFor(call);
            SeffVisitor seffVisitor = null;
            for (ContextWrapper contextWrapper : contextWrapperList) {
                seffVisitor = this.visitSEFF(seff, contextWrapper);
            }
            if (seffVisitor == null) {
                throw new RuntimeException("Internal Error: No ContextWrapper could be created for ExternalCall " + call.getEntityName() + " " + call.getId());
            }
            this.visitor.setContextWrapper((ContextWrapper)oldContextWrapper.clone());
            this.storeOutputParametersToUsageContext(call, seffVisitor);
            this.visitor.setContextWrapper(oldContextWrapper);
        }
    }

    SeffVisitor visitSEFF(ServiceEffectSpecification seff, ContextWrapper contextWrapper) {
        SeffVisitor seffVisitor = new SeffVisitor(contextWrapper);
        seffVisitor.doSwitch((EObject)seff);
        return seffVisitor;
    }

    private void createInternalAction(String timeSpecification, ExternalCallAction call) {
        PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rv.setSpecification(timeSpecification);
        ParametricResourceDemand demand = this.performanceFactory.createParametricResourceDemand();
        demand.setSpecification_ParametericResourceDemand(rv);
        demand.setRequiredResource_ParametricResourceDemand(this.getProcessingResourceType());
        InternalAction action = this.seffFactory.createInternalAction();
        action.getResourceDemand_Action().add((Object)demand);
        action.setSuccessor_AbstractAction(call.getSuccessor_AbstractAction());
        action.setPredecessor_AbstractAction((AbstractAction)call);
        ResourceDemandingBehaviour rdb = (ResourceDemandingBehaviour)call.eContainer();
        rdb.getSteps_Behaviour().add((Object)action);
    }

    private ProcessingResourceType getProcessingResourceType() {
        EList resConList = this.visitor.getContextWrapper().getPcmInstance().getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        for (ResourceContainer resCon : resConList) {
            if (!resCon.getEntityName().equals("SystemExternalResourceContainer")) continue;
            return ((ProcessingResourceSpecification)resCon.getActiveResourceSpecifications_ResourceContainer().get(0)).getActiveResourceType_ActiveResourceSpecification();
        }
        return this.createNewProcessingResourceType();
    }

    private ProcessingResourceType createNewProcessingResourceType() {
        ProcessingResourceType resType = ResourcetypeFactory.eINSTANCE.createProcessingResourceType();
        resType.setEntityName("SystemExternalResource");
        this.visitor.getContextWrapper().getPcmInstance().getResourceRepository().getAvailableResourceTypes_ResourceRepository().add((Object)resType);
        ProcessingResourceSpecification res = ResourceenvironmentFactory.eINSTANCE.createProcessingResourceSpecification();
        res.setActiveResourceType_ActiveResourceSpecification(resType);
        PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
        rv.setSpecification("1.0");
        res.setProcessingRate_ProcessingResourceSpecification(rv);
        SchedulingPolicy schedulingPolicy = this.getProcessorSharingSchedulingPolicy(this.visitor.getContextWrapper().getPcmInstance().getResourceRepository());
        res.setSchedulingPolicy(schedulingPolicy);
        ResourceContainer resCon = ResourceenvironmentFactory.eINSTANCE.createResourceContainer();
        resCon.setEntityName("SystemExternalResourceContainer");
        resCon.getActiveResourceSpecifications_ResourceContainer().add((Object)res);
        this.visitor.getContextWrapper().getPcmInstance().getResourceEnvironment().getResourceContainer_ResourceEnvironment().add((Object)resCon);
        return resType;
    }

    private String getTimeSpecification(Signature serviceToBeCalled) {
        Interface requiredInterface = (Interface)serviceToBeCalled.eContainer();
        String reqName = requiredInterface.getEntityName();
        EList annList = this.visitor.getContextWrapper().getPcmInstance().getSystem().getQosAnnotations_System();
        for (QoSAnnotations ann : annList) {
            EList timeList = ann.getSpecifiedQoSAnnotations_QoSAnnotations();
            for (SpecifiedQoSAnnotation annotation : timeList) {
                OperationRequiredRole reqRole;
                String reqIntName;
                SpecifiedExecutionTime time;
                Role role;
                if (!(annotation instanceof SpecifiedExecutionTime) || !((role = (time = (SpecifiedExecutionTime)annotation).getRole_SpecifiedQoSAnnotation()) instanceof OperationRequiredRole) || !reqName.equals(reqIntName = (reqRole = (OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getEntityName())) continue;
                String serviceName = time.getSignature_SpecifiedQoSAnnation().getEntityName();
                if (!serviceToBeCalled.getEntityName().equals(serviceName)) continue;
                return time.getSpecification_SpecifiedExecutionTime().getSpecification();
            }
        }
        logger.warn((Object)("No time specification was found for external call " + serviceToBeCalled.getEntityName() + ". I'm assuming a demand of 0."));
        return "0";
    }

    private SchedulingPolicy getProcessorSharingSchedulingPolicy(ResourceRepository resourceRepository) {
        for (SchedulingPolicy schedulingPolicy : resourceRepository.getSchedulingPolicies__ResourceRepository()) {
            if (schedulingPolicy.getEntityName() == null || !schedulingPolicy.getId().equals("ProcessorSharing")) continue;
            return schedulingPolicy;
        }
        return null;
    }

    private void storeOutputParametersToUsageContext(ExternalCallAction call, SeffVisitor nextVisitor) {
        String returnName = String.valueOf(call.getCalledService_ExternalService().getEntityName()) + ".RETURN";
        ExternalCallOutput eco = this.compUsageFactory.createExternalCallOutput();
        eco.setExternalCallAction_ExternalCallOutput(call);
        this.visitor.getContextWrapper().getCompUsgCtx().getExternalCallOutput_ComputedUsageContext().add((Object)eco);
        if (nextVisitor.getContextWrapper().getCompUsgCtx().getOutput_ComputedUsageContext() != null) {
            EList outputParamsProducedByExtCall = nextVisitor.getContextWrapper().getCompUsgCtx().getOutput_ComputedUsageContext().getParameterCharacterisations_Output();
            ComputedUsageContext dummyContext = this.compUsageFactory.createComputedUsageContext();
            Input input = this.compUsageFactory.createInput();
            for (VariableUsage vu : outputParamsProducedByExtCall) {
                VariableUsageHelper.copyVariableUsageToInput(input, vu);
            }
            dummyContext.setInput_ComputedUsageContext(input);
            ComputedAllocationContext dummyAllContext = this.compAllocationFactory.createComputedAllocationContext();
            ContextWrapper dummyWrapper = ContextWrapper.getContextWrapperFor(call, dummyContext, dummyAllContext, this.visitor.getContextWrapper()).get(0);
            EList outputParamsDeclaredInSeff = call.getReturnVariableUsage__CallReturnAction();
            for (VariableUsage vu : outputParamsDeclaredInSeff) {
                VariableUsageHelper.copySolvedVariableUsageToExternalCallOutput(dummyWrapper, eco, vu);
            }
        }
    }
}

