/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations;

import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.probfunction.math.exception.StringNotPDFException;
import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableCharacterisationType;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.SpecifiedQoSAnnotation;
import org.palladiosimulator.pcm.qosannotations.qos_reliability.SpecifiedReliabilityAnnotation;
import org.palladiosimulator.pcm.reliability.ExternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.ImplementationComponentType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UserData;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationContext;
import org.palladiosimulator.solver.context.computed_allocation.ComputedAllocationFactory;
import org.palladiosimulator.solver.context.computed_allocation.ResourceDemand;
import org.palladiosimulator.solver.context.computed_usage.BranchProbability;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageContext;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallInput;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput;
import org.palladiosimulator.solver.context.computed_usage.Input;
import org.palladiosimulator.solver.context.computed_usage.LoopIteration;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.transformations.CallsToLinkResourcesMap;
import org.palladiosimulator.solver.transformations.ExpressionToPDFWrapper;
import org.palladiosimulator.solver.transformations.PCMInstanceHelper;
import org.palladiosimulator.solver.transformations.ResourceDemandCache;
import org.palladiosimulator.solver.visitors.ExpressionHelper;
import org.palladiosimulator.solver.visitors.VariableUsageHelper;

public class ContextWrapper
implements Cloneable {
    protected static Logger logger = Logger.getLogger((String)ContextWrapper.class.getName());
    private AllocationContext allCtx;
    private List<AssemblyContext> assCtxList;
    private HashMap<AbstractBranchTransition, Double> branchProbs = new HashMap();
    private ComputedAllocationContext compAllCtx;
    private ComputedUsageContext compUsgCtx;
    private HashMap<ExternalCallAction, Double> inputParameterBytesizes = new HashMap();
    private CallsToLinkResourcesMap linkResources = new CallsToLinkResourcesMap();
    private HashMap<AbstractLoopAction, ManagedPMF> loopIters = new HashMap();
    private HashMap<ExternalCallAction, Double> outputParameterBytesizes = new HashMap();
    private PCMInstance pcmInstance;
    private HashMap<ParametricResourceDemand, ProcessingResourceSpecification> procResources = new HashMap();
    private ResourceDemandCache resDemands = new ResourceDemandCache();

    public static List<ContextWrapper> getContextWrapperFor(EntryLevelSystemCall elsa, PCMInstance pcm) {
        ContextWrapper templateContextWrapper = new ContextWrapper();
        templateContextWrapper.pcmInstance = pcm;
        List<AssemblyContext> handlingAssemblyContexts = PCMInstanceHelper.getHandlingAssemblyContexts(elsa, pcm.getSystem());
        templateContextWrapper.setAssCtxList(handlingAssemblyContexts);
        ComputedUsageContext computedUsageContext = templateContextWrapper.getFirstComputedUsageContext(elsa);
        templateContextWrapper.setCompUsgCtx(computedUsageContext);
        List<ContextWrapper> contextWrapperList = ContextWrapper.createContextWrappersBasedOnTemplate(templateContextWrapper, handlingAssemblyContexts, computedUsageContext);
        return contextWrapperList;
    }

    public static List<ContextWrapper> getContextWrapperFor(ExternalCallAction eca, ComputedUsageContext cuc, ComputedAllocationContext cac, ContextWrapper oldContextWrapper) {
        ContextWrapper templateContextWrapper = new ContextWrapper();
        templateContextWrapper.pcmInstance = oldContextWrapper.getPcmInstance();
        templateContextWrapper.setAssCtxList(PCMInstanceHelper.getHandlingAssemblyContexts(eca, oldContextWrapper.assCtxList));
        List<AllocationContext> allocationContextList = templateContextWrapper.getNextAllocationContextList(templateContextWrapper.getAssCtxList());
        ArrayList<ContextWrapper> contextWrapperList = new ArrayList<ContextWrapper>(allocationContextList.size());
        for (AllocationContext allocationContext : allocationContextList) {
            templateContextWrapper.setAllCtx(allocationContext);
            ContextWrapper contextWrapper = (ContextWrapper)templateContextWrapper.clone();
            contextWrapper.setAllCtx(allocationContext);
            contextWrapperList.add(contextWrapper);
            contextWrapper.handleComputedContexts(cuc, cac);
        }
        return contextWrapperList;
    }

    private static List<ContextWrapper> createContextWrappersBasedOnTemplate(ContextWrapper templateContextWrapper, List<AssemblyContext> calledAssemblyContextList, ComputedUsageContext computedUsageContext) {
        List<AllocationContext> allocationContextList = templateContextWrapper.getNextAllocationContextList(templateContextWrapper.getAssCtxList());
        ArrayList<ContextWrapper> contextWrapperList = new ArrayList<ContextWrapper>(allocationContextList.size());
        for (AllocationContext allocationContext : allocationContextList) {
            ContextWrapper contextWrapper = (ContextWrapper)templateContextWrapper.clone();
            contextWrapper.setAllCtx(allocationContext);
            contextWrapper.setCompAllCtx(contextWrapper.getNextComputedAllocationContext(contextWrapper.getCompUsgCtx()));
            contextWrapper.readComputedContextsToHashMaps();
            contextWrapperList.add(contextWrapper);
        }
        return contextWrapperList;
    }

    public ContextWrapper(PCMInstance pcmInstance) {
        this.pcmInstance = pcmInstance;
    }

    private ContextWrapper() {
    }

    public Object clone() {
        ContextWrapper clonedWrapper = new ContextWrapper();
        BasicEList list = new BasicEList();
        for (AssemblyContext ac : this.assCtxList) {
            list.add((Object)ac);
        }
        clonedWrapper.setAssCtxList((List<AssemblyContext>)list);
        clonedWrapper.setAllCtx(this.allCtx);
        clonedWrapper.setCompAllCtx(this.compAllCtx);
        clonedWrapper.setCompUsgCtx(this.compUsgCtx);
        clonedWrapper.setPcmInstance(this.pcmInstance);
        if (this.compAllCtx != null && this.compUsgCtx != null) {
            clonedWrapper.readComputedContextsToHashMaps();
        }
        return clonedWrapper;
    }

    public AllocationContext getAllCtx() {
        return this.allCtx;
    }

    public AssemblyContext getAssCtx() {
        return this.assCtxList.get(this.assCtxList.size() - 1);
    }

    public List<AssemblyContext> getAssCtxList() {
        return this.assCtxList;
    }

    public Double getBranchProbability(AbstractBranchTransition abt) {
        return this.branchProbs.get(abt);
    }

    public ComputedAllocationContext getCompAllCtx() {
        return this.compAllCtx;
    }

    public ComputedUsageContext getCompUsgCtx() {
        return this.compUsgCtx;
    }

    public CommunicationLinkResourceSpecification getConcreteLinkingResource(ExternalCallAction eca, AllocationContext targetAllocationContext) {
        return this.linkResources.get(eca, targetAllocationContext);
    }

    public PassiveResource getConcretePassiveResource(AcquireAction aa) {
        return aa.getPassiveresource_AcquireAction();
    }

    public PassiveResource getConcretePassiveResource(ReleaseAction ra) {
        return ra.getPassiveResource_ReleaseAction();
    }

    public ProcessingResourceSpecification getConcreteProcessingResource(ParametricResourceDemand prd) {
        return this.procResources.get(prd);
    }

    public List<ContextWrapper> getContextWrapperFor(EntryLevelSystemCall elsa) {
        this.assCtxList = PCMInstanceHelper.getHandlingAssemblyContexts(elsa, this.pcmInstance.getSystem());
        this.compUsgCtx = this.getFirstComputedUsageContext(elsa);
        return ContextWrapper.createContextWrappersBasedOnTemplate(this, this.assCtxList, this.compUsgCtx);
    }

    public List<ContextWrapper> getContextWrapperFor(ExternalCallAction eca) {
        this.assCtxList = PCMInstanceHelper.getHandlingAssemblyContexts(eca, this.assCtxList);
        this.compUsgCtx = this.getNextComputedUsageContext(eca);
        List<ContextWrapper> contextWrapperList = ContextWrapper.createContextWrappersBasedOnTemplate(this, this.assCtxList, this.compUsgCtx);
        return contextWrapperList;
    }

    public ManagedPDF getDelayOnLinkingResource(ExternalCallAction eca, CommunicationLinkResourceSpecification clrs) {
        EList eciList = this.compUsgCtx.getExternalCallInput_ComputedUsageContext();
        for (ExternalCallInput eci : eciList) {
            eci.getExternalCallAction_ExternalCallInput().getId().equals(eca.getId());
        }
        return null;
    }

    public List<ExternalFailureOccurrenceDescription> getFailureOccurrenceDescriptionsForSystemExternalCall(ExternalCallAction externalCallAction) {
        BasicEList resultList = new BasicEList();
        OperationRequiredRole systemRequiredRole = this.findSystemRequiredRoleForCurrentAssemblyContext(this.getRequiredRoleForExternalCallAction(externalCallAction));
        if (systemRequiredRole == null) {
            return resultList;
        }
        SpecifiedReliabilityAnnotation reliabilityAnnotation = this.findReliabilityAnnotationForSystemExternalCall(externalCallAction, systemRequiredRole);
        if (reliabilityAnnotation == null) {
            return resultList;
        }
        resultList.addAll((Collection)reliabilityAnnotation.getExternalFailureOccurrenceDescriptions__SpecifiedReliabilityAnnotation());
        return resultList;
    }

    public boolean getIsOriginalPDFFor(ParametricResourceDemand prd) {
        return this.resDemands.isOriginalPDF(prd);
    }

    public ManagedPMF getLoopIterations(AbstractLoopAction ala) {
        return this.loopIters.get(ala);
    }

    public Double getMeanTimeConsumption(ParametricResourceDemand prd) {
        return this.resDemands.getDouble(prd);
    }

    public Double getMeanTotalInputParameterBytesize(ExternalCallAction eca) {
        return this.inputParameterBytesizes.get(eca);
    }

    public Double getMeanTotalOutputParameterBytesize(ExternalCallAction eca) {
        return this.outputParameterBytesizes.get(eca);
    }

    public ServiceEffectSpecification getNextSEFF(EntryLevelSystemCall elsc) {
        OperationSignature sig = elsc.getOperationSignature__EntryLevelSystemCall();
        List<AssemblyContext> acList = PCMInstanceHelper.getHandlingAssemblyContexts(elsc, this.pcmInstance.getSystem());
        AssemblyContext ac = acList.get(acList.size() - 1);
        BasicComponent bc = (BasicComponent)ac.getEncapsulatedComponent__AssemblyContext();
        EList seffList = bc.getServiceEffectSpecifications__BasicComponent();
        for (ServiceEffectSpecification seff : seffList) {
            if (!seff.getDescribedService__SEFF().getEntityName().equals(sig.getEntityName())) continue;
            return seff;
        }
        return null;
    }

    public ServiceEffectSpecification getNextSEFF(ExternalCallAction eca) {
        OperationSignature sig = eca.getCalledService_ExternalService();
        List<AssemblyContext> acList = PCMInstanceHelper.getHandlingAssemblyContexts(eca, this.assCtxList);
        if (acList.size() == 0) {
            return null;
        }
        AssemblyContext ac = acList.get(acList.size() - 1);
        BasicComponent bc = (BasicComponent)ac.getEncapsulatedComponent__AssemblyContext();
        EList seffList = bc.getServiceEffectSpecifications__BasicComponent();
        for (ServiceEffectSpecification seff : seffList) {
            if (!seff.getDescribedService__SEFF().getEntityName().equals(sig.getEntityName())) continue;
            return seff;
        }
        logger.error((Object)("Could not find next SEFF for ExternalCallAction " + eca.getCalledService_ExternalService() + "!"));
        return null;
    }

    public PCMInstance getPcmInstance() {
        return this.pcmInstance;
    }

    public ManagedPDF getTimeConsumptionAsPDF(ParametricResourceDemand prd) {
        return this.resDemands.getPDF(prd);
    }

    public String getTimeConsumptionSpecification(ParametricResourceDemand prd) {
        String resultSpecification = this.resDemands.getPDF(prd).toString();
        return resultSpecification;
    }

    public void setAllCtx(AllocationContext allCtx) {
        this.allCtx = allCtx;
    }

    public void setAssCtxList(List<AssemblyContext> assCtxList) {
        this.assCtxList = assCtxList;
    }

    public void setCompAllCtx(ComputedAllocationContext compAllCtx) {
        this.compAllCtx = compAllCtx;
    }

    public void setCompUsgCtx(ComputedUsageContext compUsgCtx) {
        this.compUsgCtx = compUsgCtx;
    }

    public void setPcmInstance(PCMInstance pcmInstance) {
        this.pcmInstance = pcmInstance;
    }

    private void addComponentParametersToNewContext(ComputedUsageContext newCompUsgCtx) {
        Collection<VariableUsage> compParams = this.copyComponentParameters(this.getAssCtx());
        EList confParList = this.getAssCtx().getConfigParameterUsages__AssemblyContext();
        for (VariableUsage confParVariableUsage : confParList) {
            boolean repoVariableUsageWithSameNameFound = false;
            for (VariableUsage repoVariableUsage : compParams) {
                if (!confParVariableUsage.getNamedReference__VariableUsage().getReferenceName().equals(repoVariableUsage.getNamedReference__VariableUsage().getReferenceName())) continue;
                repoVariableUsageWithSameNameFound = true;
                EList confParCharacterisations = confParVariableUsage.getVariableCharacterisation_VariableUsage();
                EList repoCharacterisations = repoVariableUsage.getVariableCharacterisation_VariableUsage();
                ArrayList<VariableCharacterisation> vcsToBeDeleted = new ArrayList<VariableCharacterisation>(repoCharacterisations.size());
                for (VariableCharacterisation repoVariableCharacterisation : repoCharacterisations) {
                    for (VariableCharacterisation confParVariableCharacterisation : confParCharacterisations) {
                        if (!repoVariableCharacterisation.getType().equals((Object)confParVariableCharacterisation.getType())) continue;
                        vcsToBeDeleted.add(repoVariableCharacterisation);
                    }
                }
                repoCharacterisations.removeAll(vcsToBeDeleted);
                repoVariableUsage.getVariableCharacterisation_VariableUsage().addAll(VariableUsageHelper.copyVariableCharacterisations((List<VariableCharacterisation>)confParCharacterisations));
            }
            if (repoVariableUsageWithSameNameFound) continue;
            compParams.add((VariableUsage)EcoreUtil.copy((EObject)confParVariableUsage));
        }
        VariableUsageHelper.copySolvedVariableUsageToInput(newCompUsgCtx.getInput_ComputedUsageContext(), this, compParams);
        UsageModel um = this.getPcmInstance().getUsageModel();
        EList userDataList = um.getUserData_UsageModel();
        for (UserData ud : userDataList) {
            if (!ud.getAssemblyContext_userData().getId().equals(this.getAssCtx().getId())) continue;
            EList userParList = ud.getUserDataParameterUsages_UserData();
            VariableUsageHelper.copySolvedVariableUsageToInput(newCompUsgCtx.getInput_ComputedUsageContext(), this, (Collection<VariableUsage>)userParList);
        }
    }

    private ExternalCallInput addExternalCallInputToCurrentContext(ExternalCallAction eca) {
        EList parList = eca.getInputVariableUsages__CallAction();
        ExternalCallInput eci = ComputedUsageFactory.eINSTANCE.createExternalCallInput();
        eci.setExternalCallAction_ExternalCallInput(eca);
        this.compUsgCtx.getExternalCallInput_ComputedUsageContext().add((Object)eci);
        for (VariableUsage vu : parList) {
            VariableUsageHelper.copySolvedVariableUsageToExternalCallInput(this, eci, vu);
        }
        return eci;
    }

    private boolean areEqual(EList<VariableUsage> vuList1, EList<VariableUsage> vuList2) {
        int varUsgCounter = 0;
        for (VariableUsage vu1 : vuList1) {
            for (VariableUsage vu2 : vuList2) {
                if (!this.getFullParameterName(vu1.getNamedReference__VariableUsage()).equals(this.getFullParameterName(vu2.getNamedReference__VariableUsage()))) continue;
                EList vcList = vu1.getVariableCharacterisation_VariableUsage();
                int varCharFoundCounter = 0;
                for (VariableCharacterisation vc1 : vcList) {
                    EList vcList2 = vu2.getVariableCharacterisation_VariableUsage();
                    boolean singleVarCharFound = false;
                    for (VariableCharacterisation vc2 : vcList2) {
                        if (!vc1.getType().getLiteral().equals(vc2.getType().getLiteral()) || !vc1.getSpecification_VariableCharacterisation().getSpecification().replaceAll(" ", "").equals(vc2.getSpecification_VariableCharacterisation().getSpecification().replaceAll(" ", ""))) continue;
                        singleVarCharFound = true;
                    }
                    if (!singleVarCharFound) continue;
                    ++varCharFoundCounter;
                }
                if (varCharFoundCounter != vcList.size()) continue;
                ++varUsgCounter;
            }
        }
        return varUsgCounter == vuList1.size();
    }

    private Collection<VariableUsage> copyComponentParameters(AssemblyContext context) {
        ImplementationComponentType component = (ImplementationComponentType)context.getEncapsulatedComponent__AssemblyContext();
        EList originalVariableUsages = component.getComponentParameterUsage_ImplementationComponentType();
        Collection<VariableUsage> newVariableUsages = VariableUsageHelper.copyVariableUsageList((List<VariableUsage>)originalVariableUsages);
        return newVariableUsages;
    }

    private ComputedUsageContext createNewComputedUsageContext(ExternalCallAction eca) {
        ComputedUsageContext newCompUsgCtx = ComputedUsageFactory.eINSTANCE.createComputedUsageContext();
        this.pcmInstance.getComputedUsage().getUsageContexts_ComputedUsage().add((Object)newCompUsgCtx);
        newCompUsgCtx.setAssemblyContext_ComputedUsageContext(this.getAssCtx());
        Input newInput = ComputedUsageFactory.eINSTANCE.createInput();
        newCompUsgCtx.setInput_ComputedUsageContext(newInput);
        EList parList = eca.getInputVariableUsages__CallAction();
        VariableUsageHelper.copySolvedVariableUsageToInput(newCompUsgCtx.getInput_ComputedUsageContext(), this, (Collection<VariableUsage>)parList);
        this.addComponentParametersToNewContext(newCompUsgCtx);
        return newCompUsgCtx;
    }

    private boolean exists(EList<ResourceContainer> list, ResourceContainer container) {
        for (ResourceContainer element : list) {
            if (!element.getId().equals(container.getId())) continue;
            return true;
        }
        return false;
    }

    private SpecifiedReliabilityAnnotation findReliabilityAnnotationForSystemExternalCall(ExternalCallAction externalCallAction, OperationRequiredRole systemRequiredRole) {
        for (QoSAnnotations annotation : this.pcmInstance.getSystem().getQosAnnotations_System()) {
            for (SpecifiedQoSAnnotation specifiedAnnotation : annotation.getSpecifiedQoSAnnotations_QoSAnnotations()) {
                if (!(specifiedAnnotation instanceof SpecifiedReliabilityAnnotation) || !specifiedAnnotation.getRole_SpecifiedQoSAnnotation().getId().equals(systemRequiredRole.getId()) || !specifiedAnnotation.getSignature_SpecifiedQoSAnnation().getId().equals(externalCallAction.getCalledService_ExternalService().getId())) continue;
                return (SpecifiedReliabilityAnnotation)specifiedAnnotation;
            }
        }
        return null;
    }

    private OperationRequiredRole findSystemRequiredRoleForCurrentAssemblyContext(OperationRequiredRole requiredRole) {
        ComposedStructure reqStructure = null;
        int index = this.assCtxList.size() - 1;
        OperationRequiredRole reqRole = requiredRole;
        while (reqStructure == null || !reqStructure.getId().equals(this.pcmInstance.getSystem().getId())) {
            reqStructure = this.assCtxList.get(index).getParentStructure__AssemblyContext();
            RequiredDelegationConnector delConn = null;
            for (Connector conn : reqStructure.getConnectors__ComposedStructure()) {
                RequiredDelegationConnector connector;
                if (!(conn instanceof RequiredDelegationConnector) || !(connector = (RequiredDelegationConnector)conn).getAssemblyContext_RequiredDelegationConnector().getId().equals(this.assCtxList.get(index).getId()) || !connector.getInnerRequiredRole_RequiredDelegationConnector().getId().equals(reqRole.getId())) continue;
                delConn = connector;
                break;
            }
            if (delConn == null) {
                return null;
            }
            reqRole = delConn.getOuterRequiredRole_RequiredDelegationConnector();
            --index;
        }
        return reqRole;
    }

    private ComputedAllocationContext getExistingComputedAllocationContext(ComputedUsageContext compUsgCtx) {
        EList allCtxList = this.pcmInstance.getComputedAllocation().getComputedAllocationContexts_ComputedAllocation();
        for (ComputedAllocationContext cac : allCtxList) {
            if (!cac.getAllocationContext_ComputedAllocationContext().getId().equals(this.allCtx.getId()) || !cac.getUsageContext_ComputedAllocationContext().getId().equals(compUsgCtx.getId())) continue;
            return cac;
        }
        return null;
    }

    private ComputedUsageContext getExistingComputedUsageContext(ExternalCallAction eca) {
        EList eciList = this.compUsgCtx.getExternalCallInput_ComputedUsageContext();
        if (eciList.size() == 0) {
            ExternalCallInput extCallIn;
            EList inputVUList;
            ComputedUsageContext cuc;
            EList cucList = this.pcmInstance.getComputedUsage().getUsageContexts_ComputedUsage();
            if (eca.getInputVariableUsages__CallAction().size() == 0) {
                for (ComputedUsageContext cuc2 : cucList) {
                    AssemblyContext referencedAssemblyContext = cuc2.getAssemblyContext_ComputedUsageContext();
                    AssemblyContext assemblyContextThisCallIsComingFrom = this.getAssCtx();
                    if (!referencedAssemblyContext.getId().equals(assemblyContextThisCallIsComingFrom.getId()) || cuc2.getInput_ComputedUsageContext().getParameterChacterisations_Input().size() != 0) continue;
                    ExternalCallInput extCallIn2 = this.addExternalCallInputToCurrentContext(eca);
                    return cuc2;
                }
            }
            if ((cuc = this.matchVariableUsages((EList<VariableUsage>)(inputVUList = (extCallIn = this.addExternalCallInputToCurrentContext(eca)).getParameterCharacterisations_ExternalCallInput()))) != null) {
                return cuc;
            }
        } else {
            for (ExternalCallInput eci : eciList) {
                EList inputVUList;
                ComputedUsageContext cuc;
                if (!eci.getExternalCallAction_ExternalCallInput().getId().equals(eca.getId()) || (cuc = this.matchVariableUsages((EList<VariableUsage>)(inputVUList = eci.getParameterCharacterisations_ExternalCallInput()))) == null) continue;
                return cuc;
            }
            ExternalCallInput extCallIn = this.addExternalCallInputToCurrentContext(eca);
            EList inputVUList = extCallIn.getParameterCharacterisations_ExternalCallInput();
            ComputedUsageContext cuc = this.matchVariableUsages((EList<VariableUsage>)inputVUList);
            if (cuc != null) {
                return cuc;
            }
        }
        return null;
    }

    private ComputedUsageContext getFirstComputedUsageContext(EntryLevelSystemCall elsa) {
        logger.debug((Object)"In getFirstComputedUsageContext");
        EList vuList = elsa.getInputParameterUsages_EntryLevelSystemCall();
        ComputedUsageContext cuc = this.matchVariableUsages((EList<VariableUsage>)vuList);
        if (cuc != null) {
            logger.debug((Object)("Reusing existing computed usage context for " + this.getAssCtx().getEntityName()));
            return cuc;
        }
        logger.debug((Object)("Creating new computed usage context for " + this.getAssCtx().getEntityName()));
        ComputedUsageContext newCompUsgCtx = ComputedUsageFactory.eINSTANCE.createComputedUsageContext();
        this.pcmInstance.getComputedUsage().getUsageContexts_ComputedUsage().add((Object)newCompUsgCtx);
        newCompUsgCtx.setAssemblyContext_ComputedUsageContext(this.getAssCtx());
        Input newInput = ComputedUsageFactory.eINSTANCE.createInput();
        newCompUsgCtx.setInput_ComputedUsageContext(newInput);
        EList parList = elsa.getInputParameterUsages_EntryLevelSystemCall();
        VariableUsageHelper.copySolvedVariableUsageToInput(newCompUsgCtx.getInput_ComputedUsageContext(), this, (Collection<VariableUsage>)parList);
        this.addComponentParametersToNewContext(newCompUsgCtx);
        return newCompUsgCtx;
    }

    private String getFullParameterName(AbstractNamedReference ref) {
        String name = "";
        while (ref instanceof NamespaceReference) {
            NamespaceReference nsRef = (NamespaceReference)ref;
            name = String.valueOf(name) + nsRef.getReferenceName() + ".";
            ref = nsRef.getInnerReference_NamespaceReference();
        }
        name = String.valueOf(name) + ref.getReferenceName();
        return name;
    }

    private Double getMeanTotalInputParameterBytesize(ExternalCallInput eci) {
        Double meanTotalInputParameterBytesize = 0.0;
        for (VariableUsage usage : eci.getParameterCharacterisations_ExternalCallInput()) {
            for (VariableCharacterisation vchar : usage.getVariableCharacterisation_VariableUsage()) {
                ManagedPMF pmf;
                if (vchar.getType() != VariableCharacterisationType.BYTESIZE) continue;
                try {
                    pmf = ManagedPMF.createFromString((String)vchar.getSpecification_VariableCharacterisation().getSpecification());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error calculating MeanTotalInputParameterBytesize.");
                }
                meanTotalInputParameterBytesize = meanTotalInputParameterBytesize + (double)pmf.getExpectedValue().longValue();
            }
        }
        return meanTotalInputParameterBytesize;
    }

    private Double getMeanTotalOutputParameterBytesize(ExternalCallOutput eco) {
        Double meanTotalOutputParameterBytesize = 0.0;
        for (VariableUsage usage : eco.getParameterCharacterisations_ExternalCallOutput()) {
            for (VariableCharacterisation vchar : usage.getVariableCharacterisation_VariableUsage()) {
                ManagedPMF pmf;
                if (vchar.getType() != VariableCharacterisationType.BYTESIZE) continue;
                try {
                    pmf = ManagedPMF.createFromString((String)vchar.getSpecification_VariableCharacterisation().getSpecification());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error calculating MeanTotalInputParameterBytesize.", e);
                }
                meanTotalOutputParameterBytesize = meanTotalOutputParameterBytesize + pmf.getExpectedValueDouble();
            }
        }
        return meanTotalOutputParameterBytesize;
    }

    private List<AllocationContext> getNextAllocationContextList(Iterator<AssemblyContext> nextAssCtxIterator) {
        if (nextAssCtxIterator.hasNext()) {
            AssemblyContext nextAssCtx = nextAssCtxIterator.next();
            EList allCtxList = this.pcmInstance.getAllocation().getAllocationContexts_Allocation();
            ArrayList<AllocationContext> targetAllocationContextList = new ArrayList<AllocationContext>();
            for (AllocationContext allCtx : allCtxList) {
                if (!allCtx.getAssemblyContext_AllocationContext().getId().equals(nextAssCtx.getId())) continue;
                targetAllocationContextList.add(allCtx);
            }
            if (targetAllocationContextList.size() >= 0) {
                return targetAllocationContextList;
            }
            return this.getNextAllocationContextList(nextAssCtxIterator);
        }
        return null;
    }

    private List<AllocationContext> getNextAllocationContextList(List<AssemblyContext> nextAssCtxList) {
        return this.getNextAllocationContextList(nextAssCtxList.iterator());
    }

    private ComputedAllocationContext getNextComputedAllocationContext(ComputedUsageContext compUsgCtx) {
        logger.debug((Object)"In getNextComputedAllocationContext ");
        ComputedAllocationContext cac = this.getExistingComputedAllocationContext(compUsgCtx);
        if (cac != null) {
            logger.debug((Object)("Reusing existing computed allocation context for " + this.getAssCtx().getEntityName()));
            return cac;
        }
        logger.debug((Object)("Creating new computed allocation context for " + this.getAssCtx().getEntityName()));
        ComputedAllocationContext newCompAllCtx = ComputedAllocationFactory.eINSTANCE.createComputedAllocationContext();
        this.pcmInstance.getComputedAllocation().getComputedAllocationContexts_ComputedAllocation().add((Object)newCompAllCtx);
        newCompAllCtx.setUsageContext_ComputedAllocationContext(compUsgCtx);
        newCompAllCtx.setAllocationContext_ComputedAllocationContext(this.allCtx);
        return newCompAllCtx;
    }

    private ComputedUsageContext getNextComputedUsageContext(ExternalCallAction eca) {
        logger.debug((Object)("In getNextComputedUsageContext " + eca.getEntityName()));
        ComputedUsageContext cuc = this.getExistingComputedUsageContext(eca);
        if (cuc != null) {
            logger.debug((Object)("Reusing existing computed usage context for " + this.getAssCtx().getEntityName()));
            return cuc;
        }
        logger.debug((Object)("Creating new computed usage context for " + this.getAssCtx().getEntityName()));
        return this.createNewComputedUsageContext(eca);
    }

    private OperationRequiredRole getRequiredRoleForExternalCallAction(ExternalCallAction externalCallAction) {
        OperationInterface reqInterface = externalCallAction.getCalledService_ExternalService().getInterface__OperationSignature();
        for (RequiredRole role : this.assCtxList.get(this.assCtxList.size() - 1).getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity()) {
            if (!(role instanceof OperationRequiredRole) || !((OperationRequiredRole)role).getRequiredInterface__OperationRequiredRole().getId().equals(reqInterface.getId())) continue;
            return (OperationRequiredRole)role;
        }
        return null;
    }

    private void handleComputedContexts(ComputedUsageContext cuc, ComputedAllocationContext cac) {
        this.compUsgCtx = cuc;
        this.compUsgCtx.setAssemblyContext_ComputedUsageContext(this.getAssCtx());
        this.compAllCtx = cac;
        this.compAllCtx.setAllocationContext_ComputedAllocationContext(this.allCtx);
        this.readComputedContextsToHashMaps();
    }

    private ComputedUsageContext matchVariableUsages(EList<VariableUsage> vuList) {
        EList cucList = this.pcmInstance.getComputedUsage().getUsageContexts_ComputedUsage();
        for (ComputedUsageContext cuc : cucList) {
            Input input;
            EList vuList2;
            if (!cuc.getAssemblyContext_ComputedUsageContext().getId().equals(this.getAssCtx().getId()) || !this.areEqual(vuList, (EList<VariableUsage>)(vuList2 = (input = cuc.getInput_ComputedUsageContext()).getParameterChacterisations_Input()))) continue;
            return cuc;
        }
        logger.debug((Object)"Matching Input Variables for External Call failed.");
        return null;
    }

    private void readComputedContextsToHashMaps() {
        EList bpList = this.compUsgCtx.getBranchProbabilities_ComputedUsageContext();
        for (BranchProbability bp : bpList) {
            this.branchProbs.put(bp.getBranchtransition_BranchProbability(), bp.getProbability());
        }
        EList liList = this.compUsgCtx.getLoopiterations_ComputedUsageContext();
        for (LoopIteration li : liList) {
            String spec = li.getSpecification_LoopIteration().getSpecification();
            ManagedPMF pmf = null;
            try {
                pmf = ManagedPMF.createFromString((String)spec);
            }
            catch (StringNotPDFException e) {
                e.printStackTrace();
            }
            catch (RecognitionException e) {
                e.printStackTrace();
            }
            this.loopIters.put(li.getLoopaction_LoopIteration(), pmf);
        }
        EList rdList = this.compAllCtx.getResourceDemands_ComputedAllocationContext();
        for (ResourceDemand rd : rdList) {
            String spec = rd.getSpecification_ResourceDemand().getSpecification();
            Expression rdExpression = ExpressionHelper.parseToExpression(spec);
            ExpressionToPDFWrapper rdWrapper = null;
            try {
                rdWrapper = ExpressionToPDFWrapper.createExpressionToPDFWrapper(rdExpression);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not derive a PDF from expression \"" + spec + "\"; Exception type: " + e.getClass().getName() + "; Error message: \"" + e.getMessage() + "\"");
            }
            this.resDemands.put(rd.getParametricResourceDemand_ResourceDemand(), rdWrapper);
        }
        for (ResourceDemand rd : rdList) {
            ParametricResourceDemand prd = rd.getParametricResourceDemand_ResourceDemand();
            ProcessingResourceType prt = prd.getRequiredResource_ParametricResourceDemand();
            EList prsList = this.allCtx.getResourceContainer_AllocationContext().getActiveResourceSpecifications_ResourceContainer();
            for (ProcessingResourceSpecification prs : prsList) {
                ProcessingResourceType prsType = prs.getActiveResourceType_ActiveResourceSpecification();
                if (!prsType.getId().equals(prt.getId())) continue;
                this.procResources.put(prd, prs);
            }
            if (!prt.getEntityName().equals("SystemExternalResource")) continue;
            EList containerList = this.getPcmInstance().getResourceEnvironment().getResourceContainer_ResourceEnvironment();
            for (ResourceContainer container : containerList) {
                if (!container.getEntityName().equals("SystemExternalResourceContainer")) continue;
                ProcessingResourceSpecification prs = (ProcessingResourceSpecification)container.getActiveResourceSpecifications_ResourceContainer().get(0);
                this.procResources.put(prd, prs);
            }
        }
        EList eciList = this.compUsgCtx.getExternalCallInput_ComputedUsageContext();
        EList lrList = this.pcmInstance.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
        ResourceContainer rc1 = this.allCtx.getResourceContainer_AllocationContext();
        for (ExternalCallInput eci : eciList) {
            ExternalCallAction eca = eci.getExternalCallAction_ExternalCallInput();
            List<AssemblyContext> acList = PCMInstanceHelper.getHandlingAssemblyContexts(eca, this.assCtxList);
            List<AllocationContext> allocationContextList = this.getNextAllocationContextList(acList);
            for (AllocationContext nextAllCtx : allocationContextList) {
                ResourceContainer rc2 = nextAllCtx.getResourceContainer_AllocationContext();
                if (rc1 == rc2) continue;
                for (LinkingResource lr : lrList) {
                    boolean rc1Contained = this.exists((EList<ResourceContainer>)lr.getConnectedResourceContainers_LinkingResource(), rc1);
                    boolean rc2Contained = this.exists((EList<ResourceContainer>)lr.getConnectedResourceContainers_LinkingResource(), rc2);
                    if (!rc1Contained || !rc2Contained) continue;
                    CommunicationLinkResourceSpecification clrs = lr.getCommunicationLinkResourceSpecifications_LinkingResource();
                    this.linkResources.put(eca, nextAllCtx, clrs);
                }
            }
        }
        for (ExternalCallInput eci : this.compUsgCtx.getExternalCallInput_ComputedUsageContext()) {
            this.inputParameterBytesizes.put(eci.getExternalCallAction_ExternalCallInput(), this.getMeanTotalInputParameterBytesize(eci));
        }
        for (ExternalCallOutput eco : this.compUsgCtx.getExternalCallOutput_ComputedUsageContext()) {
            this.outputParameterBytesizes.put(eco.getExternalCallAction_ExternalCallOutput(), this.getMeanTotalOutputParameterBytesize(eco));
        }
    }
}

