/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.solver.lqn.ActivityDefType;
import org.palladiosimulator.solver.lqn.ActivityListType;
import org.palladiosimulator.solver.lqn.ActivityMakingCallType;
import org.palladiosimulator.solver.lqn.ActivityOrType;
import org.palladiosimulator.solver.lqn.ActivityPhasesType;
import org.palladiosimulator.solver.lqn.ActivityType;
import org.palladiosimulator.solver.lqn.AndJoinListType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.LqnFactory;
import org.palladiosimulator.solver.lqn.LqnModelType;
import org.palladiosimulator.solver.lqn.OrListType;
import org.palladiosimulator.solver.lqn.OutputEntryDistributionType;
import org.palladiosimulator.solver.lqn.PhaseActivities;
import org.palladiosimulator.solver.lqn.PrecedenceType;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.ReplyActivityType;
import org.palladiosimulator.solver.lqn.ReplyEntryType;
import org.palladiosimulator.solver.lqn.SchedulingType;
import org.palladiosimulator.solver.lqn.SemaphoreType;
import org.palladiosimulator.solver.lqn.ServiceType;
import org.palladiosimulator.solver.lqn.SingleActivityListType;
import org.palladiosimulator.solver.lqn.SolverParamsType;
import org.palladiosimulator.solver.lqn.TaskActivityGraph;
import org.palladiosimulator.solver.lqn.TaskOptionType;
import org.palladiosimulator.solver.lqn.TaskSchedulingType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.lqn.TypeType;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.pcm2lqn.CallType;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;

public class LqnBuilder {
    private static Logger logger = Logger.getLogger((String)LqnBuilder.class.getName());
    private final LqnFactory lqnFactory = LqnFactory.eINSTANCE;
    private LqnModelType lqnModel = null;
    private final Stack<TaskActivityGraph> taskGraphStack = new Stack();
    private boolean isLQSimAnalysis;
    private final boolean isInfiniteTaskMultiplicity;

    public LqnBuilder(boolean isInfTask) {
        this.lqnModel = this.lqnFactory.createLqnModelType();
        this.lqnModel.setName("PCM2LQN_Model");
        this.setIsLQSimAnalysis(false);
        this.isInfiniteTaskMultiplicity = isInfTask;
    }

    public ProcessorType addProcessor(String id) {
        ProcessorType pt = this.getProcessorTypeFromModel(id);
        if (pt == null) {
            pt = this.lqnFactory.createProcessorType();
            pt.setName(String.valueOf(id) + "_Processor");
            pt.setMultiplicity((Object)new BigInteger("1"));
            pt.setScheduling(SchedulingType.FCFS);
            this.lqnModel.getProcessor().add((Object)pt);
        }
        return pt;
    }

    private ProcessorType getProcessorTypeFromModel(String id) {
        EList list = this.lqnModel.getProcessor();
        for (ProcessorType procType : list) {
            if (!procType.getName().equals(String.valueOf(id) + "_Processor")) continue;
            return procType;
        }
        return null;
    }

    private EntryType getEntryTypeFromTask(String id, TaskType tt) {
        EList entryList = tt.getEntry();
        for (EntryType entryType : entryList) {
            if (!entryType.getName().equals(String.valueOf(id) + "_Entry")) continue;
            return entryType;
        }
        return null;
    }

    public TaskType addSemaphoreTask(String id, ProcessorType pt, int capacity) {
        TaskType tt = this.addTask(id, pt);
        if (!tt.getScheduling().equals((Object)TaskSchedulingType.SEMAPHORE)) {
            tt.setScheduling(TaskSchedulingType.SEMAPHORE);
            tt.setMultiplicity((Object)BigInteger.valueOf(capacity));
            LqnFactory lqnFactory = LqnFactory.eINSTANCE;
            EntryType wait = lqnFactory.createEntryType();
            wait.setName(Pcm2LqnHelper.getWaitEntryId(id));
            wait.setType(TypeType.PH1PH2);
            wait.setSemaphore(SemaphoreType.WAIT);
            tt.getEntry().add((Object)wait);
            ActivityPhasesType aptWait = this.addActivityPhases(id);
            PhaseActivities paWait = this.addPhaseActivities(aptWait);
            wait.setEntryPhaseActivities(paWait);
            EntryType signal = lqnFactory.createEntryType();
            signal.setName(Pcm2LqnHelper.getSignalEntryId(id));
            signal.setType(TypeType.PH1PH2);
            signal.setSemaphore(SemaphoreType.SIGNAL);
            tt.getEntry().add((Object)signal);
            ActivityPhasesType aptSignal = this.addActivityPhases(id);
            PhaseActivities paSignal = this.addPhaseActivities(aptSignal);
            signal.setEntryPhaseActivities(paSignal);
        }
        return tt;
    }

    public TaskType addTask(String id, ProcessorType pt) {
        TaskType tt = null;
        if (!pt.getTask().isEmpty()) {
            tt = (TaskType)pt.getTask().get(0);
        }
        if (tt == null) {
            tt = this.lqnFactory.createTaskType();
            tt.setName(String.valueOf(id) + "_Task");
            tt.setMultiplicity((Object)new BigInteger("1"));
            tt.setThinkTime((Object)"0.0");
            tt.setActivityGraph(TaskOptionType.YES);
            if (this.isInfiniteTaskMultiplicity) {
                tt.setScheduling(TaskSchedulingType.INF);
            } else {
                tt.setScheduling(TaskSchedulingType.FCFS);
                tt.setMultiplicity((Object)new BigInteger("10000"));
            }
            ServiceType st = this.lqnFactory.createServiceType();
            st.setName("MyService");
            tt.getService().add((Object)st);
            pt.getTask().add((Object)tt);
        }
        return tt;
    }

    public TaskType addTaskForResourceDemand(String id, ProcessorType pt) {
        TaskType tt = null;
        if (!pt.getTask().isEmpty()) {
            EList taskList = pt.getTask();
            for (TaskType t : taskList) {
                if (!t.getName().equals(String.valueOf(id) + "_Task")) continue;
                return t;
            }
        }
        if (tt == null) {
            tt = this.lqnFactory.createTaskType();
            tt.setName(String.valueOf(id) + "_Task");
            tt.setMultiplicity((Object)new BigInteger("1"));
            tt.setThinkTime((Object)"0.0");
            tt.setScheduling(TaskSchedulingType.FCFS);
            tt.setActivityGraph(TaskOptionType.YES);
            ServiceType st = this.lqnFactory.createServiceType();
            st.setName("MyService");
            tt.getService().add((Object)st);
            pt.getTask().add((Object)tt);
        }
        return tt;
    }

    public EntryType addEntry(String id, TaskType tt) {
        EntryType et = this.getEntryTypeFromTask(id, tt);
        if (et == null) {
            et = this.lqnFactory.createEntryType();
            et.setName(String.valueOf(id) + "_Entry");
            et.setType(TypeType.NONE);
            tt.getEntry().add((Object)et);
        }
        return et;
    }

    public TaskActivityGraph addTaskActivityGraph(TaskType tt) {
        TaskActivityGraph taskActivityGraph = tt.getTaskActivities();
        if (taskActivityGraph == null) {
            taskActivityGraph = this.lqnFactory.createTaskActivityGraph();
            tt.setTaskActivities(taskActivityGraph);
        }
        this.taskGraphStack.push(taskActivityGraph);
        return taskActivityGraph;
    }

    public OutputEntryDistributionType addOutputEntryDistributionType(EntryType et) {
        OutputEntryDistributionType oedt = this.lqnFactory.createOutputEntryDistributionType();
        oedt.setPhase(new BigInteger("1"));
        oedt.setMin(0.0);
        oedt.setMax(10.0);
        et.getServiceTimeDistribution().add((Object)oedt);
        return oedt;
    }

    public ReplyActivityType addReplyActivity(String id, String startId, String stopId) {
        EList list = this.taskGraphStack.peek().getReplyEntry();
        if (list.size() > 0) {
            return (ReplyActivityType)((ReplyEntryType)list.get(0)).getReplyActivity().get(0);
        }
        ReplyActivityType rat = this.lqnFactory.createReplyActivityType();
        rat.setName(stopId);
        ReplyEntryType ret = this.lqnFactory.createReplyEntryType();
        ret.setName(String.valueOf(id) + "_Entry");
        ret.getReplyActivity().add((Object)rat);
        this.taskGraphStack.peek().getReplyEntry().add((Object)ret);
        return rat;
    }

    public PrecedenceType addSequencePrecedence(String firstId, String secondId) {
        EList list = this.taskGraphStack.peek().getPrecedence();
        for (PrecedenceType precType : list) {
            SingleActivityListType salt = precType.getPre();
            if (salt == null || !salt.getActivity().getName().equals(firstId)) continue;
            return precType;
        }
        PrecedenceType pt = this.lqnFactory.createPrecedenceType();
        SingleActivityListType saltPre = this.lqnFactory.createSingleActivityListType();
        ActivityType atPre = this.lqnFactory.createActivityType();
        atPre.setName(firstId);
        saltPre.setActivity(atPre);
        SingleActivityListType saltPost = this.lqnFactory.createSingleActivityListType();
        ActivityType atPost = this.lqnFactory.createActivityType();
        atPost.setName(secondId);
        saltPost.setActivity(atPost);
        pt.setPre(saltPre);
        pt.setPost(saltPost);
        this.taskGraphStack.peek().getPrecedence().add((Object)pt);
        return pt;
    }

    public ActivityDefType addActivityDef(String id) {
        EList list = this.taskGraphStack.peek().getActivity();
        for (ActivityDefType actDefType : list) {
            if (!actDefType.getName().equals(id)) continue;
            return actDefType;
        }
        ActivityDefType adt = this.lqnFactory.createActivityDefType();
        adt.setHostDemandMean((Object)"0.0");
        adt.setName(id);
        this.taskGraphStack.peek().getActivity().add((Object)adt);
        return adt;
    }

    public ActivityMakingCallType addActivityMakingCall(String callId, String targetId, CallType callType) {
        return this.addActivityMakingCall(callId, targetId, callType, 1.0);
    }

    public ActivityMakingCallType addActivityMakingCall(String callId, String targetId, CallType callType, double callMeans) {
        EList actList = this.taskGraphStack.peek().getActivity();
        for (ActivityDefType actDefType : actList) {
            if (!actDefType.getName().equals(callId)) continue;
            EList list2 = null;
            list2 = callType == CallType.SYNCH ? actDefType.getSynchCall() : actDefType.getAsynchCall();
            for (ActivityMakingCallType amct : list2) {
                if (!amct.getDest().equals(targetId)) continue;
                amct.setCallsMean((Object)"1.0");
                return amct;
            }
        }
        ActivityMakingCallType amct = this.lqnFactory.createActivityMakingCallType();
        amct.setDest(targetId);
        amct.setCallsMean((Object)("" + callMeans));
        EList list = this.taskGraphStack.peek().getActivity();
        for (ActivityDefType adt : list) {
            if (!adt.getName().equals(callId)) continue;
            if (callType == CallType.SYNCH) {
                adt.getSynchCall().add((Object)amct);
                continue;
            }
            adt.getAsynchCall().add((Object)amct);
        }
        return amct;
    }

    private double getDoubleFromValue(Object callsMean) {
        if (callsMean instanceof String) {
            return Double.valueOf((String)callsMean);
        }
        if (callsMean instanceof Double) {
            return (Double)callsMean;
        }
        throw new RuntimeException("Cannot parse LQN value " + callsMean.getClass().getName() + " " + callsMean.toString());
    }

    public PrecedenceType addBeginBranchPrecedence(String id) {
        EList list = this.taskGraphStack.peek().getPrecedence();
        for (PrecedenceType precType : list) {
            if (precType.getPre() == null || !precType.getPre().getActivity().getName().equals(id)) continue;
            return precType;
        }
        PrecedenceType ptBegin = this.getInitialPrecedence(id);
        OrListType oltPreBegin = this.lqnFactory.createOrListType();
        ptBegin.setPostOR(oltPreBegin);
        this.taskGraphStack.peek().getPrecedence().add((Object)ptBegin);
        return ptBegin;
    }

    private PrecedenceType getInitialPrecedence(String id) {
        PrecedenceType ptBegin = this.lqnFactory.createPrecedenceType();
        SingleActivityListType saltPreBegin = this.lqnFactory.createSingleActivityListType();
        ActivityType atPre = this.lqnFactory.createActivityType();
        atPre.setName(id);
        saltPreBegin.setActivity(atPre);
        ptBegin.setPre(saltPreBegin);
        return ptBegin;
    }

    public PrecedenceType addBeginForkPrecedence(String id) {
        EList list = this.taskGraphStack.peek().getPrecedence();
        for (PrecedenceType precType : list) {
            if (precType.getPre() == null || !precType.getPre().getActivity().getName().equals(id)) continue;
            return precType;
        }
        PrecedenceType ptBegin = this.getInitialPrecedence(id);
        ActivityListType alt = this.lqnFactory.createActivityListType();
        ptBegin.setPostAND(alt);
        this.taskGraphStack.peek().getPrecedence().add((Object)ptBegin);
        return ptBegin;
    }

    public PrecedenceType addEndForkPrecedence() {
        PrecedenceType ptEnd = this.lqnFactory.createPrecedenceType();
        AndJoinListType ajlt = this.lqnFactory.createAndJoinListType();
        ptEnd.setPreAND(ajlt);
        SingleActivityListType saltPostEnd = this.lqnFactory.createSingleActivityListType();
        ActivityType atPostEnd = this.lqnFactory.createActivityType();
        saltPostEnd.setActivity(atPostEnd);
        ptEnd.setPost(saltPostEnd);
        this.taskGraphStack.peek().getPrecedence().add((Object)ptEnd);
        return ptEnd;
    }

    public PrecedenceType addEndBranchPrecedence() {
        PrecedenceType ptEnd = this.lqnFactory.createPrecedenceType();
        ActivityListType altPreEnd = this.lqnFactory.createActivityListType();
        ptEnd.setPreOR(altPreEnd);
        SingleActivityListType saltPostEnd = this.lqnFactory.createSingleActivityListType();
        ActivityType atPostEnd = this.lqnFactory.createActivityType();
        saltPostEnd.setActivity(atPostEnd);
        ptEnd.setPost(saltPostEnd);
        this.taskGraphStack.peek().getPrecedence().add((Object)ptEnd);
        return ptEnd;
    }

    public ActivityOrType addActivityOrType(String startId, String branchProb, PrecedenceType pt) {
        ActivityOrType aot2;
        EList list = pt.getPostOR().getActivity();
        for (ActivityOrType aot2 : list) {
            if (!aot2.getName().equals(startId)) continue;
            return aot2;
        }
        aot2 = this.lqnFactory.createActivityOrType();
        aot2.setProb(branchProb);
        aot2.setName(startId);
        pt.getPostOR().getActivity().add((Object)aot2);
        return aot2;
    }

    public ActivityType addActivityType(String stopId, PrecedenceType pt) {
        ActivityType at2;
        EList list = pt.getPreOR().getActivity();
        for (ActivityType at2 : list) {
            if (!at2.getName().equals(stopId)) continue;
            return at2;
        }
        at2 = this.lqnFactory.createActivityType();
        at2.setName(stopId);
        pt.getPreOR().getActivity().add((Object)at2);
        return at2;
    }

    public PhaseActivities addPhaseActivities(ActivityPhasesType apt) {
        PhaseActivities pa = this.lqnFactory.createPhaseActivities();
        pa.getActivity().add((Object)apt);
        return pa;
    }

    public ActivityPhasesType addActivityPhases(String id) {
        ActivityPhasesType apt = this.lqnFactory.createActivityPhasesType();
        apt.setHostDemandMean((Object)"0.0");
        apt.setPhase(new BigInteger("1"));
        apt.setName(String.valueOf(id) + "_Activity");
        return apt;
    }

    public TaskType getTaskForProcessor(String processorId) {
        EList list = this.lqnModel.getProcessor();
        for (ProcessorType pt : list) {
            if (!pt.getName().equals(String.valueOf(processorId) + "_Processor")) continue;
            return (TaskType)pt.getTask().get(0);
        }
        logger.error((Object)"Could not find processor in Lqn Model.");
        return null;
    }

    public void finalizeLqnModel(PCMSolverWorkflowRunConfiguration config) {
        EList processors = this.lqnModel.getProcessor();
        for (ProcessorType processorType : processors) {
            if (processorType == null) continue;
            EList tasks = processorType.getTask();
            for (TaskType taskType : tasks) {
                TaskActivityGraph taskActivityGraph;
                if (taskType == null || (taskActivityGraph = taskType.getTaskActivities()) == null) continue;
                EList precedences = taskActivityGraph.getPrecedence();
                int i = 0;
                while (i < precedences.size() - 1) {
                    PrecedenceType precedenceType = (PrecedenceType)precedences.get(i);
                    ListIterator iteratorToCompareTo = precedences.listIterator(i + 1);
                    while (iteratorToCompareTo.hasNext()) {
                        PrecedenceType precedenceTypeToCompareTo = (PrecedenceType)iteratorToCompareTo.next();
                        if (!this.duplicatePrecedence(precedenceType, precedenceTypeToCompareTo)) continue;
                        iteratorToCompareTo.remove();
                    }
                    ++i;
                }
            }
        }
        SolverParamsType spt = LqnFactory.eINSTANCE.createSolverParamsType();
        spt.setConvVal(Double.parseDouble(config.getConvValue()));
        int itLimit = Integer.parseInt(config.getItLimit());
        spt.setItLimit(itLimit);
        int printInt = Integer.parseInt(config.getPrintInt());
        spt.setPrintInt(printInt);
        spt.setUnderrelaxCoeff(Double.parseDouble(config.getUnderCoeff()));
        spt.setComment("Generated by PCM2LQN on " + new Date());
        this.lqnModel.setSolverParams(spt);
    }

    private boolean duplicatePrecedence(PrecedenceType precedenceType, PrecedenceType precedenceTypeToCompareTo) {
        EList activityListToCompareTo;
        EList activityList;
        boolean same = false;
        if (precedenceType.getPre() != null && precedenceTypeToCompareTo.getPre() != null && precedenceType.getPre().getActivity() != null && precedenceTypeToCompareTo.getPre().getActivity() != null && precedenceType.getPre().getActivity().getName().equals(precedenceTypeToCompareTo.getPre().getActivity().getName())) {
            same = true;
        }
        if (precedenceType.getPreAND() != null && precedenceTypeToCompareTo.getPreAND() != null && this.listContainsSameActivities((List<ActivityType>)(activityList = precedenceType.getPreAND().getActivity()), (List<ActivityType>)(activityListToCompareTo = precedenceTypeToCompareTo.getPreAND().getActivity()))) {
            same = true;
        }
        if (precedenceType.getPreOR() != null && precedenceTypeToCompareTo.getPreOR() != null && this.listContainsSameActivities((List<ActivityType>)(activityList = precedenceType.getPreOR().getActivity()), (List<ActivityType>)(activityListToCompareTo = precedenceTypeToCompareTo.getPreOR().getActivity()))) {
            same = true;
        }
        return same;
    }

    private boolean listContainsSameActivities(List<ActivityType> activityList, List<ActivityType> activityListToCompareTo) {
        if (activityList == null || activityListToCompareTo == null || activityList.size() == 0 || activityListToCompareTo.size() != activityList.size()) {
            return false;
        }
        int i = 0;
        while (i < activityList.size()) {
            ActivityType activity1 = activityList.get(i);
            ActivityType activity2 = activityListToCompareTo.get(i);
            if (!activity1.getName().equals(activity2.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void restoreFormerTaskActivityGraph() {
        this.taskGraphStack.pop();
    }

    public LqnModelType getLqnModel() {
        return this.lqnModel;
    }

    public ProcessorType getProcessor(String processorId) {
        EList list = this.lqnModel.getProcessor();
        for (ProcessorType pt : list) {
            if (!pt.getName().equals(String.valueOf(processorId) + "_Processor")) continue;
            return pt;
        }
        return null;
    }

    public boolean isLQSimAnalysis() {
        return this.isLQSimAnalysis;
    }

    public void setIsLQSimAnalysis(boolean isQLSim) {
        Pcm2LqnHelper.shortenIds = this.isLQSimAnalysis = isQLSim;
    }

    public void addActivityToPostAnd(String startId, PrecedenceType ptBegin) {
        ActivityType at = this.lqnFactory.createActivityType();
        at.setName(startId);
        ptBegin.getPostAND().getActivity().add((Object)at);
    }

    public void addActivityToPreAnd(String stopId, PrecedenceType ptEnd) {
        ActivityType at = this.lqnFactory.createActivityType();
        at.setName(stopId);
        ptEnd.getPreAND().getActivity().add((Object)at);
    }

    public void setPoolCapacity(Integer poolCapacity) {
        TaskActivityGraph tag = this.taskGraphStack.peek();
        TaskType task = (TaskType)tag.eContainer();
        task.setMultiplicity((Object)new BigInteger(poolCapacity.toString()));
        task.setScheduling(TaskSchedulingType.FCFS);
    }
}

