/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.probfunction.math.IContinousPDF;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.AcquireAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ForkAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ReleaseAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.SynchronisationPoint;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.solver.lqn.ActivityDefType;
import org.palladiosimulator.solver.lqn.ActivityMakingCallType;
import org.palladiosimulator.solver.lqn.ActivityPhasesType;
import org.palladiosimulator.solver.lqn.CallOrderType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.PhaseActivities;
import org.palladiosimulator.solver.lqn.PrecedenceType;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.lqn.TypeType;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.transformations.pcm2lqn.CallType;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnBuilder;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;
import org.palladiosimulator.solver.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.visitors.ExpressionHelper;

public class Rdseff2Lqn
extends SeffSwitch<String> {
    private static Logger logger = Logger.getLogger((String)Rdseff2Lqn.class.getName());
    private ContextWrapper myContextWrapper;
    private LqnBuilder lqnBuilder;

    public Rdseff2Lqn(LqnBuilder lqnBuilder, ContextWrapper contextWrapper) {
        this.lqnBuilder = lqnBuilder;
        this.myContextWrapper = contextWrapper;
    }

    public String caseAcquireAction(AcquireAction object) {
        if (this.lqnBuilder.isLQSimAnalysis()) {
            String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
            String passiveResourceId = Pcm2LqnHelper.getIdForPassiveResource(object.getPassiveresource_AcquireAction(), this.myContextWrapper.getAllCtx());
            ProcessorType pt = this.lqnBuilder.addProcessor(passiveResourceId);
            this.lqnBuilder.addSemaphoreTask(passiveResourceId, pt, Integer.valueOf(object.getPassiveresource_AcquireAction().getCapacity_PassiveResource().getSpecification()));
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            adt.setCallOrder(CallOrderType.DETERMINISTIC);
            this.lqnBuilder.addActivityMakingCall(id, Pcm2LqnHelper.getWaitEntryId(passiveResourceId), CallType.SYNCH);
            String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
            this.lqnBuilder.addSequencePrecedence(id, successorId);
            return id;
        }
        if (object.getPassiveresource_AcquireAction().getEntityName().toLowerCase().contains("pool")) {
            logger.warn((Object)"Passive resource pool found. Support by PCM2LQN is limited. Please analyze the results carefully.");
            Integer poolCapacity = Integer.valueOf(object.getPassiveresource_AcquireAction().getCapacity_PassiveResource().getSpecification());
            this.lqnBuilder.setPoolCapacity(poolCapacity);
        } else {
            logger.warn((Object)"Ignored release action because it is not supported by LQNS. Be aware that the passive resource is not analysed.");
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        return successorId;
    }

    public String caseReleaseAction(ReleaseAction object) {
        if (this.lqnBuilder.isLQSimAnalysis()) {
            String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            adt.setCallOrder(CallOrderType.DETERMINISTIC);
            String passiveResourceId = Pcm2LqnHelper.getIdForPassiveResource(object.getPassiveResource_ReleaseAction(), this.myContextWrapper.getAllCtx());
            this.lqnBuilder.addActivityMakingCall(id, Pcm2LqnHelper.getSignalEntryId(passiveResourceId), CallType.SYNCH);
            String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
            this.lqnBuilder.addSequencePrecedence(id, successorId);
            return id;
        }
        logger.warn((Object)"Ignored release action because it is not supported by LQNS. Be aware that the passive resource is not analysed.");
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        return successorId;
    }

    public String caseResourceDemandingSEFF(ResourceDemandingSEFF object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        this.lqnBuilder.addTaskActivityGraph(tt);
        ResourceDemandingSEFF rdb = object;
        String startId = (String)this.doSwitch((EObject)this.getStartAction((ResourceDemandingBehaviour)rdb));
        String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction((ResourceDemandingBehaviour)rdb), this.myContextWrapper);
        this.lqnBuilder.addReplyActivity(id, startId, stopId);
        this.lqnBuilder.restoreFormerTaskActivityGraph();
        return et.getName();
    }

    public String caseLoopAction(LoopAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.handleLoop((AbstractLoopAction)object, id);
        return id;
    }

    private void handleLoop(AbstractLoopAction object, String id) {
        String startId = this.handleLoopBody(object, id);
        this.lqnBuilder.addActivityDef(id);
        ActivityMakingCallType amct = this.lqnBuilder.addActivityMakingCall(id, startId, CallType.SYNCH);
        amct.setCallsMean((Object)this.getLoopIterations(object));
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
    }

    private String handleLoopBody(AbstractLoopAction loop, String id) {
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        this.lqnBuilder.addTaskActivityGraph(tt);
        ResourceDemandingBehaviour rdb = loop.getBodyBehaviour_Loop();
        String startId = (String)this.doSwitch((EObject)this.getStartAction(rdb));
        String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction(rdb), this.myContextWrapper);
        this.lqnBuilder.addReplyActivity(id, startId, stopId);
        this.lqnBuilder.restoreFormerTaskActivityGraph();
        return startId;
    }

    private String getLoopIterations(AbstractLoopAction loop) {
        ManagedPMF pmf = this.myContextWrapper.getLoopIterations(loop);
        if (pmf != null) {
            try {
                return String.valueOf(pmf.getPmfTimeDomain().getArithmeticMeanValue());
            }
            catch (DomainNotNumbersException e) {
                return "0.0";
            }
            catch (FunctionNotInTimeDomainException e) {
                return "0.0";
            }
        }
        return "0.0";
    }

    public String caseCollectionIteratorAction(CollectionIteratorAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.handleLoop((AbstractLoopAction)object, id);
        return id;
    }

    public String caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        return (String)this.doSwitch((EObject)this.getStartAction(object));
    }

    public String caseStartAction(StartAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        String entryId = "";
        if (object.eContainer() instanceof ResourceDemandingSEFF) {
            ResourceDemandingSEFF rdseff = (ResourceDemandingSEFF)object.eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getId((Identifier)rdseff, this.myContextWrapper)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else if (object.eContainer().eContainer() instanceof LoopAction) {
            LoopAction la = (LoopAction)object.eContainer().eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getId((Identifier)la, this.myContextWrapper)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else if (object.eContainer().eContainer() instanceof CollectionIteratorAction) {
            CollectionIteratorAction cia = (CollectionIteratorAction)object.eContainer().eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getId((Identifier)cia, this.myContextWrapper)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else if (object.eContainer().eContainer() instanceof SynchronisationPoint) {
            this.lqnBuilder.addActivityDef(id);
        } else if (object.eContainer() instanceof ForkedBehaviour) {
            ForkedBehaviour fb = (ForkedBehaviour)object.eContainer();
            ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
            entryId = String.valueOf(Pcm2LqnHelper.getIdForForkedBehaviour(fb, this.myContextWrapper)) + "_Entry";
            adt.setBoundToEntry(entryId);
        } else {
            this.lqnBuilder.addActivityDef(id);
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        this.lqnBuilder.addSequencePrecedence(id, successorId);
        if (entryId.equals("")) {
            return id;
        }
        return entryId;
    }

    public String caseBranchAction(BranchAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.lqnBuilder.addActivityDef(id);
        PrecedenceType ptBegin = this.lqnBuilder.addBeginBranchPrecedence(id);
        PrecedenceType ptEnd = this.lqnBuilder.addEndBranchPrecedence();
        EList btList = object.getBranches_Branch();
        for (AbstractBranchTransition bt : btList) {
            ResourceDemandingBehaviour rdb = bt.getBranchBehaviour_BranchTransition();
            Double branchProbNumeric = this.myContextWrapper.getBranchProbability(bt);
            if (!(branchProbNumeric > 0.0)) continue;
            String startId = (String)this.doSwitch((EObject)rdb);
            String branchProb = branchProbNumeric.toString();
            this.lqnBuilder.addActivityOrType(startId, branchProb, ptBegin);
            String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction(rdb), this.myContextWrapper);
            this.lqnBuilder.addActivityType(stopId, ptEnd);
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        ptEnd.getPost().getActivity().setName(successorId);
        return id;
    }

    public String caseSetVariableAction(SetVariableAction object) {
        Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        return (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
    }

    public String caseExternalCallAction(ExternalCallAction object) {
        return this.handleExternalCallAction(object, CallType.SYNCH, object.getSuccessor_AbstractAction());
    }

    private String handleExternalCallAction(ExternalCallAction object, CallType callType, AbstractAction successor) {
        String callId = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        AllocationContext callerAllocationContext = this.myContextWrapper.getAllCtx();
        ResourceDemandingSEFF seff = (ResourceDemandingSEFF)this.myContextWrapper.getNextSEFF(object);
        if (seff == null) {
            return (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        }
        ContextWrapper oldContextWrapper = (ContextWrapper)this.myContextWrapper.clone();
        List<ContextWrapper> contextWrapperList = this.myContextWrapper.getContextWrapperFor(object);
        ArrayList<AllocationContext> calledAllocationContextList = new ArrayList<AllocationContext>(contextWrapperList.size());
        boolean localComponentInstanceAvailable = false;
        ContextWrapper localContextWrapper = null;
        for (ContextWrapper contextWrapper : contextWrapperList) {
            if (!contextWrapper.getAllCtx().getId().equals(oldContextWrapper.getAllCtx().getId())) continue;
            localComponentInstanceAvailable = true;
            localContextWrapper = contextWrapper;
            break;
        }
        if (localComponentInstanceAvailable || contextWrapperList.size() == 1) {
            this.myContextWrapper = localContextWrapper != null ? localContextWrapper : contextWrapperList.get(0);
            AllocationContext toAllocationContext = this.myContextWrapper.getAllCtx();
            calledAllocationContextList.add(toAllocationContext);
            this.createCallActivity(callId, seff, callType);
        } else {
            double branchProb = 1.0 / (double)contextWrapperList.size();
            Iterator<ContextWrapper> iterator = contextWrapperList.iterator();
            while (iterator.hasNext()) {
                ContextWrapper contextWrapper;
                this.myContextWrapper = contextWrapper = iterator.next();
                AllocationContext toAllocationContext = this.myContextWrapper.getAllCtx();
                calledAllocationContextList.add(toAllocationContext);
                this.createCallActivity(callId, seff, callType, branchProb);
            }
        }
        this.myContextWrapper = oldContextWrapper;
        String successorId = (String)this.doSwitch((EObject)successor);
        for (AllocationContext targetAllocationContext : calledAllocationContextList) {
            if (callerAllocationContext.getResourceContainer_AllocationContext() == targetAllocationContext.getResourceContainer_AllocationContext()) continue;
            CommunicationLinkResourceSpecification link = oldContextWrapper.getConcreteLinkingResource(object, targetAllocationContext);
            if (link != null && ExpressionHelper.getMeanValue(link.getLatency_CommunicationLinkResourceSpecification()) > 0.0) {
                String linkId = Pcm2LqnHelper.getIdForCommResource(link.getLinkingResource_CommunicationLinkResourceSpecification(), link.getCommunicationLinkResourceType_CommunicationLinkResourceSpecification());
                String latencyId = Pcm2LqnHelper.getIdForLatency(linkId, callType);
                String networkCallId = "LAN_" + callId + "_" + (Object)((Object)callType);
                String networkResponseId = "LAN_" + callId + "_return";
                this.lqnBuilder.addActivityDef(networkCallId);
                this.lqnBuilder.addActivityMakingCall(networkCallId, String.valueOf(latencyId) + "_Entry", callType);
                if (callType == CallType.SYNCH) {
                    this.lqnBuilder.addActivityDef(networkResponseId);
                    this.lqnBuilder.addActivityMakingCall(networkResponseId, String.valueOf(latencyId) + "_Entry", callType);
                }
                this.lqnBuilder.addSequencePrecedence(networkCallId, callId);
                if (callType == CallType.SYNCH) {
                    this.lqnBuilder.addSequencePrecedence(callId, networkResponseId);
                    this.lqnBuilder.addSequencePrecedence(networkResponseId, successorId);
                } else {
                    this.lqnBuilder.addSequencePrecedence(callId, successorId);
                }
                return networkCallId;
            }
            if (link != null) continue;
            logger.warn((Object)("No link found between " + callerAllocationContext.getEntityName() + " <" + callerAllocationContext.getId() + "> and " + targetAllocationContext.getEntityName() + " <" + targetAllocationContext.getId() + "> , ignoring this."));
        }
        this.lqnBuilder.addSequencePrecedence(callId, successorId);
        return callId;
    }

    private void createCallActivity(String callerId, ResourceDemandingSEFF sefftoBeCalled, CallType callType) {
        this.createCallActivity(callerId, sefftoBeCalled, callType, 1.0);
    }

    private void createCallActivity(String callerId, ResourceDemandingSEFF sefftoBeCalled, CallType callType, double callMeans) {
        String entryId = "";
        try {
            Rdseff2Lqn seffVisitor = new Rdseff2Lqn(this.lqnBuilder, this.myContextWrapper);
            entryId = (String)seffVisitor.doSwitch((EObject)sefftoBeCalled);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error while visiting RDSEFF " + sefftoBeCalled.getId()));
            e.printStackTrace();
            throw e;
        }
        this.lqnBuilder.addActivityDef(callerId);
        this.lqnBuilder.addActivityMakingCall(callerId, entryId, callType, callMeans);
    }

    public String caseInternalAction(InternalAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        EList resDemList = object.getResourceDemand_Action();
        int counter = 0;
        for (ParametricResourceDemand resourceDemand : resDemList) {
            ManagedPDF pdf;
            IProbabilityDensityFunction innerPDF;
            String processorId = this.getProcessorName(resourceDemand);
            TaskType tt = this.lqnBuilder.getTaskForProcessor(processorId);
            EntryType et = this.lqnBuilder.addEntry(String.valueOf(id) + counter, tt);
            et.setType(TypeType.PH1PH2);
            ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(String.valueOf(id) + counter);
            Double demand = this.myContextWrapper.getMeanTimeConsumption(resourceDemand);
            String hostDemand = demand.toString();
            apt.setHostDemandMean((Object)hostDemand);
            if (this.myContextWrapper.getIsOriginalPDFFor(resourceDemand) && (innerPDF = (pdf = this.myContextWrapper.getTimeConsumptionAsPDF(resourceDemand)).getPdfTimeDomain()) instanceof IContinousPDF) {
                IContinousPDF innerContPDF = (IContinousPDF)innerPDF;
                double coeffv = innerContPDF.getCoefficientOfVariance();
                Double squaredcv = coeffv * coeffv;
                apt.setHostDemandCvsq((Object)squaredcv.toString());
            }
            PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
            et.setEntryPhaseActivities(pa);
            this.lqnBuilder.addActivityDef(String.valueOf(id) + counter);
            this.lqnBuilder.addActivityMakingCall(String.valueOf(id) + counter, et.getName(), CallType.SYNCH);
            if (counter < resDemList.size() - 1) {
                this.lqnBuilder.addSequencePrecedence(String.valueOf(id) + counter, String.valueOf(id) + (counter + 1));
            }
            ++counter;
        }
        String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        if (resDemList.size() > 0) {
            this.lqnBuilder.addSequencePrecedence(String.valueOf(id) + (counter - 1), successorId);
            return String.valueOf(id) + 0;
        }
        return successorId;
    }

    private String getProcessorName(ParametricResourceDemand resourceDemand) {
        ProcessingResourceSpecification prs = this.myContextWrapper.getConcreteProcessingResource(resourceDemand);
        if (prs == null) {
            throw new RuntimeException("Could not find " + ProcessingResourceSpecification.class.getName() + "of type " + resourceDemand.getRequiredResource_ParametricResourceDemand().getEntityName() + "(id:" + resourceDemand.getRequiredResource_ParametricResourceDemand().getId() + ")" + " adressed by resource demand of action " + resourceDemand.getAction_ParametricResourceDemand().getEntityName() + " (" + resourceDemand.getAction_ParametricResourceDemand().getId() + "). Check your model that the required resources are available on the server.");
        }
        ResourceContainer rc = (ResourceContainer)prs.eContainer();
        ProcessingResourceType prt = prs.getActiveResourceType_ActiveResourceSpecification();
        String name = Pcm2LqnHelper.getIdForProcResource((Entity)rc, prt);
        return name;
    }

    public String caseStopAction(StopAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        this.lqnBuilder.addActivityDef(id);
        return id;
    }

    private StartAction getStartAction(ResourceDemandingBehaviour behaviour) {
        StartAction startAction = (StartAction)EMFQueryHelper.getObjectByType(behaviour.getSteps_Behaviour(), StartAction.class);
        return startAction;
    }

    private StopAction getStopAction(ResourceDemandingBehaviour behaviour) {
        StopAction stopAction = (StopAction)EMFQueryHelper.getObjectByType(behaviour.getSteps_Behaviour(), StopAction.class);
        return stopAction;
    }

    public String caseForkActionOld(ForkAction object) {
        ForkedBehaviour innerFork;
        if (object.getAsynchronousForkedBehaviours_ForkAction().size() == 1 && (object.getSynchronisingBehaviours_ForkAction() == null || object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint().size() == 0) && (innerFork = (ForkedBehaviour)object.getAsynchronousForkedBehaviours_ForkAction().get(0)).getSteps_Behaviour().size() == 3) {
            ExternalCallAction eca = null;
            for (AbstractAction action : innerFork.getSteps_Behaviour()) {
                if (!(action instanceof ExternalCallAction)) continue;
                eca = (ExternalCallAction)action;
                break;
            }
            if (eca != null) {
                return this.handleExternalCallAction(eca, CallType.ASYNCH, object.getSuccessor_AbstractAction());
            }
        }
        logger.warn((Object)"No arbitrary Fork action supported yet, only asnychronous Forks containing a single ExternalCall are supported.");
        return (String)super.caseForkAction(object);
    }

    public String caseForkAction(ForkAction object) {
        String id = Pcm2LqnHelper.getId((Identifier)object, this.myContextWrapper);
        ActivityDefType adt = this.lqnBuilder.addActivityDef(id);
        String currentId = id;
        String predecessorId = id;
        EList asyncBehList = object.getAsynchronousForkedBehaviours_ForkAction();
        for (ForkedBehaviour asyncBeh : asyncBehList) {
            currentId = Pcm2LqnHelper.getIdForForkedBehaviour(asyncBeh, this.myContextWrapper);
            ProcessorType pt = this.lqnBuilder.addProcessor(currentId);
            TaskType tt = this.lqnBuilder.addTask(currentId, pt);
            EntryType et = this.lqnBuilder.addEntry(currentId, tt);
            this.lqnBuilder.addTaskActivityGraph(tt);
            this.doSwitch((EObject)this.getStartAction((ResourceDemandingBehaviour)asyncBeh));
            this.lqnBuilder.restoreFormerTaskActivityGraph();
            this.lqnBuilder.addActivityDef(String.valueOf(currentId) + "_Action");
            this.lqnBuilder.addActivityMakingCall(String.valueOf(currentId) + "_Action", String.valueOf(currentId) + "_Entry", CallType.ASYNCH);
            this.lqnBuilder.addSequencePrecedence(predecessorId, String.valueOf(currentId) + "_Action");
            predecessorId = String.valueOf(currentId) + "_Action";
        }
        if (object.getSynchronisingBehaviours_ForkAction() != null && object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint().size() > 0) {
            EList syncBehList = object.getSynchronisingBehaviours_ForkAction().getSynchronousForkedBehaviours_SynchronisationPoint();
            PrecedenceType ptBegin = this.lqnBuilder.addBeginForkPrecedence(String.valueOf(currentId) + "_Action");
            PrecedenceType ptEnd = this.lqnBuilder.addEndForkPrecedence();
            for (ForkedBehaviour syncBeh : syncBehList) {
                String startId = (String)this.doSwitch((EObject)this.getStartAction((ResourceDemandingBehaviour)syncBeh));
                this.lqnBuilder.addActivityToPostAnd(startId, ptBegin);
                String stopId = Pcm2LqnHelper.getId((Identifier)this.getStopAction((ResourceDemandingBehaviour)syncBeh), this.myContextWrapper);
                this.lqnBuilder.addActivityToPreAnd(stopId, ptEnd);
            }
            String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
            ptEnd.getPost().getActivity().setName(successorId);
        } else {
            String successorId = (String)this.doSwitch((EObject)object.getSuccessor_AbstractAction());
            this.lqnBuilder.addSequencePrecedence(String.valueOf(currentId) + "_Action", successorId);
        }
        return id;
    }
}

