/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2lqn;

import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentSwitch;
import org.palladiosimulator.pcm.resourcetype.CommunicationLinkResourceType;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.solver.lqn.ActivityPhasesType;
import org.palladiosimulator.solver.lqn.EntryType;
import org.palladiosimulator.solver.lqn.PhaseActivities;
import org.palladiosimulator.solver.lqn.ProcessorType;
import org.palladiosimulator.solver.lqn.SchedulingType;
import org.palladiosimulator.solver.lqn.TaskType;
import org.palladiosimulator.solver.lqn.TypeType;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.transformations.ExpressionToPDFWrapper;
import org.palladiosimulator.solver.transformations.pcm2lqn.CallType;
import org.palladiosimulator.solver.transformations.pcm2lqn.LqnBuilder;
import org.palladiosimulator.solver.transformations.pcm2lqn.Pcm2LqnHelper;
import org.palladiosimulator.solver.visitors.ExpressionHelper;

public class ResourceEnvironment2Lqn
extends ResourceenvironmentSwitch {
    private static Logger logger = Logger.getLogger((String)ResourceEnvironment2Lqn.class.getName());
    private final LqnBuilder lqnBuilder;
    private final PCMSolverWorkflowRunConfiguration config;

    public ResourceEnvironment2Lqn(LqnBuilder aLqnBuilder, PCMSolverWorkflowRunConfiguration aConfig) {
        this.lqnBuilder = aLqnBuilder;
        this.config = aConfig;
    }

    public Object caseCommunicationLinkResourceSpecification(CommunicationLinkResourceSpecification object) {
        LinkingResource lr = (LinkingResource)object.eContainer();
        CommunicationLinkResourceType clrt = object.getCommunicationLinkResourceType_CommunicationLinkResourceSpecification();
        String id = Pcm2LqnHelper.getIdForCommResource(lr, clrt);
        PCMRandomVariable throughputVariable = object.getThroughput_CommunicationLinkResourceSpecification();
        PCMRandomVariable latencyVariable = object.getLatency_CommunicationLinkResourceSpecification();
        if (throughputVariable != null || latencyVariable != null) {
            ProcessorType pt = this.lqnBuilder.addProcessor(id);
            pt.setSpeedFactor((Object)"1");
            pt.setScheduling(SchedulingType.FCFS);
            TaskType tt = this.lqnBuilder.addTask(id, pt);
            if (throughputVariable != null) {
                String throughputID = Pcm2LqnHelper.getIdForThroughput(id);
                ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(throughputID);
                PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
                EntryType et = this.lqnBuilder.addEntry(throughputID, tt);
                et.setType(TypeType.NONE);
                et.setEntryPhaseActivities(pa);
                double throughputSpeedFactor = 1.0 / ExpressionHelper.getMeanValue(throughputVariable);
                apt.setHostDemandMean((Object)("" + throughputSpeedFactor));
            }
            if (latencyVariable != null) {
                ExpressionToPDFWrapper expToPDF = ExpressionToPDFWrapper.createExpressionToPDFWrapper(latencyVariable.getExpression());
                double latency = expToPDF.getMeanValue();
                CallType[] callTypes = CallType.values();
                int i = 0;
                while (i < callTypes.length) {
                    CallType callType = callTypes[i];
                    String latencyID = Pcm2LqnHelper.getIdForLatency(id, callType);
                    ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(latencyID);
                    PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
                    EntryType et = this.lqnBuilder.addEntry(latencyID, tt);
                    et.setType(TypeType.PH1PH2);
                    et.setEntryPhaseActivities(pa);
                    apt.setHostDemandMean((Object)("" + latency));
                    double stdev = expToPDF.getStandardDeviation();
                    if (!Double.isNaN(stdev) && latency != 0.0) {
                        apt.setHostDemandCvsq((Object)("" + stdev * stdev / (latency * latency)));
                    }
                    ++i;
                }
            }
        } else {
            logger.warn((Object)"Found linking resource with neither throughput specification nor latency specification, ignoring it.");
        }
        return null;
    }

    public Object caseLinkingResource(LinkingResource object) {
        this.doSwitch((EObject)object.getCommunicationLinkResourceSpecifications_LinkingResource());
        return null;
    }

    public Object caseProcessingResourceSpecification(ProcessingResourceSpecification object) {
        ResourceContainer rc = (ResourceContainer)object.eContainer();
        ProcessingResourceType prt = object.getActiveResourceType_ActiveResourceSpecification();
        String id = Pcm2LqnHelper.getIdForProcResource((Entity)rc, prt);
        ProcessorType pt = this.lqnBuilder.addProcessor(id);
        this.setSchedulingPolicy(object, pt);
        pt.setSpeedFactor((Object)"1.0");
        pt.setMultiplicity((Object)new BigInteger("" + object.getNumberOfReplicas()));
        TaskType tt = this.lqnBuilder.addTask(id, pt);
        tt.setMultiplicity((Object)new BigInteger("" + object.getNumberOfReplicas()));
        ActivityPhasesType apt = this.lqnBuilder.addActivityPhases(id);
        PhaseActivities pa = this.lqnBuilder.addPhaseActivities(apt);
        EntryType et = this.lqnBuilder.addEntry(id, tt);
        et.setType(TypeType.NONE);
        et.setEntryPhaseActivities(pa);
        return null;
    }

    private void setSchedulingPolicy(ProcessingResourceSpecification object, ProcessorType pt) {
        String schedulingPolicyID = object.getSchedulingPolicy().getId();
        if (schedulingPolicyID.equals("FCFS")) {
            pt.setScheduling(SchedulingType.FCFS);
        } else if (schedulingPolicyID.equals("Delay")) {
            pt.setScheduling(SchedulingType.INF);
        } else if (schedulingPolicyID.equals("ProcessorSharing")) {
            pt.setScheduling(SchedulingType.PS);
            pt.setQuantum((Object)this.config.getPsQuantum());
        } else {
            logger.warn((Object)("Unknown scheduling strategy " + object.getSchedulingPolicy().getId() + ", using PROCESSOR_SHARING for " + object.getActiveResourceType_ActiveResourceSpecification().getEntityName() + " of server " + object.getResourceContainer_ProcessingResourceSpecification().getEntityName() + " (id: " + object.getResourceContainer_ProcessingResourceSpecification().getId() + ")"));
            pt.setScheduling(SchedulingType.PS);
            pt.setQuantum((Object)this.config.getPsQuantum());
        }
    }

    public Object caseResourceContainer(ResourceContainer object) {
        EList procResList = object.getActiveResourceSpecifications_ResourceContainer();
        for (ProcessingResourceSpecification prs : procResList) {
            this.doSwitch((EObject)prs);
        }
        return null;
    }

    public Object caseResourceEnvironment(ResourceEnvironment object) {
        EList resConList = object.getResourceContainer_ResourceEnvironment();
        for (ResourceContainer rc : resConList) {
            this.doSwitch((EObject)rc);
        }
        EList linkResList = object.getLinkingResources__ResourceEnvironment();
        for (LinkingResource lr : linkResList) {
            this.doSwitch((EObject)lr);
        }
        return null;
    }
}

