/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2regex;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.ManagedPDF;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.print.ProbFunctionCSVPrint;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.exprsolver.ExpressionSolver;
import org.palladiosimulator.solver.models.PCMInstance;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.transformations.EMFHelper;
import org.palladiosimulator.solver.transformations.SolverStrategy;
import org.palladiosimulator.solver.transformations.pcm2regex.ExpressionPrinter;
import org.palladiosimulator.solver.transformations.pcm2regex.TransformUsageModelVisitor;
import org.palladiosimulator.solver.visitors.UsageModelVisitor;
import org.palladiosimulator.solver.visualisation.JFVisualisation;

public class Pcm2RegExStrategy
implements SolverStrategy {
    Expression stoRegEx;
    protected IProbabilityFunctionFactory iProbFuncFactory = IProbabilityFunctionFactory.eINSTANCE;
    private static Logger logger = Logger.getLogger((String)Pcm2RegExStrategy.class.getName());
    private long overallDuration = 0L;
    private final PCMSolverWorkflowRunConfiguration configuration;

    public Pcm2RegExStrategy(PCMSolverWorkflowRunConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void loadTransformedModel(String fileName) {
        EObject object = EMFHelper.loadFromXMIFile(fileName);
        if (object instanceof Expression) {
            this.stoRegEx = (Expression)object;
        } else {
            logger.warn((Object)("Could not load " + fileName + " because is not an Expression model"));
        }
    }

    @Override
    public void solve() {
        if (this.stoRegEx != null) {
            long timeBeforeCalc = System.nanoTime();
            ExpressionSolver solver = new ExpressionSolver();
            ManagedPDF resultPDF = solver.getResponseTime(this.stoRegEx);
            if (resultPDF == null) {
                logger.error((Object)"StochasticRegularExpression could not be solved!");
                return;
            }
            long timeAfterCalc = System.nanoTime();
            long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterCalc - timeBeforeCalc);
            this.overallDuration += duration;
            logger.info((Object)("Finished Running ExprSolver:\t" + duration + " ms"));
            logger.debug((Object)("Resulting PDF:\t\t\t" + resultPDF.toString()));
            logger.trace((Object)("As csv:\n\nx;probability\n" + (String)new ProbFunctionCSVPrint().doSwitch((EObject)resultPDF.getModelBoxedPdf())));
            this.visualize(resultPDF.getPdfTimeDomain());
            long timeAfterVisualisation = System.nanoTime();
            duration = TimeUnit.NANOSECONDS.toMillis(timeAfterVisualisation - timeAfterCalc);
            this.overallDuration += duration;
            logger.info((Object)("Finished Visualisation:\t\t" + duration + " ms"));
            logger.info((Object)("Finished SRE-Solver:\t\t" + this.overallDuration + " ms"));
        } else {
            logger.error((Object)"No StochasticRegularExpression available for solution!");
        }
    }

    @Override
    public void storeTransformedModel(String fileName) {
        EMFHelper.saveToXMIFile((EObject)this.stoRegEx, fileName);
    }

    @Override
    public void transform(PCMInstance model) {
        if (!this.configuration.isUseSREInputModel()) {
            long timeBeforeCalc = System.nanoTime();
            this.runDSolver(model);
            this.runPcm2RegEx(model);
            this.printStoRegEx();
            this.storeTransformedModel(this.configuration.getSREOutputFile());
            long timeAfterCalc = System.nanoTime();
            long duration = TimeUnit.NANOSECONDS.toMillis(timeAfterCalc - timeBeforeCalc);
            this.overallDuration += duration;
            logger.info((Object)("Finished Running PCM2SRE:\t\t" + duration + " ms"));
        } else {
            String filename = this.configuration.getSREOutputFile();
            this.loadTransformedModel(filename);
            logger.warn((Object)("Using predefined Expression model " + filename));
        }
    }

    private void printStoRegEx() {
        ExpressionPrinter expPrinter = new ExpressionPrinter();
        expPrinter.doSwitch((EObject)this.stoRegEx);
        logger.debug((Object)("ExpressionPrinter: " + expPrinter.getOutput()));
    }

    private void runPcm2RegEx(PCMInstance model) {
        TransformUsageModelVisitor umVisit = new TransformUsageModelVisitor(model);
        UsageScenario us = (UsageScenario)model.getUsageModel().getUsageScenario_UsageModel().get(0);
        try {
            this.stoRegEx = (Expression)umVisit.doSwitch((EObject)us.getScenarioBehaviour_UsageScenario());
        }
        catch (Exception e) {
            logger.error((Object)("Transforming the PCM instance into a stochastic regular expression caused an Exception! Check your model for broken references, e.g. old, dangling Connectors." + e.getMessage()));
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void runDSolver(PCMInstance model) {
        UsageModelVisitor visitor = new UsageModelVisitor(model);
        try {
            UsageScenario us = (UsageScenario)model.getUsageModel().getUsageScenario_UsageModel().get(0);
            visitor.doSwitch((EObject)us.getScenarioBehaviour_UsageScenario());
        }
        catch (Exception e) {
            logger.error((Object)("Running the dependency solver caused an Exception! Check your model for broken references, e.g. old, dangling Connectors." + e.getMessage()));
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void visualize(IProbabilityDensityFunction iPDF) {
        ISamplePDF samplePDF = null;
        try {
            samplePDF = this.iProbFuncFactory.transformToSamplePDF(iPDF);
        }
        catch (UnknownPDFTypeException e1) {
            e1.printStackTrace();
        }
        try {
            double dist = 0.0;
            try {
                dist = PDFConfiguration.getCurrentConfiguration().getDistance();
            }
            catch (ConfigurationNotSetException e) {
                e.printStackTrace();
            }
            JFVisualisation vis = new JFVisualisation(dist);
            vis.addSamplePDF(samplePDF, "Execution Time");
            vis.visualizeOverlay();
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
        }
    }
}

