/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.transformations.pcm2regex;

import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityFunction;
import de.uka.ipd.sdq.probfunction.SamplePDF;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.stoex.Atom;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NumericLiteral;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.AbstractInternalControlFlowAction;
import org.palladiosimulator.pcm.seff.AbstractLoopAction;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.CollectionIteratorAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.LoopAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SetVariableAction;
import org.palladiosimulator.pcm.seff.StartAction;
import org.palladiosimulator.pcm.seff.StopAction;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.pcm.seff.util.SeffSwitch;
import org.palladiosimulator.solver.spa.expression.Expression;
import org.palladiosimulator.solver.spa.expression.ExpressionFactory;
import org.palladiosimulator.solver.spa.expression.Loop;
import org.palladiosimulator.solver.spa.expression.Option;
import org.palladiosimulator.solver.spa.expression.Sequence;
import org.palladiosimulator.solver.spa.expression.Symbol;
import org.palladiosimulator.solver.spa.resourcemodel.ResourceModelFactory;
import org.palladiosimulator.solver.spa.resourcemodel.ResourceUsage;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.transformations.pcm2regex.Pcm2RegexHelper;
import org.palladiosimulator.solver.visitors.EMFQueryHelper;
import org.palladiosimulator.solver.visitors.ExpressionHelper;

public class TransformSeffVisitor
extends SeffSwitch {
    private static Logger logger = Logger.getLogger((String)TransformSeffVisitor.class.getName());
    private ExpressionFactory expFactory = ExpressionFactory.eINSTANCE;
    private ResourceModelFactory resFactory = ResourceModelFactory.eINSTANCE;
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private ContextWrapper myContextWrapper;

    public TransformSeffVisitor(ContextWrapper ctxWrapper) {
        this.myContextWrapper = ctxWrapper;
    }

    public Object caseResourceDemandingSEFF(ResourceDemandingSEFF object) {
        ResourceDemandingSEFF rdb = object;
        return this.doSwitch((EObject)this.getStartAction((ResourceDemandingBehaviour)rdb));
    }

    public Object caseResourceDemandingBehaviour(ResourceDemandingBehaviour object) {
        return this.doSwitch((EObject)this.getStartAction(object));
    }

    public Object caseStartAction(StartAction object) {
        Symbol sym = this.expFactory.createSymbol();
        sym.setName("Start_" + object.getId());
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)sym);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    public Object caseStopAction(StopAction object) {
        Symbol sym = this.expFactory.createSymbol();
        sym.setName("Stop_" + object.getId());
        return sym;
    }

    public Object caseInternalAction(InternalAction object) {
        return this.handleSymbol((AbstractInternalControlFlowAction)object);
    }

    public Object caseSetVariableAction(SetVariableAction object) {
        return this.handleSymbol((AbstractInternalControlFlowAction)object);
    }

    public Object caseExternalCallAction(ExternalCallAction object) {
        ResourceDemandingSEFF seff = (ResourceDemandingSEFF)this.myContextWrapper.getNextSEFF(object);
        if (seff == null) {
            return this.doSwitch((EObject)object.getSuccessor_AbstractAction());
        }
        ContextWrapper oldContextWrapper = (ContextWrapper)this.myContextWrapper.clone();
        List<ContextWrapper> contextWrapperList = this.myContextWrapper.getContextWrapperFor(object);
        LinkedList<Option> optionsPerContextWrapperList = new LinkedList<Option>();
        Iterator<ContextWrapper> iterator = contextWrapperList.iterator();
        while (iterator.hasNext()) {
            ContextWrapper contextWrapper;
            this.myContextWrapper = contextWrapper = iterator.next();
            Option option = this.expFactory.createOption();
            option.setRegexp((Expression)this.doSwitch((EObject)seff));
            option.setProbability((double)(1 / contextWrapperList.size()));
            optionsPerContextWrapperList.add(option);
        }
        Expression exp = null;
        exp = optionsPerContextWrapperList.size() == 1 ? ((Option)optionsPerContextWrapperList.get(0)).getRegexp() : Pcm2RegexHelper.createAlternativesForExpressions(optionsPerContextWrapperList);
        this.myContextWrapper = oldContextWrapper;
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp(exp);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    public Object caseBranchAction(BranchAction object) {
        LinkedList<Option> optionsForBranches = new LinkedList<Option>();
        for (AbstractBranchTransition branch : object.getBranches_Branch()) {
            Option option = this.expFactory.createOption();
            option.setProbability(this.myContextWrapper.getBranchProbability(branch).doubleValue());
            Expression branchExpression = (Expression)this.doSwitch((EObject)branch.getBranchBehaviour_BranchTransition());
            option.setRegexp(branchExpression);
            optionsForBranches.add(option);
        }
        Expression alt = Pcm2RegexHelper.createAlternativesForExpressions(optionsForBranches);
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp(alt);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    public Object caseCollectionIteratorAction(CollectionIteratorAction object) {
        Loop loop = this.expFactory.createLoop();
        loop.setIterationsString(this.myContextWrapper.getLoopIterations((AbstractLoopAction)object).toString());
        loop.setRegExp((Expression)this.doSwitch((EObject)object.getBodyBehaviour_Loop()));
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)loop);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    public Object caseLoopAction(LoopAction object) {
        Loop loop = this.expFactory.createLoop();
        loop.setIterationsString(this.myContextWrapper.getLoopIterations((AbstractLoopAction)object).toString());
        loop.setRegExp((Expression)this.doSwitch((EObject)object.getBodyBehaviour_Loop()));
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)loop);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object handleSymbol(AbstractInternalControlFlowAction object) {
        Symbol sym = this.expFactory.createSymbol();
        sym.setName(object.getEntityName());
        EList prdList = object.getResourceDemand_Action();
        for (ParametricResourceDemand prd : prdList) {
            String spec = this.myContextWrapper.getTimeConsumptionAsPDF(prd).toString();
            Atom resDemExpression = (Atom)ExpressionHelper.parseToExpression(spec);
            ProbabilityDensityFunction pdf = null;
            if (resDemExpression instanceof NumericLiteral) {
                NumericLiteral resDemNumeric = (NumericLiteral)resDemExpression;
                pdf = this.getPDFForNumericLiteral(pdf, resDemNumeric);
            } else {
                if (!(resDemExpression instanceof ProbabilityFunctionLiteral)) {
                    logger.error((Object)("Invalid Resource Demand: (" + resDemExpression.getClass().getSimpleName() + "). Only DoublePDF is valid."));
                    return null;
                }
                ProbabilityFunctionLiteral probFuncLiteral = (ProbabilityFunctionLiteral)resDemExpression;
                ProbabilityFunction probFunc = probFuncLiteral.getFunction_ProbabilityFunctionLiteral();
                if (!(probFunc instanceof ProbabilityDensityFunction)) {
                    logger.error((Object)("Invalid Resource Demand: (" + probFunc.getClass().getSimpleName() + "). Only DoublePDF is valid."));
                    return null;
                }
                pdf = (ProbabilityDensityFunction)probFunc;
            }
            ResourceUsage ru = this.resFactory.createResourceUsage();
            ru.setUsageTime(pdf);
            sym.getResourceUsages().add((Object)ru);
        }
        Sequence seq = this.expFactory.createSequence();
        seq.setLeftRegExp((Expression)sym);
        seq.setRightRegExp((Expression)this.doSwitch((EObject)object.getSuccessor_AbstractAction()));
        return seq;
    }

    private ProbabilityDensityFunction getPDFForNumericLiteral(ProbabilityDensityFunction pdf, NumericLiteral resDemNumeric) {
        PDFConfiguration config = null;
        try {
            config = PDFConfiguration.getCurrentConfiguration();
        }
        catch (ConfigurationNotSetException e) {
            e.printStackTrace();
        }
        double distance = config.getDistance();
        int numOfSamples = config.getNumSamplingPoints();
        IUnit unit = config.getUnit();
        double value = 0.0;
        if (resDemNumeric instanceof DoubleLiteral) {
            value = ((DoubleLiteral)resDemNumeric).getValue();
        } else if (resDemNumeric instanceof IntLiteral) {
            value = ((IntLiteral)resDemNumeric).getValue();
        }
        if ((value /= distance) != 0.0) {
            if (value > (double)numOfSamples) {
                numOfSamples = (int)value + 1;
                PDFConfiguration.setCurrentConfiguration((int)numOfSamples, (double)distance, (IUnit)unit);
                logger.debug((Object)("Reset PDFConfiguration: numOfSamples=" + numOfSamples + ", distance=" + distance + ", unit=" + unit.getUnitName()));
            } else if (value < distance) {
                PDFConfiguration.setCurrentConfiguration((int)numOfSamples, (double)value, (IUnit)unit);
                logger.debug((Object)("Reset PDFConfiguration: numOfSamples=" + numOfSamples + ", distance=" + value + ", unit=" + unit.getUnitName()));
            }
        }
        ArrayList<Double> sampleList = new ArrayList<Double>();
        int i = 0;
        while (i < numOfSamples) {
            if (i == (int)value) {
                sampleList.add(new Double(1.0));
            } else {
                sampleList.add(new Double(0.0));
            }
            ++i;
        }
        ISamplePDF iSamplePDF = this.pfFactory.createSamplePDFFromDouble(distance, sampleList, unit);
        try {
            SamplePDF samplePDF = this.pfFactory.transformToModelSamplePDF((IProbabilityDensityFunction)iSamplePDF);
            pdf = samplePDF;
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
        }
        return pdf;
    }

    private StartAction getStartAction(ResourceDemandingBehaviour behaviour) {
        StartAction startAction = (StartAction)EMFQueryHelper.getObjectByType(behaviour.getSteps_Behaviour(), StartAction.class);
        return startAction;
    }
}

