/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.solver.visitors;

import de.uka.ipd.sdq.stoex.AbstractNamedReference;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.StoexFactory;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.parameter.ParameterFactory;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.solver.context.computed_usage.ComputedUsageFactory;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallInput;
import org.palladiosimulator.solver.context.computed_usage.ExternalCallOutput;
import org.palladiosimulator.solver.context.computed_usage.Input;
import org.palladiosimulator.solver.context.computed_usage.Output;
import org.palladiosimulator.solver.transformations.ContextWrapper;
import org.palladiosimulator.solver.visitors.ExpressionHelper;

public class VariableUsageHelper {
    private static ParameterFactory parameterFactory = ParameterFactory.eINSTANCE;
    private static ComputedUsageFactory compUsageFactory = ComputedUsageFactory.eINSTANCE;
    protected static Logger logger = Logger.getLogger((String)VariableUsageHelper.class.getName());

    public static void copySolvedVariableUsageToUsageContext(ContextWrapper ctxWrp, VariableUsage oldUsage) {
        VariableUsage newUsage = VariableUsageHelper.getCopiedSolvedVariableUsage(ctxWrp, oldUsage);
        ctxWrp.getCompUsgCtx().getInput_ComputedUsageContext().getParameterChacterisations_Input().add((Object)newUsage);
    }

    public static void copySolvedVariableUsageToInput(Input input, ContextWrapper oldContextWrapper, Collection<VariableUsage> variableUsages) {
        for (VariableUsage compParams : variableUsages) {
            VariableUsage newUsage = VariableUsageHelper.getCopiedSolvedVariableUsage(oldContextWrapper, compParams);
            String varName = VariableUsageHelper.getFullParameterName(newUsage.getNamedReference__VariableUsage());
            ArrayList<VariableUsage> usagesToBeOverwritten = new ArrayList<VariableUsage>(5);
            for (VariableUsage usage : input.getParameterChacterisations_Input()) {
                if (!VariableUsageHelper.getFullParameterName(usage.getNamedReference__VariableUsage()).equals(varName)) continue;
                usagesToBeOverwritten.add(usage);
                logger.info((Object)("Variable " + varName + " is defined twice, one definition has been overwritten."));
            }
            input.getParameterChacterisations_Input().removeAll(usagesToBeOverwritten);
            input.getParameterChacterisations_Input().add((Object)newUsage);
        }
    }

    public static void copySolvedVariableUsageToOutput(ContextWrapper contextWrapper, VariableUsage vu) {
        Output output = contextWrapper.getCompUsgCtx().getOutput_ComputedUsageContext();
        if (output == null) {
            output = compUsageFactory.createOutput();
            contextWrapper.getCompUsgCtx().setOutput_ComputedUsageContext(output);
        }
        VariableUsage newUsage = VariableUsageHelper.getCopiedSolvedVariableUsage(contextWrapper, vu);
        output.getParameterCharacterisations_Output().add((Object)newUsage);
    }

    public static void copySolvedVariableUsageToExternalCallInput(ContextWrapper contextWrapper, ExternalCallInput eci, VariableUsage vu) {
        VariableUsage newUsage = VariableUsageHelper.getCopiedSolvedVariableUsage(contextWrapper, vu);
        eci.getParameterCharacterisations_ExternalCallInput().add((Object)newUsage);
    }

    public static void copySolvedVariableUsageToExternalCallOutput(ContextWrapper contextWrapper, ExternalCallOutput eco, VariableUsage vu) {
        VariableUsage newUsage = VariableUsageHelper.getCopiedSolvedVariableUsage(contextWrapper, vu);
        eco.getParameterCharacterisations_ExternalCallOutput().add((Object)newUsage);
    }

    private static VariableUsage getCopiedSolvedVariableUsage(ContextWrapper ctxWrp, VariableUsage oldUsage) {
        VariableUsage newUsage = parameterFactory.createVariableUsage();
        newUsage.setNamedReference__VariableUsage(VariableUsageHelper.getReferenceCopy(oldUsage.getNamedReference__VariableUsage()));
        EList varCharList = oldUsage.getVariableCharacterisation_VariableUsage();
        for (VariableCharacterisation oldVC : varCharList) {
            String specification = oldVC.getSpecification_VariableCharacterisation().getSpecification();
            String solvedSpecification = ExpressionHelper.getSolvedExpressionAsString(specification, ctxWrp);
            VariableCharacterisation solvedCharacterisation = parameterFactory.createVariableCharacterisation();
            solvedCharacterisation.setType(oldVC.getType());
            PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
            rv.setSpecification(solvedSpecification);
            solvedCharacterisation.setSpecification_VariableCharacterisation(rv);
            newUsage.getVariableCharacterisation_VariableUsage().add((Object)solvedCharacterisation);
        }
        return newUsage;
    }

    public static AbstractNamedReference getReferenceCopy(AbstractNamedReference anr) {
        if (anr == null) {
            return null;
        }
        if (anr instanceof NamespaceReference) {
            NamespaceReference nr = (NamespaceReference)anr;
            NamespaceReference newRef = StoexFactory.eINSTANCE.createNamespaceReference();
            newRef.setReferenceName(nr.getReferenceName());
            newRef.setInnerReference_NamespaceReference(VariableUsageHelper.getReferenceCopy(nr.getInnerReference_NamespaceReference()));
            return newRef;
        }
        if (anr instanceof VariableReference) {
            VariableReference vr = (VariableReference)anr;
            VariableReference varRef = StoexFactory.eINSTANCE.createVariableReference();
            varRef.setReferenceName(vr.getReferenceName());
            return varRef;
        }
        throw new IllegalArgumentException("Unsupported Reference type " + anr.getClass().getName());
    }

    public static void copyVariableUsageToInput(Input input, VariableUsage vu) {
        VariableUsage newUsage = parameterFactory.createVariableUsage();
        newUsage.setNamedReference__VariableUsage(VariableUsageHelper.getReferenceCopy(vu.getNamedReference__VariableUsage()));
        EList characterisations = vu.getVariableCharacterisation_VariableUsage();
        for (VariableCharacterisation oldCharacterisation : characterisations) {
            String specification = oldCharacterisation.getSpecification_VariableCharacterisation().getSpecification();
            String solvedSpecification = ExpressionHelper.getSolvedExpressionAsString(specification, null);
            VariableCharacterisation solvedCharacterisation = parameterFactory.createVariableCharacterisation();
            solvedCharacterisation.setType(oldCharacterisation.getType());
            PCMRandomVariable rv = CoreFactory.eINSTANCE.createPCMRandomVariable();
            rv.setSpecification(solvedSpecification);
            solvedCharacterisation.setSpecification_VariableCharacterisation(rv);
            newUsage.getVariableCharacterisation_VariableUsage().add((Object)solvedCharacterisation);
        }
        input.getParameterChacterisations_Input().add((Object)newUsage);
    }

    public static List<VariableCharacterisation> getCommonCharacterisationsFromFirst(VariableUsage vu1, VariableUsage vu2) {
        if (vu1 == vu2) {
            return vu1.getVariableCharacterisation_VariableUsage();
        }
        if (VariableUsageHelper.describeSameReference(vu1.getNamedReference__VariableUsage(), vu2.getNamedReference__VariableUsage())) {
            return vu1.getVariableCharacterisation_VariableUsage();
        }
        EList characterisations1 = vu1.getVariableCharacterisation_VariableUsage();
        EList characterisations2 = vu2.getVariableCharacterisation_VariableUsage();
        ArrayList<VariableCharacterisation> listFrom1ThatAreAlsoIn2 = new ArrayList<VariableCharacterisation>();
        for (VariableCharacterisation variableCharacterisation1 : characterisations1) {
            for (VariableCharacterisation variableCharacterisation2 : characterisations2) {
                if (!variableCharacterisation1.getType().equals((Object)variableCharacterisation2.getType())) continue;
                listFrom1ThatAreAlsoIn2.add(variableCharacterisation1);
            }
        }
        return listFrom1ThatAreAlsoIn2;
    }

    private static boolean describeSameReference(AbstractNamedReference ref1, AbstractNamedReference ref2) {
        if (!ref1.getReferenceName().equals(ref2.getReferenceName())) {
            return false;
        }
        if (ref1 instanceof VariableReference && ref2 instanceof VariableReference) {
            return true;
        }
        if (ref1 instanceof NamespaceReference && ref2 instanceof NamespaceReference) {
            NamespaceReference nref1 = (NamespaceReference)ref1;
            NamespaceReference nref2 = (NamespaceReference)ref2;
            return VariableUsageHelper.describeSameReference(nref1.getInnerReference_NamespaceReference(), nref2.getInnerReference_NamespaceReference());
        }
        return false;
    }

    public static Collection<VariableUsage> copyVariableUsageList(List<VariableUsage> originalVariableUsages) {
        return EcoreUtil.copyAll(originalVariableUsages);
    }

    public static Collection<VariableCharacterisation> copyVariableCharacterisations(List<VariableCharacterisation> variableCharacterisations) {
        return EcoreUtil.copyAll(variableCharacterisations);
    }

    private static String getFullParameterName(AbstractNamedReference ref) {
        String name = "";
        while (ref instanceof NamespaceReference) {
            NamespaceReference nsRef = (NamespaceReference)ref;
            name = String.valueOf(name) + nsRef.getReferenceName() + ".";
            ref = nsRef.getInnerReference_NamespaceReference();
        }
        name = String.valueOf(name) + ref.getReferenceName();
        return name;
    }
}

