/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer;

import de.uka.ipd.sdq.workflow.ExecutionTimeLoggingProgressMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.qosannotations.QoSAnnotations;
import org.palladiosimulator.pcm.qosannotations.QosannotationsFactory;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemFactory;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.ModelAnalyzer;
import org.somox.analyzer.ModelAnalyzerException;
import org.somox.analyzer.simplemodelanalyzer.SimpleAnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.ComponentBuilder;
import org.somox.analyzer.simplemodelanalyzer.builder.PCMSystemBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.util.ComponentPrinter;
import org.somox.analyzer.simplemodelanalyzer.factories.BasicSoMoXStrategiesFactory;
import org.somox.analyzer.simplemodelanalyzer.factories.ISoMoXStrategiesFactory;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.extractor.ExtractionResult;
import org.somox.kdmhelper.KDMReader;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorFactory;
import org.somox.sourcecodedecorator.SourceCodeDecoratorRepository;

public class SimpleModelAnalyzer
implements ModelAnalyzer {
    private static Logger logger = Logger.getLogger(SimpleModelAnalyzer.class);
    private ModelAnalyzer.Status status = ModelAnalyzer.Status.READY;

    public void init() {
    }

    public AnalysisResult analyze(SoMoXConfiguration somoxConfiguration, HashMap<String, ExtractionResult> extractionResultMap, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        URI fileURI;
        this.status = ModelAnalyzer.Status.RUNNING;
        logger.info((Object)("SISSy Analyzer started with\n SOMOX Configuration: " + somoxConfiguration + "\n extractionResultMap " + extractionResultMap));
        SimpleAnalysisResult analysisResult = null;
        String platformPath = somoxConfiguration.getFileLocations().getAnalyserInputFile();
        if (platformPath != null && (fileURI = URI.createPlatformResourceURI((String)platformPath, (boolean)true)).fileExtension().toLowerCase().equals("xmi")) {
            try {
                Root root = KDMReader.loadFile((URI)fileURI);
                analysisResult = this.analyzeGASTModel(root, somoxConfiguration, progressMonitor);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to load GAST Model", (Throwable)e);
                throw new ModelAnalyzerException("Failed to load GAST model", (Exception)e);
            }
        }
        this.status = ModelAnalyzer.Status.FINISHED;
        return analysisResult;
    }

    private SimpleAnalysisResult analyzeGASTModel(Root astModel, SoMoXConfiguration somoxConfiguration, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        SimpleAnalysisResult analysisResult = this.initializeAnalysisResult();
        analysisResult.setResultStatus(AnalysisResult.ResultStatus.FAILED);
        ComponentBuilder pcmComponentBuilder = new ComponentBuilder(astModel, somoxConfiguration, analysisResult);
        BasicSoMoXStrategiesFactory strategiesFactory = new BasicSoMoXStrategiesFactory(astModel, somoxConfiguration);
        List<ComponentImplementingClassesLink> initialComponents = this.detectInitialComponentCandidates(astModel, somoxConfiguration, pcmComponentBuilder, strategiesFactory, progressMonitor);
        this.clusterComponents(initialComponents, somoxConfiguration, pcmComponentBuilder, strategiesFactory, progressMonitor);
        this.postComponentDetection(somoxConfiguration, analysisResult, strategiesFactory, progressMonitor);
        PCMSystemBuilder pcmSystemBuilder = new PCMSystemBuilder(astModel, somoxConfiguration, analysisResult, pcmComponentBuilder);
        pcmSystemBuilder.buildSystemModel();
        analysisResult.setResultStatus(AnalysisResult.ResultStatus.SUCCESS);
        return analysisResult;
    }

    private void postComponentDetection(SoMoXConfiguration somoxConfiguration, SimpleAnalysisResult analysisResult, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) {
        strategiesFactory.getPostComponentDetectionStrategy().postComponentDetection(somoxConfiguration, analysisResult, progressMonitor);
    }

    private void clusterComponents(List<ComponentImplementingClassesLink> initialComponentCandidates, SoMoXConfiguration somoxConfiguration, ComponentBuilder sammBuilder, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) throws ModelAnalyzerException {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, 0);
        subProgressMonitor.beginTask("Cluster components", -1);
        List<ComponentImplementingClassesLink> componentsFound = strategiesFactory.getDetectionStrategy(initialComponentCandidates).startDetection(sammBuilder, somoxConfiguration, progressMonitor, initialComponentCandidates);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Printing detected components");
            ComponentPrinter.printComponents(componentsFound, logger);
        }
        subProgressMonitor.done();
    }

    private List<ComponentImplementingClassesLink> detectInitialComponentCandidates(Root gastModel, SoMoXConfiguration somoxConfiguration, ComponentBuilder sammBuilder, ISoMoXStrategiesFactory strategiesFactory, IProgressMonitor progressMonitor) {
        ExecutionTimeLoggingProgressMonitor subProgressMonitor = new ExecutionTimeLoggingProgressMonitor(progressMonitor, 0);
        subProgressMonitor.beginTask("Detecting primitive components", -1);
        List<ComponentImplementingClassesLink> components = strategiesFactory.getInitializationStrategy().createInitialComponentCandidates(gastModel, somoxConfiguration, sammBuilder);
        logger.debug((Object)("Finished detection of primitive components. Found " + components.size() + " candidates"));
        subProgressMonitor.done();
        return components;
    }

    private SimpleAnalysisResult initializeAnalysisResult() {
        SimpleAnalysisResult analysisResult = new SimpleAnalysisResult(this);
        SourceCodeDecoratorRepository sourceCodeDecoratorRepository = SourceCodeDecoratorFactory.eINSTANCE.createSourceCodeDecoratorRepository();
        System system = SystemFactory.eINSTANCE.createSystem();
        QoSAnnotations qosAnnotationModel = QosannotationsFactory.eINSTANCE.createQoSAnnotations();
        Repository newInternalArchitectureModel = RepositoryFactory.eINSTANCE.createRepository();
        Allocation allocation = AllocationFactory.eINSTANCE.createAllocation();
        analysisResult.setInternalArchitectureModel(newInternalArchitectureModel);
        analysisResult.setSourceCodeDecoratorRepository(sourceCodeDecoratorRepository);
        analysisResult.setSystemModel(system);
        analysisResult.setQosAnnotationModel(qosAnnotationModel);
        analysisResult.setAllocation(allocation);
        return analysisResult;
    }

    public ModelAnalyzer.Status getStatus() {
        return this.status;
    }
}

