/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder;

import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.Block;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.EventGroup;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.somox.analyzer.AnalysisResult;
import org.somox.analyzer.simplemodelanalyzer.builder.AbstractBuilder;
import org.somox.analyzer.simplemodelanalyzer.detection.util.EqualityChecker;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.MethodLevelSourceCodeLink;
import org.somox.sourcecodedecorator.Seff2MethodLink;
import org.somox.sourcecodedecorator.SourceCodeDecoratorFactory;

public class Seff2JavaASTBuilder
extends AbstractBuilder {
    private static final Logger logger = Logger.getLogger(Seff2JavaASTBuilder.class);

    public Seff2JavaASTBuilder(Root gastModel, SoMoXConfiguration somoxConfiguration, AnalysisResult analysisResult) {
        super(gastModel, somoxConfiguration, analysisResult);
    }

    public void addSeffsToPrimitiveComponent(BasicComponent component, ProvidedRole providedRole) {
        block3: {
            block2: {
                if (!(providedRole instanceof OperationProvidedRole)) break block2;
                OperationInterface providedInterface = ((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole();
                for (OperationSignature signature : providedInterface.getSignatures__OperationInterface()) {
                    this.addSeffToBasicComponent(component, (Signature)signature);
                }
                break block3;
            }
            if (!(providedRole instanceof SinkRole)) break block3;
            EventGroup providedInterface = ((SinkRole)providedRole).getEventGroup__SinkRole();
            for (EventType signature : providedInterface.getEventTypes__EventGroup()) {
                this.addSeffToBasicComponent(component, (Signature)signature);
            }
        }
    }

    private void addSeffToBasicComponent(BasicComponent component, Signature operation) {
        MethodLevelSourceCodeLink link = this.getMethodLevelSourceCodeLink(operation);
        if (link == null) {
            throw new RuntimeException("Found interface with operations for which no method link exists. This should never happen!");
        }
        link.setRepositoryComponent((RepositoryComponent)component);
        this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink().add((Object)link);
        ResourceDemandingSEFF seff = SeffFactory.eINSTANCE.createResourceDemandingSEFF();
        seff.setDescribedService__SEFF(link.getOperation());
        component.getServiceEffectSpecifications__BasicComponent().add((Object)seff);
        Seff2MethodLink seff2MethodMapping = SourceCodeDecoratorFactory.eINSTANCE.createSeff2MethodLink();
        Block methodBody = this.getFunctionImplementation(link.getFunction(), this.findComponentLink((RepositoryComponent)component));
        seff2MethodMapping.setBlockstatement(methodBody);
        if (seff2MethodMapping.getBlockstatement() == null) {
            logger.warn((Object)("Empty behaviour added for " + seff.getDescribedService__SEFF().getEntityName() + "! Reverse engineering of behaviour will NOT be able to succeed for this method!"));
        }
        seff2MethodMapping.setSeff((ServiceEffectSpecification)seff);
        this.analysisResult.getSourceCodeDecoratorRepository().getSeff2MethodLink().add((Object)seff2MethodMapping);
    }

    private Block getFunctionImplementation(AbstractMethodDeclaration function, ComponentImplementingClassesLink component) {
        for (Type implementingClass : component.getImplementingClasses()) {
            for (MethodDeclaration implementedMethod : KDMHelper.getMethods((Type)implementingClass)) {
                if (!EqualityChecker.areFunctionsEqual(function, (AbstractMethodDeclaration)implementedMethod)) continue;
                return implementedMethod.getBody();
            }
        }
        logger.error((Object)("No method implemementation found for method " + function.getName() + " for component " + component.getComponent().getEntityName()));
        return null;
    }

    private ComponentImplementingClassesLink findComponentLink(RepositoryComponent component) {
        for (ComponentImplementingClassesLink compLink : this.analysisResult.getSourceCodeDecoratorRepository().getComponentImplementingClassesLink()) {
            if (!compLink.getComponent().equals(component)) continue;
            return compLink;
        }
        logger.error((Object)("No component link found for component " + component.getEntityName()));
        return null;
    }

    private MethodLevelSourceCodeLink getMethodLevelSourceCodeLink(Signature operation) {
        assert (this.operationUnique(operation));
        for (MethodLevelSourceCodeLink link : this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            if (operation != link.getOperation()) continue;
            return link;
        }
        return null;
    }

    private boolean operationUnique(Signature signature) {
        boolean alreadyFound = false;
        for (MethodLevelSourceCodeLink link : this.analysisResult.getSourceCodeDecoratorRepository().getMethodLevelSourceCodeLink()) {
            if (signature != link.getOperation()) continue;
            if (alreadyFound) {
                return false;
            }
            alreadyFound = true;
        }
        return alreadyFound;
    }
}

