/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gmt.modisco.java.Type;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;

public class ComponentToImplementingClassesHelper {
    private Map<ComponentImplementingClassesLink, Set<Type>> mapOfImplementingClasses = new HashMap<ComponentImplementingClassesLink, Set<Type>>();

    public synchronized Set<Type> deriveImplementingClasses(ComponentImplementingClassesLink componentCandidate) {
        Set<Type> result;
        if (!this.mapOfImplementingClasses.containsKey(componentCandidate)) {
            HashSet<Type> classSet = new HashSet<Type>();
            classSet.addAll((Collection<Type>)componentCandidate.getImplementingClasses());
            for (ComponentImplementingClassesLink subComponent : componentCandidate.getSubComponents()) {
                classSet.addAll(this.deriveImplementingClasses(subComponent));
            }
            for (InterfaceSourceCodeLink providedIfLink : componentCandidate.getProvidedInterfaces()) {
                if (classSet.contains(providedIfLink.getGastClass())) continue;
                classSet.add(providedIfLink.getGastClass());
            }
            if (classSet.size() == 0) {
                throw new RuntimeException("Component must have associated classes");
            }
            this.mapOfImplementingClasses.put(componentCandidate, classSet);
        }
        if ((result = this.mapOfImplementingClasses.get(componentCandidate)) == null) {
            throw new IllegalStateException("The component to class cache did not contain a value which has been asserted to be there. There might be a concurrency issue here");
        }
        return result;
    }

    public Set<Type> collectAllClasses(List<ComponentImplementingClassesLink> componentCandidates) {
        HashSet<Type> allOtherComponentClasses = new HashSet<Type>();
        for (ComponentImplementingClassesLink classLink : componentCandidates) {
            allOtherComponentClasses.addAll(this.deriveImplementingClasses(classLink));
        }
        return allOtherComponentClasses;
    }
}

