/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.ratio;

import java.util.Map;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.metrics.ICompositionFunction;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractComposedMetric;
import org.somox.metrics.ratio.Abstractness;
import org.somox.metrics.ratio.Instability;

public class DMS
extends AbstractComposedMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.DMS");
    private static final ICompositionFunction compositionFunction = new ICompositionFunction(){

        @Override
        public double computeOverallDirectedMetricValue(Map<MetricID, Double> metricValues) {
            double abs = metricValues.get(Abstractness.METRIC_ID);
            double ins = metricValues.get(Instability.METRIC_ID);
            double dms = Math.abs(abs + ins - 1.0);
            if (!($assertionsDisabled || dms >= 0.0 && dms <= 1.0)) {
                throw new AssertionError();
            }
            return dms;
        }
    };

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    @Override
    protected IMetric[] getChildMetrics(Map<MetricID, IMetric> allMetrics) {
        return new IMetric[]{this.getMetric(allMetrics, Abstractness.METRIC_ID), this.getMetric(allMetrics, Instability.METRIC_ID)};
    }

    @Override
    protected ICompositionFunction getCompositionFunction(SoMoXConfiguration somoxConfiguration) {
        return compositionFunction;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

