/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter;

import de.mdelab.sdm.interpreter.core.notifications.ActivityExecutionFinishedNotification;
import de.mdelab.sdm.interpreter.core.notifications.ActivityExecutionStartedNotification;
import de.mdelab.sdm.interpreter.core.notifications.ActivityNodeExecutionFinishedNotification;
import de.mdelab.sdm.interpreter.core.notifications.ActivityNodeExecutionStartedNotification;
import de.mdelab.sdm.interpreter.core.notifications.AttributeValueSetNotification;
import de.mdelab.sdm.interpreter.core.notifications.EvaluatedExpressionNotification;
import de.mdelab.sdm.interpreter.core.notifications.EvaluatingExpressionNotification;
import de.mdelab.sdm.interpreter.core.notifications.InstanceLinkCreatedNotification;
import de.mdelab.sdm.interpreter.core.notifications.InstanceLinkDestroyedNotification;
import de.mdelab.sdm.interpreter.core.notifications.InstanceObjectCreatedNotification;
import de.mdelab.sdm.interpreter.core.notifications.InstanceObjectDestroyedNotification;
import de.mdelab.sdm.interpreter.core.notifications.InterpreterNotification;
import de.mdelab.sdm.interpreter.core.notifications.LinkCheckFailedNotification;
import de.mdelab.sdm.interpreter.core.notifications.LinkCheckSuccessfulNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternApplicationFinishedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternApplicationStartedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternConstraintHoldsNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternConstraintViolatedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternInitializationFinishedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternInitializationStartedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternMatchingFailedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternMatchingStartedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternMatchingSuccessfulNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternObjectBindingRevokedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternObjectBoundNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternObjectConstraintHoldsNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternObjectConstraintViolatedNotification;
import de.mdelab.sdm.interpreter.core.notifications.StoryPatternObjectNotBoundNotification;
import de.mdelab.sdm.interpreter.core.notifications.TraversingActivityEdgeNotification;
import de.mdelab.sdm.interpreter.core.notifications.TraversingLinkNotification;
import de.mdelab.sdm.interpreter.core.notifications.VariableCreatedNotification;
import de.mdelab.sdm.interpreter.core.notifications.VariableDeletedNotification;
import de.mdelab.sdm.interpreter.core.notifications.VariableValueChangedNotification;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.diagram.interpreter.util.InterpreterConsole;
import org.storydriven.storydiagrams.diagram.interpreter.util.Texts;
import org.storydriven.storydiagrams.interpreter.notifications.StoryDrivenNotificationReceiver;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class ConsoleNotificationReceiver
implements StoryDrivenNotificationReceiver {
    private InterpreterConsole console;
    private int indent;

    public ConsoleNotificationReceiver(InterpreterConsole text) {
        this.console = text;
        this.indent = 0;
    }

    public void notifyChanged(InterpreterNotification<EClassifier> notification) {
        switch (notification.getNotificationType()) {
            case ACTIVITY_EXECUTION_STARTED: {
                this.startActivity((ActivityExecutionStartedNotification<Activity, EClassifier>)((ActivityExecutionStartedNotification)notification));
                ++this.indent;
                break;
            }
            case ACTIVITY_EXECUTION_FINISHED: {
                --this.indent;
                this.finishActivity((ActivityExecutionFinishedNotification<Activity, EClassifier>)((ActivityExecutionFinishedNotification)notification));
                break;
            }
            case ACTIVITY_NODE_EXECUTION_STARTED: {
                this.startActivityNode((ActivityNodeExecutionStartedNotification<ActivityNode, EClassifier>)((ActivityNodeExecutionStartedNotification)notification));
                ++this.indent;
                break;
            }
            case ACTIVITY_NODE_EXECUTION_FINISHED: {
                --this.indent;
                this.finishActivityNode((ActivityNodeExecutionFinishedNotification<ActivityNode, EClassifier>)((ActivityNodeExecutionFinishedNotification)notification));
                break;
            }
            case TRAVERSING_ACTIVITY_EDGE: {
                this.traverseActivityEdge((TraversingActivityEdgeNotification<ActivityEdge, EClassifier>)((TraversingActivityEdgeNotification)notification));
                break;
            }
            case STORY_PATTERN_INITIALIZATION_STARTED: {
                this.storyPatternInitializationStarted((StoryPatternInitializationStartedNotification<StoryPattern, EClassifier>)((StoryPatternInitializationStartedNotification)notification));
                ++this.indent;
                break;
            }
            case STORY_PATTERN_INITIALIZATION_FINISHED: {
                --this.indent;
                this.storyPatternInitializationFinished((StoryPatternInitializationFinishedNotification<StoryPattern, EClassifier>)((StoryPatternInitializationFinishedNotification)notification));
                break;
            }
            case STORY_PATTERN_MATCHING_STARTED: {
                this.storyPatternMatchingStarted((StoryPatternMatchingStartedNotification<StoryPattern, EClassifier>)((StoryPatternMatchingStartedNotification)notification));
                break;
            }
            case STORY_PATTERN_MATCHING_SUCCESSFUL: {
                this.storyPatternMatchingSuccessful((StoryPatternMatchingSuccessfulNotification<StoryPattern, EClassifier>)((StoryPatternMatchingSuccessfulNotification)notification));
                break;
            }
            case STORY_PATTERN_MATCHING_FAILED: {
                this.storyPatternMatchingFailed((StoryPatternMatchingFailedNotification<StoryPattern, EClassifier>)((StoryPatternMatchingFailedNotification)notification));
                break;
            }
            case STORY_PATTERN_APPLICATION_STARTED: {
                this.storyPatternApplicationStarted((StoryPatternApplicationStartedNotification<StoryPattern, EClassifier>)((StoryPatternApplicationStartedNotification)notification));
                ++this.indent;
                break;
            }
            case STORY_PATTERN_APPLICATION_FINISHED: {
                --this.indent;
                this.storyPatternApplicationFinished((StoryPatternApplicationFinishedNotification<StoryPattern, EClassifier>)((StoryPatternApplicationFinishedNotification)notification));
                break;
            }
            case ATTRIBUTE_VALUE_SET: {
                this.attributeValueSet((AttributeValueSetNotification<AbstractVariable, EClassifier, EStructuralFeature>)((AttributeValueSetNotification)notification));
                break;
            }
            case INSTANCE_OBJECT_CREATED: {
                this.createdInstance((InstanceObjectCreatedNotification<AbstractVariable, EClassifier>)((InstanceObjectCreatedNotification)notification));
                break;
            }
            case INSTANCE_OBJECT_DESTROYED: {
                this.destroyedInstance((InstanceObjectDestroyedNotification<AbstractVariable, EClassifier>)((InstanceObjectDestroyedNotification)notification));
                break;
            }
            case INSTANCE_LINK_CREATED: {
                this.createdInstance((InstanceLinkCreatedNotification<AbstractVariable, AbstractLinkVariable, EClassifier>)((InstanceLinkCreatedNotification)notification));
                break;
            }
            case INSTANCE_LINK_DESTROYED: {
                this.destroyedInstance((InstanceLinkDestroyedNotification<AbstractVariable, AbstractLinkVariable, EClassifier>)((InstanceLinkDestroyedNotification)notification));
                break;
            }
            case LINK_CHECK_SUCCESSFUL: {
                this.linkChecked((LinkCheckSuccessfulNotification<AbstractVariable, AbstractLinkVariable, EClassifier>)((LinkCheckSuccessfulNotification)notification));
                break;
            }
            case LINK_CHECK_FAILED: {
                this.linkFailed((LinkCheckFailedNotification<AbstractVariable, AbstractLinkVariable, EClassifier>)((LinkCheckFailedNotification)notification));
                break;
            }
            case STORY_PATTERN_OBJECT_BINDING_REVOKED: {
                this.boundRevoked((StoryPatternObjectBindingRevokedNotification<AbstractVariable, EClassifier>)((StoryPatternObjectBindingRevokedNotification)notification));
                break;
            }
            case STORY_PATTERN_OBJECT_BOUND: {
                this.bound((StoryPatternObjectBoundNotification<AbstractVariable, EClassifier>)((StoryPatternObjectBoundNotification)notification));
                break;
            }
            case STORY_PATTERN_OBJECT_NOT_BOUND: {
                this.boundNot((StoryPatternObjectNotBoundNotification<AbstractVariable, EClassifier>)((StoryPatternObjectNotBoundNotification)notification));
                break;
            }
            case TRAVERSING_LINK: {
                this.traverseLink((TraversingLinkNotification<AbstractVariable, AbstractLinkVariable, EClassifier>)((TraversingLinkNotification)notification));
                break;
            }
            case VARIABLE_CREATED: {
                this.variableCreated((VariableCreatedNotification<EClassifier>)((VariableCreatedNotification)notification));
                break;
            }
            case VARIABLE_VALUE_CHANGED: {
                this.variableChanged((VariableValueChangedNotification<EClassifier>)((VariableValueChangedNotification)notification));
                break;
            }
            case VARIABLE_DELETED: {
                this.variableDeleted((VariableDeletedNotification<EClassifier>)((VariableDeletedNotification)notification));
                break;
            }
            case EVALUATING_EXPRESSION: {
                this.startExpression((EvaluatingExpressionNotification<EClassifier, Expression>)((EvaluatingExpressionNotification)notification));
                ++this.indent;
                break;
            }
            case EVALUATED_EXPRESSION: {
                --this.indent;
                this.finishExpression((EvaluatedExpressionNotification<EClassifier, Expression>)((EvaluatedExpressionNotification)notification));
                break;
            }
            case STORY_PATTERN_CONSTRAINT_HOLDS: {
                this.constraintHolds((StoryPatternConstraintHoldsNotification<StoryPattern, EClassifier, Expression>)((StoryPatternConstraintHoldsNotification)notification));
                break;
            }
            case STORY_PATTERN_CONSTRAINT_VIOLATED: {
                this.constraintViolated((StoryPatternConstraintViolatedNotification<StoryPattern, EClassifier, Expression>)((StoryPatternConstraintViolatedNotification)notification));
                break;
            }
            case STORY_PATTERN_OBJECT_CONSTRAINT_HOLDS: {
                this.constraintHolds((StoryPatternObjectConstraintHoldsNotification<AbstractVariable, EClassifier, Expression>)((StoryPatternObjectConstraintHoldsNotification)notification));
                break;
            }
            case STORY_PATTERN_OBJECT_CONSTRAINT_VIOLATED: {
                this.constraintViolated((StoryPatternObjectConstraintViolatedNotification<AbstractVariable, EClassifier, Expression>)((StoryPatternObjectConstraintViolatedNotification)notification));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void startActivity(ActivityExecutionStartedNotification<Activity, EClassifier> notification) {
        this.debug("Starting execution of %1s...", notification.getActivity());
    }

    private void startActivityNode(ActivityNodeExecutionStartedNotification<ActivityNode, EClassifier> notification) {
        this.wrap();
        this.debug("Starting execution of %1s...", notification.getActivityNode());
    }

    private void storyPatternInitializationStarted(StoryPatternInitializationStartedNotification<StoryPattern, EClassifier> notification) {
        this.debug("Starting initialization of %1s...", notification.getStoryPattern());
    }

    private void storyPatternMatchingStarted(StoryPatternMatchingStartedNotification<StoryPattern, EClassifier> notification) {
        this.wrap();
        this.debug("Starting matching of %1s...", notification.getStoryPattern());
    }

    private void storyPatternApplicationStarted(StoryPatternApplicationStartedNotification<StoryPattern, EClassifier> notification) {
        this.wrap();
        this.debug("Starting application of %1s...", notification.getStoryPattern());
    }

    private void variableChanged(VariableValueChangedNotification<EClassifier> notification) {
        this.debug("Variable value changed: %1s: %2s -> %3s", notification.getVariable().getName(), notification.getOldValue(), notification.getVariable().getValue());
    }

    private void startExpression(EvaluatingExpressionNotification<EClassifier, Expression> notification) {
        this.debug("Starting evaluation of expression '%1s'...", notification.getExpression());
    }

    private void finishActivity(ActivityExecutionFinishedNotification<Activity, EClassifier> notification) {
        this.info("Finished execution of %1s.", notification.getActivity());
    }

    private void finishActivityNode(ActivityNodeExecutionFinishedNotification<ActivityNode, EClassifier> notification) {
        this.info("Finished execution of %1s.", notification.getActivityNode());
    }

    private void traverseActivityEdge(TraversingActivityEdgeNotification<ActivityEdge, EClassifier> notification) {
        ActivityEdge edge = (ActivityEdge)notification.getActivityEdge();
        this.wrap();
        this.info("Traversing %1s...", edge);
    }

    private void storyPatternInitializationFinished(StoryPatternInitializationFinishedNotification<StoryPattern, EClassifier> notification) {
        this.info("Finished initialization of %1s.", notification.getStoryPattern());
    }

    private void storyPatternMatchingSuccessful(StoryPatternMatchingSuccessfulNotification<StoryPattern, EClassifier> notification) {
        this.info("Finished matching of %1s successfully.", notification.getStoryPattern());
    }

    private void storyPatternApplicationFinished(StoryPatternApplicationFinishedNotification<StoryPattern, EClassifier> notification) {
        this.info("Finished application of %1s.", notification.getStoryPattern());
    }

    private void linkChecked(LinkCheckSuccessfulNotification<AbstractVariable, AbstractLinkVariable, EClassifier> notification) {
        this.info("Link check successful: '%1s' from '%2s' to '%3s' (source: '%4s', target: '%5s').", notification.getLink(), notification.getSourceStoryPatternObject(), notification.getTargetStoryPatternObject(), notification.getSourceObject(), notification.getTargetObject());
    }

    private void boundNot(StoryPatternObjectNotBoundNotification<AbstractVariable, EClassifier> notification) {
        this.info("Could not bind %1s.", notification.getStoryPatternObject());
    }

    private void traverseLink(TraversingLinkNotification<AbstractVariable, AbstractLinkVariable, EClassifier> notification) {
        this.wrap();
        this.info("Traversing link %1s...", notification.getLink());
        this.wrap();
    }

    private void finishExpression(EvaluatedExpressionNotification<EClassifier, Expression> notification) {
        this.info("Finished evaluation of expression '%1s' := %2s.", notification.getExpression(), notification.getResult());
    }

    private void constraintHolds(StoryPatternConstraintHoldsNotification<StoryPattern, EClassifier, Expression> notification) {
        this.info("Constraint '%1s' holds on %2s.", notification.getConstraint(), notification.getStoryPattern());
    }

    private void wrap() {
        this.console.wrap();
    }

    private void storyPatternMatchingFailed(StoryPatternMatchingFailedNotification<StoryPattern, EClassifier> notification) {
        this.fail("Matching of %1s failed.", notification.getStoryPattern());
    }

    private void destroyedInstance(InstanceObjectDestroyedNotification<AbstractVariable, EClassifier> notification) {
        this.fail("Destroyed instance of %1s := %2s.", notification.getStoryPatternObject(), notification.getInstanceObject());
    }

    private void destroyedInstance(InstanceLinkDestroyedNotification<AbstractVariable, AbstractLinkVariable, EClassifier> notification) {
        this.fail("Destroyed instance link %1s (%2s to %3s).", notification.getLink(), notification.getSourceObject(), notification.getTargetObject());
    }

    private void linkFailed(LinkCheckFailedNotification<AbstractVariable, AbstractLinkVariable, EClassifier> notification) {
        this.fail("Link check failed: '%1s' from '%2s' to '%3s' (source: '%4s', target: '%5s').", notification.getLink(), notification.getSourceStoryPatternObject(), notification.getTargetStoryPatternObject(), notification.getSourceObject(), notification.getTargetObject());
    }

    private void boundRevoked(StoryPatternObjectBindingRevokedNotification<AbstractVariable, EClassifier> notification) {
        this.fail("Binding revoked for %1s. Was bound to '%2s'.", notification.getStoryPatternObject(), notification.getInstanceObject());
    }

    private void variableDeleted(VariableDeletedNotification<EClassifier> notification) {
        this.fail("Deleted variable '%1s'.", notification.getVariable().getName());
    }

    private void constraintViolated(StoryPatternConstraintViolatedNotification<StoryPattern, EClassifier, Expression> notification) {
        this.fail("Constraint '%1s' is violated on %2s.", notification.getConstraint(), notification.getStoryPattern());
    }

    private void constraintViolated(StoryPatternObjectConstraintViolatedNotification<AbstractVariable, EClassifier, Expression> notification) {
        this.fail("Constraint '%1s' is violated on %2s.", notification.getConstraint(), notification.getStoryPatternObject());
    }

    private void attributeValueSet(AttributeValueSetNotification<AbstractVariable, EClassifier, EStructuralFeature> notification) {
        this.success("Set attribute %1s.%2s := %3s", ((AbstractVariable)notification.getStoryPatternObject()).getName(), ((EStructuralFeature)notification.getFeature()).getName(), notification.getFeatureValue());
    }

    private void createdInstance(InstanceObjectCreatedNotification<AbstractVariable, EClassifier> notification) {
        this.success("Created instance for %1s := %2s.", notification.getStoryPatternObject(), notification.getInstanceObject());
    }

    private void createdInstance(InstanceLinkCreatedNotification<AbstractVariable, AbstractLinkVariable, EClassifier> notification) {
        this.success("Created instance link %1s (%2s to %3s).", notification.getLink(), notification.getSourceObject(), notification.getTargetObject());
    }

    private void bound(StoryPatternObjectBoundNotification<AbstractVariable, EClassifier> notification) {
        this.success("Bound %1s to %2s.", notification.getStoryPatternObject(), notification.getInstanceObject());
    }

    private void variableCreated(VariableCreatedNotification<EClassifier> notification) {
        Variable variable = notification.getVariable();
        this.success("Created variable '%1s' := %2s.", variable.getName(), variable.getValue());
    }

    private void constraintHolds(StoryPatternObjectConstraintHoldsNotification<AbstractVariable, EClassifier, Expression> notification) {
        this.success("Constraint '%1s' holds on %2s.", notification.getConstraint(), notification.getStoryPatternObject());
    }

    private void debug(String format, Object ... args) {
        this.append(InterpreterConsole.StreamType.DEBUG, format, args);
    }

    private void fail(String format, Object ... args) {
        this.append(InterpreterConsole.StreamType.FAILURE, format, args);
    }

    private void info(String format, Object ... args) {
        this.append(InterpreterConsole.StreamType.INFO, format, args);
    }

    private void success(String format, Object ... args) {
        this.append(InterpreterConsole.StreamType.SUCCESS, format, args);
    }

    private void append(InterpreterConsole.StreamType type, String format, Object[] args) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.indent) {
            builder.append("  ");
            ++i;
        }
        builder.append(format);
        if (args == null) {
            this.console.append(type, builder.toString());
        } else {
            Object[] translated = new Object[args.length];
            int i2 = 0;
            while (i2 < translated.length) {
                translated[i2] = Texts.get(args[i2]);
                ++i2;
            }
            this.console.append(type, String.format(builder.toString(), translated));
        }
    }
}

