/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.wizards;

import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.util.TypeUtil;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.InterpreteWizardPage;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.ResultWizardPage;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.SelectInputWizardPage;

public class InterpreteActivityWizard
extends Wizard {
    private Activity activity;
    private final Map<EParameter, Object> bindings;
    private Resource resource;
    private ResourceSet resourceSet = new ResourceSetImpl();
    private Map<String, Variable<EClassifier>> results;
    private boolean saveResource;
    private Throwable throwable;

    public InterpreteActivityWizard(Activity activity) {
        this.bindings = new LinkedHashMap<EParameter, Object>();
        for (EParameter parameter : activity.getInParameters()) {
            switch (TypeUtil.getType((Object)parameter)) {
                case BOOLEAN: {
                    this.bindings.put(parameter, false);
                    break;
                }
                case BYTE: 
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LONG: 
                case SHORT: {
                    this.bindings.put(parameter, 0);
                    break;
                }
                case ENUM: {
                    this.bindings.put(parameter, TypeUtil.getFirstLiteral((Object)parameter));
                    break;
                }
                case STRING: {
                    this.bindings.put(parameter, "");
                    break;
                }
                case CHAR: {
                    this.bindings.put(parameter, Character.valueOf('a'));
                    break;
                }
                default: {
                    this.bindings.put(parameter, null);
                }
            }
        }
        this.activity = activity;
        this.setHelpAvailable(false);
        this.setWindowTitle("Interpret Activity");
        this.setNeedsProgressMonitor(true);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addPages() {
        this.addPage((IWizardPage)new SelectInputWizardPage());
        this.addPage((IWizardPage)new InterpreteWizardPage());
        this.addPage((IWizardPage)new ResultWizardPage());
    }

    public Activity getActivity() {
        return this.activity;
    }

    public Map<EParameter, Object> getBindings() {
        return this.bindings;
    }

    public Set<EParameter> getParameters() {
        return this.bindings.keySet();
    }

    public Resource getResource() {
        return this.resource;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public Map<String, Variable<EClassifier>> getResults() {
        return this.results;
    }

    public boolean performFinish() {
        if (this.saveResource) {
            try {
                this.resource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setResults(Map<String, Variable<EClassifier>> results) {
        this.results = results;
    }

    public void setSaveResource(boolean saveResource) {
        this.saveResource = saveResource;
    }

    public void setException(Throwable throwable) {
        this.throwable = throwable;
    }
}

