/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.wizards;

import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.interpreter.util.InterpreterConsole;
import org.storydriven.storydiagrams.diagram.interpreter.util.InterpreterRunnable;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.InterpreteActivityWizard;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.SelectInputWizardPage;

public class InterpreteWizardPage
extends WizardPage {
    private InterpreterConsole console = new InterpreterConsole();
    private TextConsoleViewer viewer;

    protected InterpreteWizardPage() {
        super(InterpreteWizardPage.class.getName());
        this.setTitle("Interpreting...");
        this.setDescription("Analyze the notifications of the interpreting activity.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Activity activity = this.getWizard().getActivity();
            List<Variable<EClassifier>> parameters = ((SelectInputWizardPage)this.getPreviousPage()).getParameters();
            this.getWizard().setResults(null);
            this.console.clearConsole();
            this.getWizard().setException(null);
            if (this.getWizard().getResource() != null) {
                this.getWizard().getResource().setTrackingModification(true);
            }
            Throwable throwable = null;
            try {
                InterpreterRunnable runnable = new InterpreterRunnable(activity, parameters, this.console);
                this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
                this.getWizard().setResults(runnable.getResults());
            }
            catch (InvocationTargetException e) {
                throwable = e.getCause();
                if (e.getCause() == null) {
                    throwable = e;
                }
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                throwable = e.getCause();
                if (e.getCause() == null) {
                    throwable = e;
                }
                e.printStackTrace();
            }
            if (throwable != null) {
                this.getWizard().setException(throwable);
                this.console.wrap();
                this.console.append(InterpreterConsole.StreamType.FAILURE, "An exception occurred during the interpretation!");
            }
        }
    }

    public InterpreteActivityWizard getWizard() {
        return (InterpreteActivityWizard)super.getWizard();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.viewer = new TextConsoleViewer(composite, (TextConsole)this.console);
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                int index = InterpreteWizardPage.this.viewer.getDocument().getLength() - 1;
                InterpreteWizardPage.this.viewer.setTopIndex(index);
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        this.viewer.setEditable(false);
        this.setControl((Control)composite);
    }
}

