/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.interpreter.wizards;

import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.interpreter.ParameterBindingEditingSupport;
import org.storydriven.storydiagrams.diagram.interpreter.dialogs.SelectWorkspaceResourceDialog;
import org.storydriven.storydiagrams.diagram.interpreter.util.Texts;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.InterpreteActivityWizard;
import org.storydriven.storydiagrams.diagram.interpreter.wizards.InterpreteWizardPage;

public class SelectInputWizardPage
extends WizardPage {
    private ParameterBindingEditingSupport editingSupport;
    private SelectWorkspaceResourceDialog hostDialog = new SelectWorkspaceResourceDialog();
    private Button hostPathButton;
    private Text hostPathText;
    private TableViewer parametersTable;
    private String path;

    protected SelectInputWizardPage() {
        super(SelectInputWizardPage.class.getName());
        this.setDescription("Configure input and output parameters.");
        this.setTitle("Configure Input");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Composite hostComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(hostComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hostComposite);
        Label hostPathLabel = new Label(hostComposite, 131072);
        hostPathLabel.setText("Host Graph:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)hostPathLabel);
        this.hostPathText = new Text(hostComposite, 18436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.hostPathText);
        this.hostPathButton = new Button(hostComposite, 8);
        this.hostPathButton.setText("Select");
        GridDataFactory.fillDefaults().applyTo((Control)this.hostPathButton);
        Group inParameterGroup = new Group(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)inParameterGroup);
        inParameterGroup.setLayout((Layout)new GridLayout(2, false));
        inParameterGroup.setText("Input Parameters");
        this.parametersTable = new TableViewer((Composite)inParameterGroup, 67588);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.parametersTable.getControl());
        this.parametersTable.getTable().setHeaderVisible(true);
        this.parametersTable.getTable().setLinesVisible(true);
        this.parametersTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn nameColumn = new TableViewerColumn(this.parametersTable, 16384);
        nameColumn.getColumn().setWidth(200);
        nameColumn.getColumn().setText("Parameter");
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return DiagramImages.getImage((String)"icons/elements/ecore/EParameter_in.png");
            }

            public String getText(Object element) {
                return Texts.get(element).toString();
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.parametersTable, 16384);
        valueColumn.getColumn().setWidth(200);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            private ComposedAdapterFactoryLabelProvider aflp = new ComposedAdapterFactoryLabelProvider();

            public void dispose() {
                this.aflp.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                return this.aflp.getImage(SelectInputWizardPage.this.getBinding(element));
            }

            public String getText(Object element) {
                return this.aflp.getText(SelectInputWizardPage.this.getBinding(element));
            }
        });
        this.editingSupport = new ParameterBindingEditingSupport(this.parametersTable, this.getWizard().getBindings());
        valueColumn.setEditingSupport((EditingSupport)this.editingSupport);
        Composite inParameterControlComposite = new Composite((Composite)inParameterGroup, 0);
        GridDataFactory.fillDefaults().applyTo((Control)inParameterControlComposite);
        GridLayoutFactory.fillDefaults().applyTo(inParameterControlComposite);
        Button button = new Button(inParameterControlComposite, 8);
        button.setText("open");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EParameter element = (EParameter)((IStructuredSelection)SelectInputWizardPage.this.parametersTable.getSelection()).getFirstElement();
                SelectInputWizardPage.this.parametersTable.editElement((Object)element, 1);
            }
        });
        this.parametersTable.setInput(this.getWizard().getBindings().keySet());
        this.hookListeners();
        this.setControl((Control)composite);
        this.setPageComplete(this.isValid());
    }

    private boolean isValid() {
        IResource member;
        if (this.path != null && !((member = ResourcesPlugin.getWorkspace().getRoot().findMember(this.path)) instanceof IFile)) {
            this.setErrorMessage("The selected resource does not exist.");
        }
        if (this.getWizard().getResource() == null) {
            this.setErrorMessage("You have to select a host graph resource.");
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public List<Variable<EClassifier>> getParameters() {
        ArrayList<Variable<EClassifier>> parameters = new ArrayList<Variable<EClassifier>>();
        for (EParameter parameter : this.getWizard().getParameters()) {
            String name = parameter.getName();
            EClassifier classifier = parameter.getEType();
            Object value = this.getBinding(parameter);
            parameters.add((Variable<EClassifier>)new Variable(name, (Object)classifier, value));
        }
        return parameters;
    }

    protected Object getBinding(Object element) {
        return this.getWizard().getBindings().get(element);
    }

    private ResourceSet getResourceSet() {
        return this.getWizard().getResourceSet();
    }

    public InterpreteActivityWizard getWizard() {
        return (InterpreteActivityWizard)super.getWizard();
    }

    private void hookListeners() {
        this.hostPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectInputWizardPage.this.getWizard().setResource(null);
                SelectInputWizardPage.this.path = SelectInputWizardPage.this.hostPathText.getText();
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(SelectInputWizardPage.this.path);
                if (member instanceof IFile) {
                    try {
                        SelectInputWizardPage.this.getContainer().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                URI uri = URI.createPlatformResourceURI((String)SelectInputWizardPage.this.path, (boolean)true);
                                String message = String.format("Loading Resource '%1s'...", uri.toPlatformString(true));
                                monitor.beginTask(message, -1);
                                try {
                                    SelectInputWizardPage.this.getWizard().setResource(SelectInputWizardPage.this.getResourceSet().getResource(uri, true));
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                SelectInputWizardPage.this.editingSupport.setResource(SelectInputWizardPage.this.getWizard().getResource().getResourceSet());
                SelectInputWizardPage.this.setPageComplete(SelectInputWizardPage.this.isValid());
            }
        });
        this.hostPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectInputWizardPage.this.hostDialog.open() == 0) {
                    IFile file = (IFile)SelectInputWizardPage.this.hostDialog.getElement();
                    SelectInputWizardPage.this.hostPathText.setText(file.getFullPath().toString());
                }
            }
        });
    }

    public InterpreteWizardPage getNextPage() {
        return (InterpreteWizardPage)super.getNextPage();
    }
}

