/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.activities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeGuard implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    SUCCESS(1, "SUCCESS", "SUCCESS"),
    FAILURE(2, "FAILURE", "FAILURE"),
    EACH_TIME(3, "EACH_TIME", "EACH_TIME"),
    END(4, "END", "END"),
    ELSE(5, "ELSE", "ELSE"),
    BOOL(6, "BOOL", "BOOL"),
    EXCEPTION(7, "EXCEPTION", "EXCEPTION"),
    FINALLY(8, "FINALLY", "FINALLY");

    public static final int NONE_VALUE = 0;
    public static final int SUCCESS_VALUE = 1;
    public static final int FAILURE_VALUE = 2;
    public static final int EACH_TIME_VALUE = 3;
    public static final int END_VALUE = 4;
    public static final int ELSE_VALUE = 5;
    public static final int BOOL_VALUE = 6;
    public static final int EXCEPTION_VALUE = 7;
    public static final int FINALLY_VALUE = 8;
    private static final EdgeGuard[] VALUES_ARRAY;
    public static final List<EdgeGuard> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeGuard[]{NONE, SUCCESS, FAILURE, EACH_TIME, END, ELSE, BOOL, EXCEPTION, FINALLY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeGuard get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeGuard result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeGuard getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeGuard result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeGuard get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SUCCESS;
            }
            case 2: {
                return FAILURE;
            }
            case 3: {
                return EACH_TIME;
            }
            case 4: {
                return END;
            }
            case 5: {
                return ELSE;
            }
            case 6: {
                return BOOL;
            }
            case 7: {
                return EXCEPTION;
            }
            case 8: {
                return FINALLY;
            }
        }
        return null;
    }

    private EdgeGuard(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

