/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.diagram.custom.util.ActivityUtil;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public final class BoundUtil {
    private BoundUtil() {
    }

    public static Map<String, EClassifier> getBoundObjects(EObject element) {
        Activity activity;
        LinkedHashMap<String, EClassifier> map = new LinkedHashMap<String, EClassifier>();
        HashSet<ActivityNode> visited = new HashSet<ActivityNode>();
        if (element instanceof ActivityNode) {
            BoundUtil.collect(visited, map, (ActivityNode)element);
        }
        if (element instanceof ActivityEdge) {
            BoundUtil.collect(visited, map, (ActivityEdge)element);
        }
        if ((activity = ActivityUtil.getActivity(element)) != null) {
            BoundUtil.collect(map, activity);
        }
        return map;
    }

    private static void collect(Collection<ActivityNode> visited, Map<String, EClassifier> map, ActivityNode node) {
        if (!visited.contains(node)) {
            visited.add(node);
            if (node instanceof StoryNode) {
                BoundUtil.collect(map, ((StoryNode)node).getStoryPattern());
            }
            for (ActivityEdge incoming : node.getIncomings()) {
                BoundUtil.collect(visited, map, incoming);
            }
        }
    }

    private static void collect(Map<String, EClassifier> map, StoryPattern pattern) {
        for (StoryPattern childPattern : pattern.getContainedPatterns()) {
            BoundUtil.collect(map, childPattern);
        }
        if (!BindingSemantics.NEGATIVE.equals((Object)pattern.getBindingSemantics())) {
            for (AbstractVariable variable : pattern.getVariables()) {
                if (BindingState.BOUND.equals((Object)variable.getBindingState())) continue;
                if (variable instanceof ObjectVariable) {
                    if (BindingSemantics.NEGATIVE.equals((Object)((ObjectVariable)variable).getBindingSemantics())) continue;
                    BoundUtil.collect(map, variable);
                    continue;
                }
                BoundUtil.collect(map, variable);
            }
        }
    }

    private static void collect(Map<String, EClassifier> map, AbstractVariable variable) {
        BoundUtil.collect(map, variable.getName(), variable.getType());
    }

    private static void collect(Map<String, EClassifier> map, Activity activity) {
        for (EParameter parameter : activity.getInParameters()) {
            BoundUtil.collect(map, parameter.getName(), parameter.getEType());
        }
    }

    private static void collect(Map<String, EClassifier> map, String name, EClassifier classifier) {
        if (!map.containsKey(name)) {
            map.put(name, classifier);
        } else {
            System.out.println("\talready bound something for key '" + name + "'!");
        }
    }

    private static void collect(Collection<ActivityNode> visited, Map<String, EClassifier> map, ActivityEdge edge) {
        if (!visited.contains(edge)) {
            BoundUtil.collect(visited, map, edge.getSource());
        }
    }

    public static List<ObjectVariable> getAllObjectVariables(Activity activity) {
        if (activity != null) {
            TreeIterator it = EcoreUtil.getAllContents((EObject)activity, (boolean)true);
            ArrayList<ObjectVariable> list = new ArrayList<ObjectVariable>();
            while (it.hasNext()) {
                Notifier element = (Notifier)it.next();
                if (!(element instanceof ObjectVariable)) continue;
                list.add((ObjectVariable)element);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static List<PrimitiveVariable> getAllPrimitiveVariables(Activity activity) {
        if (activity != null) {
            TreeIterator it = EcoreUtil.getAllContents((EObject)activity, (boolean)true);
            ArrayList<PrimitiveVariable> list = new ArrayList<PrimitiveVariable>();
            while (it.hasNext()) {
                Notifier element = (Notifier)it.next();
                if (!(element instanceof PrimitiveVariable)) continue;
                list.add((PrimitiveVariable)element);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

