/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import tools.descartes.dlim.DlimGeneratorPlugin;
import tools.descartes.dlim.exporter.DlimRequestStampExporter;
import tools.descartes.dlim.exporter.IDlimExporter;
import tools.descartes.dlim.exporter.dialogs.NoBinningRequestTimeStampParametersDialog;
import tools.descartes.dlim.generator.ModelEvaluator;

public class DlimNoBinningRequestStampExporterCSV
extends DlimRequestStampExporter
implements IDlimExporter {
    public void export(String projectPath, String modelPath, ModelEvaluator evaluator) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NoBinningRequestTimeStampParametersDialog paramDialog = new NoBinningRequestTimeStampParametersDialog(evaluator, modelPath, shell);
        paramDialog.open();
        if (!paramDialog.wasCanceled()) {
            IPath timeStampFolderPath = this.perpareTimestampDir(projectPath);
            File file = timeStampFolderPath.append(String.valueOf(evaluator.getName()) + "TimeStamps.csv").toFile();
            double stretch = paramDialog.getStretch();
            double arDevisor = paramDialog.getArDevisor();
            double zeroResamplingTime = paramDialog.getZeroResamplingTime();
            try {
                PrintWriter timeStampWriter = new PrintWriter(file, "UTF-8");
                double currentTime = 0.0;
                double finalDuration = evaluator.getTerminatingDuration();
                while (currentTime < finalDuration) {
                    double arrivalRate = evaluator.getArrivalRateAtTime(currentTime) / arDevisor;
                    double step = zeroResamplingTime;
                    if (arrivalRate > 0.0) {
                        step = 1.0 / arrivalRate;
                        timeStampWriter.println(currentTime * stretch);
                    }
                    currentTime += step;
                }
                timeStampWriter.close();
            }
            catch (FileNotFoundException e) {
                DlimGeneratorPlugin.INSTANCE.log((Object)new Status(1, "tools.descartes.dlim.generator", "FileNotFound, Could not write time stamps.", (Throwable)e));
            }
            catch (UnsupportedEncodingException e) {
                DlimGeneratorPlugin.INSTANCE.log((Object)new Status(1, "tools.descartes.dlim.generator", "UnsupportedEncoding, Could not write time stamps.", (Throwable)e));
            }
        }
    }
}

