/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.generator.ModelEvaluator;

public class NoBinningRequestTimeStampParametersDialog
extends TitleAreaDialog {
    private Text decimalPlacesText;
    private Text zeroResamplingTimeText;
    private Text rndSeedText;
    private Text stretchText;
    private Text arDevisorText;
    private int decimalPlaces = 3;
    private int rndSeed = 5;
    private double zeroResamplingTime = 1.0;
    private double stretch = 1.0E-4;
    private double arDevisor = 1.0;
    private boolean canceled = false;
    private String fileString;
    private ModelEvaluator evaluator;

    public NoBinningRequestTimeStampParametersDialog(ModelEvaluator evaluator, String fileString, Shell parentShell) {
        super(parentShell);
        this.fileString = fileString;
        this.evaluator = evaluator;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void setDefaultValues() {
        this.decimalPlaces = 3;
        this.rndSeed = 5;
        this.zeroResamplingTime = 1.0E-4;
        this.stretch = 1.0;
        this.arDevisor = 1.0;
        this.canceled = false;
    }

    public void create() {
        super.create();
        this.setTitle("Request Time Stamp Generation Parameters");
        this.setMessage("For Model: " + this.fileString, 1);
        if (this.evaluator.getDuration() >= Double.MAX_VALUE) {
            this.setMessage("Model has infinite duration. Terminating after first loop!", 2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogContainer = (Composite)super.createDialogArea(parent);
        Label warningLabel1 = new Label(dialogContainer, 0);
        warningLabel1.setText(" Caution: Time stamp files for large models can be several 100 MB large.");
        Label warningLabel2 = new Label(dialogContainer, 0);
        warningLabel2.setText(" Generation may take several minutes.");
        FontData fontData = warningLabel1.getFont().getFontData()[0];
        Font boldFont = new Font((Device)this.getShell().getDisplay(), fontData.getName(), fontData.getHeight(), 1);
        warningLabel1.setFont(boldFont);
        warningLabel2.setFont(boldFont);
        Composite columnContainer = new Composite(dialogContainer, 0);
        columnContainer.setLayout((Layout)new FillLayout(512));
        this.createDecimalPlaceParameterField(columnContainer);
        this.createZeroResamplingTimeParameterField(columnContainer);
        this.createRndSeedParameterField(columnContainer);
        Label delimiterLabel = new Label(columnContainer, 0);
        delimiterLabel.setText("Time Stamp Modifiers");
        delimiterLabel.setAlignment(0x1000000);
        this.createStretchParameterField(columnContainer);
        this.createArDevisorParameterField(columnContainer);
        return dialogContainer;
    }

    private void createDecimalPlaceParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Maximum Decimal Places: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.decimalPlacesText = new Text(gridContainer, 2048);
        this.decimalPlacesText.setText("3");
        this.decimalPlacesText.setLayoutData((Object)parameterFieldData);
    }

    private void createRndSeedParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Random Generator Seed: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 16;
        this.rndSeedText = new Text(gridContainer, 2048);
        this.rndSeedText.setText("5");
        this.rndSeedText.setLayoutData((Object)parameterFieldData);
    }

    private void createZeroResamplingTimeParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Sampling Interval in case of 0 arrival rate: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 20;
        this.zeroResamplingTimeText = new Text(gridContainer, 2048);
        this.zeroResamplingTimeText.setText("1.0");
        this.zeroResamplingTimeText.setLayoutData((Object)parameterFieldData);
    }

    private void createStretchParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Stretch Model Times by: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 20;
        this.stretchText = new Text(gridContainer, 2048);
        this.stretchText.setText("1.0");
        this.stretchText.setLayoutData((Object)parameterFieldData);
    }

    private void createArDevisorParameterField(Composite container) {
        Composite gridContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        gridContainer.setLayout((Layout)layout);
        Label parameterFieldLabel = new Label(gridContainer, 0);
        parameterFieldLabel.setText("Divide Model Arrival Rates by: ");
        GridData parameterFieldData = new GridData();
        parameterFieldData.grabExcessHorizontalSpace = false;
        parameterFieldData.horizontalAlignment = 1;
        parameterFieldData.widthHint = 24;
        this.arDevisorText = new Text(gridContainer, 2048);
        this.arDevisorText.setText("1.0");
        this.arDevisorText.setLayoutData((Object)parameterFieldData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Request Time Stamp Generation Parameters");
    }

    protected void cancelPressed() {
        this.setDefaultValues();
        this.canceled = true;
        super.cancelPressed();
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    protected void okPressed() {
        boolean error = false;
        try {
            this.decimalPlaces = Integer.parseInt(this.decimalPlacesText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Decimal Places must be an Integer.", 3);
            error = true;
        }
        try {
            this.zeroResamplingTime = Double.parseDouble(this.zeroResamplingTimeText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Sampling Interval Width must be a number.", 3);
            error = true;
        }
        try {
            this.rndSeed = Integer.parseInt(this.rndSeedText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Random Seed must be an Integer.", 3);
            error = true;
        }
        try {
            this.stretch = Double.parseDouble(this.stretchText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Time stretch factor must be a number.", 3);
            error = true;
        }
        try {
            this.arDevisor = Double.parseDouble(this.arDevisorText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Arrival Rate Devisor must be a number.", 3);
            error = true;
        }
        if (this.arDevisor <= 0.0) {
            error = true;
            this.setMessage("Arrival Rate Devisor must greater than 0.", 3);
        }
        if (this.stretch <= 0.0) {
            error = true;
            this.setMessage("Time stretch factor must greater than 0.", 3);
        }
        if (this.zeroResamplingTime <= 0.0) {
            error = true;
            this.setMessage("Sampling Interval Width must greater than 0.", 3);
        }
        if (this.decimalPlaces <= 0) {
            error = true;
            this.setMessage("Decimal Places must greater than 0.", 3);
        }
        if (!error) {
            super.okPressed();
        }
    }

    public int getRndSeed() {
        return this.rndSeed;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public double getZeroResamplingTime() {
        return this.zeroResamplingTime;
    }

    public double getStretch() {
        return this.stretch;
    }

    public double getArDevisor() {
        return this.arDevisor;
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }
}

