/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.ocl.environment;

import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.parser.AbstractOCLAnalyzer;

public class CustomOCLEnvironment
extends EcoreEnvironment {
    private final VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, ?> variablesScope;

    protected CustomOCLEnvironment(VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, ?> variablesScope) {
        super(EPackage.Registry.INSTANCE);
        this.variablesScope = variablesScope;
    }

    public boolean addElement(String name, Variable<EClassifier, EParameter> elem, boolean isExplicit) {
        return super.addElement(name, elem, isExplicit);
    }

    public void deleteElement(String name) {
        super.deleteElement(name);
    }

    public Collection<Variable<EClassifier, EParameter>> getVariables() {
        throw new UnsupportedOperationException("getVariables not implemented yet");
    }

    public Variable<EClassifier, EParameter> lookupLocal(String name) {
        assert (this.variablesScope != null);
        assert (name != null);
        assert (!"".equals(name));
        de.mdelab.sdm.interpreter.core.variables.Variable variable = this.variablesScope.getVariable(name);
        if (variable == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            variable = this.variablesScope.getVariable(AbstractOCLAnalyzer.unescape((String)name));
        }
        if (variable == null) {
            return super.lookupLocal(name);
        }
        Variable var = this.getOCLFactory().createVariable();
        var.setName(variable.getName());
        var.setType((Object)this.getOclType((EClassifier)variable.getClassifier()));
        return var;
    }

    private EClassifier getOclType(EClassifier classifier) {
        assert (classifier != null);
        if (classifier.eClass() == EcorePackage.Literals.EDATA_TYPE) {
            if (EcorePackage.Literals.EINT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EINTEGER_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EBIG_INTEGER.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EBYTE.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EBYTE_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ESHORT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ESHORT_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ELONG.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ELONG_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName())) {
                return (EClassifier)this.getOCLStandardLibrary().getInteger();
            }
            if (EcorePackage.Literals.EDOUBLE.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EDOUBLE_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EFLOAT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EFLOAT_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName())) {
                return (EClassifier)this.getOCLStandardLibrary().getReal();
            }
            if (EcorePackage.Literals.EBOOLEAN.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.EBOOLEAN_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName())) {
                return (EClassifier)this.getOCLStandardLibrary().getBoolean();
            }
            if (EcorePackage.Literals.ECHAR.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ECHARACTER_OBJECT.getInstanceTypeName().equals(classifier.getInstanceTypeName()) || EcorePackage.Literals.ESTRING.getInstanceTypeName().equals(classifier.getInstanceTypeName())) {
                return (EClassifier)this.getOCLStandardLibrary().getString();
            }
            return classifier;
        }
        return classifier;
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier classifier = super.lookupClassifier(names);
        if (classifier != null) {
            return classifier;
        }
        if (names.size() <= 1) {
            return null;
        }
        EPackage rootPackage = null;
        for (de.mdelab.sdm.interpreter.core.variables.Variable var : this.variablesScope.getVariables()) {
            rootPackage = this.findRootPackage((EClassifier)var.getClassifier(), names.get(0));
            if (rootPackage != null) break;
        }
        if (rootPackage != null) {
            EPackage pkg = rootPackage;
            int i = 1;
            while (i < names.size() - 1) {
                if ((pkg = CustomOCLEnvironment.getESubpackage(pkg, names.get(i))) == null) {
                    return null;
                }
                ++i;
            }
            return CustomOCLEnvironment.getEClassifier(pkg, names.get(names.size() - 1));
        }
        return null;
    }

    private EPackage findRootPackage(EClassifier classifier, String packageName) {
        EPackage pkg = classifier.getEPackage();
        while (pkg.getESuperPackage() != null) {
            pkg = pkg.getESuperPackage();
        }
        if (pkg.getName().equals(packageName)) {
            return pkg;
        }
        if (classifier instanceof EClass) {
            for (EClass eClass : ((EClass)classifier).getESuperTypes()) {
                pkg = this.findRootPackage((EClassifier)eClass, packageName);
                if (pkg == null) continue;
                return pkg;
            }
        }
        return null;
    }

    public static EPackage getESubpackage(EPackage pkg, String name) {
        for (EPackage sub : pkg.getESubpackages()) {
            if (!name.equals(sub.getName())) continue;
            return sub;
        }
        if (AbstractOCLAnalyzer.isEscaped((String)name)) {
            name = AbstractOCLAnalyzer.unescape((String)name);
            for (EPackage sub : pkg.getESubpackages()) {
                if (!name.equals(sub.getName())) continue;
                return sub;
            }
        }
        return null;
    }

    public static EClassifier getEClassifier(EPackage pkg, String name) {
        EClassifier result = pkg.getEClassifier(name);
        if (result == null && AbstractOCLAnalyzer.isEscaped((String)name)) {
            result = pkg.getEClassifier(AbstractOCLAnalyzer.unescape((String)name));
        }
        return result;
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }
}

