/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.debug;

import de.uka.ipd.sdq.codegen.simucontroller.debug.SimuComProcessDebugThread;
import de.uka.ipd.sdq.codegen.simucontroller.debug.SimulationDebugElement;
import de.uka.ipd.sdq.codegen.simucontroller.debug.SimulationDebugThread;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.DockModel;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.events.DockEvent;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.events.DockSimulationStartedEvent;
import de.uka.ipd.sdq.codegen.simucontroller.dockmodel.events.DockSimulationTerminatedEvent;
import de.uka.ipd.sdq.simucomframework.simucomstatus.Process;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusPackage;
import de.uka.ipd.sdq.simucomframework.simulationdock.SimulationDockService;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.common.notify.Notification;

public class SimulationDebugTarget
extends SimulationDebugElement
implements IDebugTarget,
Observer {
    private SimulationDockService simControl;
    private SimulationDebugThread myEventProcessorThread = null;
    private DockModel myDock;
    private boolean isTerminated;
    private ArrayList<IThread> runningSimThreads = new ArrayList();
    private SimuComStatus simulationStatus;

    public SimulationDebugTarget(ILaunch launch, DockModel dock) {
        super(null, launch);
        this.myDebugTarget = this;
        this.myDock = dock;
        this.simControl = dock.getService();
        this.myDock.addObserver(this);
        this.myEventProcessorThread = new SimulationDebugThread(this, launch, dock);
    }

    public String getName() throws DebugException {
        return "SimuCom Simulation Run";
    }

    public IProcess getProcess() {
        return this.launch.getProcesses()[0];
    }

    public IThread[] getThreads() throws DebugException {
        ArrayList<IThread> result = new ArrayList<IThread>();
        if (!this.isTerminated) {
            result.add(this.myEventProcessorThread);
            result.addAll(this.runningSimThreads);
        }
        return result.toArray(new IThread[0]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public boolean canTerminate() {
        return true;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.simControl.stopSimulation();
    }

    public boolean canResume() {
        return true;
    }

    public boolean canSuspend() {
        return true;
    }

    public boolean isSuspended() {
        return this.myDock.isSuspended();
    }

    public void resume() throws DebugException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SimulationDebugTarget.this.simControl.resume();
            }
        }).run();
    }

    public void suspend() throws DebugException {
        this.simControl.suspend();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public void dispose() {
        assert (this.isTerminated);
        this.myEventProcessorThread.dispose();
        this.simControl = null;
        this.myDock.deleteObserver(this);
        this.myDock = null;
    }

    @Override
    public void update(Observable o, Object arg) {
        DockEvent dockEvent;
        if (arg instanceof DockEvent && (dockEvent = (DockEvent)arg).comesFrom(this.myDock)) {
            if (dockEvent instanceof DockSimulationTerminatedEvent) {
                this.isTerminated = true;
                if (!this.myDock.isRemote()) {
                    this.simulationStatus.eAdapters().remove((Object)this);
                    this.simulationStatus.getProcessStatus().eAdapters().remove((Object)this);
                    this.simulationStatus.getResourceStatus().eAdapters().remove((Object)this);
                }
                this.fireEvent(this, 8);
            }
            if (dockEvent instanceof DockSimulationStartedEvent && !this.myDock.isRemote()) {
                this.simulationStatus = this.simControl.getSimuComStatus();
                this.simulationStatus.eAdapters().add((Object)this);
                this.simulationStatus.getProcessStatus().eAdapters().add((Object)this);
                this.simulationStatus.getResourceStatus().eAdapters().add((Object)this);
            }
        }
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 3 && notification.getFeature() == SimucomstatusPackage.eINSTANCE.getSimulatedProcesses_Processes()) {
            this.runningSimThreads.add(new SimuComProcessDebugThread(this, this.launch, (Process)notification.getNewValue()));
            this.fireEvent(this, 16);
        }
        if (notification.getEventType() == 4 && notification.getFeature() == SimucomstatusPackage.eINSTANCE.getSimulatedProcesses_Processes()) {
            SimuComProcessDebugThread candidate = null;
            for (IThread thread : this.runningSimThreads) {
                if (thread instanceof SimuComProcessDebugThread && (candidate = (SimuComProcessDebugThread)thread).getProcess() == notification.getOldValue()) break;
            }
            this.runningSimThreads.remove((Object)candidate);
            candidate.dispose();
            this.fireEvent(this, 16);
        }
    }
}

