/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.transformations;

import de.uka.ipd.sdq.codegen.simucontroller.runconfig.AbstractSimulationWorkflowConfiguration;
import de.uka.ipd.sdq.featureconfig.Configuration;
import de.uka.ipd.sdq.pcm.transformations.AllInstancesTransformer;
import de.uka.ipd.sdq.pcm.transformations.builder.connectors.ConnectorReplacingBuilder;
import de.uka.ipd.sdq.pcm.transformations.builder.util.PCMAndCompletionModelHolder;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;

public class ApplyConnectorCompletionsJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(ApplyConnectorCompletionsJob.class);
    public static final String COMPLETION_REPOSITORY_PARTITION = "de.uka.ipd.sdq.pcm.completionRepositoryPartition";
    private static final String COMPLETIONS_FOLDER = "model/connector-completion";
    private MDSDBlackboard blackboard;
    private final AbstractSimulationWorkflowConfiguration configuration;

    public ApplyConnectorCompletionsJob(AbstractSimulationWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        block4: {
            PCMResourceSetPartition pcmModels = (PCMResourceSetPartition)this.blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
            ResourceSetPartition middlewareRepository = (ResourceSetPartition)this.blackboard.getPartition("de.uka.ipd.sdq.pcmmodels.partition.rmimiddleware");
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)"Create completion repository...");
            }
            ResourceSetPartition completionRepositoryPartition = new ResourceSetPartition();
            Repository completionRepository = RepositoryFactory.eINSTANCE.createRepository();
            String completionRepositoryName = "CompletionsRepository";
            completionRepository.setEntityName(completionRepositoryName);
            IFolder completionFolder = this.getOrCreateCompletionFolder();
            URI completionFolderURI = URI.createFileURI((String)completionFolder.getLocation().toOSString());
            URI completionRepositoryURI = completionFolderURI.appendSegment("completions.repository");
            Resource r = completionRepositoryPartition.getResourceSet().createResource(completionRepositoryURI);
            r.getContents().add((Object)completionRepository);
            this.blackboard.addPartition(COMPLETION_REPOSITORY_PARTITION, (Object)completionRepositoryPartition);
            final PCMAndCompletionModelHolder models = new PCMAndCompletionModelHolder(pcmModels.getResourceTypeRepository(), null, pcmModels.getSystem(), pcmModels.getAllocation(), null, completionRepository, (Repository)((Resource)middlewareRepository.getResourceSet().getResources().get(0)).getContents().get(0));
            final Configuration featureConfiguration = pcmModels.getFeatureConfig();
            new AllInstancesTransformer<ResourceContainer>((EClassifier)ResourceenvironmentPackage.eINSTANCE.getResourceContainer(), (EObject)models.getAllocation().getTargetResourceEnvironment_Allocation()){

                @Override
                protected void transform(ResourceContainer object) {
                    ApplyConnectorCompletionsJob.this.addMiddleware(models, object);
                }
            }.transform();
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)"Replace connectors with completions...");
            }
            new AllInstancesTransformer<AssemblyConnector>((EClassifier)CompositionPackage.eINSTANCE.getAssemblyConnector(), (EObject)models.getSystem()){

                @Override
                protected void transform(AssemblyConnector connector) {
                    if (ApplyConnectorCompletionsJob.this.configuration.getSimulateLinkingResources()) {
                        ConnectorReplacingBuilder replacer = new ConnectorReplacingBuilder(models, connector, featureConfiguration.getDefaultConfig());
                        replacer.build();
                    }
                }
            }.transform();
            try {
                completionRepositoryPartition.storeAllResources();
            }
            catch (IOException e) {
                if (!LOGGER.isEnabledFor((Priority)Level.ERROR)) break block4;
                LOGGER.error((Object)"Unable to serialize the working copy of the completion models.", (Throwable)e);
            }
        }
    }

    private IFolder getOrCreateCompletionFolder() throws JobFailedException {
        assert (this.configuration != null);
        IProject project = CreatePluginProjectJob.getProject((String)this.configuration.getStoragePluginID());
        assert (project != null);
        return CreatePluginProjectJob.getOrCreateFolder((IProject)project, (String)COMPLETIONS_FOLDER);
    }

    private void addMiddleware(PCMAndCompletionModelHolder models, ResourceContainer resContainer) {
        AssemblyContext ctx = CompositionFactory.eINSTANCE.createAssemblyContext();
        ctx.setEntityName("AssCtx Middleware " + resContainer.getEntityName());
        ctx.setEncapsulatedComponent__AssemblyContext((RepositoryComponent)models.getMiddlewareRepository().getComponents__Repository().get(0));
        models.getSystem().getAssemblyContexts__ComposedStructure().add((Object)ctx);
        models.getSystem().getAssemblyContexts__ComposedStructure().add((Object)ctx);
        AllocationContext allocCtx = AllocationFactory.eINSTANCE.createAllocationContext();
        allocCtx.setEntityName("AllocCtx Middleware " + resContainer.getEntityName());
        allocCtx.setAssemblyContext_AllocationContext(ctx);
        allocCtx.setResourceContainer_AllocationContext(resContainer);
        models.getAllocation().getAllocationContexts_Allocation().add((Object)allocCtx);
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Added middleware component >" + ctx.getEncapsulatedComponent__AssemblyContext().getEntityName() + "< to resource container >" + resContainer.getEntityName() + "<"));
        }
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Add connector completions job";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }
}

