/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.simucom;

import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IStatisticAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.AssemblyContextContext;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.ExperimentRunComparator;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.simucom.SimuComQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.statistics.estimation.SampleMeanEstimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Measure;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Median;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.PassiveResourceResult;
import org.palladiosimulator.edp2.dao.MeasurementsDao;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.MeasuringType;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.solver.models.PCMInstance;

public class SimuComAnalysisEDP2Result
extends SimuComAnalysisResult {
    private final ExperimentSetting experimentSetting;
    private final ExperimentRun run;
    private List<BaseMetricDescription> metricDescriptions;
    private List<MeasuringType> measuringTypes;

    public SimuComAnalysisEDP2Result(ExperimentRun run, ExperimentSetting experiment, PCMInstance pcmInstance, Entity pcmEntity, Map<Criterion, EvaluationAspectWithContext> objectiveToAspect, SimuComQualityAttributeDeclaration qualityAttributeInfo) throws AnalysisFailedException {
        super(pcmInstance);
        this.experimentSetting = experiment;
        this.run = run;
        this.objectiveToAspects = objectiveToAspect;
        this.qualityAttributeInfo = qualityAttributeInfo;
        this.results = this.retrieveResults(pcmInstance);
        this.maxUtilization = this.calculateMaxUtil("CPU");
        double[] values = this.getValuesForPcmEntity();
        this.meanValue = this.calculateUnivariateStatistic(values, (UnivariateStatistic)new Mean());
        this.stdDeviation = this.calculateUnivariateStatistic(values, (UnivariateStatistic)new StandardDeviation());
        this.medianValue = this.calculateUnivariateStatistic(values, (UnivariateStatistic)new Median());
        this.throughput = this.calculateThroughput(this.getTimePointsForPcmEntity());
        this.observations = values.length;
        this.confidenceInterval = this.determineConfidenceInterval(values);
        logger.debug((Object)"Initialised SimuCom EDP2 result");
    }

    public static boolean isExperimentRunExisting(String experimentName, String experimentSettingName, Repository repo) {
        return SimuComAnalysisEDP2Result.findExperimentRun(experimentName, experimentSettingName, repo) != null;
    }

    private static ExperimentSetting findExperimentRun(String experimentName, String experimentSettingName, Repository repo) {
        EList currentExperimentGroups = repo.getExperimentGroups();
        for (ExperimentGroup curr : currentExperimentGroups) {
            if (!experimentName.equals(curr.getPurpose())) continue;
            EList settings = curr.getExperimentSettings();
            for (ExperimentSetting experimentSetting : settings) {
                EList expRuns;
                if (!experimentSettingName.equals(experimentSetting.getDescription()) || (expRuns = experimentSetting.getExperimentRuns()).size() <= 0) continue;
                for (ExperimentRun experimentRun : expRuns) {
                    if (experimentRun.getMeasurement().size() <= 0) continue;
                    return experimentSetting;
                }
            }
        }
        return null;
    }

    protected static Repository findSelectedEDP2Repository(ILaunchConfiguration config) throws CoreException {
        String selectedDataSourceID = config.getAttribute("EDP2RepositoryID", "");
        EList repos = RepositoryManager.getCentralRepository().getAvailableRepositories();
        int i = 0;
        while (i < repos.size()) {
            String s = ((Repository)repos.get(i)).getId();
            if (s.equals(selectedDataSourceID)) {
                return (Repository)repos.get(i);
            }
            ++i;
        }
        return null;
    }

    public static IStatisticAnalysisResult findExperimentRunAndCreateResult(Entity pcmEntity, String experimentName, String experimentSettingName, PCMInstance pcmInstance, Repository repo, Map<Criterion, EvaluationAspectWithContext> criterionToAspect, SimuComQualityAttributeDeclaration qualityAttribute) throws AnalysisFailedException {
        ExperimentSetting mySetting = SimuComAnalysisEDP2Result.findExperimentRun(experimentName, experimentSettingName, repo);
        if (mySetting != null) {
            EList expRuns = mySetting.getExperimentRuns();
            ExperimentRunComparator comp = new ExperimentRunComparator();
            ECollections.sort((EList)expRuns, (Comparator)comp);
            ExperimentRun reqRun = null;
            for (ExperimentRun experimentRun : expRuns) {
                if (experimentRun.getMeasurement().size() <= 0) continue;
                reqRun = experimentRun;
                break;
            }
            return new SimuComAnalysisEDP2Result(reqRun, mySetting, pcmInstance, pcmEntity, criterionToAspect, qualityAttribute);
        }
        return null;
    }

    @Override
    protected void retrieveServiceResultsFinish(PCMInstance pcmInstance, ResultDecoratorRepository repo, HashMap<String, ExternalCallAction> idToExternalCallMap, Map<String, AssemblyContextContext> idToAssemblyContextMap, List<String> completionComponentIdsToIgnore) {
        logger.warn((Object)"SimuComAnalysisEDP2Result.retrieveServiceResultsFinish not yet implemented for EDP2");
    }

    @Override
    protected Map<String, PassiveResourceResult> retrievePassiveResourceUtilFinish(Map<String, PassiveResourceResult> idsToPassiveResourceResult) {
        logger.warn((Object)"SimuComAnalysisEDP2Result.retrievePassiveResourceUtilFinish not yet implemented for EDP2");
        return Collections.emptyMap();
    }

    @Override
    protected void getUtilisationOfResource(ActiveResourceUtilisationResult resultToFill, Entity container, ResourceType resourceType) throws AnalysisFailedException {
        logger.warn((Object)"SimuComAnalysisEDP2Result.getUtilisationOfResource not yet implemented for EDP2");
    }

    private ConfidenceInterval determineConfidenceInterval(double[] values) {
        ArrayList<Double> valueList = new ArrayList<Double>();
        int i = 0;
        while (i < values.length) {
            valueList.add(values[i]);
            ++i;
        }
        return new SampleMeanEstimator().estimateConfidence(valueList, this.alpha);
    }

    private double calculateThroughput(double[] values) {
        int numberOfMeasurements = values.length;
        double duration = this.calculateUnivariateStatistic(values, (UnivariateStatistic)new Max()) - this.calculateUnivariateStatistic(values, (UnivariateStatistic)new Min());
        return (double)numberOfMeasurements / duration;
    }

    private double[] getValuesForPcmEntity() {
        return this.getValuesFromMeasurement(this.getPcmEntityMeasurements());
    }

    private double[] getTimePointsForPcmEntity() {
        return this.getTimePointsFromMeasurement(this.getPcmEntityMeasurements());
    }

    private double[] getValuesFromMeasurement(Measurement measurement) {
        if (measurement == null) {
            return null;
        }
        DataSeries dataSeries = (DataSeries)((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries().get(1);
        return this.getValuesFromDataSeries(dataSeries);
    }

    private double[] getTimePointsFromMeasurement(Measurement measurement) {
        if (measurement == null) {
            return null;
        }
        DataSeries dataSeries = (DataSeries)((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements().getDataSeries().get(0);
        return this.getValuesFromDataSeries(dataSeries);
    }

    private double[] getValuesFromDataSeries(DataSeries dataSeries) {
        if (dataSeries == null) {
            return null;
        }
        MeasurementsDao meaDao = MeasurementsUtility.getMeasurementsDao((DataSeries)dataSeries);
        List values = meaDao.getMeasurements();
        double[] result = new double[values.size()];
        int i = 0;
        while (i < values.size()) {
            result[i] = (Double)((Measure)values.get(i)).getValue();
            ++i;
        }
        return result;
    }

    private Measurement getPcmEntityMeasurements() {
        for (Measurement m : this.run.getMeasurement()) {
            MeasuringPoint measuringPoint = m.getMeasuringType().getMeasuringPoint();
            if (!(measuringPoint instanceof StringMeasuringPoint) || !this.isRequestedMeasurement(this.pcmEntityIdentifier, ((StringMeasuringPoint)measuringPoint).getMeasuringPoint())) continue;
            return m;
        }
        return null;
    }

    private boolean isRequestedMeasurement(String usageScenarioName, String measuringPoint) {
        if (usageScenarioName != null && measuringPoint != null) {
            return measuringPoint.contains(usageScenarioName);
        }
        return false;
    }

    private double calculateUnivariateStatistic(double[] values, UnivariateStatistic stat) {
        return stat.evaluate(values);
    }
}

