/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.gdof.ChangeableElementDescription;
import de.uka.ipd.sdq.pcm.designdecision.gdof.DegreeOfFreedom;
import de.uka.ipd.sdq.pcm.designdecision.gdof.HelperOCLDefinition;
import de.uka.ipd.sdq.pcm.designdecision.gdof.util.gdofSwitch;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.pcm.seff.SeffPackage;
import org.palladiosimulator.solver.models.PCMInstance;

public class FixGDOFReferenceSwitch
extends gdofSwitch<EObject> {
    protected static Logger logger = Logger.getLogger((String)FixGDOFReferenceSwitch.class.getName());
    private final PCMInstance initialInstance;

    public FixGDOFReferenceSwitch(PCMInstance initialInstance2) {
        this.initialInstance = initialInstance2;
    }

    public EObject caseChangeableElementDescription(ChangeableElementDescription object) {
        return object;
    }

    public EObject caseDegreeOfFreedom(DegreeOfFreedom object) {
        return object;
    }

    public EObject switchReferences(DegreeOfFreedomInstance dofi) {
        DegreeOfFreedom dof = dofi.getDof();
        for (ChangeableElementDescription ced : dof.getChangeableElementDescriptions()) {
            for (HelperOCLDefinition helpDef : ced.getValueRule().getHelperDefinition()) {
                this.doContextClassSwitch(helpDef);
            }
            if (ced.getSelectionRule() == null) continue;
            for (HelperOCLDefinition helpDef : ced.getSelectionRule().getHelperDefinition()) {
                this.doContextClassSwitch(helpDef);
            }
        }
        return dofi;
    }

    private void doContextClassSwitch(HelperOCLDefinition helpDef) {
        EClass helperClass = helpDef.getContextClass();
        EPackage container = (EPackage)helperClass.eContainer();
        System.out.println(container.getName());
        if (container.getName().equals("composition")) {
            this.doCompositionSwich(helpDef);
        } else if (container.getName().equals("entity")) {
            this.doEntitySwitch(helpDef);
        } else if (container.getName().equals("usagemodel")) {
            this.doUsagemodelSwitch(helpDef);
        } else if (container.getName().equals("repository")) {
            this.doRepositorySwitch(helpDef);
        } else if (container.getName().equals("resourcetype")) {
            this.doResourcetypeSwitch(helpDef);
        } else if (container.getName().equals("protocol")) {
            this.doProtocolSwitch(helpDef);
        } else if (container.getName().equals("parameter")) {
            this.doParameterSwitch(helpDef);
        } else if (container.getName().equals("reliability")) {
            this.doReliabilitySwitch(helpDef);
        } else if (container.getName().equals("seff")) {
            this.doSeffSwitch(helpDef);
        } else if (container.getName().equals("qosannotations")) {
            this.doQosannotationsSwitch(helpDef);
        } else if (container.getName().equals("system")) {
            this.doSystemSwitch(helpDef);
        } else if (container.getName().equals("resourceenvironment")) {
            this.doResourceenvironmentSwitch(helpDef);
        } else if (container.getName().equals("allocation")) {
            this.doAllocationSwitch(helpDef);
        } else if (container.getName().equals("subsystem")) {
            this.doSubsystemSwitch(helpDef);
        }
    }

    private void doSubsystemSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doResourceenvironmentSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doSystemSwitch(HelperOCLDefinition helpDef) {
        EClass systemClass = this.initialInstance.getSystem().eClass();
        if (helpDef.getContextClass().getName().equals(systemClass.getName())) {
            helpDef.setContextClass(systemClass);
        }
    }

    private void doQosannotationsSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doReliabilitySwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doParameterSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doProtocolSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doResourcetypeSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doUsagemodelSwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doEntitySwitch(HelperOCLDefinition helpDef) {
        logger.error((Object)("Please implement Swich for: " + helpDef.getContextClass().getName()));
    }

    private void doAllocationSwitch(HelperOCLDefinition helpDef) {
        Allocation allocation = this.initialInstance.getAllocation();
        EList contents = allocation.eContents();
        EList superTypes = allocation.eClass().getEAllSuperTypes();
        this.switchClasses(helpDef, contents, superTypes);
    }

    private void doSeffSwitch(HelperOCLDefinition helpDef) {
        SeffPackage seffPackage = SeffFactory.eINSTANCE.getSeffPackage();
        EList contents = seffPackage.eContents();
        EList superTypes = seffPackage.eClass().getEAllSuperTypes();
        this.switchClasses(helpDef, contents, superTypes);
    }

    private void doRepositorySwitch(HelperOCLDefinition helpDef) {
        List repositories = this.initialInstance.getRepositories();
        BasicEList contents = new BasicEList();
        BasicEList superTypes = new BasicEList();
        for (Repository repository : repositories) {
            contents.addAll((Collection)repository.eContents());
        }
        for (EObject content : contents) {
            superTypes.addAll((Collection)content.eClass().getEAllSuperTypes());
        }
        this.switchClasses(helpDef, (EList<?>)contents, (EList<?>)superTypes);
    }

    private void doCompositionSwich(HelperOCLDefinition helpDef) {
        org.palladiosimulator.pcm.system.System system = this.initialInstance.getSystem();
        EList contents = system.eContents();
        EList superTypes = system.eClass().getEAllSuperTypes();
        this.switchClasses(helpDef, contents, superTypes);
    }

    private void switchClasses(HelperOCLDefinition helpDef, EList<?> contents, EList<?> superTypes) {
        boolean found = false;
        for (Object content : contents) {
            if (content instanceof EClass) {
                EClass eClass = (EClass)content;
                if (!helpDef.getContextClass().getName().equals(eClass.getName())) continue;
                helpDef.setContextClass(eClass);
                found = true;
                break;
            }
            if (!(content instanceof EObject)) continue;
            EObject eObj = (EObject)content;
            if (!helpDef.getContextClass().getName().equals(eObj.eClass().getName())) continue;
            helpDef.setContextClass(eObj.eClass());
            found = true;
            break;
        }
        if (!found) {
            for (EClass superType : superTypes) {
                if (!helpDef.getContextClass().getName().equals(superType.getName())) continue;
                helpDef.setContextClass(superType);
                found = true;
                break;
            }
        }
    }
}

