/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.helper;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractPerformanceAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import de.uka.ipd.sdq.dsexplore.helper.CriterionAndEvaluator;
import de.uka.ipd.sdq.dsexplore.helper.DSEFileWriter;
import de.uka.ipd.sdq.dsexplore.helper.DegreeOfFreedomHelper;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.ResourcesWithUtilisationDescriptor;
import de.uka.ipd.sdq.dsexplore.helper.ResultsWriter;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEDecoder;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEEvaluator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEProblem;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDimensionReader;
import de.uka.ipd.sdq.pcm.designdecision.Candidate;
import de.uka.ipd.sdq.pcm.designdecision.Candidates;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionPackage;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.Genotype;
import org.opt4j.core.Value;
import org.opt4j.start.Opt4JTask;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.ResultdecoratorFactory;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ActiveResourceUtilisationResult;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ComputedAggregatedUsage;
import org.palladiosimulator.solver.models.PCMInstance;

public class GenotypeReader {
    private static Opt4JTask task = null;
    private static final String SEPARATOR = ";";
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.helper.GenotypeReader");

    public static void setTask(Opt4JTask t) {
        task = t;
    }

    public static List<DesignDecisionGenotype> getGenotypes(URI filename, MDSDBlackboard blackboard) throws CoreException {
        if (filename == null) {
            return Collections.emptyList();
        }
        if (filename.toString().contains("csv")) {
            try {
                List<DSEIndividual> individuals = GenotypeReader.readInPrettyPrintedIndividuals(GenotypeReader.getReaderFor(filename), blackboard);
                ArrayList<DesignDecisionGenotype> results = new ArrayList<DesignDecisionGenotype>(individuals.size());
                for (DSEIndividual individual : individuals) {
                    results.add(individual.getGenotype());
                }
                return results;
            }
            catch (Exception ex) {
                throw ExceptionHelper.createNewCoreException("Could not evaluate predefined instances. See nested Exceptions for cause. " + ex.getMessage(), ex);
            }
        }
        if (filename.toString().contains("designdecision")) {
            return GenotypeReader.loadGenotypesFromEMF(filename);
        }
        throw ExceptionHelper.createNewCoreException("Genotype file to read must must be of type csv or designdecision.");
    }

    public static List<DSEIndividual> getIndividuals(URI filename, MDSDBlackboard blackboard) throws CoreException {
        if (filename == null) {
            return Collections.emptyList();
        }
        if (filename.toString().contains("csv")) {
            try {
                List<DSEIndividual> individuals = GenotypeReader.readInPrettyPrintedIndividuals(GenotypeReader.getReaderFor(filename), blackboard);
                return individuals;
            }
            catch (Exception ex) {
                throw ExceptionHelper.createNewCoreException("Could not evaluate predefined instances. See nested Exceptions for cause. " + ex.getMessage(), ex);
            }
        }
        if (filename.toString().contains("designdecision")) {
            List<DesignDecisionGenotype> genotypes = GenotypeReader.loadGenotypesFromEMF(filename);
            ArrayList<DSEIndividual> individuals = new ArrayList<DSEIndividual>(genotypes.size());
            for (DesignDecisionGenotype designDecisionGenotype : genotypes) {
                DSEIndividualFactory builder = Opt4JStarter.getIndividualFactory();
                DSEIndividual individual = builder.create((Genotype)designDecisionGenotype);
                individuals.add(individual);
            }
            return individuals;
        }
        throw ExceptionHelper.createNewCoreException("Genotype file to read must must be of type csv or designdecision.");
    }

    public static List<DSEObjectives> getObjectives(URI filename) throws CoreException {
        try {
            List<DSEObjectives> results = GenotypeReader.readInPrettyPrintedObjectives(GenotypeReader.getReaderFor(filename));
            return results;
        }
        catch (Exception ex) {
            throw ExceptionHelper.createNewCoreException("Could not evaluate predefined instances. Leave field blank for evolutionary search or type \"random\" for a random search. " + ex.getMessage(), ex);
        }
    }

    private static List<DesignDecisionGenotype> loadGenotypesFromEMF(URI filename) {
        PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
        ResourceSet pcmResourceSet = pcm.getAllocation().eResource().getResourceSet();
        EObject eCandidates = EMFHelper.loadFromXMIFile(filename, pcmResourceSet, (EPackage)designdecisionPackage.eINSTANCE);
        if (!(eCandidates instanceof Candidates)) {
            throw new RuntimeException("Cannot read candidate model file " + filename + ". Please create a new one.", null);
        }
        Candidates candidates = (Candidates)eCandidates;
        EcoreUtil.resolveAll((EObject)candidates);
        ArrayList<DesignDecisionGenotype> genotypeList = new ArrayList<DesignDecisionGenotype>(candidates.getCandidate().size());
        for (Candidate candidate : candidates.getCandidate()) {
            DesignDecisionGenotype genotype = new DesignDecisionGenotype(candidate, candidates.getProblem(), Opt4JStarter.getProblem().getGenotypeOfInitialPCMInstance());
            genotypeList.add(genotype);
        }
        return genotypeList;
    }

    private static List<DSEObjectives> readInPrettyPrintedObjectives(BufferedReader in) throws CoreException, IOException {
        String line;
        ArrayList<DSEObjectives> results = new ArrayList<DSEObjectives>();
        String headline = in.readLine();
        if (headline == null) {
            throw ExceptionHelper.createNewCoreException("Predefined instances file could not be read because it is empty. Specify a valid file or \"random\" or leave the field blank for an evolutionary search.");
        }
        String[] headlineArray = headline.split(SEPARATOR);
        List<CriterionAndEvaluator> objectiveList = Opt4JStarter.getDSEEvaluator().getCriterionAndEvaluatorList();
        List<List<CriterionAndEvaluator>> orderedObjectives = GenotypeReader.getOrderedObjectiveCollection(headlineArray, objectiveList);
        int numberOfConfidenceIntervals = GenotypeReader.countConfidenceIntervals(headlineArray);
        int startIndexOfConfidence = orderedObjectives.size();
        if (orderedObjectives.size() == 0) {
            ExceptionHelper.createNewCoreException("Tried to read in Pareto front that has no objectives in it. Fix your file.");
        }
        int expectedLineArrayLength = headlineArray.length;
        while ((line = in.readLine()) != null) {
            String[] lineArray = line.split(SEPARATOR);
            if (lineArray.length < expectedLineArrayLength) {
                throw ExceptionHelper.createNewCoreException("A line in the predefined instances file has not the right length");
            }
            DSEObjectives objectives = GenotypeReader.readInObjectivesAndConfidence(orderedObjectives, startIndexOfConfidence, numberOfConfidenceIntervals, lineArray, headlineArray.length);
            results.add(objectives);
        }
        in.close();
        return results;
    }

    private static BufferedReader getReaderFor(URI fileLocation) throws FileNotFoundException {
        File file = new File(DSEFileWriter.getFilenameFor(fileLocation));
        InputStreamReader ir = new InputStreamReader(new FileInputStream(file));
        BufferedReader in = new BufferedReader(ir);
        return in;
    }

    private static List<DSEIndividual> readInPrettyPrintedIndividuals(BufferedReader in, MDSDBlackboard blackboard) throws CoreException, IOException {
        String line;
        List<CriterionAndEvaluator> objectiveList;
        LinkedList<DSEIndividual> results = new LinkedList<DSEIndividual>();
        DSEProblem problem = Opt4JStarter.getProblem();
        List<DegreeOfFreedomInstance> decisionList = problem.getDesignDecisions();
        String headline = in.readLine();
        if (headline == null) {
            throw ExceptionHelper.createNewCoreException("Predefined instances file could not be read because it is empty. Specify a valid file or \"random\" or leave the field blank for an evolutionary search.");
        }
        String[] headlineArray = headline.split(SEPARATOR);
        List<List<CriterionAndEvaluator>> orderedObjectives = GenotypeReader.getOrderedObjectiveCollection(headlineArray, objectiveList = Opt4JStarter.getDSEEvaluator().getCriterionAndEvaluatorList());
        boolean hasObjectives = orderedObjectives.size() != 0;
        List<CriterionAndEvaluator> missingObjectives = GenotypeReader.determineMissingObjectives(objectiveList, orderedObjectives);
        Criterion performance = null;
        if (hasObjectives) {
            for (List<CriterionAndEvaluator> objectiveAndEvaluatorList : orderedObjectives) {
                CriterionAndEvaluator first;
                if (objectiveAndEvaluatorList.size() <= 0 || !ResultsWriter.getDimensionName((first = objectiveAndEvaluatorList.get(0)).getCriterion()).contains(new QMLDimensionReader().getDimension("pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype").getEntityName()) && !ResultsWriter.getDimensionName(first.getCriterion()).contains(new QMLDimensionReader().getDimension("pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype").getEntityName())) continue;
                performance = first.getCriterion();
                break;
            }
        }
        int numberOfConfidenceIntervals = GenotypeReader.countConfidenceIntervals(headlineArray);
        int startIndexOfConfidence = orderedObjectives.size();
        int startIndexOfGenotype = orderedObjectives.size() + numberOfConfidenceIntervals * 3;
        List<DegreeOfFreedomInstance> orderedDesignDecisions = GenotypeReader.getOrderedDesignDecisions(decisionList, headlineArray, startIndexOfGenotype, problem);
        int minExpectedLineArrayLength = startIndexOfGenotype + orderedDesignDecisions.size();
        List<ResourcesWithUtilisationDescriptor> resourceDescriptorsWithUtilResults = GenotypeReader.getDescriptorsForResourcesWithUtilisation(headlineArray, minExpectedLineArrayLength, problem);
        while ((line = in.readLine()) != null) {
            String[] lineArray = line.split(SEPARATOR);
            if (lineArray.length < minExpectedLineArrayLength) {
                throw ExceptionHelper.createNewCoreException("A line in the predefined instances file has not the right length");
            }
            DesignDecisionGenotype genotype = GenotypeReader.extractGenotypeAndAddToList(startIndexOfGenotype, orderedDesignDecisions, lineArray);
            DSEIndividualFactory builder = Opt4JStarter.getIndividualFactory();
            DSEIndividual individual = builder.create((Genotype)genotype);
            results.add(individual);
            if (!hasObjectives) continue;
            DSEObjectives objectives = GenotypeReader.readInObjectivesAndConfidence(orderedObjectives, startIndexOfConfidence, numberOfConfidenceIntervals, lineArray, startIndexOfGenotype);
            if (resourceDescriptorsWithUtilResults.size() > 0 && performance != null) {
                objectives.addResultDecoratorFor(performance, GenotypeReader.getResultDecorator(lineArray, minExpectedLineArrayLength, resourceDescriptorsWithUtilResults));
                if (objectives.getResultDecoratorFor(performance).getUtilisationResults_ResultDecoratorRepository().size() == 0 && !objectives.getValueForCriterion(performance).equals((Object)new DoubleValue(Double.valueOf(Double.POSITIVE_INFINITY)))) {
                    logger.warn((Object)"Empty utilisation values for non-infinity objectives encountered when reading in individuals, check that this is ok.");
                }
            }
            if (Opt4JStarter.getDSEWorkflowConfig().isUseHeuristics()) {
                PCMInstance model = Opt4JStarter.getProblem().getInitialInstance();
                Opt4JStarter.getDSEDecoder().decode(genotype);
                AbstractPerformanceAnalysisResult.solveDependencies(model);
                ComputedAggregatedUsage computedAggregatedUsage = model.getComputedAggregatedUsage();
                if (computedAggregatedUsage != null) {
                    objectives.addComputedAggregatedUsage(performance, computedAggregatedUsage);
                }
            }
            Opt4JStarter.getDSEEvaluator().addToPhenotypeCache(DSEDecoder.getGenotypeString(genotype), objectives);
            individual.setObjectives(objectives);
        }
        in.close();
        if (hasObjectives && missingObjectives.size() > 0) {
            GenotypeReader.evaluateMissingObjectives(results, missingObjectives);
        }
        return results;
    }

    public static List<CriterionAndEvaluator> determineMissingObjectives(List<CriterionAndEvaluator> desiredObjectives, List<List<CriterionAndEvaluator>> availableObjectives) {
        ArrayList<CriterionAndEvaluator> flattenedAvailableObjectives = new ArrayList<CriterionAndEvaluator>(availableObjectives.size() * 3);
        for (List<CriterionAndEvaluator> list : availableObjectives) {
            flattenedAvailableObjectives.addAll(list);
        }
        ArrayList<CriterionAndEvaluator> missingObjectives = new ArrayList<CriterionAndEvaluator>();
        missingObjectives.addAll(desiredObjectives);
        missingObjectives.removeAll(flattenedAvailableObjectives);
        return missingObjectives;
    }

    private static void evaluateMissingObjectives(List<DSEIndividual> results, List<CriterionAndEvaluator> missingObjectives) throws CoreException {
        for (DSEIndividual individual : results) {
            DSEEvaluator dseEvaluator = (DSEEvaluator)task.getInstance(DSEEvaluator.class);
            DSEDecoder decoder = (DSEDecoder)task.getInstance(DSEDecoder.class);
            PCMPhenotype pheno = decoder.decode(individual.getGenotype());
            individual.setPhenotype(pheno);
            LinkedList<IAnalysis> alreadyEvaluatedMissingObjectives = new LinkedList<IAnalysis>();
            for (CriterionAndEvaluator criterionAndEvaluator : missingObjectives) {
                IAnalysis evaluator = criterionAndEvaluator.getEvaluator();
                try {
                    if (!alreadyEvaluatedMissingObjectives.contains(evaluator)) {
                        evaluator.analyse(pheno, dseEvaluator.getMonitor());
                        alreadyEvaluatedMissingObjectives.add(evaluator);
                    }
                    dseEvaluator.retrieveCriterion(pheno, individual.getObjectives(), criterionAndEvaluator);
                }
                catch (Exception e) {
                    throw ExceptionHelper.createNewCoreException("Analysis of missing objectives when reading in genotypes failed. See nested cause.", e);
                }
            }
        }
    }

    private static List<ResourcesWithUtilisationDescriptor> getDescriptorsForResourcesWithUtilisation(String[] headlineArray, int minExpectedLineArrayLength, DSEProblem problem) {
        List<ResourcesWithUtilisationDescriptor> allPotentialResourcesWithUtil = GenotypeReader.getAllProcessors(problem);
        ArrayList<ResourcesWithUtilisationDescriptor> orderedListOfUsedResourceDesccriptors = new ArrayList<ResourcesWithUtilisationDescriptor>(allPotentialResourcesWithUtil.size());
        int i = minExpectedLineArrayLength;
        while (i < headlineArray.length) {
            String entry = headlineArray[i];
            Iterator<ResourcesWithUtilisationDescriptor> iterator = allPotentialResourcesWithUtil.iterator();
            while (iterator.hasNext()) {
                ResourcesWithUtilisationDescriptor processor = iterator.next();
                if (!entry.contains(processor.getEntity().getEntityName()) || !entry.contains(processor.getResourceType().getEntityName())) continue;
                orderedListOfUsedResourceDesccriptors.add(processor);
                iterator.remove();
                break;
            }
            ++i;
        }
        return orderedListOfUsedResourceDesccriptors;
    }

    private static List<ResourcesWithUtilisationDescriptor> getAllProcessors(DSEProblem problem) {
        EList containers = problem.getInitialInstance().getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        LinkedList<ResourcesWithUtilisationDescriptor> descriptorList = new LinkedList<ResourcesWithUtilisationDescriptor>();
        for (ResourceContainer resourceContainer : containers) {
            EList processorsOnContainer = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
            for (ProcessingResourceSpecification processingResourceSpecification : processorsOnContainer) {
                descriptorList.add(new ResourcesWithUtilisationDescriptor((Entity)resourceContainer, (ResourceType)processingResourceSpecification.getActiveResourceType_ActiveResourceSpecification()));
            }
        }
        EList links = problem.getInitialInstance().getResourceEnvironment().getLinkingResources__ResourceEnvironment();
        for (LinkingResource linkingResource : links) {
            descriptorList.add(new ResourcesWithUtilisationDescriptor((Entity)linkingResource, (ResourceType)linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource().getCommunicationLinkResourceType_CommunicationLinkResourceSpecification()));
        }
        return descriptorList;
    }

    private static ResultDecoratorRepository getResultDecorator(String[] lineArray, int minExpectedLineArrayLength, List<ResourcesWithUtilisationDescriptor> processorsWithUtilResults) throws CoreException {
        ResultDecoratorRepository repo = ResultdecoratorFactory.eINSTANCE.createResultDecoratorRepository();
        int i = 0;
        while (i < lineArray.length - minExpectedLineArrayLength && i < processorsWithUtilResults.size()) {
            String entry = lineArray[i + minExpectedLineArrayLength];
            if (entry.length() > 0) {
                ResourcesWithUtilisationDescriptor processor = processorsWithUtilResults.get(i);
                ActiveResourceUtilisationResult result = processor.createUtilisationResult();
                result.setResourceUtilisation(Double.parseDouble(entry));
                result.setDemandedTime(Double.NaN);
                result.setAverageWaitTime(Double.NaN);
                repo.getUtilisationResults_ResultDecoratorRepository().add((Object)result);
            }
            ++i;
        }
        return repo;
    }

    private static int countConfidenceIntervals(String[] headlineArray) throws CoreException {
        int numberOfConfidenceIntervals = 0;
        int i = 0;
        while (i < headlineArray.length) {
            if (headlineArray[i].contains("lower bound confidence(")) {
                ++numberOfConfidenceIntervals;
            }
            ++i;
        }
        return numberOfConfidenceIntervals;
    }

    private static DesignDecisionGenotype extractGenotypeAndAddToList(int startIndexOfGenotype, List<DegreeOfFreedomInstance> orderedDesignDecisions, String[] lineArray) throws CoreException {
        DesignDecisionGenotype genotype = new DesignDecisionGenotype();
        int decisionIndex = 0;
        int i = startIndexOfGenotype;
        while (i < lineArray.length && decisionIndex < orderedDesignDecisions.size()) {
            Choice gene = DSEDecoder.getChoiceFor(lineArray[i], orderedDesignDecisions.get(decisionIndex));
            genotype.add(gene);
            ++decisionIndex;
            ++i;
        }
        return genotype;
    }

    private static DSEObjectives readInObjectivesAndConfidence(List<List<CriterionAndEvaluator>> orderedObjectives, int startIndexOfConfidence, int numberOfConfidenceIntervals, String[] lineArray, int startIndexOfGenotype) throws CoreException {
        DSEObjectives objectives = GenotypeReader.readInObjectives(lineArray, startIndexOfConfidence, orderedObjectives);
        GenotypeReader.readInConfidenceIntervals(lineArray, startIndexOfConfidence, numberOfConfidenceIntervals, orderedObjectives, objectives, startIndexOfGenotype);
        return objectives;
    }

    private static List<DegreeOfFreedomInstance> getOrderedDesignDecisions(List<DegreeOfFreedomInstance> decisionList, String[] headlineArray, int startIndexOfGenotype, DSEProblem problem) throws CoreException {
        ArrayList<DegreeOfFreedomInstance> orderedDesignDecisions = new ArrayList<DegreeOfFreedomInstance>();
        int i = startIndexOfGenotype;
        while (i < headlineArray.length) {
            String headlineEntry = headlineArray[i];
            for (DegreeOfFreedomInstance decision : decisionList) {
                if (!DegreeOfFreedomHelper.getDegreeDescription(decision).contains(headlineEntry)) continue;
                orderedDesignDecisions.add(decision);
                break;
            }
            ++i;
        }
        int numberOfUtilColumns = 0;
        int i2 = startIndexOfGenotype + orderedDesignDecisions.size();
        while (i2 < headlineArray.length) {
            String headlineString = headlineArray[i2];
            if (headlineString.contains("Util") || headlineString.contains("Candidate ID")) {
                ++numberOfUtilColumns;
            }
            ++i2;
        }
        if (headlineArray.length - startIndexOfGenotype - numberOfUtilColumns > orderedDesignDecisions.size()) {
            throw ExceptionHelper.createNewCoreException("Not all design decisions in the file were recognised. Check your file.\n Design decisions from index " + startIndexOfGenotype + " to index " + (headlineArray.length - numberOfUtilColumns - 1) + ", but expected " + orderedDesignDecisions.size() + " decisions.\n These decisions are expected: " + ((Object)orderedDesignDecisions).toString() + "\n Make sure that you provided a designdecision file that matches the predefined candidates (i.e. there is a decision for each column in the predefined candidates files).");
        }
        problem.getDesignDecisions().clear();
        problem.getDesignDecisions().addAll(orderedDesignDecisions);
        return orderedDesignDecisions;
    }

    private static DSEObjectives readInConfidenceIntervals(String[] lineArray, int startIndexOfConfidence, int numberOfConfidenceIntervals, List<List<CriterionAndEvaluator>> orderedObjectives, DSEObjectives objectives, int startIndexOfGenotype) throws CoreException {
        int index = startIndexOfConfidence;
        for (List<CriterionAndEvaluator> objectiveAndEvaluatorList : orderedObjectives) {
            CriterionAndEvaluator objectiveAndEvaluator;
            if (objectiveAndEvaluatorList.size() <= 0 || !(objectiveAndEvaluator = objectiveAndEvaluatorList.get(0)).getEvaluator().hasStatisticResultsFor() || index >= lineArray.length - 2) continue;
            String lowerConfidenceString = lineArray[index];
            String upperConfidenceString = lineArray[index + 1];
            String alphaConfidenceString = lineArray[index + 2];
            Criterion criterion = objectiveAndEvaluator.getCriterion();
            Value<?> value = objectives.getValueForCriterion(criterion);
            ConfidenceInterval ci = GenotypeReader.readInConfidenceInterval(lowerConfidenceString, upperConfidenceString, alphaConfidenceString, value);
            objectives.addConfidence(objectiveAndEvaluator.getCriterion(), ci);
            if ((index += 3) >= startIndexOfGenotype) break;
        }
        return objectives;
    }

    private static List<List<CriterionAndEvaluator>> getOrderedObjectiveCollection(String[] headline, List<CriterionAndEvaluator> objectiveList) throws CoreException {
        ArrayList<List<CriterionAndEvaluator>> orderedObjectives = new ArrayList<List<CriterionAndEvaluator>>(objectiveList.size());
        int i = 0;
        while (i < headline.length) {
            String objectiveString = headline[i];
            List<CriterionAndEvaluator> o = GenotypeReader.matchObjective(objectiveList, objectiveString);
            if (o.size() == 0) break;
            orderedObjectives.add(o);
            ++i;
        }
        if (objectiveList.size() < orderedObjectives.size()) {
            throw ExceptionHelper.createNewCoreException("Error reading in objectives: There must be only one column for each objective.");
        }
        return orderedObjectives;
    }

    private static ConfidenceInterval readInConfidenceInterval(String lowerConfidenceString, String upperConfidenceString, String alphaConfidenceString, Value<?> value) throws CoreException {
        try {
            double lowerBound = GenotypeReader.parseToDouble(lowerConfidenceString);
            double upperBound = GenotypeReader.parseToDouble(upperConfidenceString);
            double level = GenotypeReader.parseToDouble(alphaConfidenceString);
            return new ConfidenceInterval(value.getDouble().doubleValue(), lowerBound, upperBound, level);
        }
        catch (NumberFormatException e) {
            throw ExceptionHelper.createNewCoreException("Could not read in confidence interval. Expected this to be a confidence interval: " + lowerConfidenceString + SEPARATOR + upperConfidenceString + SEPARATOR + alphaConfidenceString, e);
        }
    }

    private static List<CriterionAndEvaluator> matchObjective(List<CriterionAndEvaluator> objectiveList, String objectiveString) {
        ArrayList<CriterionAndEvaluator> results = new ArrayList<CriterionAndEvaluator>(objectiveList.size());
        for (CriterionAndEvaluator objective : objectiveList) {
            if (!objectiveString.equals(ResultsWriter.getDimensionName(objective.getCriterion()))) continue;
            results.add(objective);
        }
        return results;
    }

    private static DSEObjectives readInObjectives(String[] objectiveLine, int endIndex, List<List<CriterionAndEvaluator>> orderedObjectives) throws CoreException {
        if (objectiveLine.length < orderedObjectives.size()) {
            throw ExceptionHelper.createNewCoreException("Error when reading in result line: the line is shorter (" + objectiveLine + " entries) than the number of objectives I look for (" + orderedObjectives.size() + "entries).");
        }
        DSEObjectives obj = task != null ? (DSEObjectives)((Object)task.getInstance(DSEObjectives.class)) : new DSEObjectives();
        int lineIndex = 0;
        for (List<CriterionAndEvaluator> criterionList : orderedObjectives) {
            try {
                double d = GenotypeReader.parseToDouble(objectiveLine[lineIndex]);
                for (CriterionAndEvaluator criterionAndEvaluator : criterionList) {
                    Criterion criterion = criterionAndEvaluator.getCriterion();
                    obj.addValueForCriterion(criterion, d);
                }
            }
            catch (NumberFormatException e) {
                throw ExceptionHelper.createNewCoreException("Could not parse objective value " + objectiveLine[lineIndex] + ". Fix your input genome file.");
            }
            ++lineIndex;
        }
        return obj;
    }

    private static double parseToDouble(String number) {
        double d = Double.parseDouble(number);
        if (Double.isInfinite(d)) {
            logger.warn((Object)"Read in an infinite objective or confidence interval from predefined file, please check that this is correct and not result of an incomplete previous analysis step.");
        } else if (Double.isNaN(d)) {
            logger.warn((Object)"Read in an objective or confidence interval with NaN value from predefined file, please check that this is correct and not result of an incomplete previous analysis step.");
        }
        return d;
    }
}

