/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.helper.ExtensionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEAnalysisMethodTab;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.QMLContractType;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.reader.PCMDeclarationsReader;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDimensionReader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.usagemodel.UsageModel;

public class QMLManager {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    protected List<DSEAnalysisMethodTab> tabs = new ArrayList<DSEAnalysisMethodTab>();
    protected boolean qmlLoaded = false;
    protected String diagnosis = null;
    protected PCMDeclarationsReader pcmReader;
    protected QMLDimensionReader dimensionReader = new QMLDimensionReader();
    protected String currentQMLPath = "";
    protected String currentUsageModelPath = "";
    protected DSEAnalysisMethodTab costTab = null;
    protected DSEAnalysisMethodTab pofodTab = null;
    protected DSEAnalysisMethodTab performanceTab = null;
    protected DSEAnalysisMethodTab securityTab = null;
    protected DSEAnalysisMethodTab nqrTab = null;
    protected Set<EvaluationAspectWithContext> objectives = Collections.synchronizedSet(new HashSet(5));

    public List<EvaluationAspectWithContext> getActivatedObjectives() {
        ArrayList<EvaluationAspectWithContext> returnList = new ArrayList<EvaluationAspectWithContext>(this.objectives);
        return returnList;
    }

    public boolean hasActivatedObjectives() {
        return this.objectives.size() > 0;
    }

    public void addTabs(DSEAnalysisMethodTab ... tabs) {
        DSEAnalysisMethodTab[] dSEAnalysisMethodTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            DSEAnalysisMethodTab tab = dSEAnalysisMethodTabArray[n2];
            this.tabs.add(tab);
            if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.PERFORMANCE_QUALITY.getName())) {
                this.performanceTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.COST_QUALITY.getName())) {
                this.costTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.RELIABILITY_QUALITY.getName())) {
                this.pofodTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.SECURITY_QUALITY.getName())) {
                this.securityTab = tab;
            } else if (tab.getId().equals(DSEConstantsContainer.QualityAttribute.NQR_QUALITY.getName())) {
                this.nqrTab = tab;
            }
            ++n2;
        }
    }

    public void processQMLFile(String qmlFilePath, String usageModelFilePath) {
        ArrayList<IExtension> removeList;
        List<IExtension> tmp_exts;
        if (this.currentQMLPath.equals(qmlFilePath) && this.currentUsageModelPath.equals(usageModelFilePath)) {
            return;
        }
        this.currentQMLPath = qmlFilePath;
        this.currentUsageModelPath = usageModelFilePath;
        this.qmlLoaded = false;
        this.objectives.clear();
        this.deactivateAllTabs();
        ResourceSetImpl rs = new ResourceSetImpl();
        UsageModel usageModel = null;
        try {
            URI uri = URI.createURI((String)usageModelFilePath);
            if (!uri.isPlatform() && usageModelFilePath.indexOf("://") < 0) {
                uri = URI.createFileURI((String)usageModelFilePath);
            }
            Resource r = rs.getResource(uri, true);
            EList contents = r.getContents();
            for (Object object : contents) {
                if (!(object instanceof UsageModel)) continue;
                usageModel = (UsageModel)object;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not load usage model from " + usageModelFilePath + ". Error was: " + e.getClass() + " " + e.getMessage()));
            e.printStackTrace();
        }
        if (usageModel == null) {
            this.diagnosis = "Could not load usage model from " + usageModelFilePath + "! Please check the UsageModel file and path!";
            return;
        }
        if (!this.fileExists(qmlFilePath) || !qmlFilePath.endsWith(DSEConstantsContainer.QML_DEFINITION_EXTENSION.substring(DSEConstantsContainer.QML_DEFINITION_EXTENSION.lastIndexOf(46), DSEConstantsContainer.QML_DEFINITION_EXTENSION.length()))) {
            this.diagnosis = "Could not load qml definition model! Please check the path!";
            return;
        }
        this.pcmReader = new PCMDeclarationsReader(qmlFilePath);
        ArrayList<IExtension> exts = new ArrayList<IExtension>();
        List costObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype").getId());
        costObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_initialcost.qmlcontracttype").getId()));
        costObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_operatingcost.qmlcontracttype").getId()));
        List costConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_cost.qmlcontracttype").getId());
        costConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_initialcost.qmlcontracttype").getId()));
        costConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_operatingcost.qmlcontracttype").getId()));
        ArrayList costCriteria = new ArrayList();
        costCriteria.addAll(costObjectives);
        costCriteria.addAll(costConstraints);
        exts.clear();
        int init = 0;
        for (EvaluationAspectWithContext aspect : costCriteria) {
            tmp_exts = this.getExtensionsThatEvaluateAspect(aspect);
            if (init == 0) {
                exts.addAll(tmp_exts);
                ++init;
                continue;
            }
            removeList = new ArrayList<IExtension>();
            for (IExtension e : exts) {
                if (tmp_exts.contains(e)) continue;
                removeList.add(e);
            }
            exts.removeAll(removeList);
        }
        if (this.costTab != null) {
            if (exts.size() == 0) {
                this.costTab.deactivate();
            } else {
                this.costTab.activate(exts);
                this.objectives.addAll(costObjectives);
            }
        }
        List pofodObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_pofod.qmlcontracttype").getId());
        List pofodConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_pofod.qmlcontracttype").getId());
        ArrayList pofodCriteria = new ArrayList();
        pofodCriteria.addAll(pofodObjectives);
        pofodCriteria.addAll(pofodConstraints);
        exts.clear();
        init = 0;
        for (EvaluationAspectWithContext aspect : pofodCriteria) {
            tmp_exts = this.getExtensionsThatEvaluateAspect(aspect);
            if (init == 0) {
                exts.addAll(tmp_exts);
                ++init;
                continue;
            }
            removeList = new ArrayList();
            for (IExtension e : exts) {
                if (tmp_exts.contains(e)) continue;
                removeList.add(e);
            }
            exts.removeAll(removeList);
        }
        if (this.pofodTab != null) {
            if (exts.size() == 0) {
                this.pofodTab.deactivate();
            } else {
                this.pofodTab.activate(exts);
                this.objectives.addAll(pofodObjectives);
            }
        }
        List securityObjectives = null;
        try {
            securityObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_security.qmlcontracttype").getId());
            List securityConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_security.qmlcontracttype").getId());
            ArrayList securityCriteria = new ArrayList();
            securityCriteria.addAll(securityObjectives);
            securityCriteria.addAll(securityConstraints);
            exts.clear();
            init = 0;
            for (EvaluationAspectWithContext aspect : securityCriteria) {
                tmp_exts = this.getExtensionsThatEvaluateAspect(aspect);
                if (init == 0) {
                    exts.addAll(tmp_exts);
                    ++init;
                    continue;
                }
                removeList = new ArrayList();
                for (IExtension e : exts) {
                    if (tmp_exts.contains(e)) continue;
                    removeList.add(e);
                }
                exts.removeAll(removeList);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Security dimension file could not be loaded. Ignoring it.");
            e.printStackTrace();
            exts.clear();
        }
        if (this.securityTab != null) {
            if (exts.size() == 0) {
                this.securityTab.deactivate();
            } else {
                this.securityTab.activate(exts);
                this.objectives.addAll(securityObjectives);
            }
        }
        ArrayList nqrObjectives = new ArrayList();
        ArrayList nqrConstraints = new ArrayList();
        try {
            QMLContractType contractTypeForUsageModel = this.pcmReader.getContractTypeForUsageModel(usageModel);
            for (Dimension dim : contractTypeForUsageModel.getDimensions()) {
                nqrObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, dim.getId()));
                nqrConstraints.addAll(this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, dim.getId()));
            }
            ArrayList nqrCriteria = new ArrayList();
            nqrCriteria.addAll(nqrObjectives);
            nqrCriteria.addAll(nqrConstraints);
            exts.clear();
            IExtension[] availExts = Platform.getExtensionRegistry().getExtensionPoint("de.uka.ipd.sdq.dsexplore.analysis").getExtensions();
            int i = 0;
            while (i < availExts.length) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = availExts[i].getConfigurationElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (element.getName().equals("analysis") && element.getAttribute("qualityAttribute").equals("de.uka.ipd.sdq.dsexplore.nqr")) {
                        exts.add(availExts[i]);
                    }
                    ++n2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"NQR dimension file could not be loaded. Ignoring it.");
            e.printStackTrace();
            exts.clear();
        }
        boolean extentionIntersection = false;
        for (EvaluationAspectWithContext aspect : nqrObjectives) {
            List<IExtension> tmp_exts2 = this.getExtensionsThatEvaluateAspect(aspect);
            if (tmp_exts2.size() > 0) {
                extentionIntersection = true;
                continue;
            }
            extentionIntersection = false;
            break;
        }
        if (this.nqrTab != null) {
            if (exts.size() == 0 || extentionIntersection) {
                this.nqrTab.deactivate();
            } else {
                this.nqrTab.activate(exts);
                for (EvaluationAspectWithContext eawc : nqrObjectives) {
                    if (this.objectives.contains(eawc)) continue;
                    this.objectives.add(eawc);
                }
            }
        }
        List performanceObjectives = this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype").getId());
        performanceObjectives.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype").getId()));
        List performanceConstraints = this.pcmReader.getDimensionConstraintContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype").getId());
        performanceConstraints.addAll(this.pcmReader.getDimensionObjectiveContextsForUsageModel(usageModel, this.dimensionReader.getDimension("pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype").getId()));
        ArrayList performanceCriteria = new ArrayList(performanceObjectives.size() + performanceConstraints.size());
        performanceCriteria.addAll(performanceObjectives);
        performanceCriteria.addAll(performanceConstraints);
        exts.clear();
        init = 0;
        for (EvaluationAspectWithContext aspect : performanceCriteria) {
            List<IExtension> tmp_exts3 = this.getExtensionsThatEvaluateAspect(aspect);
            if (init == 0) {
                exts.addAll(tmp_exts3);
                ++init;
                continue;
            }
            removeList = new ArrayList();
            for (IExtension e : exts) {
                if (tmp_exts3.contains(e)) continue;
                removeList.add(e);
            }
            exts.removeAll(removeList);
        }
        if (this.performanceTab != null) {
            if (exts.size() == 0) {
                this.performanceTab.deactivate();
            } else {
                this.performanceTab.activate(exts);
                this.objectives.addAll(performanceObjectives);
            }
        }
        this.qmlLoaded = true;
    }

    protected void deactivateAllTabs() {
        for (DSEAnalysisMethodTab tab : this.tabs) {
            tab.deactivate();
        }
    }

    protected boolean fileExists(String path) {
        if (path.startsWith("platform:")) {
            try {
                URL solvedURL = FileLocator.resolve((URL)new URL(path));
                path = solvedURL.getPath();
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        File f = new File(path);
        return f.exists();
    }

    protected List<IExtension> getExtensionsThatEvaluateAspect(EvaluationAspectWithContext aspect) {
        List<IExtension> exts = ExtensionHelper.loadAnalysisExtensions(aspect.getDimension().getId());
        ArrayList<IExtension> return_list = new ArrayList<IExtension>(exts);
        for (IExtension ex : exts) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = ex.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAnalysisQualityAttributeDeclaration attribute;
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    attribute = (IAnalysisQualityAttributeDeclaration)ExtensionHelper.loadExecutableAttribute(e, "qualityAttributeHandler");
                }
                catch (CoreException e1) {
                    return_list.clear();
                    return return_list;
                }
                if (!attribute.canEvaluateAspectForDimension(aspect.getEvaluationAspect(), aspect.getDimension())) {
                    return_list.remove(ex);
                }
                ++n2;
            }
        }
        return return_list;
    }

    public boolean isQMLLoaded() {
        return this.qmlLoaded;
    }

    public String getDiagnosis() {
        return this.diagnosis;
    }
}

