/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.genotype;

import de.uka.ipd.sdq.dsexplore.opt4j.genotype.BinaryGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.BinaryGenotypeRepresentation;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.FinalBinaryGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Candidate;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ResourceSelectionDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.specificFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class Adapter {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.genotype.Adapter");
    List<EObject> SERVERS;
    List<EObject> WEBSERVERS;
    List<EObject> COMPONENTS;
    double[] SERVER_INTERVALS = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] CAPACITYDEGREE_INTERVALS = new double[]{0.0, 0.0, 0.0, 0.0};
    Map<Integer, ArrayList<Object>> ContinuousProcessingRateArchiveStorage = new HashMap<Integer, ArrayList<Object>>();
    DecisionSpace problemSpace = Opt4JStarter.getProblem().getEMFProblem();

    public Adapter() {
        logger.info((Object)"The problem is registered in Adapter");
        boolean traversed_AllocationDegree = false;
        boolean traversed_ResourceSelectionDegree = false;
        int count = 0;
        for (DegreeOfFreedomInstance dofi : this.problemSpace.getDegreesOfFreedom()) {
            double diff;
            if (dofi instanceof ContinuousProcessingRateDegree) {
                double server_interval_lowerbound = ((ContinuousProcessingRateDegree)dofi).getFrom();
                double server_interval_upperbound = ((ContinuousProcessingRateDegree)dofi).getTo();
                diff = (server_interval_upperbound - server_interval_lowerbound) / 4.0;
                int i = 0;
                while (i < 4) {
                    this.SERVER_INTERVALS[i] = server_interval_lowerbound + (double)i * diff;
                    ++i;
                }
                this.ContinuousProcessingRateArchiveStorage.put(count, new ArrayList());
                ArrayList arrayList = new ArrayList();
                ArrayList<Double> server_intervals_list = new ArrayList<Double>();
                int i2 = 0;
                while (i2 < this.SERVER_INTERVALS.length) {
                    ArrayList<Double> list = new ArrayList<Double>();
                    double rnum = 0.0;
                    rnum = i2 == 0 ? Math.random() * this.SERVER_INTERVALS[i2] : Math.random() * (this.SERVER_INTERVALS[i2] - this.SERVER_INTERVALS[i2 - 1]) + this.SERVER_INTERVALS[i2 - 1];
                    list.add(rnum);
                    server_intervals_list.add(this.SERVER_INTERVALS[i2]);
                    arrayList.add(list);
                    ++i2;
                }
                this.ContinuousProcessingRateArchiveStorage.get(count).add(arrayList);
                this.ContinuousProcessingRateArchiveStorage.get(count).add(server_intervals_list);
            } else if (dofi instanceof AllocationDegree && !traversed_AllocationDegree) {
                this.SERVERS = ((AllocationDegree)dofi).getClassDesignOptions();
                traversed_AllocationDegree = true;
            } else if (dofi instanceof ResourceSelectionDegree && !traversed_ResourceSelectionDegree) {
                this.WEBSERVERS = ((ResourceSelectionDegree)dofi).getClassDesignOptions();
                traversed_ResourceSelectionDegree = true;
            } else if (dofi instanceof AssembledComponentDegree) {
                this.COMPONENTS = ((AssembledComponentDegree)dofi).getClassDesignOptions();
            } else if (dofi instanceof CapacityDegree) {
                double capacitydegree_interval_lowerbound = ((CapacityDegree)dofi).getFrom();
                double capacitydegree_interval_upperbound = ((CapacityDegree)dofi).getTo();
                diff = (capacitydegree_interval_upperbound - capacitydegree_interval_lowerbound) / 4.0;
                if (diff != 0.0) {
                    int i = 0;
                    while (i < 4) {
                        this.CAPACITYDEGREE_INTERVALS[i] = capacitydegree_interval_lowerbound + (double)i * diff;
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < 4) {
                        this.CAPACITYDEGREE_INTERVALS[i] = this.SERVER_INTERVALS[i];
                        ++i;
                    }
                }
            }
            ++count;
        }
    }

    public static void main(String[] args) {
        HashMap Dict = new HashMap();
        DegreeOfFreedomInstance dof = designdecisionFactory.eINSTANCE.createDegreeOfFreedomInstance();
        ArrayList list = new ArrayList();
        Dict.put(dof, list);
        System.out.println(((ArrayList)Dict.get(dof)).size());
        ((ArrayList)Dict.get(dof)).add(0.0);
        ((ArrayList)Dict.get(dof)).add(1.0);
        System.out.println(((ArrayList)Dict.get(dof)).get(1));
    }

    public List<BinaryGenotype> translateDesignDecisionGenotype(DesignDecisionGenotype DDGenotype) {
        List<Choice> ChoiceList = DDGenotype.getInternalList();
        ArrayList<BinaryGenotype> TranslatedGenotype = new ArrayList<BinaryGenotype>();
        Iterator<Choice> ChoiceIteratorInstance = ChoiceList.iterator();
        int i = 0;
        while (i < ChoiceList.size()) {
            Choice ChoiceIterator = ChoiceIteratorInstance.next();
            if (ChoiceIterator.getDegreeOfFreedomInstance() instanceof ContinuousProcessingRateDegree) {
                double ServerSpeed = (Double)ChoiceIterator.getValue();
                List<Integer> ServerBinaryRep = this.getServerBinaryRep(ServerSpeed, i);
                int w = 0;
                while (w < ServerBinaryRep.size()) {
                    if (ServerBinaryRep.get(w) == 1) {
                        ((ArrayList)((ArrayList)this.ContinuousProcessingRateArchiveStorage.get(i).get(0)).get(w)).add(ServerSpeed);
                    }
                    ++w;
                }
                BinaryGenotype<Integer> ServerBinaryGenotypeObj = new BinaryGenotype<Integer>(ServerBinaryRep, BinaryGenotypeRepresentation.TypeOfDegree.ContinuousProcessingRateDegree);
                TranslatedGenotype.add(ServerBinaryGenotypeObj);
            } else if (ChoiceIterator.getDegreeOfFreedomInstance() instanceof ResourceSelectionDegree) {
                EObject WebServer = ((ClassChoice)ChoiceIterator).getChosenValue();
                List<Integer> WebServerBinaryRep = this.getWebServerBinaryRep(WebServer);
                BinaryGenotype<Integer> WebServerBinaryGenotypeObj = new BinaryGenotype<Integer>(WebServerBinaryRep, BinaryGenotypeRepresentation.TypeOfDegree.ResourceSelectionDegree);
                TranslatedGenotype.add(WebServerBinaryGenotypeObj);
            } else if (ChoiceIterator.getDegreeOfFreedomInstance() instanceof AllocationDegree) {
                EObject AllocatedServer = ((ClassChoice)ChoiceIterator).getChosenValue();
                List<Integer> AllocatedServerBinaryRep = this.getAllocatedServerBinaryRep(AllocatedServer);
                BinaryGenotype<Integer> AllocatedServerBinaryGenotypeObj = new BinaryGenotype<Integer>(AllocatedServerBinaryRep, BinaryGenotypeRepresentation.TypeOfDegree.AllocationDegree);
                TranslatedGenotype.add(AllocatedServerBinaryGenotypeObj);
            } else if (ChoiceIterator.getDegreeOfFreedomInstance() instanceof AssembledComponentDegree) {
                EObject AllocatedComponent = ((ClassChoice)ChoiceIterator).getChosenValue();
                List<Integer> AllocatedComponentBinaryRep = this.getAllocatedComponentBinaryRep(AllocatedComponent);
                BinaryGenotype<Integer> AllocatedComponentBinaryGenotypeObj = new BinaryGenotype<Integer>(AllocatedComponentBinaryRep, BinaryGenotypeRepresentation.TypeOfDegree.AssembledComponentDegree);
                TranslatedGenotype.add(AllocatedComponentBinaryGenotypeObj);
            } else if (ChoiceIterator.getDegreeOfFreedomInstance() instanceof CapacityDegree) {
                double capacityDegreeValue = ((Integer)ChoiceIterator.getValue()).intValue();
                List<Integer> capacityDegreeValueBinaryRep = this.getCapacityBinaryRep(capacityDegreeValue);
                BinaryGenotype<Integer> capacityDegreeValueBinaryGenotypeObj = new BinaryGenotype<Integer>(capacityDegreeValueBinaryRep, BinaryGenotypeRepresentation.TypeOfDegree.CapacityDegree);
                TranslatedGenotype.add(capacityDegreeValueBinaryGenotypeObj);
            } else {
                this.throwOutOfScopeDegreeException(ChoiceIterator.getDegreeOfFreedomInstance());
            }
            ++i;
        }
        return TranslatedGenotype;
    }

    public DesignDecisionGenotype translateFinalBinaryGenotype(FinalBinaryGenotype FBGenotype) {
        ArrayList<BinaryGenotype> TranslatedBGObjects = new ArrayList<BinaryGenotype>();
        int i = 0;
        while (i < FBGenotype.getBitsPerDegree().size()) {
            ArrayList<Integer> BinaryString = new ArrayList<Integer>();
            int j = 0;
            while (j < FBGenotype.getBitsPerDegree().get(i)) {
                BinaryString.add(FBGenotype.getBinaryGenotype().remove(0));
                ++j;
            }
            BinaryGenotype BGObject = new BinaryGenotype(BinaryString, FBGenotype.getOrderOfDegrees().get(i));
            TranslatedBGObjects.add(BGObject);
            ++i;
        }
        this.makeCompatible(TranslatedBGObjects);
        ArrayList<ContinousRangeChoice> ChoiceObjectList = new ArrayList<ContinousRangeChoice>();
        int i2 = 0;
        while (i2 < TranslatedBGObjects.size()) {
            ContinuousProcessingRateDegree DegreeObject;
            ContinousRangeChoice ChoiceObject;
            List BinaryList;
            if (((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType().toString() == "ContinuousProcessingRateDegree") {
                BinaryList = ((BinaryGenotype)TranslatedBGObjects.get(i2)).getInternalList();
                logger.info(BinaryList);
                ChoiceObject = designdecisionFactory.eINSTANCE.createContinousRangeChoice();
                int j = 0;
                while (j < BinaryList.size()) {
                    if ((Integer)BinaryList.get(j) == 1) {
                        Random rnum = new Random();
                        double ServerSpeedValue = (Double)((ArrayList)((ArrayList)this.ContinuousProcessingRateArchiveStorage.get(i2).get(0)).get(j)).get(rnum.nextInt(((ArrayList)((ArrayList)this.ContinuousProcessingRateArchiveStorage.get(i2).get(0)).get(j)).size()));
                        ChoiceObject.setValue((Object)ServerSpeedValue);
                        logger.info((Object)("Adapter Line 528: The ServerSpeedValue is " + Double.valueOf(ServerSpeedValue).toString()));
                    }
                    ++j;
                }
                DegreeObject = specificFactory.eINSTANCE.createContinuousProcessingRateDegree();
                DegreeObject.setEntityName("Server Speed");
                ChoiceObject.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)DegreeObject);
                ChoiceObjectList.add(ChoiceObject);
            } else if (((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType() == BinaryGenotypeRepresentation.TypeOfDegree.ResourceSelectionDegree) {
                BinaryList = ((BinaryGenotype)TranslatedBGObjects.get(i2)).getInternalList();
                ChoiceObject = designdecisionFactory.eINSTANCE.createClassChoice();
                int j = 0;
                while (j < BinaryList.size()) {
                    if ((Integer)BinaryList.get(j) == 1) {
                        ((ClassChoice)ChoiceObject).setChosenValue(this.WEBSERVERS.get(j));
                    }
                    ++j;
                }
                DegreeObject = specificFactory.eINSTANCE.createResourceSelectionDegree();
                DegreeObject.setEntityName("WebServer");
                ChoiceObject.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)DegreeObject);
                ChoiceObjectList.add(ChoiceObject);
            } else if (((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType() == BinaryGenotypeRepresentation.TypeOfDegree.AllocationDegree) {
                BinaryList = ((BinaryGenotype)TranslatedBGObjects.get(i2)).getInternalList();
                ChoiceObject = designdecisionFactory.eINSTANCE.createClassChoice();
                int j = 0;
                while (j < BinaryList.size()) {
                    if ((Integer)BinaryList.get(j) == 1) {
                        ChoiceObject.setChosenValue(this.SERVERS.get(j));
                    }
                    ++j;
                }
                DegreeObject = specificFactory.eINSTANCE.createAllocationDegree();
                DegreeObject.setEntityName("Allocation Degree");
                ChoiceObject.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)DegreeObject);
                ChoiceObjectList.add(ChoiceObject);
            } else if (((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType() == BinaryGenotypeRepresentation.TypeOfDegree.AssembledComponentDegree) {
                BinaryList = ((BinaryGenotype)TranslatedBGObjects.get(i2)).getInternalList();
                ChoiceObject = designdecisionFactory.eINSTANCE.createClassChoice();
                int j = 0;
                while (j < BinaryList.size()) {
                    if ((Integer)BinaryList.get(j) == 1) {
                        ChoiceObject.setChosenValue(this.COMPONENTS.get(j));
                    }
                    ++j;
                }
                DegreeObject = specificFactory.eINSTANCE.createAssembledComponentDegree();
                DegreeObject.setEntityName("AssembledComponent Degree");
                ChoiceObject.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)DegreeObject);
                ChoiceObjectList.add(ChoiceObject);
            } else if (((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType() == BinaryGenotypeRepresentation.TypeOfDegree.CapacityDegree) {
                BinaryList = ((BinaryGenotype)TranslatedBGObjects.get(i2)).getInternalList();
                ChoiceObject = designdecisionFactory.eINSTANCE.createDiscreteRangeChoice();
                int j = 0;
                while (j < BinaryList.size()) {
                    if ((Integer)BinaryList.get(j) == 1) {
                        int CapacityDegreeValue = 1;
                        ChoiceObject.setValue((Object)CapacityDegreeValue);
                    }
                    ++j;
                }
                DegreeObject = specificFactory.eINSTANCE.createCapacityDegree();
                DegreeObject.setEntityName("Capacity Degree");
                ChoiceObject.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)DegreeObject);
                ChoiceObjectList.add(ChoiceObject);
            } else {
                this.throwUnidentifiedObjectException((Object)((BinaryGenotype)TranslatedBGObjects.get(i2)).getDegreeType());
            }
            ++i2;
        }
        logger.info((Object)"Line 595: FBGeno");
        Candidate CandidateObject = designdecisionFactory.eINSTANCE.createCandidate();
        CandidateObject.getChoices().addAll(ChoiceObjectList);
        DesignDecisionGenotype FinalDesignDecisionGenotype = new DesignDecisionGenotype(CandidateObject);
        return FinalDesignDecisionGenotype;
    }

    private List<Integer> getServerBinaryRep(double serverSpeed, int key) {
        Double[] Server_Intervals = new Double[((List)this.ContinuousProcessingRateArchiveStorage.get(key).get(1)).size()];
        ((List)this.ContinuousProcessingRateArchiveStorage.get(key).get(1)).toArray(Server_Intervals);
        boolean FOUNDINTERVAL = false;
        ArrayList<Integer> Result = new ArrayList<Integer>();
        int i = 0;
        while (i < Server_Intervals.length) {
            if (serverSpeed < Server_Intervals[i] & !FOUNDINTERVAL) {
                Result.add(1);
                FOUNDINTERVAL = true;
            } else {
                Result.add(0);
            }
            ++i;
        }
        return Result;
    }

    private List<Integer> getWebServerBinaryRep(EObject webServer) {
        ArrayList<Integer> Result = new ArrayList<Integer>();
        int i = 0;
        while (i < this.WEBSERVERS.size()) {
            if (webServer.equals(this.WEBSERVERS.get(i))) {
                Result.add(1);
            } else {
                Result.add(0);
            }
            ++i;
        }
        return Result;
    }

    private List<Integer> getAllocatedServerBinaryRep(EObject allocatedServer) {
        ArrayList<Integer> Result = new ArrayList<Integer>();
        int i = 0;
        while (i < this.SERVERS.size()) {
            if (allocatedServer.equals(this.SERVERS.get(i))) {
                Result.add(1);
            } else {
                Result.add(0);
            }
            ++i;
        }
        return Result;
    }

    private List<Integer> getAllocatedComponentBinaryRep(EObject allocatedComponent) {
        ArrayList<Integer> Result = new ArrayList<Integer>();
        int i = 0;
        while (i < this.COMPONENTS.size()) {
            if (allocatedComponent.equals(this.COMPONENTS.get(i))) {
                Result.add(1);
            } else {
                Result.add(0);
            }
            ++i;
        }
        return Result;
    }

    private List<Integer> getCapacityBinaryRep(double capacityDegreeValue) {
        boolean FOUNDINTERVAL = false;
        ArrayList<Integer> Result = new ArrayList<Integer>();
        int i = 0;
        while (i < this.CAPACITYDEGREE_INTERVALS.length) {
            if (capacityDegreeValue < this.SERVER_INTERVALS[i] & !FOUNDINTERVAL) {
                Result.add(1);
                FOUNDINTERVAL = true;
            } else {
                Result.add(0);
            }
            ++i;
        }
        return Result;
    }

    private void throwOutOfScopeDegreeException(DegreeOfFreedomInstance dd) {
        throw new RuntimeException("The degree of freedom " + dd.toString() + " is out of scope for the current version of Adapter.");
    }

    private void throwUnidentifiedObjectException(Object dd) {
        throw new RuntimeException("The object " + dd.toString() + " is not identified/out of scope for the current version of Adapter.");
    }

    private void makeCompatible(List<BinaryGenotype> bg) {
        int i = 0;
        while (i < bg.size()) {
            List<Integer> binaryList = bg.get(i).getInternalList();
            if (!binaryList.contains(1)) {
                Random random = new Random();
                binaryList.set(random.nextInt(binaryList.size() - 1), 1);
            } else {
                int index = 0;
                int j = 0;
                while (j < binaryList.size()) {
                    if ((Integer)binaryList.get(j) == 1) {
                        index = j;
                    }
                    ++j;
                }
                j = 0;
                while (j < binaryList.size()) {
                    if (j != index) {
                        binaryList.set(j, 0);
                    }
                    ++j;
                }
                bg.get(i).setInternalList(binaryList);
            }
            ++i;
        }
    }
}

