/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.Pair;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.ComponentAndServiceResult;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl.ResourceContainerWithDoubleValue;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Criterion;
import org.opt4j.core.Genotype;
import org.opt4j.core.Objective;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.ResultDecoratorRepository;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.AllocationServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.repositorydecorator.ServiceResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.LinkingResourceResults;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ComputedAggregatedUsage;
import org.palladiosimulator.solver.context.aggregatedUsageContext.ServiceExecutionContext;

public class ReallocateForReduceLinkUsage
extends AbstractTactic {
    private double thresholdUtilisation;
    private Objective performance;
    protected static Logger logger = Logger.getLogger((String)ReallocateForReduceLinkUsage.class.getName());

    public ReallocateForReduceLinkUsage(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype"});
        this.setHeuristicWeight(1.0);
        this.thresholdUtilisation = 0.8;
        try {
            Collection<Objective> objectives = Opt4JStarter.getDSEEvaluator().getObjectives();
            for (Objective objective : objectives) {
                if (!objective.getName().contains(DSEConstantsContainer.QualityAttribute.PERFORMANCE_QUALITY.getName())) continue;
                this.performance = objective;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultsCache) {
        if (this.performance != null && individual.getObjectives().getResultDecoratorFor((Criterion)this.performance) != null) {
            ResultDecoratorRepository resultRepo = individual.getObjectives().getResultDecoratorFor((Criterion)this.performance);
            LinkingResourceResults linkWithHighestUtil = resultsCache.getMaxLinkUtilisationResult(individual);
            if (linkWithHighestUtil != null) {
                EList connectedContainers = linkWithHighestUtil.getLinkingResource_LinkingResourceResults().getConnectedResourceContainers_LinkingResource();
                if (linkWithHighestUtil.getResourceUtilisation() > this.thresholdUtilisation) {
                    EList serviceResultList = resultRepo.getServiceResult_ResultDecoratorRepository();
                    serviceResultList.size();
                    ArrayList<ComponentAndServiceResult> componentsAndServices = new ArrayList<ComponentAndServiceResult>();
                    for (ServiceResult serviceResult : serviceResultList) {
                        if (serviceResult instanceof AllocationServiceResult) {
                            AllocationServiceResult allocServiceResult = (AllocationServiceResult)serviceResult;
                            AllocationContext component = allocServiceResult.getAllocationContext_AllocationServiceResult();
                            if (component == null) continue;
                            ComponentAndServiceResult compReslt = null;
                            for (ComponentAndServiceResult componentAndServiceResult : componentsAndServices) {
                                if (!EMFHelper.checkIdentity((EObject)componentAndServiceResult.getComponent(), (EObject)component)) continue;
                                compReslt = componentAndServiceResult;
                                break;
                            }
                            if (compReslt == null) {
                                compReslt = new ComponentAndServiceResult(component, individual);
                            }
                            compReslt.addAllocationServiceResult(allocServiceResult);
                            continue;
                        }
                        logger.error((Object)("An unknown type of service results has been encountered, expected " + AllocationServiceResult.class.getName() + " only. Encountered type is " + serviceResult.getClass().getName()));
                    }
                    ComputedAggregatedUsage computedUsage = individual.getObjectives().getComputedAggregatedUsageFor((Criterion)this.performance);
                    if (computedUsage != null) {
                        EList serviceContexts = computedUsage.getServiceExecutionContexts_ComputedAggregatedUsage();
                        for (ServiceExecutionContext serviceExecutionContext : serviceContexts) {
                            AllocationContext component = serviceExecutionContext.getAllocationContext_ServiceExecutionContext();
                            ComponentAndServiceResult compReslt = null;
                            for (ComponentAndServiceResult componentAndServiceResult : componentsAndServices) {
                                if (!EMFHelper.checkIdentity((EObject)componentAndServiceResult.getComponent(), (EObject)component)) continue;
                                compReslt = componentAndServiceResult;
                                break;
                            }
                            if (compReslt == null) {
                                compReslt = new ComponentAndServiceResult(component, individual);
                                componentsAndServices.add(compReslt);
                            }
                            compReslt.addServiceExecutionContext(serviceExecutionContext);
                        }
                        for (ComponentAndServiceResult componentAndServiceResult : componentsAndServices) {
                            componentAndServiceResult.countCalls();
                        }
                        Pair<ComponentAndServiceResult, ResourceContainerWithDoubleValue> componentWithTargetContainer = this.getComponentWithHighestRatioToOneOfContainers(componentsAndServices, (List<ResourceContainer>)connectedContainers);
                        return this.createCandidate(componentWithTargetContainer, individual, linkWithHighestUtil.getResourceUtilisation());
                    }
                    logger.warn((Object)("No ComputedUsage found for candidate " + individual.getNumericID() + " , cannot apply linking resource tactic."));
                }
            }
        }
        return Collections.emptyList();
    }

    private List<TacticsResultCandidate> createCandidate(Pair<ComponentAndServiceResult, ResourceContainerWithDoubleValue> componentWithTargetContainer, DSEIndividual individual, double highestUtil) {
        if (componentWithTargetContainer == null || componentWithTargetContainer.getFirst() == null || componentWithTargetContainer.getSecond() == null) {
            return Collections.emptyList();
        }
        double candidateWeight = Math.max(1.0, (Double)componentWithTargetContainer.getSecond().getSecond() * ((highestUtil - this.thresholdUtilisation) / (1.0 - this.thresholdUtilisation)));
        ArrayList<TacticsResultCandidate> result = new ArrayList<TacticsResultCandidate>(1);
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        candidate.setHeuristic(this);
        candidate.setCandidateWeight(candidateWeight);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !EcoreUtil.equals((EObject)choice.getDegreeOfFreedomInstance(), (EObject)componentWithTargetContainer.getFirst().getAllocationDegree())) continue;
            ((ClassChoice)choice).setChosenValue((EObject)EMFHelper.retrieveEntityByID((List<? extends EObject>)((ClassDegree)choice.getDegreeOfFreedomInstance()).getClassDesignOptions(), (EObject)componentWithTargetContainer.getSecond().getFirst()));
            result.add(candidate);
            break;
        }
        return result;
    }

    private Pair<ComponentAndServiceResult, ResourceContainerWithDoubleValue> getComponentWithHighestRatioToOneOfContainers(List<ComponentAndServiceResult> componentsAndServices, List<ResourceContainer> connectedContainers) {
        Pair<ComponentAndServiceResult, ResourceContainerWithDoubleValue> componentWithTargetContainer = null;
        for (ComponentAndServiceResult componentResult : componentsAndServices) {
            ResourceContainerWithDoubleValue maxContainerOfComponent = componentResult.getMostPromisingContainerToReallocateTo(connectedContainers);
            if (maxContainerOfComponent == null || !((Double)maxContainerOfComponent.getSecond() > 0.5) || componentWithTargetContainer != null && !((Double)maxContainerOfComponent.getSecond() > (Double)((ResourceContainerWithDoubleValue)componentWithTargetContainer.getSecond()).getSecond())) continue;
            componentWithTargetContainer = new Pair<ComponentAndServiceResult, ResourceContainerWithDoubleValue>(componentResult, maxContainerOfComponent);
        }
        return componentWithTargetContainer;
    }
}

