/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.impl;

import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.AbstractTactic;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.TacticsResultCandidate;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.operators.UtilisationResultCacheAndHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividualFactory;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Genotype;
import org.opt4j.operator.copy.Copy;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.ProcessingResourceSpecificationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.UtilisationResult;
import org.palladiosimulator.analyzer.resultdecorator.resourceenvironmentdecorator.impl.ProcessingResourceSpecificationResultImpl;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class ServerExpansionImpl
extends AbstractTactic {
    private int maxNumberOfReplacements;
    private double thresholdHighUtilisation;
    private Random generator = new Random();
    private UtilisationResultCacheAndHelper resultInterpretationHelper = new UtilisationResultCacheAndHelper();

    public ServerExpansionImpl(Copy<Genotype> copy, DSEIndividualFactory individualFactory, DSEWorkflowConfiguration configuration) {
        super(copy, individualFactory, configuration, new String[]{"pathmap://PCM_MODELS/Dimension_responsetime.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_throughput.qmlcontracttype", "pathmap://PCM_MODELS/Dimension_maxCPUUtilization.qmlcontracttype"});
        this.setHeuristicWeight(configuration.getServerExpansionWeight());
        this.maxNumberOfReplacements = configuration.getServerExpansionMaxNumberOfReplacements();
        this.thresholdHighUtilisation = configuration.getServerExpansionThresholdHighUtilisation();
    }

    private boolean doesMatchHighUtilisation(DSEIndividual individual) {
        ProcessingResourceSpecificationResult maxUtilisationResult = this.resultInterpretationHelper.getMaxProcUtilisationResult(individual);
        return maxUtilisationResult != null && maxUtilisationResult.getResourceUtilisation() >= this.thresholdHighUtilisation;
    }

    public boolean doesMatchPrecondition(DSEIndividual individual) {
        return this.doesMatchHighUtilisation(individual) && !this.resultInterpretationHelper.getUnusedAvailableResourceContainers(individual).isEmpty();
    }

    @Override
    public List<TacticsResultCandidate> getHeuristicCandidates(DSEIndividual individual, UtilisationResultCacheAndHelper resultsHelper) {
        this.resultInterpretationHelper = resultsHelper;
        ArrayList<TacticsResultCandidate> candidates = new ArrayList<TacticsResultCandidate>();
        if (this.doesMatchPrecondition(individual)) {
            ProcessingResourceSpecificationResult maxUtilisationResult = this.resultInterpretationHelper.getMaxProcUtilisationResult(individual);
            ProcessingResourceSpecification maxProcessingResourceSpec = ((ProcessingResourceSpecificationResultImpl)maxUtilisationResult).getProcessingResourceSpecification_ProcessingResourceSpecificationResult();
            ResourceContainer resourceContainer = (ResourceContainer)maxProcessingResourceSpec.eContainer();
            this.createServerMultiplicityExpansionCandidates(individual, candidates, maxUtilisationResult, resourceContainer);
            this.createClassicServerExpansionCandidates(individual, candidates, maxUtilisationResult, resourceContainer);
        }
        return candidates;
    }

    private void createServerMultiplicityExpansionCandidates(DSEIndividual individual, List<TacticsResultCandidate> candidates, ProcessingResourceSpecificationResult maxUtilisationResult, ResourceContainer resourceContainer) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            DiscreteRangeChoice discreteChoice;
            ResourceContainerReplicationDegree replDegree;
            Choice choice = iterator.next();
            if (!(choice instanceof DiscreteRangeChoice) || !(choice.getDegreeOfFreedomInstance() instanceof ResourceContainerReplicationDegree) || !EMFHelper.checkIdentity((replDegree = (ResourceContainerReplicationDegree)choice.getDegreeOfFreedomInstance()).getPrimaryChanged(), (EObject)resourceContainer) || (discreteChoice = (DiscreteRangeChoice)choice).getChosenValue() >= (replDegree.isUpperBoundIncluded() ? replDegree.getTo() : replDegree.getTo() - 1)) continue;
            discreteChoice.setChosenValue(discreteChoice.getChosenValue() + 1);
            candidate.setCandidateWeight(this.getCandidateWeight((UtilisationResult)maxUtilisationResult));
            candidate.setHeuristic(this);
            candidates.add(candidate);
            this.increaseCounterOfGeneratedCandidates();
        }
    }

    private void createClassicServerExpansionCandidates(DSEIndividual individual, List<TacticsResultCandidate> candidates, ProcessingResourceSpecificationResult maxUtilisationResult, ResourceContainer resourceContainer) {
        TacticsResultCandidate candidate = this.individualFactory.buildCandidate(this.copy.copy((Genotype)individual.getGenotype()), individual);
        ResourceContainer targetResourceContainer = this.getRandomUnusedResourceContainer(individual);
        LinkedList<ClassChoice> componentsAllocatedHere = new LinkedList<ClassChoice>();
        Iterator<Choice> iterator = candidate.getGenotype().iterator();
        while (iterator.hasNext()) {
            ClassChoice ClassChoice2;
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice) || !((ClassChoice2 = (ClassChoice)choice).getDegreeOfFreedomInstance() instanceof AllocationDegree) || !EMFHelper.checkIdentity(ClassChoice2.getChosenValue(), (EObject)resourceContainer)) continue;
            componentsAllocatedHere.add(ClassChoice2);
        }
        int halfOfFoundComponents = componentsAllocatedHere.size() / 2;
        int reallocateAtMost = halfOfFoundComponents > this.maxNumberOfReplacements ? this.maxNumberOfReplacements : halfOfFoundComponents;
        int i = 0;
        while (i < reallocateAtMost && componentsAllocatedHere.size() > 0) {
            ClassChoice classChoice = (ClassChoice)componentsAllocatedHere.get(this.generator.nextInt(componentsAllocatedHere.size()));
            Entity targetResourceContainerInMemory = EMFHelper.retrieveEntityByID((List<? extends EObject>)((ClassDegree)classChoice.getDegreeOfFreedomInstance()).getClassDesignOptions(), (EObject)targetResourceContainer);
            if (targetResourceContainerInMemory != null) {
                classChoice.setChosenValue((EObject)targetResourceContainerInMemory);
            } else {
                --i;
            }
            componentsAllocatedHere.remove(classChoice);
            ++i;
        }
        candidate.setCandidateWeight(this.getCandidateWeight((UtilisationResult)maxUtilisationResult));
        candidate.setHeuristic(this);
        candidates.add(candidate);
        this.increaseCounterOfGeneratedCandidates();
    }

    private double getCandidateWeight(UtilisationResult utilisationResult) {
        return Math.min(1.0, Math.max(utilisationResult.getResourceUtilisation() / (1.0 - this.thresholdHighUtilisation) - this.thresholdHighUtilisation / (1.0 - this.thresholdHighUtilisation), 0.0));
    }

    private ResourceContainer getRandomUnusedResourceContainer(DSEIndividual individual) {
        Random random = new Random();
        Collection<ResourceContainer> resourceContainers = this.resultInterpretationHelper.getUnusedAvailableResourceContainers(individual);
        int randomInt = random.nextInt(resourceContainers.size());
        int n = 0;
        for (ResourceContainer container : resourceContainers) {
            if (n == randomInt) {
                return container;
            }
            ++n;
        }
        return null;
    }
}

