/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.startingPopulation.impl;

import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.operator.CopyDesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.optimizer.heuristic.startingPopulation.AbstractStartingPopulationHeuristic;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEIndividual;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.TerminationException;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class StartingPopulationHeuristicImpl
extends AbstractStartingPopulationHeuristic {
    private final int minNumberOfResourceContainers;
    private final int maxNumberOfResourceContainers;
    private static final int MAX_TRIES = 50;
    private final int numberOfCandidatesPerAllocationLevel;

    public StartingPopulationHeuristicImpl(DSEWorkflowConfiguration configuration) {
        super(configuration);
        this.minNumberOfResourceContainers = configuration.getMinNumberOfResourceContainers();
        this.maxNumberOfResourceContainers = configuration.getMaxNumberOfResourceContainers();
        this.numberOfCandidatesPerAllocationLevel = configuration.getNumberOfCandidatesPerAllocationLevel();
    }

    public static ArrayList<Integer> getNumberOfComponentsPerResourceContainer(int numberOfComponents, int numberOfResourceContainers) {
        if (numberOfResourceContainers <= 0 || numberOfComponents < 0) {
            throw new IllegalArgumentException();
        }
        int numberOfServersWithLessComponents = (int)(((double)numberOfComponents - Math.ceil((double)numberOfComponents / (double)numberOfResourceContainers) * (double)numberOfResourceContainers) / (Math.floor((double)numberOfComponents / (double)numberOfResourceContainers) - Math.ceil((double)numberOfComponents / (double)numberOfResourceContainers)));
        ArrayList<Integer> numberOfComponentsPerResourceContainer = new ArrayList<Integer>(numberOfResourceContainers);
        int i = 1;
        while (i <= numberOfResourceContainers) {
            if (i <= numberOfServersWithLessComponents) {
                numberOfComponentsPerResourceContainer.add((int)Math.floor((double)numberOfComponents / (double)numberOfResourceContainers));
            } else {
                numberOfComponentsPerResourceContainer.add((int)Math.ceil((double)numberOfComponents / (double)numberOfResourceContainers));
            }
            ++i;
        }
        return numberOfComponentsPerResourceContainer;
    }

    @Override
    public Collection<DSEIndividual> getStartingPopulation(IndividualCompleter completer, IndividualFactory individualFactory, DSEIndividual baseIndividual) {
        LinkedList<DSEIndividual> result = new LinkedList<DSEIndividual>();
        Collection<DSEIndividual> population = this.getStartingPopulationWithDefaultProcessingRate(completer, individualFactory, baseIndividual);
        result.addAll(this.getAdjustedProcessingRatePopulation(population, individualFactory, PROCESSING_RATE_LEVEL.MAX));
        result.addAll(this.getAdjustedProcessingRatePopulation(population, individualFactory, PROCESSING_RATE_LEVEL.MIN));
        result.addAll(this.getAdjustedProcessingRatePopulation(population, individualFactory, PROCESSING_RATE_LEVEL.LESS));
        result.addAll(this.getAdjustedProcessingRatePopulation(population, individualFactory, PROCESSING_RATE_LEVEL.MORE));
        result.addAll(population);
        return result;
    }

    private Collection<DSEIndividual> getAdjustedProcessingRatePopulation(Collection<DSEIndividual> population, IndividualFactory individualFactory, PROCESSING_RATE_LEVEL processingRateLevel) {
        CopyDesignDecisionGenotype copy = new CopyDesignDecisionGenotype();
        LinkedList<DSEIndividual> result = new LinkedList<DSEIndividual>();
        for (DSEIndividual individual : population) {
            DSEIndividual newIndividual = (DSEIndividual)individualFactory.create((Genotype)copy.copy(individual.getGenotype()));
            result.add(newIndividual);
        }
        for (DSEIndividual individual : result) {
            Iterator<Choice> iterator = individual.getGenotype().iterator();
            while (iterator.hasNext()) {
                Choice choice = iterator.next();
                if (!(choice instanceof ContinousRangeChoice)) continue;
                ContinousRangeChoice continousRangeChoice = (ContinousRangeChoice)choice;
                DegreeOfFreedomInstance DegreeOfFreedomInstance2 = choice.getDegreeOfFreedomInstance();
                if (!(DegreeOfFreedomInstance2 instanceof ContinuousProcessingRateDegree)) continue;
                ContinuousProcessingRateDegree processingRateDegree = (ContinuousProcessingRateDegree)DegreeOfFreedomInstance2;
                double newProcessingRate = continousRangeChoice.getChosenValue();
                switch (processingRateLevel) {
                    case MIN: {
                        newProcessingRate = processingRateDegree.getFrom();
                        break;
                    }
                    case LESS: {
                        newProcessingRate = (processingRateDegree.getFrom() + continousRangeChoice.getChosenValue()) / 2.0;
                        break;
                    }
                    case DEFAULT: {
                        newProcessingRate = continousRangeChoice.getChosenValue();
                        break;
                    }
                    case MORE: {
                        newProcessingRate = (processingRateDegree.getTo() + continousRangeChoice.getChosenValue()) / 2.0;
                        break;
                    }
                    case MAX: {
                        newProcessingRate = processingRateDegree.getTo();
                    }
                }
                continousRangeChoice.setChosenValue(newProcessingRate);
            }
        }
        return result;
    }

    private Collection<DSEIndividual> getStartingPopulationWithDefaultProcessingRate(IndividualCompleter completer, IndividualFactory individualFactory, DSEIndividual firstIndividual) {
        LinkedList<DSEIndividual> population = new LinkedList<DSEIndividual>();
        CopyDesignDecisionGenotype copy = new CopyDesignDecisionGenotype();
        if (this.minNumberOfResourceContainers > this.maxNumberOfResourceContainers) {
            throw new IllegalArgumentException("Minimum number of resource containers cannot be larger than maximum number of containers. Check your starting population heuristic settings.");
        }
        if (this.maxNumberOfResourceContainers > this.getResourceContainers().size()) {
            throw new IllegalArgumentException("There are not enough resource containers available. Decrease the \"maximum number of resource containers\" setting in the starting population heuristic configuration in your launch configuration.");
        }
        int numberOfResourceContainers = this.minNumberOfResourceContainers;
        while (numberOfResourceContainers <= this.maxNumberOfResourceContainers) {
            ArrayList<DSEIndividual> individualsForAllocation = new ArrayList<DSEIndividual>();
            int tries = 0;
            while (individualsForAllocation.size() < this.numberOfCandidatesPerAllocationLevel && tries <= this.numberOfCandidatesPerAllocationLevel + 50) {
                ArrayList<Integer> allocation = StartingPopulationHeuristicImpl.getNumberOfComponentsPerResourceContainer(this.getAllocationContexts().size(), numberOfResourceContainers);
                DSEIndividual newIndividual = (DSEIndividual)individualFactory.create((Genotype)copy.copy(firstIndividual.getGenotype()));
                if (!individualsForAllocation.contains((Object)(newIndividual = (DSEIndividual)this.getRandomIndividual(allocation, newIndividual)))) {
                    try {
                        completer.complete(new Individual[]{newIndividual});
                        individualsForAllocation.add(newIndividual);
                    }
                    catch (TerminationException terminationException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                ++tries;
            }
            population.addAll(this.getParetoOptimalIndividuals(individualsForAllocation));
            ++numberOfResourceContainers;
        }
        return population;
    }

    private List<DSEIndividual> getParetoOptimalIndividuals(List<DSEIndividual> individuals) {
        if (individuals.isEmpty()) {
            return null;
        }
        ArrayList<DSEIndividual> toBeRemoved = new ArrayList<DSEIndividual>(individuals.size());
        ArrayList<DSEIndividual> result = new ArrayList<DSEIndividual>(individuals.size());
        result.addAll(individuals);
        int i = 0;
        while (i < individuals.size()) {
            DSEIndividual indiv1 = individuals.get(i);
            int j = i + 1;
            while (j < individuals.size()) {
                DSEIndividual indiv2 = individuals.get(j);
                if (indiv1.getObjectives().dominates(indiv2.getObjectives())) {
                    toBeRemoved.add(indiv2);
                } else if (indiv2.getObjectives().dominates(indiv1.getObjectives())) {
                    toBeRemoved.add(indiv1);
                }
                ++j;
            }
            ++i;
        }
        result.removeAll(toBeRemoved);
        return result;
    }

    private Individual getRandomIndividual(ArrayList<Integer> allocation, Individual individual) {
        ArrayList<Integer> contexts = new ArrayList<Integer>();
        int i = 0;
        while (i < this.getAllocationContexts().size()) {
            contexts.add(new Integer(i));
            ++i;
        }
        i = 0;
        while (i < allocation.size()) {
            this.allocateRandomlyToContainer(individual, this.getResourceContainers().get(i), allocation.get(i), contexts);
            ++i;
        }
        return individual;
    }

    private void allocateRandomlyToContainer(Individual individual, ResourceContainer container, int numberOfAllocationContexts, ArrayList<Integer> contexts) {
        int i = 1;
        while (i <= numberOfAllocationContexts) {
            int randomIndex = StartingPopulationHeuristicImpl.getRandomInt(0, contexts.size() - 1);
            int randomContext = contexts.get(randomIndex);
            this.allocateContextToContainer(container, randomContext, (DSEIndividual)individual);
            contexts.remove(randomIndex);
            ++i;
        }
    }

    private void allocateContextToContainer(ResourceContainer container, int allocationContext, DSEIndividual individual) {
        int iterationCounter = 0;
        Iterator<Choice> iterator = individual.getGenotype().iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            if (!(choice instanceof ClassChoice)) continue;
            ClassChoice ClassChoice2 = (ClassChoice)choice;
            if (ClassChoice2.getDegreeOfFreedomInstance() instanceof AllocationDegree && iterationCounter == allocationContext) {
                boolean foundMatchingServer = false;
                DegreeOfFreedomInstance dof = ClassChoice2.getDegreeOfFreedomInstance();
                if (dof instanceof AllocationDegree) {
                    EList domain = ((AllocationDegree)dof).getClassDesignOptions();
                    for (EObject entity : domain) {
                        if (!(entity instanceof Entity) || !((Entity)entity).getId().equals(container.getId())) continue;
                        ClassChoice2.setChosenValue((EObject)container);
                        foundMatchingServer = true;
                        break;
                    }
                }
                if (!foundMatchingServer) {
                    throw new RuntimeException("Start Population Heuristic only supports design decision files that allow all components to be allocated to all servers. Sorry! Please disable the Starting population heuristic for this model.");
                }
            }
            ++iterationCounter;
        }
    }

    private static int getRandomInt(int from, int to) {
        Random random = new Random();
        return random.nextInt(to - from + 1) + from;
    }

    public static enum PROCESSING_RATE_LEVEL {
        MIN,
        LESS,
        DEFAULT,
        MORE,
        MAX;

    }
}

