/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.helper.ConstraintAndEvaluator;
import de.uka.ipd.sdq.dsexplore.helper.CriterionAndEvaluator;
import de.uka.ipd.sdq.dsexplore.helper.ObjectiveAndEvaluator;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEObjectives;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.ObjectiveAndEvaluatorListDecorator;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.Constraint;
import org.opt4j.core.Constraints;
import org.opt4j.core.Criterion;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.problem.Evaluator;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;

public class DSEEvaluator
implements Evaluator<PCMPhenotype> {
    protected List<ObjectiveAndEvaluator> objectives;
    protected List<ConstraintAndEvaluator> constraints;
    private List<Exception> exceptionList = new ArrayList<Exception>();
    private boolean firstRunSuccessful = false;
    private Map<String, DSEObjectives> phenotypeResultsCache = new HashMap<String, DSEObjectives>();
    private List<IAnalysis> evaluators;
    private IProgressMonitor monitor;
    private Provider<DSEObjectives> objectivesProvider;
    private boolean stopOnInitialFailure;
    private MDSDBlackboard blackboard;
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEEvaluator");

    @Inject
    public DSEEvaluator(Provider<DSEObjectives> provider) {
        this.objectivesProvider = provider;
    }

    public void init(List<IAnalysis> evaluators, IProgressMonitor monitor, MDSDBlackboard blackboard, boolean stopOnInitialFailure) {
        this.blackboard = blackboard;
        DSEEvaluator.copyPCMPartitionToAnalysisSlot(blackboard);
        for (IAnalysis iAnalysis : evaluators) {
            iAnalysis.setBlackboard(blackboard);
        }
        this.initCriterions(evaluators);
        this.monitor = monitor;
        this.evaluators = evaluators;
        this.stopOnInitialFailure = stopOnInitialFailure;
    }

    private void initCriterions(List<IAnalysis> evaluators) {
        this.objectives = new ArrayList<ObjectiveAndEvaluator>();
        this.constraints = new ArrayList<ConstraintAndEvaluator>();
        for (IAnalysis analysis : evaluators) {
            try {
                List<Criterion> criterionList = analysis.getCriterions();
                for (Criterion criterion : criterionList) {
                    if (criterion instanceof Objective) {
                        this.objectives.add(new ObjectiveAndEvaluator((Objective)criterion, analysis));
                        continue;
                    }
                    if (!(criterion instanceof Constraint)) continue;
                    this.constraints.add(new ConstraintAndEvaluator((Constraint)criterion, analysis));
                }
            }
            catch (CoreException e) {
                logger.error((Object)("Could not load quality attribute evaluator " + analysis.getClass()));
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void reset() {
        this.firstRunSuccessful = false;
        this.exceptionList = new ArrayList<Exception>();
    }

    public DSEObjectives evaluate(PCMPhenotype pheno) {
        DSEEvaluator.copyPCMPartitionToAnalysisSlot(this.blackboard);
        DSEObjectives cachedObjective = this.phenotypeResultsCache.get(pheno.getGenotypeID());
        if (cachedObjective != null) {
            return cachedObjective;
        }
        DSEObjectives obj = (DSEObjectives)((Object)this.objectivesProvider.get());
        try {
            for (IAnalysis evaluator : this.evaluators) {
                evaluator.analyse(pheno, this.monitor);
                int i = 0;
                while (i < this.constraints.size()) {
                    if (this.constraints.get(i).getEvaluator() == evaluator) {
                        this.retrieveConstraint(pheno, obj, this.constraints.get(i));
                    }
                    ++i;
                }
            }
        }
        catch (UserCanceledException e) {
            this.fillObjectivesWithInfeasible(obj);
            return obj;
        }
        catch (Exception e) {
            if (!this.firstRunSuccessful && this.stopOnInitialFailure) {
                e.printStackTrace();
                throw new RuntimeException("An exception was raised at the beginning, I assume it makes no sense to continue. See stacktrace for details.", e);
            }
            logger.error((Object)("Quality analysis threw exception, trying to ignoring it and retrieve results. Cause: " + e.getMessage()));
            e.printStackTrace();
        }
        try {
            int i = 0;
            while (i < this.objectives.size()) {
                this.retrieveQuality(pheno, obj, this.objectives.get(i));
                ++i;
            }
            i = 0;
            while (i < this.constraints.size()) {
                this.retrieveConstraint(pheno, obj, this.constraints.get(i));
                ++i;
            }
            this.firstRunSuccessful = true;
            this.phenotypeResultsCache.put(pheno.getGenotypeID(), obj);
            return obj;
        }
        catch (UserCanceledException e) {
            this.fillObjectivesWithInfeasible(obj);
            return obj;
        }
        catch (Exception e) {
            return this.ignoreOrFailWithRuntimeException(obj, e);
        }
    }

    private DSEObjectives ignoreOrFailWithRuntimeException(DSEObjectives obj, Exception e) {
        if (!this.firstRunSuccessful && this.stopOnInitialFailure) {
            e.printStackTrace();
            throw new RuntimeException("An exception was raised at the beginning, I assume it makes no sense to continue. See stacktrace for details.", e);
        }
        this.exceptionList.add(new Exception("Evaluation of a candidate failed. Filling objectves with NaN.", e));
        this.fillObjectivesWithInfeasible(obj);
        this.fillConstraintsWithInfeasible(obj);
        return obj;
    }

    private static void copyPCMPartitionToAnalysisSlot(MDSDBlackboard blackboard) {
        PCMResourceSetPartition analysisPartition = (PCMResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        ResourceSet analysisResourceSet = analysisPartition.getResourceSet();
        analysisResourceSet.getResources().clear();
        PCMResourceSetPartition originalModelPartition = (PCMResourceSetPartition)blackboard.getPartition("initialPCModelPartitionID");
        EList resourceList = originalModelPartition.getResourceSet().getResources();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        for (Resource resource : resourceList) {
            if (resource.getURI().toString().contains("pathmap")) {
                analysisPartition.loadModel(resource.getURI());
                continue;
            }
            EList contentList = resource.getContents();
            Collection copiedContent = copier.copyAll((Collection)contentList);
            Resource newResource = analysisResourceSet.createResource(URI.createURI((String)(resource.getURI() + "cand." + resource.getURI().fileExtension())));
            newResource.getContents().addAll(copiedContent);
        }
        copier.copyReferences();
    }

    private void fillConstraintsWithInfeasible(Objectives obj) {
        Constraints con = obj.getConstraints();
        int i = 0;
        while (i < this.constraints.size()) {
            con.add((Criterion)this.constraints.get(i).getConstraint(), (Value)new DoubleValue(Double.valueOf(Double.NaN)));
            ++i;
        }
    }

    private void fillObjectivesWithInfeasible(Objectives obj) {
        int i = 0;
        while (i < this.objectives.size()) {
            if (obj.size() == i) {
                this.addInfeasibleValue(obj, i);
            }
            ++i;
        }
    }

    private void retrieveQuality(PCMPhenotype pheno, DSEObjectives obj, ObjectiveAndEvaluator o) throws CoreException, UserCanceledException, JobFailedException, AnalysisFailedException {
        IAnalysisResult result = o.getEvaluator().retrieveResultsFor(pheno, (Criterion)o.getObjective());
        obj.add(o.getObjective(), result.getValueFor(o.getCriterion()));
        obj.addResult(o.getObjective(), result);
    }

    private void retrieveConstraint(PCMPhenotype pheno, DSEObjectives obj, ConstraintAndEvaluator o) throws CoreException, UserCanceledException, JobFailedException, AnalysisFailedException {
        IAnalysisResult result = o.getEvaluator().retrieveResultsFor(pheno, (Criterion)o.getConstraint());
        Constraints con = obj.getConstraints();
        con.add((Criterion)o.getConstraint(), result.getValueFor(o.getCriterion()));
    }

    public void retrieveCriterion(PCMPhenotype pheno, DSEObjectives obj, CriterionAndEvaluator criterionAndEvaluator) throws CoreException, UserCanceledException, JobFailedException, AnalysisFailedException {
        if (criterionAndEvaluator instanceof ObjectiveAndEvaluator) {
            this.retrieveQuality(pheno, obj, (ObjectiveAndEvaluator)criterionAndEvaluator);
        } else if (criterionAndEvaluator instanceof ConstraintAndEvaluator) {
            this.retrieveConstraint(pheno, obj, (ConstraintAndEvaluator)criterionAndEvaluator);
        } else {
            throw new RuntimeException("Unknown type of criterion and evaluator" + criterionAndEvaluator.getClass() + ", adjust code in " + this.getClass());
        }
    }

    public Collection<Objective> getObjectives() {
        return new ObjectiveAndEvaluatorListDecorator(this.objectives);
    }

    public List<CriterionAndEvaluator> getCriterionAndEvaluatorList() {
        ArrayList<CriterionAndEvaluator> criterionAndEvaluatorList = new ArrayList<CriterionAndEvaluator>(this.objectives.size() + this.constraints.size());
        criterionAndEvaluatorList.addAll(this.objectives);
        criterionAndEvaluatorList.addAll(this.constraints);
        return criterionAndEvaluatorList;
    }

    public List<Exception> getExceptionList() {
        return this.exceptionList;
    }

    private Double getInfeasibleValue(ObjectiveAndEvaluator objectiveAndEvaluator) {
        if (objectiveAndEvaluator.getObjective().getSign().equals((Object)Objective.Sign.MAX)) {
            return Double.NEGATIVE_INFINITY;
        }
        return Double.POSITIVE_INFINITY;
    }

    private void addInfeasibleValue(Objectives obj, int objectiveIndex) {
        obj.add(this.objectives.get(objectiveIndex).getObjective(), this.getInfeasibleValue(this.objectives.get(objectiveIndex)).doubleValue());
    }

    public void addToPhenotypeCache(String genotypeID, DSEObjectives oc) {
        this.phenotypeResultsCache.put(genotypeID, oc);
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }
}

