/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.AlternativeComponent;
import de.uka.ipd.sdq.dsexplore.exception.ChoiceOutOfBoundsException;
import de.uka.ipd.sdq.dsexplore.gdof.GenomeToCandidateModelTransformation;
import de.uka.ipd.sdq.dsexplore.helper.DegreeOfFreedomHelper;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.FixDesignDecisionReferenceSwitch;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.cost.helper.CostUtil;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DecisionSpace;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionPackage;
import de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.ATNumberOfReplicaDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.MonitoringDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ProcessingResourceDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.SchedulingPolicyDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.impl.specificFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.specificFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;
import org.palladiosimulator.solver.models.PCMInstance;

public class DSEProblem {
    private final PCMInstance initialInstance;
    private DecisionSpace pcmProblem;
    private final designdecisionFactory designDecisionFactory;
    private final specificFactory specificDesignDecisionFactory;
    private List<DesignDecisionGenotype> initialGenotypeList = null;
    private final DSEWorkflowConfiguration dseConfig;
    private DesignDecisionGenotype initialGenotype;

    public DSEProblem(DSEWorkflowConfiguration dseConfig, PCMInstance pcmInstance) throws CoreException {
        this.dseConfig = dseConfig;
        boolean newProblem = dseConfig.isNewProblem();
        this.initialInstance = pcmInstance;
        this.designDecisionFactory = designdecisionFactoryImpl.init();
        this.specificDesignDecisionFactory = specificFactoryImpl.init();
        if (newProblem) {
            this.initialiseProblem();
        } else {
            DecisionSpace problem;
            AlternativeComponent.getInstance().generateDesignDecisions(pcmInstance);
            this.pcmProblem = problem = this.loadProblem();
            this.initialGenotypeList = this.determineInitialGenotype(problem);
        }
    }

    private DecisionSpace loadProblem() throws CoreException {
        URI filename = this.dseConfig.getDesignDecisionFileName();
        return this.loadProblem(filename);
    }

    private DecisionSpace loadProblem(URI filename) throws CoreException {
        ResourceSet pcmResourceSet = this.initialInstance.getAllocation().eResource().getResourceSet();
        EObject eproblem = EMFHelper.loadFromXMIFile(filename, pcmResourceSet, (EPackage)designdecisionPackage.eINSTANCE);
        if (!(eproblem instanceof DecisionSpace)) {
            throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, "Cannot read design decision file " + filename + ". Please create a new one.", null));
        }
        DecisionSpace problem = (DecisionSpace)eproblem;
        FixDesignDecisionReferenceSwitch visitor = new FixDesignDecisionReferenceSwitch(this.initialInstance);
        visitor.doSwitch((EObject)problem);
        EcoreUtil.resolveAll((EObject)eproblem);
        return problem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<DesignDecisionGenotype> determineInitialGenotype(DecisionSpace problem) throws CoreException {
        DesignDecisionGenotype genotype = new DesignDecisionGenotype();
        for (DegreeOfFreedomInstance dd : problem.getDegreesOfFreedom()) {
            ClassChoice choice;
            if (dd.getDof() != null) {
                ClassChoice choice2;
                EStructuralFeature property = dd.getDof().getPrimaryChangeable().getChangeable();
                Object value = GenomeToCandidateModelTransformation.getProperty(dd.getPrimaryChanged(), property);
                if (value instanceof EObject) {
                    choice2 = this.designDecisionFactory.createClassChoice();
                    choice2.setChosenValue((EObject)value);
                } else if (value instanceof Double) {
                    choice2 = this.designDecisionFactory.createContinousRangeChoice();
                    ((ContinousRangeChoice)choice2).setChosenValue(((Double)value).doubleValue());
                } else {
                    if (!(value instanceof Integer)) throw new CoreException((IStatus)new Status(4, "de.uka.ipd.sdq.dsexplore", 0, "Cannot cast " + value + " to an EObject, Integer, or Double. Please extend DSEProblem.determineInitialGenotype to handle your type of choice.", null));
                    choice2 = this.designDecisionFactory.createDiscreteRangeChoice();
                    ((DiscreteRangeChoice)choice2).setChosenValue(((Integer)value).intValue());
                }
                choice2.setDegreeOfFreedomInstance(dd);
                genotype.add((Choice)choice2);
                continue;
            }
            if (dd instanceof ClassDegree) {
                AssemblyContext ac;
                choice = this.designDecisionFactory.createClassChoice();
                choice.setDegreeOfFreedomInstance(dd);
                if (dd instanceof AssembledComponentDegree) {
                    AssembledComponentDegree acd = (AssembledComponentDegree)dd;
                    ac = (AssemblyContext)acd.getPrimaryChanged();
                    RepositoryComponent rc = ac.getEncapsulatedComponent__AssemblyContext();
                    choice.setChosenValue((EObject)rc);
                } else if (dd instanceof AllocationDegree) {
                    AllocationDegree ad = (AllocationDegree)dd;
                    ac = (AllocationContext)ad.getPrimaryChanged();
                    ResourceContainer rc = ac.getResourceContainer_AllocationContext();
                    choice.setChosenValue((EObject)rc);
                } else if (dd instanceof SchedulingPolicyDegree) {
                    ProcessingResourceType procType = ((SchedulingPolicyDegree)dd).getProcessingresourcetype();
                    ResourceContainer rc = (ResourceContainer)dd.getPrimaryChanged();
                    SchedulingPolicy policy = null;
                    for (ProcessingResourceSpecification proc : rc.getActiveResourceSpecifications_ResourceContainer()) {
                        if (!EMFHelper.checkIdentity((EObject)proc.getActiveResourceType_ActiveResourceSpecification(), (EObject)procType)) continue;
                        policy = proc.getSchedulingPolicy();
                        break;
                    }
                    if (policy == null) {
                        throw new RuntimeException("Invalid degree of freedom " + dd.toString() + ". The referenced ProcessingResourceType is not available in the given ResourceContainer.");
                    }
                    choice.setChosenValue(policy);
                    genotype.add((Choice)choice);
                } else {
                    this.throwUnknownDegreeException(dd);
                }
                if (!EMFHelper.contains((Collection<? extends EObject>)((ClassDegree)dd).getClassDesignOptions(), choice.getChosenValue())) {
                    throw new ChoiceOutOfBoundsException(choice, "Error when determining initial genotype");
                }
                genotype.add((Choice)choice);
                continue;
            }
            if (dd instanceof ContinuousRangeDegree) {
                choice = this.designDecisionFactory.createContinousRangeChoice();
                choice.setDegreeOfFreedomInstance(dd);
                if (dd instanceof MonitoringDegree) {
                    ContinuousRangeDegree crdobj = (ContinuousRangeDegree)dd;
                    choice.setChosenValue(crdobj.getFrom());
                } else if (dd instanceof ContinuousProcessingRateDegree) {
                    ContinuousProcessingRateDegree prd = (ContinuousProcessingRateDegree)dd;
                    ProcessingResourceSpecification rightPrs = this.getProcessingResourceSpec((ProcessingResourceDegree)prd);
                    if (rightPrs == null) throw new RuntimeException("Invalid degree of freedom " + dd.toString() + ". The referenced ProcessingResourceType is not available in the given ResourceContainer.");
                    double rate = CostUtil.getInstance().getDoubleFromSpecification(rightPrs.getProcessingRate_ProcessingResourceSpecification().getSpecification());
                    choice.setChosenValue(rate);
                } else {
                    this.throwUnknownDegreeException(dd);
                }
                genotype.add((Choice)choice);
                continue;
            }
            if (dd instanceof DiscreteDegree) {
                DiscreteDegree degree = (DiscreteDegree)dd;
                DiscreteRangeChoice choice3 = this.designDecisionFactory.createDiscreteRangeChoice();
                choice3.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)degree);
                EObject entity = degree.getPrimaryChanged();
                if (degree instanceof CapacityDegree) {
                    PassiveResource pr = (PassiveResource)entity;
                    choice3.setChosenValue(Integer.valueOf(pr.getCapacity_PassiveResource().getSpecification()).intValue());
                } else if (degree instanceof NumberOfCoresDegree) {
                    ProcessingResourceSpecification prd = this.getProcessingResourceSpec((ProcessingResourceDegree)degree);
                    choice3.setChosenValue(prd.getNumberOfReplicas());
                } else if (degree instanceof DiscreteProcessingRateDegree) {
                    DiscreteProcessingRateDegree prd = (DiscreteProcessingRateDegree)dd;
                    ProcessingResourceSpecification rightPrs = this.getProcessingResourceSpec((ProcessingResourceDegree)prd);
                    if (rightPrs == null) throw new RuntimeException("Invalid degree of freedom " + dd.toString() + ". The referenced ProcessingResourceType is not available in the given ResourceContainer.");
                    if (!prd.isLowerBoundIncluded() || !prd.isUpperBoundIncluded()) {
                        throw new RuntimeException("Only DiscreteProcessingRateDegrees with upper and lower bound included are supported so far, sorry. ");
                    }
                    double rate = CostUtil.getInstance().getDoubleFromSpecification(rightPrs.getProcessingRate_ProcessingResourceSpecification().getSpecification());
                    double startStep = prd.getFrom();
                    double endStep = prd.getTo();
                    double stepwidth = (endStep - startStep) / (double)prd.getNumberOfSteps();
                    double chosenStep = (rate - startStep) / stepwidth;
                    choice3.setChosenValue((int)chosenStep);
                } else if (degree instanceof ResourceContainerReplicationDegree) {
                    choice3.setChosenValue(1);
                } else if (degree instanceof ATNumberOfReplicaDegree) {
                    ATNumberOfReplicaDegree atNumberOfReplicasDegree = (ATNumberOfReplicaDegree)degree;
                    if (entity instanceof ResourceContainer) {
                        ResourceContainer resourceContainer = (ResourceContainer)entity;
                        if (StereotypeAPI.isStereotypeApplied((EObject)resourceContainer, (String)"ReplicableResourceContainer")) {
                            int min = atNumberOfReplicasDegree.getFrom();
                            StereotypeAPI.setTaggedValue((EObject)resourceContainer, (Object)min, (String)"ReplicableResourceContainer", (String)"numberOfReplicas");
                            choice3.setChosenValue(min);
                        }
                    } else {
                        boolean cfr_ignored_0 = entity instanceof AssemblyContext;
                    }
                } else {
                    this.throwUnknownDegreeException(dd);
                }
                genotype.add((Choice)choice3);
                continue;
            }
            this.throwUnknownDegreeException(dd);
        }
        ArrayList<DesignDecisionGenotype> result = new ArrayList<DesignDecisionGenotype>();
        result.add(genotype);
        this.initialGenotype = genotype;
        return result;
    }

    private ProcessingResourceSpecification getProcessingResourceSpec(ProcessingResourceDegree prd) {
        ResourceContainer rc = (ResourceContainer)prd.getPrimaryChanged();
        EList prsList = rc.getActiveResourceSpecifications_ResourceContainer();
        ProcessingResourceType prt = prd.getProcessingresourcetype();
        ProcessingResourceSpecification rightPrs = null;
        for (ProcessingResourceSpecification prs : prsList) {
            if (!EMFHelper.checkIdentity((EObject)prs.getActiveResourceType_ActiveResourceSpecification(), (EObject)prt)) continue;
            rightPrs = prs;
            break;
        }
        return rightPrs;
    }

    private void throwUnknownDegreeException(DegreeOfFreedomInstance dd) {
        throw new RuntimeException("Unknown degree of freedom " + dd.toString() + ".");
    }

    private void initialiseProblem() {
        this.pcmProblem = this.designDecisionFactory.createDecisionSpace();
        EList dds = this.pcmProblem.getDegreesOfFreedom();
        this.initialGenotypeList = new ArrayList<DesignDecisionGenotype>();
        DesignDecisionGenotype initialCandidate = new DesignDecisionGenotype();
        this.determineProcessingRateDecisions((List<DegreeOfFreedomInstance>)dds, initialCandidate);
        this.determineAssembledComponentsDecisions((List<DegreeOfFreedomInstance>)dds, initialCandidate);
        this.determineAllocationDecisions((List<DegreeOfFreedomInstance>)dds, initialCandidate);
        this.determineCapacityDecisions((List<DegreeOfFreedomInstance>)dds, initialCandidate);
        this.initialGenotypeList.add(initialCandidate);
    }

    private void determineCapacityDecisions(List<DegreeOfFreedomInstance> dds, DesignDecisionGenotype genotype) {
        List repositories = this.initialInstance.getRepositories();
        for (Repository repository : repositories) {
            EList components = repository.getComponents__Repository();
            for (RepositoryComponent repositoryComponent : components) {
                if (!(repositoryComponent instanceof BasicComponent)) continue;
                BasicComponent basicComponent = (BasicComponent)repositoryComponent;
                EList passiveResources = basicComponent.getPassiveResource_BasicComponent();
                for (PassiveResource passiveResource : passiveResources) {
                    CapacityDegree capacityDegree = this.specificDesignDecisionFactory.createCapacityDegree();
                    capacityDegree.setPrimaryChanged((EObject)passiveResource);
                    capacityDegree.setFrom(1);
                    capacityDegree.setTo(Integer.valueOf(passiveResource.getCapacity_PassiveResource().getSpecification()).intValue());
                    dds.add((DegreeOfFreedomInstance)capacityDegree);
                    DiscreteRangeChoice choice = this.designDecisionFactory.createDiscreteRangeChoice();
                    choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)capacityDegree);
                    choice.setChosenValue(Integer.valueOf(passiveResource.getCapacity_PassiveResource().getSpecification()).intValue());
                    genotype.add((Choice)choice);
                }
            }
        }
    }

    private void determineAllocationDecisions(List<DegreeOfFreedomInstance> dds, DesignDecisionGenotype genotype) {
        EList acs = this.initialInstance.getAllocation().getAllocationContexts_Allocation();
        EList rcs = this.initialInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        for (AllocationContext ac : acs) {
            AllocationDegree ad = this.specificDesignDecisionFactory.createAllocationDegree();
            ad.setPrimaryChanged((EObject)ac);
            ad.getClassDesignOptions().addAll((Collection)rcs);
            dds.add((DegreeOfFreedomInstance)ad);
            ClassChoice choice = this.designDecisionFactory.createClassChoice();
            choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)ad);
            choice.setChosenValue((EObject)ac.getResourceContainer_AllocationContext());
            genotype.add((Choice)choice);
        }
    }

    private void determineAssembledComponentsDecisions(List<DegreeOfFreedomInstance> dds, DesignDecisionGenotype genotype) {
        AlternativeComponent ac = AlternativeComponent.getInstance();
        List<AssembledComponentDegree> decisions = ac.generateDesignDecisions(this.initialInstance);
        for (AssembledComponentDegree designDecision : decisions) {
            dds.add((DegreeOfFreedomInstance)designDecision);
            RepositoryComponent currentlyAssembledComponent = ((AssemblyContext)designDecision.getPrimaryChanged()).getEncapsulatedComponent__AssemblyContext();
            ClassChoice choice = this.designDecisionFactory.createClassChoice();
            choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)designDecision);
            choice.setChosenValue((EObject)currentlyAssembledComponent);
            genotype.add((Choice)choice);
        }
    }

    private void determineProcessingRateDecisions(List<DegreeOfFreedomInstance> dds, DesignDecisionGenotype genotype) {
        EList resourceContainers = this.initialInstance.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        for (ResourceContainer resourceContainer : resourceContainers) {
            EList resources = resourceContainer.getActiveResourceSpecifications_ResourceContainer();
            for (ProcessingResourceSpecification resource : resources) {
                ContinuousProcessingRateDegree decision = this.specificDesignDecisionFactory.createContinuousProcessingRateDegree();
                decision.setLowerBoundIncluded(false);
                double currentRate = CostUtil.getInstance().getDoubleFromSpecification(resource.getProcessingRate_ProcessingResourceSpecification().getSpecification());
                decision.setTo(currentRate * 2.0);
                decision.setFrom(currentRate * 0.5);
                decision.setPrimaryChanged((EObject)resourceContainer);
                decision.setProcessingresourcetype(resource.getActiveResourceType_ActiveResourceSpecification());
                dds.add((DegreeOfFreedomInstance)decision);
                ContinousRangeChoice choice = this.designDecisionFactory.createContinousRangeChoice();
                choice.setDegreeOfFreedomInstance((DegreeOfFreedomInstance)decision);
                choice.setChosenValue(currentRate);
                genotype.add((Choice)choice);
            }
        }
    }

    protected DegreeOfFreedomInstance getDesignDecision(int index) {
        return (DegreeOfFreedomInstance)this.pcmProblem.getDegreesOfFreedom().get(index);
    }

    public List<DegreeOfFreedomInstance> getDesignDecisions() {
        return this.pcmProblem.getDegreesOfFreedom();
    }

    public PCMInstance getInitialInstance() {
        return this.initialInstance;
    }

    public DesignDecisionGenotype getGenotypeOfInitialPCMInstance() {
        return this.initialGenotype;
    }

    protected List<DesignDecisionGenotype> getInitialGenotypeList() {
        return this.initialGenotypeList;
    }

    public void saveProblem() {
        URI filename = this.dseConfig.getDesignDecisionFileName();
        EMFHelper.saveToXMIFile((EObject)this.pcmProblem, filename);
    }

    public String toString() {
        String result = "";
        EList decisions = this.pcmProblem.getDegreesOfFreedom();
        for (DegreeOfFreedomInstance designDecision : decisions) {
            result = String.valueOf(result) + DegreeOfFreedomHelper.getDegreeDescription(designDecision) + ";";
        }
        return result;
    }

    public void setInitialPopulation(List<DesignDecisionGenotype> population) throws CoreException {
        this.initialGenotypeList = population;
        Opt4JStarter.getDSECreator().setNumberOfNotEvaluatedPredefinedOnes(population.size());
    }

    public DegreeOfFreedomInstance getDegree(Entity entity, Class<? extends DegreeOfFreedomInstance> degreeClass) {
        EList degrees = this.pcmProblem.getDegreesOfFreedom();
        for (DegreeOfFreedomInstance DegreeOfFreedomInstance2 : degrees) {
            if (!degreeClass.isInstance(DegreeOfFreedomInstance2) || !DegreeOfFreedomInstance2.getPrimaryChanged().equals(entity)) continue;
            return DegreeOfFreedomInstance2;
        }
        return null;
    }

    public DecisionSpace getEMFProblem() {
        return this.pcmProblem;
    }
}

