/**
 */
package de.uka.ipd.sdq.pcm.designdecision.specific.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.uka.ipd.sdq.pcm.designdecision.specific.util.specificAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class specificItemProviderAdapterFactory extends specificAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public specificItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ExchangeComponentRule} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExchangeComponentRuleItemProvider exchangeComponentRuleItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ExchangeComponentRule}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExchangeComponentRuleAdapter() {
        if (this.exchangeComponentRuleItemProvider == null) {
            this.exchangeComponentRuleItemProvider = new ExchangeComponentRuleItemProvider(this);
        }

        return this.exchangeComponentRuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ClassAsReferenceDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ClassAsReferenceDegreeItemProvider classAsReferenceDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ClassAsReferenceDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createClassAsReferenceDegreeAdapter() {
        if (this.classAsReferenceDegreeItemProvider == null) {
            this.classAsReferenceDegreeItemProvider = new ClassAsReferenceDegreeItemProvider(this);
        }

        return this.classAsReferenceDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ContinuousRangeDegreeItemProvider continuousRangeDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createContinuousRangeDegreeAdapter() {
        if (this.continuousRangeDegreeItemProvider == null) {
            this.continuousRangeDegreeItemProvider = new ContinuousRangeDegreeItemProvider(this);
        }

        return this.continuousRangeDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteRangeDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DiscreteRangeDegreeItemProvider discreteRangeDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteRangeDegree}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDiscreteRangeDegreeAdapter() {
        if (this.discreteRangeDegreeItemProvider == null) {
            this.discreteRangeDegreeItemProvider = new DiscreteRangeDegreeItemProvider(this);
        }

        return this.discreteRangeDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.OrderedIntegerDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected OrderedIntegerDegreeItemProvider orderedIntegerDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.OrderedIntegerDegree}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOrderedIntegerDegreeAdapter() {
        if (this.orderedIntegerDegreeItemProvider == null) {
            this.orderedIntegerDegreeItemProvider = new OrderedIntegerDegreeItemProvider(this);
        }

        return this.orderedIntegerDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousComponentParamDegree} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ContinuousComponentParamDegreeItemProvider continuousComponentParamDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousComponentParamDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createContinuousComponentParamDegreeAdapter() {
        if (this.continuousComponentParamDegreeItemProvider == null) {
            this.continuousComponentParamDegreeItemProvider = new ContinuousComponentParamDegreeItemProvider(this);
        }

        return this.continuousComponentParamDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ContinuousProcessingRateDegreeItemProvider continuousProcessingRateDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousProcessingRateDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createContinuousProcessingRateDegreeAdapter() {
        if (this.continuousProcessingRateDegreeItemProvider == null) {
            this.continuousProcessingRateDegreeItemProvider = new ContinuousProcessingRateDegreeItemProvider(this);
        }

        return this.continuousProcessingRateDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteComponentParamDegree} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DiscreteComponentParamDegreeItemProvider discreteComponentParamDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteComponentParamDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDiscreteComponentParamDegreeAdapter() {
        if (this.discreteComponentParamDegreeItemProvider == null) {
            this.discreteComponentParamDegreeItemProvider = new DiscreteComponentParamDegreeItemProvider(this);
        }

        return this.discreteComponentParamDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteProcessingRateDegree} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DiscreteProcessingRateDegreeItemProvider discreteProcessingRateDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteProcessingRateDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDiscreteProcessingRateDegreeAdapter() {
        if (this.discreteProcessingRateDegreeItemProvider == null) {
            this.discreteProcessingRateDegreeItemProvider = new DiscreteProcessingRateDegreeItemProvider(this);
        }

        return this.discreteProcessingRateDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.FeatureGroupDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FeatureGroupDegreeItemProvider featureGroupDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.FeatureGroupDegree}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFeatureGroupDegreeAdapter() {
        if (this.featureGroupDegreeItemProvider == null) {
            this.featureGroupDegreeItemProvider = new FeatureGroupDegreeItemProvider(this);
        }

        return this.featureGroupDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.FeatureSubset} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FeatureSubsetItemProvider featureSubsetItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.FeatureSubset}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFeatureSubsetAdapter() {
        if (this.featureSubsetItemProvider == null) {
            this.featureSubsetItemProvider = new FeatureSubsetItemProvider(this);
        }

        return this.featureSubsetItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsListDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumberOfCoresAsListDegreeItemProvider numberOfCoresAsListDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsListDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumberOfCoresAsListDegreeAdapter() {
        if (this.numberOfCoresAsListDegreeItemProvider == null) {
            this.numberOfCoresAsListDegreeItemProvider = new NumberOfCoresAsListDegreeItemProvider(this);
        }

        return this.numberOfCoresAsListDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsRangeDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumberOfCoresAsRangeDegreeItemProvider numberOfCoresAsRangeDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresAsRangeDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumberOfCoresAsRangeDegreeAdapter() {
        if (this.numberOfCoresAsRangeDegreeItemProvider == null) {
            this.numberOfCoresAsRangeDegreeItemProvider = new NumberOfCoresAsRangeDegreeItemProvider(this);
        }

        return this.numberOfCoresAsRangeDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.OptionalFeatureDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected OptionalFeatureDegreeItemProvider optionalFeatureDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.OptionalFeatureDegree}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOptionalFeatureDegreeAdapter() {
        if (this.optionalFeatureDegreeItemProvider == null) {
            this.optionalFeatureDegreeItemProvider = new OptionalFeatureDegreeItemProvider(this);
        }

        return this.optionalFeatureDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegree}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceContainerReplicationDegreeItemProvider resourceContainerReplicationDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceContainerReplicationDegreeAdapter() {
        if (this.resourceContainerReplicationDegreeItemProvider == null) {
            this.resourceContainerReplicationDegreeItemProvider = new ResourceContainerReplicationDegreeItemProvider(
                    this);
        }

        return this.resourceContainerReplicationDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegreeWithComponentChange}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceContainerReplicationDegreeWithComponentChangeItemProvider resourceContainerReplicationDegreeWithComponentChangeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegreeWithComponentChange}
     * . <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceContainerReplicationDegreeWithComponentChangeAdapter() {
        if (this.resourceContainerReplicationDegreeWithComponentChangeItemProvider == null) {
            this.resourceContainerReplicationDegreeWithComponentChangeItemProvider = new ResourceContainerReplicationDegreeWithComponentChangeItemProvider(
                    this);
        }

        return this.resourceContainerReplicationDegreeWithComponentChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceSelectionDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ResourceSelectionDegreeItemProvider resourceSelectionDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ResourceSelectionDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceSelectionDegreeAdapter() {
        if (this.resourceSelectionDegreeItemProvider == null) {
            this.resourceSelectionDegreeItemProvider = new ResourceSelectionDegreeItemProvider(this);
        }

        return this.resourceSelectionDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.SchedulingPolicyDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SchedulingPolicyDegreeItemProvider schedulingPolicyDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.SchedulingPolicyDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSchedulingPolicyDegreeAdapter() {
        if (this.schedulingPolicyDegreeItemProvider == null) {
            this.schedulingPolicyDegreeItemProvider = new SchedulingPolicyDegreeItemProvider(this);
        }

        return this.schedulingPolicyDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.StringComponentParamDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected StringComponentParamDegreeItemProvider stringComponentParamDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.StringComponentParamDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStringComponentParamDegreeAdapter() {
        if (this.stringComponentParamDegreeItemProvider == null) {
            this.stringComponentParamDegreeItemProvider = new StringComponentParamDegreeItemProvider(this);
        }

        return this.stringComponentParamDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AllocationDegreeItemProvider allocationDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAllocationDegreeAdapter() {
        if (this.allocationDegreeItemProvider == null) {
            this.allocationDegreeItemProvider = new AllocationDegreeItemProvider(this);
        }

        return this.allocationDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AssembledComponentDegreeItemProvider assembledComponentDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAssembledComponentDegreeAdapter() {
        if (this.assembledComponentDegreeItemProvider == null) {
            this.assembledComponentDegreeItemProvider = new AssembledComponentDegreeItemProvider(this);
        }

        return this.assembledComponentDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CapacityDegreeItemProvider capacityDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCapacityDegreeAdapter() {
        if (this.capacityDegreeItemProvider == null) {
            this.capacityDegreeItemProvider = new CapacityDegreeItemProvider(this);
        }

        return this.capacityDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.MonitoringDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MonitoringDegreeItemProvider monitoringDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.MonitoringDegree}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMonitoringDegreeAdapter() {
        if (this.monitoringDegreeItemProvider == null) {
            this.monitoringDegreeItemProvider = new MonitoringDegreeItemProvider(this);
        }

        return this.monitoringDegreeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ATNumberOfReplicaDegree} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ATNumberOfReplicaDegreeItemProvider atNumberOfReplicaDegreeItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.specific.ATNumberOfReplicaDegree}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createATNumberOfReplicaDegreeAdapter() {
        if (this.atNumberOfReplicaDegreeItemProvider == null) {
            this.atNumberOfReplicaDegreeItemProvider = new ATNumberOfReplicaDegreeItemProvider(this);
        }

        return this.atNumberOfReplicaDegreeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.exchangeComponentRuleItemProvider != null) {
            this.exchangeComponentRuleItemProvider.dispose();
        }
        if (this.classAsReferenceDegreeItemProvider != null) {
            this.classAsReferenceDegreeItemProvider.dispose();
        }
        if (this.continuousRangeDegreeItemProvider != null) {
            this.continuousRangeDegreeItemProvider.dispose();
        }
        if (this.discreteRangeDegreeItemProvider != null) {
            this.discreteRangeDegreeItemProvider.dispose();
        }
        if (this.orderedIntegerDegreeItemProvider != null) {
            this.orderedIntegerDegreeItemProvider.dispose();
        }
        if (this.continuousComponentParamDegreeItemProvider != null) {
            this.continuousComponentParamDegreeItemProvider.dispose();
        }
        if (this.continuousProcessingRateDegreeItemProvider != null) {
            this.continuousProcessingRateDegreeItemProvider.dispose();
        }
        if (this.discreteComponentParamDegreeItemProvider != null) {
            this.discreteComponentParamDegreeItemProvider.dispose();
        }
        if (this.discreteProcessingRateDegreeItemProvider != null) {
            this.discreteProcessingRateDegreeItemProvider.dispose();
        }
        if (this.featureGroupDegreeItemProvider != null) {
            this.featureGroupDegreeItemProvider.dispose();
        }
        if (this.featureSubsetItemProvider != null) {
            this.featureSubsetItemProvider.dispose();
        }
        if (this.numberOfCoresAsListDegreeItemProvider != null) {
            this.numberOfCoresAsListDegreeItemProvider.dispose();
        }
        if (this.numberOfCoresAsRangeDegreeItemProvider != null) {
            this.numberOfCoresAsRangeDegreeItemProvider.dispose();
        }
        if (this.optionalFeatureDegreeItemProvider != null) {
            this.optionalFeatureDegreeItemProvider.dispose();
        }
        if (this.resourceContainerReplicationDegreeItemProvider != null) {
            this.resourceContainerReplicationDegreeItemProvider.dispose();
        }
        if (this.resourceContainerReplicationDegreeWithComponentChangeItemProvider != null) {
            this.resourceContainerReplicationDegreeWithComponentChangeItemProvider.dispose();
        }
        if (this.resourceSelectionDegreeItemProvider != null) {
            this.resourceSelectionDegreeItemProvider.dispose();
        }
        if (this.schedulingPolicyDegreeItemProvider != null) {
            this.schedulingPolicyDegreeItemProvider.dispose();
        }
        if (this.stringComponentParamDegreeItemProvider != null) {
            this.stringComponentParamDegreeItemProvider.dispose();
        }
        if (this.allocationDegreeItemProvider != null) {
            this.allocationDegreeItemProvider.dispose();
        }
        if (this.assembledComponentDegreeItemProvider != null) {
            this.assembledComponentDegreeItemProvider.dispose();
        }
        if (this.capacityDegreeItemProvider != null) {
            this.capacityDegreeItemProvider.dispose();
        }
        if (this.monitoringDegreeItemProvider != null) {
            this.monitoringDegreeItemProvider.dispose();
        }
        if (this.atNumberOfReplicaDegreeItemProvider != null) {
            this.atNumberOfReplicaDegreeItemProvider.dispose();
        }
    }

}
