/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.resource.part;

import de.uka.ipd.sdq.pcm.gmf.resource.part.PalladioComponentModelDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;

public class PalladioComponentModelVisualIDRegistry {
    private static final String DEBUG_KEY = "de.uka.ipd.sdq.pcm.gmf.resource/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return PalladioComponentModelVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return PalladioComponentModelVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return PalladioComponentModelVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return PalladioComponentModelVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return PalladioComponentModelVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return PalladioComponentModelVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("ResourceEnvironmentModel".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return PalladioComponentModelVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                PalladioComponentModelDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment().isSuperTypeOf(domainElement.eClass()) && PalladioComponentModelVisualIDRegistry.isDiagram((ResourceEnvironment)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"ResourceEnvironmentModel".equals(containerModelID)) {
            return -1;
        }
        if ("ResourceEnvironmentModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (!ResourceenvironmentPackage.eINSTANCE.getLinkingResource().isSuperTypeOf(domainElement.eClass())) break;
                return 2005;
            }
            case 7004: {
                if (!ResourceenvironmentPackage.eINSTANCE.getProcessingResourceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7007: {
                if (!ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7008: {
                if (!ResourceenvironmentPackage.eINSTANCE.getProcessingResourceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7009: {
                if (!ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isSuperTypeOf(domainElement.eClass())) break;
                return 3005;
            }
            case 7006: {
                if (!ResourceenvironmentPackage.eINSTANCE.getCommunicationLinkResourceSpecification().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = PalladioComponentModelVisualIDRegistry.getModelID(containerView);
        if (!"ResourceEnvironmentModel".equals(containerModelID)) {
            return false;
        }
        if ("ResourceEnvironmentModel".equals(containerModelID)) {
            containerVisualID = PalladioComponentModelVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3003: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (7008 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (5023 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3005 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(ResourceEnvironment element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = PalladioComponentModelVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3003: 
            case 3004: {
                return true;
            }
        }
        return false;
    }
}

