/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.SamplePDF;
import de.uka.ipd.sdq.probfunction.math.IBoxedPDF;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.PDFConfiguration;
import de.uka.ipd.sdq.probfunction.math.exception.ConfigurationNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInFrequencyDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.StringNotPDFException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.probfunction.print.ProbFunctionPrettyPrint;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.parser.StochasticExpressionsLexer;
import de.uka.ipd.sdq.stoex.parser.StochasticExpressionsParser;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ManagedPDF {
    private IProbabilityDensityFunction pdfTimeDomain;
    private ISamplePDF samplePdfTimeDomain;
    private IBoxedPDF boxedPdfTimeDomain;
    private IProbabilityDensityFunction pdfFrequencyDomain;
    private ISamplePDF samplePdfFrequencyDomain;
    private ProbabilityDensityFunction modelPDF;
    private BoxedPDF modelBoxedPDF;
    private SamplePDF modelSamplePDF;
    private boolean useConfiguration = false;
    private static String pdfAsString;
    private double meanValue;
    private ISamplePDF cumulativeDistributionFunction;
    private static IProbabilityFunctionFactory pfFactory;

    static {
        pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    }

    private ManagedPDF() {
        this.reset();
    }

    public ManagedPDF(ProbabilityDensityFunction pdf) {
        this();
        this.useConfiguration = false;
        this.setModelPdf(pdf);
    }

    public ManagedPDF(IProbabilityDensityFunction pdf) {
        this();
        this.useConfiguration = false;
        this.setPdf(pdf);
    }

    public ManagedPDF(IProbabilityDensityFunction pdf, boolean useConfiguration) {
        this();
        this.useConfiguration = useConfiguration;
        this.setPdf(pdf);
    }

    public ManagedPDF(ProbabilityDensityFunction pdf, boolean useConfiguration) {
        this();
        this.useConfiguration = useConfiguration;
        this.setModelPdf(pdf);
    }

    public ManagedPDF(double distance, List<Double> values, IUnit unit, boolean useConfiguration) {
        this.useConfiguration = useConfiguration;
        ISamplePDF pdf = pfFactory.createSamplePDFFromMeasurements(distance, values, unit);
        this.setPdf(pdf);
    }

    private void reset() {
        this.pdfFrequencyDomain = null;
        this.samplePdfFrequencyDomain = null;
        this.pdfTimeDomain = null;
        this.samplePdfTimeDomain = null;
        this.boxedPdfTimeDomain = null;
        this.modelPDF = null;
        this.modelBoxedPDF = null;
        this.modelSamplePDF = null;
        pdfAsString = null;
        this.cumulativeDistributionFunction = null;
        this.meanValue = -1.0;
    }

    public IProbabilityDensityFunction getPdfTimeDomain() {
        if (this.pdfTimeDomain == null) {
            if (this.modelPDF != null) {
                try {
                    this.pdfTimeDomain = IProbabilityFunctionFactory.eINSTANCE.transformToPDF(this.modelPDF);
                }
                catch (ProbabilityFunctionException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            if (this.pdfFrequencyDomain != null) {
                try {
                    this.pdfTimeDomain = this.pdfFrequencyDomain.getInverseFourierTransform();
                }
                catch (FunctionNotInFrequencyDomainException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        }
        return this.pdfTimeDomain;
    }

    public IBoxedPDF getBoxedPdfTimeDomain() {
        if (this.boxedPdfTimeDomain == null) {
            try {
                this.boxedPdfTimeDomain = pfFactory.transformToBoxedPDF(this.getPdfTimeDomain());
            }
            catch (ProbabilityFunctionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.boxedPdfTimeDomain;
    }

    public ISamplePDF getSamplePdfTimeDomain() {
        if (this.samplePdfTimeDomain == null) {
            try {
                this.samplePdfTimeDomain = pfFactory.transformToSamplePDF(this.getPdfTimeDomain());
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.samplePdfTimeDomain;
    }

    public ISamplePDF getSamplePdfFrequencyDomain() {
        if (this.samplePdfFrequencyDomain == null) {
            try {
                this.samplePdfFrequencyDomain = pfFactory.transformToSamplePDF(this.getPdfFrequencyDomain());
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.samplePdfFrequencyDomain;
    }

    public IProbabilityDensityFunction getPdfFrequencyDomain() {
        if (this.pdfFrequencyDomain == null && this.getPdfTimeDomain() != null) {
            try {
                this.pdfFrequencyDomain = this.getPdfTimeDomain().getFourierTransform();
            }
            catch (FunctionNotInTimeDomainException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.pdfFrequencyDomain;
    }

    private void setPdf(IProbabilityDensityFunction pdf) {
        this.reset();
        if (pdf.isInFrequencyDomain()) {
            this.pdfFrequencyDomain = pdf;
        } else {
            this.pdfTimeDomain = pdf;
        }
        this.adjustToConfiguration();
    }

    private void setModelPdf(ProbabilityDensityFunction pdf) {
        this.reset();
        this.modelPDF = pdf;
        this.adjustToConfiguration();
    }

    private void adjustToConfiguration() {
        block11: {
            try {
                if (!this.useConfiguration) break block11;
                try {
                    PDFConfiguration config = PDFConfiguration.getCurrentConfiguration();
                    if (config != null) {
                        IProbabilityDensityFunction pdf = this.getPdfTimeDomain();
                        ISamplePDF samplePDF = null;
                        boolean changed = false;
                        if (!(pdf instanceof ISamplePDF)) {
                            changed = true;
                            samplePDF = pfFactory.transformToSamplePDF(pdf);
                        } else {
                            samplePDF = (ISamplePDF)pdf;
                        }
                        if (!config.getUnit().equals(samplePDF.getUnit())) {
                            changed = true;
                            samplePDF = pfFactory.createSamplePDFFromComplex(samplePDF.getDistance(), samplePDF.getValues(), false, config.getUnit());
                        }
                        if (!MathTools.equalsDouble(config.getDistance(), samplePDF.getDistance())) {
                            changed = true;
                            samplePDF = samplePDF.getFunctionWithNewDistance(config.getDistance());
                        }
                        if (config.getNumSamplingPoints() > samplePDF.numberOfSamples()) {
                            changed = true;
                            samplePDF.expand(config.getNumSamplingPoints());
                        }
                        if (changed) {
                            this.setPdf(samplePDF);
                        }
                    }
                }
                catch (ConfigurationNotSetException e) {
                    System.err.println("No configuration for pdf's found!");
                }
            }
            catch (ProbabilityFunctionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public ProbabilityDensityFunction getModelPdf() {
        try {
            if (this.modelPDF == null) {
                this.modelPDF = IProbabilityFunctionFactory.eINSTANCE.transformToModelPDF(this.getPdfTimeDomain());
            }
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this.modelPDF;
    }

    public boolean isComplete() {
        return true;
    }

    public static ManagedPDF createDiracImpulse() throws ConfigurationNotSetException {
        return ManagedPDF.createImpulseAt(0);
    }

    public static ManagedPDF createImpulseAt(int pos) throws ConfigurationNotSetException {
        PDFConfiguration config = PDFConfiguration.getCurrentConfiguration();
        ISamplePDF pdf = pfFactory.createImpulseAt(pos, config.getNumSamplingPoints(), config.getDistance(), config.getUnit());
        return new ManagedPDF(pdf, true);
    }

    public static ManagedPDF createZeroFunction() throws ConfigurationNotSetException {
        PDFConfiguration config = PDFConfiguration.getCurrentConfiguration();
        ISamplePDF pdf = pfFactory.createZeroFunction(config.getNumSamplingPoints(), config.getDistance(), config.getUnit());
        return new ManagedPDF(pdf, true);
    }

    public String toString() {
        if (pdfAsString == null) {
            BoxedPDF pdf = this.getModelBoxedPdf();
            ProbFunctionPrettyPrint pp = new ProbFunctionPrettyPrint();
            pdfAsString = (String)pp.doSwitch((EObject)pdf);
        }
        return pdfAsString;
    }

    public BoxedPDF getModelBoxedPdf() {
        if (this.modelBoxedPDF == null) {
            try {
                this.modelBoxedPDF = pfFactory.transformToModelBoxedPDF(this.getBoxedPdfTimeDomain());
            }
            catch (ProbabilityFunctionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.modelBoxedPDF;
    }

    public SamplePDF getModelSamplePDF() {
        if (this.modelSamplePDF == null) {
            try {
                this.modelSamplePDF = pfFactory.transformToModelSamplePDF(this.getSamplePdfTimeDomain());
            }
            catch (UnknownPDFTypeException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.modelSamplePDF;
    }

    public double getMeanValue() {
        if (this.meanValue < 0.0) {
            try {
                this.meanValue = this.getPdfTimeDomain().getArithmeticMeanValue();
            }
            catch (ProbabilityFunctionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.meanValue;
    }

    public double getExpectedValue() {
        BoxedPDF boxedPDF = this.getModelBoxedPdf();
        EList sampleList = boxedPDF.getSamples();
        double result = 0.0;
        for (ContinuousSample sample : sampleList) {
            Double value = sample.getValue();
            result += value * sample.getProbability();
        }
        return result;
    }

    public ISamplePDF getCumulativeDistributionFunction() {
        if (this.cumulativeDistributionFunction == null) {
            try {
                this.cumulativeDistributionFunction = (ISamplePDF)this.getSamplePdfTimeDomain().getCumulativeFunction();
            }
            catch (FunctionNotInTimeDomainException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.cumulativeDistributionFunction;
    }

    public double probEquals(ManagedPDF pdf) {
        try {
            return this.getSamplePdfTimeDomain().probabilisticEquals(pdf.getSamplePdfTimeDomain());
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public double probGreaterThan(ManagedPDF pdf) {
        ISamplePDF cdfA = this.getCumulativeDistributionFunction();
        ISamplePDF pdfA = this.getSamplePdfTimeDomain();
        int size = pdfA.getValues().size();
        double distance = pdfA.getDistance();
        pdf.adjustPDF(distance, size);
        ISamplePDF pdfB = pdf.getSamplePdfTimeDomain();
        double prob = 0.0;
        int i = 0;
        while (i < size) {
            prob += pdfB.getValueAsDouble(i) * (1.0 - cdfA.getValueAsDouble(i));
            ++i;
        }
        return prob;
    }

    public double probGreaterOrEqualThan(ManagedPDF pdf) {
        ISamplePDF pdfA = this.getSamplePdfTimeDomain();
        ISamplePDF cdfA = this.getCumulativeDistributionFunction();
        int size = pdfA.getValues().size();
        double distance = pdfA.getDistance();
        pdf.adjustPDF(distance, size);
        ISamplePDF pdfB = pdf.getSamplePdfTimeDomain();
        double prob = 0.0;
        int i = 0;
        while (i < size) {
            prob += pdfB.getValueAsDouble(i) * (1.0 - cdfA.getValueAsDouble(i) + pdfA.getValueAsDouble(i));
            ++i;
        }
        return prob;
    }

    public double probLessThan(ManagedPDF pdf) {
        return pdf.probGreaterThan(this);
    }

    public void adjustPDF(double distance, int size) {
        try {
            ISamplePDF sPDF = this.getSamplePdfTimeDomain();
            sPDF = sPDF.getFunctionWithNewDistance(distance);
            if (size > sPDF.getValues().size()) {
                sPDF.expand(size);
            }
            this.setPdf(sPDF);
        }
        catch (ProbabilityFunctionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new ManagedPDF(this.getPdfTimeDomain());
    }

    public boolean usesConfiguration() {
        return this.useConfiguration;
    }

    public static ManagedPDF createFromString(String spec) throws RecognitionException, StringNotPDFException {
        ProbabilityFunctionLiteral value = ManagedPDF.parse(spec);
        try {
            ProbabilityDensityFunction pdf = (ProbabilityDensityFunction)value.getFunction_ProbabilityFunctionLiteral();
            return new ManagedPDF(pdf);
        }
        catch (ClassCastException e) {
            throw new StringNotPDFException();
        }
    }

    private static ProbabilityFunctionLiteral parse(String s) throws RecognitionException {
        StochasticExpressionsLexer lexer = new StochasticExpressionsLexer((CharStream)new ANTLRStringStream(s));
        StochasticExpressionsParser parser = new StochasticExpressionsParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return (ProbabilityFunctionLiteral)parser.expression();
    }
}

