/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.factory;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulingFactory;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.factory.SchedulerExtensionFactory;
import de.uka.ipd.sdq.scheduler.resources.active.SimDelayResource;
import de.uka.ipd.sdq.scheduler.resources.active.SimFCFSResource;
import de.uka.ipd.sdq.scheduler.resources.active.SimProcessorSharingResource;
import de.uka.ipd.sdq.scheduler.resources.active.special.SimProcessorSharingResourceLinuxO1;
import de.uka.ipd.sdq.scheduler.resources.active.special.SimProcessorSharingResourceWindows;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class SchedulingFactory
implements ISchedulingFactory {
    private final Map<String, IActiveResource> active_resource_map = new Hashtable<String, IActiveResource>();
    private final Map<String, IPassiveResource> passive_resource_map = new Hashtable<String, IPassiveResource>();
    private final SchedulerModel model;
    private static final String SchedulerExtensionPointId = "de.uka.ipd.sdq.scheduler";
    private static final String SchedulerExtensionPointAttribute_Class = "class";

    public SchedulingFactory(SchedulerModel model) {
        this.model = model;
    }

    @Override
    public IActiveResource createResourceFromExtension(String extensionId, String resourceId, long numberOfCores) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        if (resource == null) {
            SchedulerExtensionFactory factory = SchedulingFactory.getSchedulerExtensionFactory(extensionId);
            assert (factory != null);
            resource = factory.getExtensionScheduler(this.model, extensionId, resourceId, numberOfCores);
            this.active_resource_map.put(resourceId, resource);
        }
        return resource;
    }

    @Override
    public IActiveResource createSimFCFSResource(String resourceName, String resourceId) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        resource = new SimFCFSResource(this.model, resourceName, resourceId, 1L);
        this.active_resource_map.put(resourceId, resource);
        return resource;
    }

    @Override
    public IActiveResource createSimDelayResource(String resourceName, String resourceId) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        resource = new SimDelayResource(this.model, resourceName, resourceId);
        this.active_resource_map.put(resourceId, resource);
        return resource;
    }

    @Override
    public IActiveResource createSimProcessorSharingResource(String resourceName, String resourceId, long numberOfCores) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        resource = new SimProcessorSharingResource(this.model, resourceName, resourceId, numberOfCores);
        this.active_resource_map.put(resourceId, resource);
        return resource;
    }

    @Override
    public IActiveResource createSimProcessorSharingResourceWindows(String resourceName, String resourceId, long numberOfCores) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        resource = new SimProcessorSharingResourceWindows(this.model, resourceName, resourceId, numberOfCores);
        this.active_resource_map.put(resourceId, resource);
        return resource;
    }

    @Override
    public IActiveResource createSimProcessorSharingResourceLinuxO1(String resourceName, String resourceId, long numberOfCores) {
        IActiveResource resource = this.active_resource_map.get(resourceId);
        resource = new SimProcessorSharingResourceLinuxO1(this.model, resourceName, resourceId, numberOfCores);
        this.active_resource_map.put(resourceId, resource);
        return resource;
    }

    @Override
    public void resetFactory() {
        this.active_resource_map.clear();
        this.passive_resource_map.clear();
    }

    private static IExtension[] getRegisteredSchedulerExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(SchedulerExtensionPointId);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        return extensions;
    }

    private static SchedulerExtensionFactory getSchedulerExtensionFactory(String extensionId) {
        IExtension[] registeredExtensions = SchedulingFactory.getRegisteredSchedulerExtensions();
        assert (registeredExtensions != null) : "No scheduler extensions available!";
        int i = 0;
        while (i < registeredExtensions.length) {
            IExtension registeredExtension = registeredExtensions[i];
            IConfigurationElement[] elements = registeredExtension.getConfigurationElements();
            if (registeredExtension.getUniqueIdentifier().equals(extensionId)) {
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    Object o = null;
                    try {
                        o = element.createExecutableExtension(SchedulerExtensionPointAttribute_Class);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (o != null && o instanceof SchedulerExtensionFactory) {
                        return (SchedulerExtensionFactory)o;
                    }
                    ++j;
                }
            }
            ++i;
        }
        assert (false) : "No scheduler extension for ID " + extensionId + " available!";
        return null;
    }
}

