/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.adapter;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Utilization;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.UtilizationBucketInformation;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.SensorAndMeasurements;
import de.uka.ipd.sdq.sensorframework.entities.StateMeasurement;
import java.util.Collection;

public class StateToUtilizationAdapter
extends DataAdapter {
    public static final String IDLE_STATE_REPRESENTATION = "Idle";
    public static final String UTILIZATION_WIDTH = "UTILIZATION_WIDTH";
    private final SensorAndMeasurements samInformation;

    public StateToUtilizationAdapter(SensorAndMeasurements sensorAndMeasurements) {
        this.samInformation = sensorAndMeasurements;
        this.initializeUtilizationInterval();
    }

    protected void initializeUtilizationInterval() {
        if (this.samInformation.getMeasurements().size() <= 1) {
            this.adapterProperties.put(UTILIZATION_WIDTH, (Object)1.0);
            return;
        }
        StateMeasurement stateMeasurement = null;
        double minEventTimeValue = Double.MAX_VALUE;
        double maxEventTimeValue = Double.MIN_VALUE;
        for (Measurement measurement : this.samInformation.getMeasurements()) {
            stateMeasurement = (StateMeasurement)measurement;
            minEventTimeValue = minEventTimeValue < stateMeasurement.getEventTime() ? minEventTimeValue : stateMeasurement.getEventTime();
            double d = maxEventTimeValue = maxEventTimeValue > stateMeasurement.getEventTime() ? maxEventTimeValue : stateMeasurement.getEventTime();
        }
        if (maxEventTimeValue - minEventTimeValue < 1.0) {
            this.adapterProperties.put(UTILIZATION_WIDTH, (Object)((maxEventTimeValue - minEventTimeValue) / 2.0));
        } else {
            double currentNumberOfBuckets = (maxEventTimeValue - minEventTimeValue) / 1.0;
            if (currentNumberOfBuckets > 100.0) {
                this.adapterProperties.put(UTILIZATION_WIDTH, (Object)((maxEventTimeValue - minEventTimeValue) / 100.0));
            } else {
                this.adapterProperties.put(UTILIZATION_WIDTH, (Object)1.0);
            }
        }
    }

    public Object getAdaptedObject() {
        double utilWidth = (Double)this.adapterProperties.get(UTILIZATION_WIDTH);
        if (utilWidth <= 0.0) {
            throw new RuntimeException("Utilization width must be > 0");
        }
        Utilization utilization = new Utilization(this.samInformation.getSensor().getSensorName(), utilWidth);
        Collection measurements = this.samInformation.getMeasurements();
        double lastEventTime = 0.0;
        boolean lastStateIsIdle = true;
        double currentUtilization = 0.0;
        long currentInterval = 0L;
        for (Measurement measurement : measurements) {
            StateMeasurement stateMmt = (StateMeasurement)measurement;
            if (stateMmt.getEventTime() >= (double)(currentInterval + 1L) * utilWidth) {
                if (!lastStateIsIdle) {
                    currentUtilization += (double)(currentInterval + 1L) * utilWidth - lastEventTime;
                }
                utilization.addEntity(new UtilizationBucketInformation(currentUtilization / utilWidth, (double)currentInterval * utilWidth));
                ++currentInterval;
                while (stateMmt.getEventTime() > (double)(currentInterval + 1L) * utilWidth) {
                    currentUtilization = lastStateIsIdle ? 0.0 : 1.0;
                    utilization.addEntity(new UtilizationBucketInformation(currentUtilization / utilWidth, (double)currentInterval * utilWidth));
                    ++currentInterval;
                }
                currentUtilization = lastStateIsIdle ? 0.0 : stateMmt.getEventTime() - (double)currentInterval * utilWidth;
            } else if (!lastStateIsIdle) {
                currentUtilization += stateMmt.getEventTime() - lastEventTime;
            }
            lastEventTime = stateMmt.getEventTime();
            lastStateIsIdle = stateMmt.getSensorState().getStateLiteral().equals(IDLE_STATE_REPRESENTATION);
        }
        if (!lastStateIsIdle) {
            currentUtilization += (double)(currentInterval + 1L) * utilWidth - lastEventTime;
        }
        utilization.addEntity(new UtilizationBucketInformation(currentUtilization / utilWidth, (double)currentInterval * utilWidth));
        return utilization;
    }
}

