/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dialogs.dataset;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.AddNewDatasourceWizard;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.DatasourceDialog;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.OpenDatasourceWizard;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class ConfigureDatasourceDialog
extends DatasourceDialog {
    public static String OPEN_WISARD_TITLE = "Load a source storage for the sensor framework.";
    public static String ADD_WIZARD_TITLE = "Select/create a storage for the sensor framework.";

    public ConfigureDatasourceDialog(Shell parentShell, String dialogTitel, boolean makeValidation) {
        super(parentShell, dialogTitel, SensorFrameworkDataset.singleton().getDataSources(), makeValidation);
        this.create();
        this.setRemoveButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDAOFactory selectedSource = (IDAOFactory)ConfigureDatasourceDialog.this.getResult();
                SensorFrameworkDataset.singleton().removeDataSource(selectedSource);
                ConfigureDatasourceDialog.this.refresh();
            }
        });
        this.setAddButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddNewDatasourceWizard w = new AddNewDatasourceWizard();
                WizardDialog dialog = new WizardDialog(e.display.getActiveShell(), (IWizard)w);
                dialog.create();
                dialog.setTitle(ADD_WIZARD_TITLE);
                dialog.open();
                ConfigureDatasourceDialog.this.refresh();
            }
        });
        this.setOpenButtonAction((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenDatasourceWizard w = new OpenDatasourceWizard();
                WizardDialog dialog = new WizardDialog(e.display.getActiveShell(), (IWizard)w);
                dialog.create();
                dialog.setTitle(OPEN_WISARD_TITLE);
                dialog.open();
                ConfigureDatasourceDialog.this.refresh();
            }
        });
    }
}

