/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import java.util.List;

public class LogFunction
implements IFunction {
    public static final String LOG_FUNCTION_NAME = "Log";

    @Override
    public boolean checkParameters(List<Object> parameters) {
        Number value;
        Number base;
        if (parameters.size() != 2) {
            return false;
        }
        if (parameters.get(0) instanceof Double) {
            base = (Double)parameters.get(0);
            if ((Double)base <= 0.0 || (Double)base == 1.0) {
                return false;
            }
        } else if (parameters.get(0) instanceof Integer) {
            base = (Integer)parameters.get(0);
            if ((Integer)base <= 0 || (Integer)base == 1) {
                return false;
            }
        } else {
            return false;
        }
        if (parameters.get(1) instanceof Double) {
            value = (Double)parameters.get(1);
            if ((Double)value <= 0.0) {
                return false;
            }
        } else if (parameters.get(1) instanceof Integer) {
            value = (Integer)parameters.get(1);
            if ((Integer)value <= 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(List<Object> parameters) {
        Double base = parameters.get(0) instanceof Integer ? Double.valueOf(((Integer)parameters.get(0)).intValue()) : (Double)parameters.get(0);
        Double value = parameters.get(1) instanceof Integer ? Double.valueOf(((Integer)parameters.get(1)).intValue()) : (Double)parameters.get(1);
        return Math.log(value) / Math.log(base);
    }
}

